<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us | BakiCure - Premium Bakkie Accessories</title>
    <meta name="description" content="Learn about BakiCure - South Africa's trusted supplier of premium bakkie canopies, tonneau covers, and accessories.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #374151; --primary-dark: #1f2937; --accent: #f59e0b; --accent-dark: #d97706; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-200: #e5e7eb; --gray-600: #4b5563; --white: #fff; --gradient-hero: linear-gradient(135deg, #1f2937 0%, #374151 50%, #4b5563 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 60px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 10px 18px; border-radius: 12px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-accent { background: var(--accent); color: var(--dark); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-hero { background: var(--gradient-hero); padding: 160px 0 100px; text-align: center; color: white; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }
        .about-section { padding: 80px 0; }
        .about-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .about-content h2 { font-size: 2rem; margin-bottom: 20px; }
        .about-content p { color: var(--gray-600); margin-bottom: 16px; }
        .about-image { background: linear-gradient(135deg, var(--gray-100) 0%, var(--gray-200) 100%); border-radius: var(--radius); height: 400px; display: flex; align-items: center; justify-content: center; }
        .about-image i { font-size: 8rem; color: var(--primary); opacity: 0.3; }
        .values-section { padding: 80px 0; background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 48px; }
        .section-header h2 { font-size: 2rem; margin-bottom: 12px; }
        .section-header p { color: var(--gray-600); }
        .values-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .value-card { background: white; padding: 32px; border-radius: var(--radius); text-align: center; box-shadow: var(--shadow); }
        .value-icon { width: 70px; height: 70px; background: var(--gradient-hero); color: white; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 28px; margin: 0 auto 20px; }
        .value-card h3 { font-size: 1.1rem; margin-bottom: 10px; }
        .value-card p { color: var(--gray-600); font-size: 14px; }
        .brands-section { padding: 80px 0; }
        .brands-grid { display: grid; grid-template-columns: repeat(6, 1fr); gap: 24px; }
        .brand-item { background: var(--gray-50); padding: 24px; border-radius: var(--radius); text-align: center; font-weight: 600; color: var(--gray-600); }
        .cta-section { background: var(--gradient-hero); padding: 80px 0; text-align: center; color: white; }
        .cta-section h2 { font-size: 2rem; margin-bottom: 16px; }
        .cta-section p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 40px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 8px; color: rgba(255,255,255,0.7); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .about-grid { grid-template-columns: 1fr; } .values-grid { grid-template-columns: repeat(2, 1fr); } .brands-grid { grid-template-columns: repeat(3, 1fr); } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .values-grid { grid-template-columns: 1fr; } .brands-grid { grid-template-columns: repeat(2, 1fr); } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" style="height: 90px;" alt="BakiCure"></a>
        <nav><ul class="nav-links"><li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li><li><a href="/">Home</a></li><li><a href="/products.php">Products</a></li><li><a href="/about.php" class="active">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
    </div></div></header>

    <section class="page-hero"><div class="container"><h1>About BakiCure</h1><p>South Africa's trusted supplier of premium bakkie accessories and fitment solutions.</p></div></section>

    <section class="about-section"><div class="container"><div class="about-grid">
        <div class="about-content">
            <h2>Built for the South African Bakkie Owner</h2>
            <p>BakiCure was founded with a simple mission: to provide South African bakkie owners with high-quality accessories that enhance both the functionality and appearance of their vehicles.</p>
            <p>We understand that your bakkie is more than just transportation - it's a workhorse, an adventure companion, and often a significant investment. That's why we partner with leading manufacturers to bring you accessories that are built to last and designed for our unique conditions.</p>
            <p>From premium canopies that protect your cargo to stylish roll bars that add presence, every product in our range has been selected for its quality, durability, and value.</p>
        </div>
        <div class="about-image"><i class="fas fa-truck-pickup"></i></div>
    </div></div></section>

    <section class="values-section"><div class="container">
        <div class="section-header"><h2>Why Choose BakiCure</h2><p>Our commitment to quality and service sets us apart.</p></div>
        <div class="values-grid">
            <div class="value-card"><div class="value-icon"><i class="fas fa-medal"></i></div><h3>Premium Quality</h3><p>Only the best brands and materials make it into our product range.</p></div>
            <div class="value-card"><div class="value-icon"><i class="fas fa-tools"></i></div><h3>Expert Fitment</h3><p>Professional installation by trained technicians for perfect results.</p></div>
            <div class="value-card"><div class="value-icon"><i class="fas fa-truck"></i></div><h3>Nationwide Delivery</h3><p>We deliver across South Africa with reliable shipping partners.</p></div>
            <div class="value-card"><div class="value-icon"><i class="fas fa-shield-alt"></i></div><h3>Warranty Backed</h3><p>All products come with manufacturer warranties for peace of mind.</p></div>
        </div>
    </div></section>

    <section class="brands-section"><div class="container">
        <div class="section-header"><h2>We Fit All Major Bakkie Brands</h2><p>Accessories available for all popular South African bakkies.</p></div>
        <div class="brands-grid">
            <div class="brand-item">Toyota Hilux</div>
            <div class="brand-item">Ford Ranger</div>
            <div class="brand-item">Isuzu D-Max</div>
            <div class="brand-item">VW Amarok</div>
            <div class="brand-item">Nissan Navara</div>
            <div class="brand-item">GWM P-Series</div>
            <div class="brand-item">Mazda BT-50</div>
            <div class="brand-item">Mitsubishi Triton</div>
            <div class="brand-item">JAC T8</div>
            <div class="brand-item">Mahindra Pik Up</div>
            <div class="brand-item">Fiat Fullback</div>
            <div class="brand-item">Steed</div>
        </div>
    </div></section>

    <section class="cta-section"><div class="container">
        <h2>Ready to Upgrade Your Bakkie?</h2>
        <p>Get in touch for expert advice on the best accessories for your vehicle.</p>
        <a href="/contact.php" class="btn btn-accent"><i class="fas fa-phone"></i> Contact Us Today</a>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand"><div class="footer-icon-container"><img src="/images/logo-icon.png" style="height: 75px;" alt="Bakicure" style="height: 80px;"></div><p class="footer-tagline">Bakkie Accessories</p>
                    <p>Premium accessories<br>for your bakkie.</p></div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/products.php">Products</a></li><li><a href="/about.php">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul></div>
            <div><h4>Products</h4><ul class="footer-links"><li><a href="/products.php#canopies">Canopies</a></li><li><a href="/products.php#tonneau">Tonneau Covers</a></li><li><a href="/products.php#rollbars">Roll Bars</a></li><li><a href="/products.php#loadbins">Load Bins</a></li></ul></div>
            <div><h4>Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-phone"></i> +27 12 345 6789</p><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@bakicure.co.za</p></div>
        </div>
        <div class="footer-bottom"><p>&copy; <?= date('Y') ?> BakiCure. All rights reserved.</p><a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></div></div>
    </div></footer>
</body>
</html>
