<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BakiCure - Premium Bakkie Accessories | South Africa</title>
    <meta name="description" content="BakiCure offers premium bakkie canopies, tonneau covers, roll bars, and accessories for Toyota Hilux, Ford Ranger, Isuzu and more.">
    <link rel="icon" type="image/x-icon" href="/bakicure/favicon.ico">
    <link rel="apple-touch-icon" href="/bakicure/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #374151; --primary-dark: #1f2937; --accent: #f59e0b; --accent-dark: #d97706; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-200: #e5e7eb; --gray-600: #4b5563; --white: #fff; --gradient-hero: linear-gradient(135deg, #1f2937 0%, #374151 50%, #4b5563 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 75px; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); color: var(--gray-600) !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-accent { background: var(--accent); color: var(--dark); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-white { background: white; color: var(--primary); }
        .btn-lg { padding: 14px 28px; font-size: 15px; }
        .hero { background: var(--gradient-hero); padding: 160px 0 100px; color: white; position: relative; overflow: hidden; }
        .hero::before { content: ''; position: absolute; top: -50%; right: -20%; width: 800px; height: 800px; background: radial-gradient(circle, rgba(245,158,11,0.15) 0%, transparent 70%); border-radius: 50%; }
        .hero .container { position: relative; z-index: 1; display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .hero-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.15); padding: 8px 16px; border-radius: 50px; font-size: 14px; margin-bottom: 20px; }
        .hero h1 { font-size: 3.2rem; font-weight: 800; margin-bottom: 20px; line-height: 1.1; }
        .hero p { font-size: 1.2rem; opacity: 0.9; margin-bottom: 32px; }
        .hero-buttons { display: flex; gap: 16px; flex-wrap: wrap; }
        .hero-image { text-align: center; }
        .hero-image img { max-width: 350px; width: 100%; animation: heroFloat 4s ease-in-out infinite; }
        @keyframes heroFloat { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-15px); } }
        .products { padding: 100px 0; background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(55,65,81,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .products-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .product-card { background: white; border-radius: var(--radius); padding: 32px; text-align: center; box-shadow: var(--shadow); transition: all 0.3s; text-decoration: none; color: inherit; }
        .product-card:hover { transform: translateY(-8px); box-shadow: var(--shadow-lg); }
        .product-icon { width: 80px; height: 80px; background: var(--gradient-hero); color: white; border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 32px; margin: 0 auto 20px; }
        .product-card h3 { font-size: 1.2rem; margin-bottom: 10px; }
        .product-card p { color: var(--gray-600); font-size: 14px; margin-bottom: 16px; }
        .product-link { color: var(--accent-dark); font-weight: 600; font-size: 14px; }
        .brands { padding: 100px 0; }
        .brands-grid { display: grid; grid-template-columns: repeat(6, 1fr); gap: 20px; }
        .brand-item { background: var(--gray-50); padding: 24px; border-radius: 12px; text-align: center; font-weight: 600; color: var(--gray-600); font-size: 14px; }
        .features { padding: 100px 0; background: var(--gray-50); }
        .features-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .feature-card { text-align: center; padding: 32px 20px; background: white; border-radius: var(--radius); box-shadow: var(--shadow); }
        .feature-icon { width: 70px; height: 70px; background: var(--gradient-hero); color: white; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 28px; margin: 0 auto 20px; }
        .feature-card h3 { font-size: 1.1rem; margin-bottom: 10px; }
        .feature-card p { color: var(--gray-600); font-size: 14px; }
        .cta { background: var(--gradient-hero); padding: 100px 0; text-align: center; color: white; }
        .cta h2 { font-size: 2.5rem; margin-bottom: 16px; }
        .cta p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-links a:hover { color: var(--accent); }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .hero .container { grid-template-columns: 1fr; text-align: center; } .hero-visual { display: none; } .products-grid { grid-template-columns: repeat(2, 1fr); } .brands-grid { grid-template-columns: repeat(3, 1fr); } .features-grid { grid-template-columns: repeat(2, 1fr); } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .products-grid { grid-template-columns: 1fr; } .brands-grid { grid-template-columns: repeat(2, 1fr); } .features-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } .footer-bottom { flex-direction: column; gap: 16px; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/bakicure/" class="logo"><img src="/bakicure/images/logo-long.png" alt="BakiCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/bakicure/">Home</a></li>
                <li><a href="/bakicure/products.php">Products</a></li>
                <li><a href="/bakicure/about.php">About Us</a></li>
                <li><a href="/bakicure/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <section class="hero">
        <div class="container">
            <div>
                <div class="hero-badge"><i class="fas fa-truck-pickup"></i> Driven by Excellence</div>
                <h1>Premium Bakkie Accessories</h1>
                <p>Quality canopies, tonneau covers, roll bars, and accessories for South Africa's favourite bakkies.</p>
                <div class="hero-buttons">
                    <a href="/bakicure/products.php" class="btn btn-accent btn-lg"><i class="fas fa-th-large"></i> Browse Products</a>
                    <a href="/bakicure/contact.php" class="btn btn-outline btn-lg" style="border-color: white; color: white;"><i class="fas fa-file-invoice"></i> Get Quote</a>
                </div>
            </div>
            <div class="hero-visual" style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                <div class="stat-card" style="background: rgba(255,255,255,0.1); backdrop-filter: blur(10px); border-radius: 16px; padding: 24px; text-align: center; border: 1px solid rgba(255,255,255,0.1);">
                    <h3 style="font-size: 2.5rem; font-weight: 800; color: white;">12+</h3>
                    <p style="font-size: 13px; color: rgba(255,255,255,0.8); margin-top: 4px;">Bakkie Brands</p>
                </div>
                <div class="stat-card" style="background: var(--accent); backdrop-filter: blur(10px); border-radius: 16px; padding: 24px; text-align: center;">
                    <h3 style="font-size: 2.5rem; font-weight: 800; color: white;">100+</h3>
                    <p style="font-size: 13px; color: rgba(255,255,255,0.8); margin-top: 4px;">Products</p>
                </div>
                <div class="stat-card" style="background: var(--accent); backdrop-filter: blur(10px); border-radius: 16px; padding: 24px; text-align: center;">
                    <h3 style="font-size: 2.5rem; font-weight: 800; color: white;">SA</h3>
                    <p style="font-size: 13px; color: rgba(255,255,255,0.8); margin-top: 4px;">Nationwide Delivery</p>
                </div>
                <div class="stat-card" style="background: rgba(255,255,255,0.1); backdrop-filter: blur(10px); border-radius: 16px; padding: 24px; text-align: center; border: 1px solid rgba(255,255,255,0.1);">
                    <h3 style="font-size: 2.5rem; font-weight: 800; color: white;"><i class="fas fa-check"></i></h3>
                    <p style="font-size: 13px; color: rgba(255,255,255,0.8); margin-top: 4px;">Quality Warranty</p>
                </div>
            </div>
        </div>
    </section>

    <section class="products"><div class="container">
        <div class="section-header">
            <span class="section-badge">Our Products</span>
            <h2>Bakkie Accessories</h2>
            <p>Everything you need to enhance and protect your bakkie.</p>
        </div>
        <div class="products-grid">
            <a href="/bakicure/products.php#canopies" class="product-card">
                <div class="product-icon"><i class="fas fa-warehouse"></i></div>
                <h3>Canopies</h3>
                <p>Quality canopies for cargo protection and style.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/bakicure/products.php#tonneau" class="product-card">
                <div class="product-icon"><i class="fas fa-box"></i></div>
                <h3>Tonneau Covers</h3>
                <p>Secure covers for your load bin in multiple styles.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/bakicure/products.php#rollbars" class="product-card">
                <div class="product-icon"><i class="fas fa-grip-lines"></i></div>
                <h3>Roll Bars</h3>
                <p>Chrome and black roll bars for style and safety.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/bakicure/products.php#loadbins" class="product-card">
                <div class="product-icon"><i class="fas fa-layer-group"></i></div>
                <h3>Load Bin Liners</h3>
                <p>Protect your load bin from scratches and damage.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
        </div>
    </div></section>

    <section class="brands"><div class="container">
        <div class="section-header">
            <span class="section-badge">Compatible Bakkies</span>
            <h2>We Fit All Major Brands</h2>
            <p>Accessories available for South Africa's most popular bakkies.</p>
        </div>
        <div class="brands-grid">
            <div class="brand-item">Toyota Hilux</div>
            <div class="brand-item">Ford Ranger</div>
            <div class="brand-item">Isuzu D-Max</div>
            <div class="brand-item">VW Amarok</div>
            <div class="brand-item">Nissan Navara</div>
            <div class="brand-item">GWM P-Series</div>
            <div class="brand-item">Mazda BT-50</div>
            <div class="brand-item">Mitsubishi Triton</div>
            <div class="brand-item">JAC T8</div>
            <div class="brand-item">Mahindra Pik Up</div>
            <div class="brand-item">Fiat Fullback</div>
            <div class="brand-item">Steed</div>
        </div>
    </div></section>

    <section class="features"><div class="container">
        <div class="section-header">
            <span class="section-badge">Why BakiCure</span>
            <h2>Quality You Can Trust</h2>
        </div>
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-medal"></i></div>
                <h3>Premium Quality</h3>
                <p>Only the best materials and craftsmanship.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-tools"></i></div>
                <h3>Expert Fitment</h3>
                <p>Professional installation available.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-truck"></i></div>
                <h3>Nationwide</h3>
                <p>Delivery across South Africa.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-shield-alt"></i></div>
                <h3>Warranty</h3>
                <p>Manufacturer backed warranties.</p>
            </div>
        </div>
    </div></section>

    <section class="cta"><div class="container">
        <h2>Ready to Upgrade Your Bakkie?</h2>
        <p>Contact us for a quote on premium bakkie accessories.</p>
        <a href="/bakicure/contact.php" class="btn btn-accent btn-lg"><i class="fas fa-envelope"></i> Get a Quote</a>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand">
                <div class="footer-icon-container"><img src="/bakicure/images/logo-icon.png" alt="BakiCure"></div>
                <p class="footer-tagline">Bakkie Accessories</p>
                    <p>Premium accessories<br>for your bakkie.</p>
            </div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/bakicure/products.php">Products</a></li><li><a href="/bakicure/about.php">About Us</a></li><li><a href="/bakicure/contact.php">Contact</a></li></ul></div>
            <div><h4>Products</h4><ul class="footer-links"><li><a href="/bakicure/products.php#canopies">Canopies</a></li><li><a href="/bakicure/products.php#tonneau">Tonneau Covers</a></li><li><a href="/bakicure/products.php#rollbars">Roll Bars</a></li><li><a href="/bakicure/products.php#loadbins">Load Bins</a></li></ul></div>
            <div><h4>Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-phone"></i> +27 12 345 6789</p><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@bakicure.co.za</p></div>
        </div>
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> BakiCure. All rights reserved.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
        </div>
    </div></footer>
</body>
</html>
