<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products | BakiCure - Bakkie Accessories South Africa</title>
    <meta name="description" content="Browse our range of bakkie accessories - canopies, tonneau covers, roll bars, load bins and more for all bakkie models.">
    <link rel="icon" type="image/x-icon" href="/bakicure/favicon.ico">
    <link rel="apple-touch-icon" href="/bakicure/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #374151; --primary-dark: #1f2937; --secondary: #f59e0b; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-200: #e5e7eb; --gray-600: #4b5563; --white: #fff; --gradient-hero: linear-gradient(135deg, #1f2937 0%, #374151 50%, #4b5563 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 60px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 10px 18px; border-radius: 12px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-quote { background: var(--secondary); color: var(--dark); }
        .btn-sm { padding: 10px 20px; font-size: 14px; }
        .page-hero { background: var(--gradient-hero); padding: 160px 0 100px; text-align: center; color: white; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }
        .section { padding: 80px 0; }
        .section-alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 48px; }
        .section-badge { display: inline-block; background: rgba(55,65,81,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.2rem; font-weight: 700; margin-bottom: 12px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .products-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; }
        .product-card { background: white; border-radius: var(--radius); overflow: hidden; box-shadow: var(--shadow); transition: all 0.3s; }
        .product-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); }
        .product-image { height: 160px; background: var(--gray-100); display: flex; align-items: center; justify-content: center; }
        .product-image i { font-size: 3.5rem; color: var(--primary); opacity: 0.4; }
        .product-content { padding: 20px; }
        .product-badge { display: inline-block; background: rgba(55,65,81,0.1); color: var(--primary); padding: 4px 12px; border-radius: 50px; font-size: 11px; font-weight: 600; margin-bottom: 10px; }
        .product-content h3 { font-size: 1.1rem; margin-bottom: 8px; }
        .product-content p { color: var(--gray-600); font-size: 13px; margin-bottom: 16px; }
        .product-actions .btn { width: 100%; justify-content: center; }
        .modal-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.7); z-index: 9999; align-items: center; justify-content: center; padding: 20px; }
        .modal-overlay.active { display: flex; }
        .modal { background: white; border-radius: var(--radius); padding: 40px; max-width: 500px; width: 100%; position: relative; }
        .modal h3 { font-size: 1.5rem; margin-bottom: 8px; }
        .modal .subtitle { color: var(--gray-600); margin-bottom: 24px; }
        .modal-close { position: absolute; top: 20px; right: 20px; background: none; border: none; font-size: 24px; cursor: pointer; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 14px; border: 2px solid var(--gray-200); border-radius: 10px; font-family: inherit; font-size: 13px; }
        .form-group input:focus, .form-group textarea:focus { outline: none; border-color: var(--primary); }
        .success-message { display: none; text-align: center; padding: 40px; }
        .success-message.active { display: block; }
        .success-message i { font-size: 4rem; color: var(--secondary); margin-bottom: 20px; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 40px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 8px; color: rgba(255,255,255,0.7); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .products-grid { grid-template-columns: repeat(2, 1fr); } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .products-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/bakicure/" class="logo"><img src="/bakicure/images/logo-long.png" style="height: 90px;" alt="BakiCure"></a>
        <nav><ul class="nav-links"><li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li><li><a href="/bakicure/">Home</a></li><li><a href="/bakicure/products.php" class="active">Products</a></li><li><a href="/bakicure/about.php">About Us</a></li><li><a href="/bakicure/contact.php">Contact</a></li></ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
    </div></div></header>

    <section class="page-hero"><div class="container"><h1>Bakkie Accessories</h1><p>Quality accessories for all major bakkie brands in South Africa.</p></div></section>

    <section class="section" id="canopies"><div class="container">
        <div class="section-header"><span class="section-badge">Canopies</span><h2>Bakkie Canopies</h2><p>Steel and fibreglass canopies with optional features.</p></div>
        <div class="products-grid">
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-canopy-steel.jpg" alt="Steel Canopy" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Steel</span><h3>Steel Canopy</h3><p>Durable steel construction with sliding windows and central locking.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Steel Canopy')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-canopy-fiberglass.jpg" alt="Fibreglass Canopy" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Fibreglass</span><h3>Fibreglass Canopy</h3><p>Lightweight fibreglass with smooth finish and colour match options.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Fibreglass Canopy')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-canopy-commercial.jpg" alt="Commercial Canopy" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Commercial</span><h3>Commercial Canopy</h3><p>Heavy-duty canopy for commercial use with roof rack option.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Commercial Canopy')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
        </div>
    </div></section>

    <section class="section section-alt" id="tonneau"><div class="container">
        <div class="section-header"><span class="section-badge">Tonneau Covers</span><h2>Tonneau Covers</h2><p>Protect your cargo with quality covers.</p></div>
        <div class="products-grid">
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-tonneau-soft.jpg" alt="Soft Tonneau Cover" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Soft</span><h3>Soft Roll-Up Cover</h3><p>Vinyl roll-up cover with easy access and weather protection.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Soft Tonneau Cover')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-tonneau-hard.jpg" alt="Hard Tonneau Cover" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Hard</span><h3>Hard Tri-Fold Cover</h3><p>Aluminium tri-fold cover with secure locking system.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Hard Tonneau Cover')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-tonneau-retractable.jpg" alt="Retractable Cover" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Retractable</span><h3>Retractable Cover</h3><p>Premium retractable aluminium cover with remote control.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Retractable Tonneau')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
        </div>
    </div></section>

    <section class="section" id="rollbars"><div class="container">
        <div class="section-header"><span class="section-badge">Roll Bars</span><h2>Roll Bars & Styling</h2><p>Add style and functionality to your bakkie.</p></div>
        <div class="products-grid">
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-rollbar-chrome.jpg" alt="Chrome Roll Bar" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Chrome</span><h3>Chrome Roll Bar</h3><p>Polished stainless steel chrome roll bar with spot lights.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Chrome Roll Bar')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-rollbar-black.jpg" alt="Black Roll Bar" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Black</span><h3>Black Roll Bar</h3><p>Matt black powder-coated roll bar for rugged look.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Black Roll Bar')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-sportsbar.jpg" alt="Sports Bar" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Sports Bar</span><h3>Sports Bar</h3><p>Sleek sports bar design with integrated brake light.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Sports Bar')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
        </div>
    </div></section>

    <section class="section section-alt" id="loadbins"><div class="container">
        <div class="section-header"><span class="section-badge">Load Bins</span><h2>Load Bin Protection</h2><p>Protect your load bin from damage.</p></div>
        <div class="products-grid">
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-liner.jpg" alt="Load Bin Liner" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Liner</span><h3>Load Bin Liner</h3><p>Heavy-duty HDPE liner for complete protection.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Load Bin Liner')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-spray-liner.jpg" alt="Spray-On Liner" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Spray</span><h3>Spray-On Liner</h3><p>Professional spray-on bed liner coating.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Spray-On Liner')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
            <div class="product-card"><div class="product-image"><img src="/bakicure/images/product-rubber-mat.jpg" alt="Rubber Mat" style="width:100%;height:100%;object-fit:cover;"></div><div class="product-content"><span class="product-badge">Mat</span><h3>Rubber Mat</h3><p>Non-slip rubber mat for cargo protection.</p><div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Rubber Mat')"><i class="fas fa-file-invoice"></i> Get Quote</button></div></div></div>
        </div>
    </div></section>

    <section style="padding: 80px 0; background: var(--gradient-hero); text-align: center; color: white;"><div class="container">
        <h2 style="font-size: 2.2rem; margin-bottom: 16px;">Need Help Choosing?</h2>
        <p style="opacity: 0.9; margin-bottom: 32px;">Contact us with your bakkie model and we'll recommend the best accessories.</p>
        <a href="/bakicure/contact.php" class="btn" style="background: var(--secondary); color: var(--dark);"><i class="fas fa-phone"></i> Contact Us</a>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand"><div class="footer-icon-container"><img src="/bakicure/images/logo-icon.png" style="height: 75px;" alt="Bakicure" style="height: 80px;"></div><p>Premium bakkie accessories for South Africa.</p></div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/bakicure/products.php">Products</a></li><li><a href="/bakicure/about.php">About Us</a></li><li><a href="/bakicure/contact.php">Contact</a></li></ul></div>
            <div><h4>Products</h4><ul class="footer-links"><li><a href="#canopies">Canopies</a></li><li><a href="#tonneau">Tonneau Covers</a></li><li><a href="#rollbars">Roll Bars</a></li><li><a href="#loadbins">Load Bins</a></li></ul></div>
            <div><h4>Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-phone"></i> +27 12 345 6789</p><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@bakicure.co.za</p></div>
        </div>
        <div class="footer-bottom"><p>&copy; <?= date('Y') ?> BakiCure. All rights reserved.</p><a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></div></div>
    </div></footer>

    <div class="modal-overlay" id="quoteModal"><div class="modal"><button class="modal-close" onclick="closeQuoteModal()">&times;</button>
        <div id="quoteForm"><h3>Request a Quote</h3><p class="subtitle" id="productName">Product</p>
            <form onsubmit="submitQuote(event)">
                <div class="form-group"><label>Name *</label><input type="text" required></div>
                <div class="form-group"><label>Email *</label><input type="email" required></div>
                <div class="form-group"><label>Phone *</label><input type="tel" required></div>
                <div class="form-group"><label>Bakkie Make & Model *</label><input type="text" placeholder="e.g., Toyota Hilux 2022" required></div>
                <div class="form-group"><label>Message</label><textarea rows="3" placeholder="Any specific requirements..."></textarea></div>
                <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fas fa-paper-plane"></i> Submit</button>
            </form>
        </div>
        <div class="success-message" id="successMessage"><i class="fas fa-check-circle"></i><h3>Quote Request Received!</h3><p>We'll get back to you within 24 hours.</p><button class="btn btn-primary" onclick="closeQuoteModal()" style="margin-top: 20px;">Close</button></div>
    </div></div>

    <script>
        function openQuoteModal(product) { document.getElementById('productName').textContent = product; document.getElementById('quoteModal').classList.add('active'); }
        function closeQuoteModal() { document.getElementById('quoteModal').classList.remove('active'); document.getElementById('quoteForm').style.display = 'block'; document.getElementById('successMessage').classList.remove('active'); }
        function submitQuote(e) { e.preventDefault(); document.getElementById('quoteForm').style.display = 'none'; document.getElementById('successMessage').classList.add('active'); }
        document.getElementById('quoteModal').addEventListener('click', function(e) { if (e.target === this) closeQuoteModal(); });
    </script>
</body>
</html>
