<?php
require_once 'config.php';

$success = false;
$error = '';
$user = null;

$token = $_GET['token'] ?? '';

if (empty($token) || strlen($token) !== 64) {
    $error = 'Invalid approval link.';
} else {
    try {
        $db = getDB();

        $stmt = $db->prepare('SELECT * FROM users WHERE approval_token = ?');
        $stmt->execute([$token]);
        $user = $stmt->fetch();

        if (!$user) {
            $error = 'Invalid or expired approval link.';
        } elseif ($user['is_active']) {
            $error = 'This account has already been approved.';
            $user = null;
        } else {
            $stmt = $db->prepare('UPDATE users SET is_active = 1, approval_token = NULL, approved_at = NOW() WHERE id = ?');
            $stmt->execute([$user['id']]);

            $to = $user['email'];
            $subject = "Your Bakicure Reseller Account is Approved!";

            $emailBody = "
Dear {$user['contact_person']},

Great news! Your Bakicure reseller account has been approved.

You can now log in to the Reseller Portal using:

Email: {$user['email']}
Password: (the password you created during registration)

Login here: " . SITE_URL . "/reseller/login.php

As a registered reseller, you now have access to:
- Exclusive reseller pricing
- Latest product pricelists
- Direct order enquiries
- Priority support

Welcome to the Bakicure family!

Best regards,
Bakicure Team
";

            $headers = "From: Bakicure <noreply@bakicure.co.za>\r\n";
            $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

            mail($to, $subject, $emailBody, $headers);

            $success = true;
        }
    } catch (PDOException $e) {
        $error = 'An error occurred. Please try again.';
        error_log('Approval error: ' . $e->getMessage());
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reseller Approval - Bakicure</title>
    <link rel="icon" type="image/x-icon" href="../favicon.ico">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; padding: 40px 20px; }
        .container { background: white; padding: 50px; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); width: 100%; max-width: 500px; text-align: center; }
        .logo { margin-bottom: 30px; }
        .logo img { height: 60px; }
        .icon { width: 100px; height: 100px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 24px; font-size: 50px; }
        .icon.success { background: #e8f5e9; color: #2e7d32; }
        .icon.error { background: #ffebee; color: #c62828; }
        h1 { font-size: 1.8rem; color: #333; margin-bottom: 16px; }
        p { color: #666; line-height: 1.6; margin-bottom: 16px; }
        .user-info { background: #f5f5f5; border-radius: 8px; padding: 20px; margin: 24px 0; text-align: left; }
        .user-info h3 { font-size: 14px; color: #999; margin-bottom: 12px; text-transform: uppercase; letter-spacing: 1px; }
        .user-info p { margin-bottom: 8px; font-size: 14px; }
        .user-info strong { color: #333; }
        .btn { display: inline-block; padding: 14px 32px; background: #374151; color: white; text-decoration: none; border-radius: 8px; font-weight: 600; }
        .btn:hover { opacity: 0.9; }
        .btn-secondary { background: #e0e0e0; color: #333; }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <img src="../images/logo-long.png" alt="Bakicure" onerror="this.style.display='none'">
        </div>

        <?php if ($success && $user): ?>
            <div class="icon success">&#10003;</div>
            <h1>Reseller Approved!</h1>
            <p>The account has been activated and the reseller has been notified via email.</p>

            <div class="user-info">
                <h3>Approved Reseller</h3>
                <p><strong>Company:</strong> <?= htmlspecialchars($user['company_name']) ?></p>
                <p><strong>Contact:</strong> <?= htmlspecialchars($user['contact_person']) ?></p>
                <p><strong>Email:</strong> <?= htmlspecialchars($user['email']) ?></p>
                <p><strong>Phone:</strong> <?= htmlspecialchars($user['phone']) ?></p>
            </div>

            <a href="/" class="btn">Go to Homepage</a>
        <?php else: ?>
            <div class="icon error">&#10007;</div>
            <h1>Approval Failed</h1>
            <p><?= htmlspecialchars($error) ?></p>
            <br>
            <a href="/" class="btn btn-secondary">Go to Homepage</a>
        <?php endif; ?>
    </div>
</body>
</html>