<?php 
require_once __DIR__ . '/includes/config.php'; 
require_once __DIR__ . '/includes/email_config.php';
require_once __DIR__ . '/includes/security.php';
$isReseller = isReseller(); 
$brand = 'farmcure';
$emails = getBrandEmails($brand);

$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $formType = $_POST['form_type'] ?? 'contact';
    $data = [
        'name' => htmlspecialchars($_POST['name'] ?? ''),
        'email' => filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL),
        'phone' => htmlspecialchars($_POST['phone'] ?? ''),
        'company' => htmlspecialchars($_POST['company'] ?? ''),
        'subject' => htmlspecialchars($_POST['subject'] ?? ''),
        'products' => htmlspecialchars($_POST['products'] ?? ''),
        'message' => htmlspecialchars($_POST['message'] ?? ''),
    ];
    
    if (empty($data['name']) || empty($data['email']) || empty($data['message'])) {
        $error = 'Please fill in all required fields.';
    } elseif (!filter_var($data['email'], FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } else {
        if ($formType === 'quote') {
            $sent = sendQuoteEmail($brand, $data);
        } else {
            $sent = sendContactEmail($brand, $data);
        }
        if ($sent) {
            $success = true;
        } else {
            $error = 'Failed to send message. Please try again or contact us directly.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - FarmCure | 100% Natural Farming Solutions</title>
    <meta name="description" content="Contact FarmCure for natural farming solutions, quotes, and product enquiries.">
    <link rel="icon" type="image/png" href="/images/logo-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #16a34a; --primary-dark: #14532d; --primary-light: #22c55e; --dark: #14532d; --gray-50: #f0fdf4; --gray-100: #dcfce7; --gray-600: #4d7c0f; --white: #fff; --shadow: 0 4px 20px rgba(0,0,0,0.08); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: #333; line-height: 1.7; }
        .container { max-width: 1200px; margin: 0 auto; padding: 0 24px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 75px; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: #f1f5f9; color: #64748b !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; font-size: 13px; border: none; cursor: pointer; transition: all 0.3s; }
        .btn-primary { background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-hero { background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%); padding: 160px 0 80px; color: white; text-align: center; }
        .page-hero h1 { font-size: 3rem; margin-bottom: 16px; }
        .page-hero p { opacity: 0.9; font-size: 1.2rem; }
        .contact-section { padding: 80px 0; }
        .contact-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; }
        .contact-info h2 { font-size: 2rem; margin-bottom: 20px; color: var(--dark); }
        .contact-info > p { color: #666; margin-bottom: 32px; }
        .contact-item { display: flex; align-items: flex-start; gap: 16px; margin-bottom: 24px; }
        .contact-icon { width: 50px; height: 50px; background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%); color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 20px; flex-shrink: 0; }
        .contact-item h4 { margin-bottom: 4px; color: var(--dark); }
        .contact-item p { color: #666; font-size: 14px; margin: 0; }
        .contact-item a { color: var(--primary); text-decoration: none; font-size: 14px; }
        .contact-item a:hover { text-decoration: underline; }
        .email-list { margin-top: 32px; padding: 24px; background: var(--gray-50); border-radius: var(--radius); border: 1px solid var(--gray-100); }
        .email-list h4 { margin-bottom: 16px; color: var(--dark); }
        .email-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 12px; }
        .email-item { display: flex; align-items: center; gap: 8px; font-size: 13px; }
        .email-item i { color: var(--primary); width: 16px; }
        .email-item a { color: #666; text-decoration: none; }
        .email-item a:hover { color: var(--primary); }
        .contact-form { background: var(--gray-50); padding: 40px; border-radius: var(--radius); border: 1px solid var(--gray-100); }
        .form-tabs { display: flex; gap: 8px; margin-bottom: 24px; }
        .form-tab { flex: 1; padding: 12px; text-align: center; border: 2px solid var(--gray-100); border-radius: 10px; cursor: pointer; font-weight: 600; font-size: 14px; background: white; transition: all 0.2s; }
        .form-tab.active { background: var(--primary); color: white; border-color: var(--primary); }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 600; margin-bottom: 8px; font-size: 14px; color: var(--dark); }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 14px; border: 2px solid var(--gray-100); border-radius: 10px; font-family: inherit; font-size: 14px; background: white; }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { outline: none; border-color: var(--primary); }
        .form-group textarea { min-height: 120px; resize: vertical; }
        .quote-fields { display: none; }
        .quote-fields.active { display: block; }
        .alert { padding: 16px; border-radius: 10px; margin-bottom: 20px; font-size: 14px; }
        .alert-success { background: #d1fae5; color: #065f46; }
        .alert-error { background: #fee2e2; color: #991b1b; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 768px) { .contact-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-bottom { flex-direction: column; gap: 16px; } .email-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" alt="FarmCure"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/">Home</a></li>
                <li><a href="/products.php">Products</a></li>
                <li><a href="/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <section class="page-hero">
        <div class="container">
            <h1>Contact Us</h1>
            <p>Get in touch for quotes, product enquiries, or technical support.</p>
        </div>
    </section>

    <section class="contact-section"><div class="container">
        <div class="contact-grid">
            <div class="contact-info">
                <h2>Get in Touch</h2>
                <p>We're here to help with all your natural farming solution needs. Contact us for quotes, technical advice, or product information.</p>

                <div class="contact-item">
                    <div class="contact-icon"><i class="fas fa-user"></i></div>
                    <div>
                        <h4>Francois Viljoen</h4>
                        <a href="#" class="protected-email" data-u="cois" data-d="farmcure.co.za"></a><br>
                        <a href="#" class="protected-phone" data-p="27828050405" data-d="082 805 0405"></a>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon"><i class="fas fa-user"></i></div>
                    <div>
                        <h4>Mariaan Viljoen</h4>
                        <a href="#" class="protected-email" data-u="mariaan" data-d="farmcure.co.za"></a><br>
                        <a href="#" class="protected-phone" data-p="27829077494" data-d="082 907 7494"></a>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon"><i class="fas fa-map-marker-alt"></i></div>
                    <div>
                        <h4>Location</h4>
                        <p>Pretoria, Gauteng<br>South Africa</p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon"><i class="fab fa-whatsapp"></i></div>
                    <div>
                        <h4>WhatsApp</h4>
                        <a href="https://wa.me/27828050405">Chat on WhatsApp</a>
                    </div>
                </div>
            </div>
            
            <div class="contact-form">
                <?php if ($success): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> Thank you! Your message has been sent successfully.
                    </div>
                <?php elseif ($error): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i> <?= $error ?>
                    </div>
                <?php endif; ?>
                
                <div class="form-tabs">
                    <div class="form-tab active" onclick="switchTab('contact')">General Enquiry</div>
                    <div class="form-tab" onclick="switchTab('quote')">Request Quote</div>
                </div>
                
                <form method="post" id="contactForm" onsubmit="submitContactForm(event); return false;">
                            <?= outputHoneypot() ?>
                            <?= outputTimestamp() ?>
                    <input type="hidden" name="form_type" id="formType" value="contact">
                    
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input type="text" id="name" name="name" required>
                    </div>
                    <div class="form-group">
                        <label for="email">Email Address *</label>
                        <input type="email" id="email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input type="tel" id="phone" name="phone">
                    </div>
                    
                    <div class="quote-fields" id="quoteFields">
                        <div class="form-group">
                            <label for="company">Company Name</label>
                            <input type="text" id="company" name="company">
                        </div>
                        <div class="form-group">
                            <label for="products">Products/Services Required *</label>
                            <textarea id="products" name="products" placeholder="List the products you need a quote for..."></textarea>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="message">Message *</label>
                        <textarea id="message" name="message" required></textarea>
                    </div>
                    <?= outputMathCaptcha("math_answer") ?>
                            <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fas fa-paper-plane"></i> Send Message</button>
                </form>
            </div>
        </div>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> FarmCure. Powered by Nature.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge">
                <span>Part of</span>
                <div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
            </a>
        </div>
    </div></footer>

    <script>
    function switchTab(type) {
        document.querySelectorAll('.form-tab').forEach(tab => tab.classList.remove('active'));
        event.target.classList.add('active');
        document.getElementById('formType').value = type;
        
        const quoteFields = document.getElementById('quoteFields');
        if (type === 'quote') {
            quoteFields.classList.add('active');
            document.getElementById('products').required = true;
        } else {
            quoteFields.classList.remove('active');
            document.getElementById('products').required = false;
        }
    }
    // Protect contacts from bots
    document.querySelectorAll('.protected-email').forEach(function(el) {
        var u = el.getAttribute('data-u');
        var d = el.getAttribute('data-d');
        var email = u + '@' + d;
        el.href = 'mai' + 'lto:' + email;
        el.textContent = email;
    });
    document.querySelectorAll('.protected-phone').forEach(function(el) {
        var p = el.getAttribute('data-p');
        var d = el.getAttribute('data-d');
        el.href = 't' + 'el:+' + p;
        el.textContent = d;
    });
    </script>
</body>
</html>
