<?php
require_once __DIR__ . '/includes/config.php';
$isReseller = isReseller();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FarmCure - 100% Natural Farming Solutions | Powered by Nature</title>
    <meta name="description" content="FarmCure provides 100% all-natural cleaning and disinfecting solutions for Poultry, Piggeries, Dairies, Abattoirs & Butcheries. Powered by Nature.">
    <link rel="icon" type="image/x-icon" href="/farmcure/favicon.ico">
    <link rel="apple-touch-icon" href="/farmcure/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #16a34a;
            --primary-dark: #14532d;
            --primary-light: #22c55e;
            --secondary: #84cc16;
            --accent: #65a30d;
            --white: #fff;
            --gray-50: #f0fdf4;
            --gray-100: #dcfce7;
            --gray-600: #4d7c0f;
            --dark: #14532d;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: #333; line-height: 1.7; }
        .container { max-width: 1200px; margin: 0 auto; padding: 0 24px; }

        /* Header */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: rgba(255,255,255,0.97);
            backdrop-filter: blur(20px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.06);
        }
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 0;
        }
        .logo img { height: 75px; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav a {
            text-decoration: none;
            color: #64748b;
            font-weight: 500;
            font-size: 13px;
            padding: 8px 14px;
            border-radius: 8px;
            transition: all 0.2s;
        }
        .nav a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: #f1f5f9; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 10px 18px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 13px;
            text-decoration: none;
            transition: all 0.3s;
        }
        .btn-primary { background: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary) 100%); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }

        /* Hero Section */
        .hero {
            padding: 140px 0 80px;
            background: linear-gradient(135deg, rgba(20,83,45,0.95) 0%, rgba(22,163,74,0.9) 100%);
            position: relative;
            overflow: hidden;
        }
        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('https://images.unsplash.com/photo-1500382017468-9049fed747ef?w=1920&q=80') center/cover;
            opacity: 0.2;
            z-index: 0;
        }
        .hero .container { position: relative; z-index: 1; }
        .hero-content {
            display: grid;
            grid-template-columns: 1fr 1.2fr;
            gap: 60px;
            align-items: center;
        }
        .hero-text { color: white; }
        .hero-badge {
            display: inline-block;
            background: rgba(255,255,255,0.2);
            padding: 8px 20px;
            border-radius: 50px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 20px;
        }
        .hero h1 {
            font-size: 2.8rem;
            font-weight: 800;
            margin-bottom: 16px;
            line-height: 1.1;
        }
        .hero-tagline {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-bottom: 32px;
        }
        .industries-list {
            display: flex;
            flex-wrap: wrap;
            gap: 12px;
            margin-bottom: 32px;
        }
        .industry-tag {
            background: rgba(255,255,255,0.15);
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .hero-images {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 16px;
        }
        .hero-img {
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 8px 30px rgba(0,0,0,0.3);
        }
        .hero-img img {
            width: 100%;
            height: 180px;
            object-fit: cover;
            display: block;
        }

        /* Creation Section */
        .creation {
            padding: 100px 0;
            background: linear-gradient(180deg, var(--gray-50) 0%, white 100%);
        }
        .creation-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 80px;
            align-items: center;
        }
        .section-badge {
            display: inline-block;
            background: rgba(22,163,74,0.1);
            color: var(--primary);
            padding: 8px 20px;
            border-radius: 50px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 16px;
        }
        .creation h2 {
            font-size: 2.2rem;
            color: var(--primary-dark);
            margin-bottom: 24px;
        }
        .creation p {
            color: #555;
            margin-bottom: 16px;
            font-size: 15px;
        }
        .creation-highlight {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 20px 24px;
            border-radius: 12px;
            margin-top: 24px;
            font-size: 14px;
        }
        .creation-images {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 16px;
            position: relative;
        }
        .creation-img {
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
            position: relative;
            transition: all 0.4s ease;
        }
        .creation-img:hover {
            transform: translateY(-8px) scale(1.02);
            box-shadow: 0 16px 50px rgba(22,163,74,0.25);
        }
        .creation-img img {
            width: 100%;
            height: 180px;
            object-fit: cover;
            transition: transform 0.4s ease;
        }
        .creation-img:hover img {
            transform: scale(1.1);
        }
        .creation-img.large {
            grid-column: span 2;
        }
        .creation-img.large img {
            height: 220px;
        }
        .creation-img .img-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 16px;
            background: linear-gradient(transparent, rgba(20,83,45,0.9));
            color: white;
            font-size: 13px;
            font-weight: 500;
            opacity: 0;
            transition: opacity 0.3s;
        }
        .creation-img:hover .img-overlay {
            opacity: 1;
        }

        /* Objective Section */
        .objective {
            padding: 100px 0;
            background: linear-gradient(135deg, rgba(20,83,45,0.95) 0%, rgba(22,163,74,0.92) 100%);
            position: relative;
            color: white;
        }
        .objective::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('https://images.unsplash.com/photo-1586771107445-d3ca888129ff?w=1920&q=80') center/cover;
            opacity: 0.15;
        }
        .objective .container { position: relative; z-index: 1; }
        .objective-header {
            text-align: center;
            margin-bottom: 60px;
        }
        .objective h2 {
            font-size: 2.5rem;
            margin-bottom: 16px;
        }
        .objective-intro {
            max-width: 800px;
            margin: 0 auto 24px;
            font-size: 1.1rem;
            opacity: 0.95;
        }
        .biosecurity-note {
            background: rgba(255,255,255,0.1);
            padding: 16px 24px;
            border-radius: 10px;
            max-width: 700px;
            margin: 0 auto;
            font-size: 14px;
            font-style: italic;
        }
        .steps-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 24px;
        }
        .step-card {
            background: rgba(255,255,255,0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 28px;
            border: none;
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
            color: #333;
        }
        .step-header {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-bottom: 16px;
        }
        .step-number {
            width: 50px;
            height: 50px;
            background: var(--secondary);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            font-weight: 800;
            color: var(--primary-dark);
        }
        .step-card h3 {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--primary-dark);
        }
        .step-card ul {
            list-style: none;
            font-size: 13px;
            color: #555;
        }
        .step-card li {
            padding: 6px 0;
            padding-left: 20px;
            position: relative;
        }
        .step-card li::before {
            content: '';
            position: absolute;
            left: 0;
            top: 12px;
            width: 8px;
            height: 8px;
            background: var(--secondary);
            border-radius: 50%;
        }
        .step-note {
            background: linear-gradient(135deg, rgba(22,163,74,0.1) 0%, rgba(132,204,22,0.15) 100%);
            padding: 12px 16px;
            border-radius: 8px;
            font-size: 12px;
            margin-top: 12px;
            border-left: 3px solid var(--primary);
            color: var(--primary-dark);
        }

        /* Products Section */
        .products {
            padding: 100px 0;
            background: white;
        }
        .products-header {
            text-align: center;
            margin-bottom: 60px;
        }
        .products h2 {
            font-size: 2.2rem;
            color: var(--primary-dark);
            margin-bottom: 16px;
        }
        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 24px;
        }
        .product-card {
            background: var(--gray-50);
            border-radius: 16px;
            padding: 28px;
            border: 1px solid var(--gray-100);
            transition: all 0.3s;
        }
        .product-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 40px rgba(22,163,74,0.15);
        }
        .product-card h3 {
            color: var(--primary-dark);
            font-size: 1.1rem;
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .product-card h3 i {
            color: var(--primary);
        }
        .product-card p {
            color: #555;
            font-size: 13px;
            margin-bottom: 12px;
        }
        .product-card ul {
            list-style: none;
            font-size: 12px;
            color: #666;
        }
        .product-card li {
            padding: 4px 0;
            display: flex;
            align-items: flex-start;
            gap: 8px;
        }
        .product-card li i {
            color: var(--primary);
            margin-top: 4px;
        }
        .product-sizes {
            margin-top: 12px;
            padding-top: 12px;
            border-top: 1px solid var(--gray-100);
            font-size: 11px;
            color: var(--primary);
        }

        /* Quote Button & Modal */
        .quote-btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            margin-top: 16px;
            padding: 10px 18px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
        }
        .quote-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(22,163,74,0.35);
        }
        .floating-quote {
            position: fixed;
            bottom: 30px;
            right: 30px;
            z-index: 999;
            padding: 16px 28px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            border: none;
            border-radius: 50px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 8px 30px rgba(22,163,74,0.4);
            display: flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s;
            text-decoration: none;
        }
        .floating-quote:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 12px 40px rgba(22,163,74,0.5);
        }
        .floating-quote i {
            font-size: 18px;
        }
        .quote-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.7);
            z-index: 2000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .quote-modal.active {
            display: flex;
        }
        .quote-modal-content {
            background: white;
            border-radius: 20px;
            max-width: 500px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            animation: modalSlide 0.3s ease;
        }
        @keyframes modalSlide {
            from { opacity: 0; transform: translateY(-30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .quote-modal-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 24px 28px;
            border-radius: 20px 20px 0 0;
        }
        .quote-modal-header h3 {
            font-size: 1.4rem;
            margin-bottom: 4px;
        }
        .quote-modal-header p {
            opacity: 0.9;
            font-size: 14px;
        }
        .quote-modal-close {
            position: absolute;
            top: 16px;
            right: 20px;
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            font-size: 18px;
            cursor: pointer;
            transition: all 0.2s;
        }
        .quote-modal-close:hover {
            background: rgba(255,255,255,0.3);
            transform: rotate(90deg);
        }
        .quote-form {
            padding: 28px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: var(--primary-dark);
            margin-bottom: 8px;
        }
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid var(--gray-100);
            border-radius: 10px;
            font-size: 14px;
            font-family: inherit;
            transition: all 0.2s;
        }
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(22,163,74,0.1);
        }
        .form-group textarea {
            min-height: 100px;
            resize: vertical;
        }
        .product-checkboxes {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
        }
        .product-checkbox {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 10px 12px;
            background: var(--gray-50);
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.2s;
            font-size: 12px;
        }
        .product-checkbox:hover {
            background: var(--gray-100);
        }
        .product-checkbox input {
            width: auto;
            accent-color: var(--primary);
        }
        .submit-quote {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        .submit-quote:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(22,163,74,0.35);
        }

        /* Contact Section */
        .contact {
            padding: 80px 0;
            background: var(--primary-dark);
            color: white;
            text-align: center;
        }
        .contact h2 {
            font-size: 2rem;
            margin-bottom: 32px;
        }
        .contact-grid {
            display: flex;
            justify-content: center;
            gap: 48px;
            flex-wrap: wrap;
            margin-bottom: 32px;
        }
        .contact-item {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .contact-item i {
            width: 50px;
            height: 50px;
            background: rgba(255,255,255,0.1);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }
        .contact-item span {
            font-size: 15px;
        }
        .certifications {
            display: flex;
            justify-content: center;
            gap: 24px;
            margin-top: 32px;
            opacity: 0.7;
        }
        .certifications img {
            height: 40px;
            filter: brightness(0) invert(1);
        }

        /* Footer */
        .footer {
            background: #0f3d1f;
            padding: 32px 0;
            text-align: center;
        }
        .footer-bottom {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 16px;
        }
        .footer p {
            color: rgba(255,255,255,0.5);
            font-size: 13px;
        }
        .multicure-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            color: rgba(255,255,255,0.7);
            font-size: 13px;
            text-decoration: none;
        }
        .multicure-badge .badge-logo {
            background: rgba(255,255,255,0.95);
            padding: 8px 16px;
            border-radius: 8px;
        }
        .multicure-badge img { height: 28px; display: block; }

        /* Mobile */
        .mobile-menu-btn { display: none; background: none; border: none; font-size: 24px; color: var(--primary); cursor: pointer; }
        @media (max-width: 1024px) {
            .hero-content { grid-template-columns: 1fr; text-align: center; }
            .hero-images { max-width: 500px; margin: 0 auto; }
            .industries-list { justify-content: center; }
            .creation-grid { grid-template-columns: 1fr; }
            .steps-grid { grid-template-columns: 1fr; }
        }
        @media (max-width: 768px) {
            .nav a:not(.multicure-link):not(.btn) { display: none; }
            .mobile-menu-btn { display: block; }
            .hero { padding: 120px 0 60px; }
            .hero h1 { font-size: 2rem; }
            .hero-images { grid-template-columns: 1fr; }
            .creation, .objective, .products { padding: 60px 0; }
            .products-grid { grid-template-columns: 1fr; }
            .contact-grid { flex-direction: column; align-items: center; }
            .footer-bottom { justify-content: center; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/farmcure/" class="logo">
                    <img src="/farmcure/images/logo-long.png" alt="FarmCure">
                </a>
                <nav class="nav">
                    <a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a>
                    <a href="/farmcure/">Home</a>
                    <a href="#products">Products</a>
                    <a href="/farmcure/contact.php">Contact</a>
                    <button class="mobile-menu-btn"><i class="fas fa-bars"></i></button>
                    <?php if ($isReseller): ?>
                        <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
                    <?php else: ?>
                        <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <span class="hero-badge"><i class="fas fa-leaf"></i> Powered by Nature</span>
                    <h1>100% Natural Farming Solutions</h1>
                    <p class="hero-tagline">Cleaning & Disinfecting for the Following Industries:</p>
                    <div class="industries-list">
                        <span class="industry-tag"><i class="fas fa-egg"></i> Poultry</span>
                        <span class="industry-tag"><i class="fas fa-piggy-bank"></i> Piggeries</span>
                        <span class="industry-tag"><i class="fas fa-cow"></i> Dairies</span>
                        <span class="industry-tag"><i class="fas fa-industry"></i> Abattoirs</span>
                        <span class="industry-tag"><i class="fas fa-store"></i> Butcheries</span>
                    </div>
                    <a href="#contact" class="btn btn-primary" style="background: white; color: var(--primary-dark);"><i class="fas fa-phone"></i> Contact Us</a>
                </div>
                <div class="hero-images">
                    <div class="hero-img"><img src="https://images.unsplash.com/photo-1548550023-2bdb3c5beed7?w=400&h=300&fit=crop" alt="Poultry Farm"></div>
                    <div class="hero-img"><img src="https://images.unsplash.com/photo-1516467508483-a7212febe31a?w=400&h=300&fit=crop" alt="Dairy Cattle"></div>
                    <div class="hero-img"><img src="https://images.unsplash.com/photo-1604848698030-c434ba08ece1?w=400&h=300&fit=crop" alt="Pig Farm"></div>
                    <div class="hero-img"><img src="https://images.unsplash.com/photo-1500595046743-cd271d694d30?w=400&h=300&fit=crop" alt="Farm Animals"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Creation Section -->
    <section class="creation">
        <div class="container">
            <div class="creation-grid">
                <div class="creation-content">
                    <span class="section-badge"><i class="fas fa-seedling"></i> Our Story</span>
                    <h2>The Creation of FarmCure</h2>
                    <p>Taking environmental health and the future of our planet seriously, is not just <strong>FarmCure's</strong> ethos, but also our business catalyst and driver.</p>
                    <p>In the past, <span style="color: var(--primary); font-weight: 600;">green products</span> did not measure up to the cleaning effectiveness of their chemical counterparts. With the global movement towards environmentally conscious living, a misconception developed that green products and all-natural cleaning products are the same.</p>
                    <p>However, while green products offer a safer, less toxic alternative, they do not use <span style="color: var(--primary); font-weight: 600;">all-natural ingredients</span>. With countless industries buzzing with the idea of going green, the real impact of environmentally conscious living can only be achieved by going <strong>100% all-natural</strong> – by using our products true eco-friendly and non-toxic results can then be achieved.</p>
                    <p>We also believe that training is essential! Too often biosecurity processes are left to unsupervised and untrained staff to carry-out these crucial tasks. This often leads to undesired results and product wastage.</p>
                    <div class="creation-highlight">
                        <strong>NOTE:</strong> With the implementation of <strong>our products</strong>, we offer ongoing training & support to your staff.
                    </div>
                </div>
                <div class="creation-images">
                    <div class="creation-img">
                        <img src="https://images.unsplash.com/photo-1605000797499-95a51c5269ae?w=500&h=400&fit=crop" alt="Farmer Working">
                        <div class="img-overlay"><i class="fas fa-user-check"></i> Expert Training Provided</div>
                    </div>
                    <div class="creation-img">
                        <img src="https://images.unsplash.com/photo-1594771804886-a933bb2d609b?w=500&h=400&fit=crop" alt="Sustainable Farming">
                        <div class="img-overlay"><i class="fas fa-leaf"></i> 100% Natural Products</div>
                    </div>
                    <div class="creation-img">
                        <img src="https://images.unsplash.com/photo-1560493676-04071c5f467b?w=500&h=400&fit=crop" alt="Poultry Farm">
                        <div class="img-overlay"><i class="fas fa-egg"></i> Poultry Solutions</div>
                    </div>
                    <div class="creation-img">
                        <img src="https://images.unsplash.com/photo-1516467508483-a7212febe31a?w=500&h=400&fit=crop" alt="Dairy Farm">
                        <div class="img-overlay"><i class="fas fa-cow"></i> Dairy Biosecurity</div>
                    </div>
                    <div class="creation-img large">
                        <img src="https://images.unsplash.com/photo-1574943320219-553eb213f72d?w=900&h=500&fit=crop" alt="Farm Team Working">
                        <div class="img-overlay"><i class="fas fa-hands-helping"></i> Ongoing Support & Training for Your Team</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Objective Section -->
    <section class="objective">
        <div class="container">
            <div class="objective-header">
                <span class="section-badge" style="background: rgba(255,255,255,0.2); color: white;"><i class="fas fa-bullseye"></i> Our Approach</span>
                <h2>OBJECTIVE</h2>
                <p class="objective-intro">Not to sterilize, but rather to decrease the pathogen load significantly to prevent transmission of diseases, therefore creating a <strong>TRUE BIOSECURITY</strong> environment.</p>
                <div class="biosecurity-note">
                    "Biosecurity" - Implementing SOP's to protect the population against harmful biological or biochemical substances.
                </div>
            </div>
            <div class="steps-grid">
                <div class="step-card">
                    <div class="step-header">
                        <div class="step-number">1</div>
                        <h3>CLEANING</h3>
                    </div>
                    <ul>
                        <li>Remove excessive manure, urine and feed with shovels, brooms and/or squeegees to decrease the organic load.</li>
                        <li>In preparation for cleaning, wet all surfaces with a hosepipe or pressure washer.</li>
                    </ul>
                </div>
                <div class="step-card">
                    <div class="step-header">
                        <div class="step-number">2</div>
                        <h3>WASHING</h3>
                    </div>
                    <ul>
                        <li>Use the foaming lance to dispense the "FarmCure Degreaser" and spray all walls, floors and equipment.</li>
                        <li>Allow sufficient dwell time for soaking to break down the organic matter (recommended 5 – 10 minutes).</li>
                        <li>Brush the treated surfaces with a hard broom.</li>
                        <li>Rinse all treated surfaces using a high-pressure gun (use hot water if available).</li>
                        <li>Allow all treated surfaces to air-dry (24 – 48hours if possible).</li>
                    </ul>
                </div>
                <div class="step-card">
                    <div class="step-header">
                        <div class="step-number">3</div>
                        <h3>DISINFECTING</h3>
                    </div>
                    <ul>
                        <li>Use the foaming lance with "FarmCure Natural Disinfectant S-A-S" and spray all walls, floors and equipment and allow to air-dry.</li>
                    </ul>
                    <div class="step-note">
                        <strong>Note:</strong> Disinfecting with the foaming lance ensures you don't miss any of the surfaces and it also increases the products contact time.
                    </div>
                </div>
                <div class="step-card">
                    <div class="step-header">
                        <div class="step-number">4</div>
                        <h3>SLURRY DRAIN MIXTURE</h3>
                    </div>
                    <ul>
                        <li>Fill each Slurry Drain to the depth of 250mm with clean water.</li>
                        <li>Add 20L of our "Slurry Mix" to each of the respective drains in weeks 1, 3 & 5.</li>
                        <li>The product to be dispersed with a high-pressure gun. Spray directly over the floor grids, allowing the product to enter the drain below, through the floor grids.</li>
                    </ul>
                </div>
                <div class="step-card">
                    <div class="step-header">
                        <div class="step-number">5</div>
                        <h3>FOOT BATHS</h3>
                    </div>
                    <ul>
                        <li>Fill all foot baths with water.</li>
                        <li>Dilute "FarmCure S-A-W Disinfectant Powder" at a dilution ratio of 1gr / 500ml water (1:500).</li>
                    </ul>
                    <div class="step-note">
                        <strong>Note:</strong> The foot bath disinfectant does not have to be changed daily, it only needs to be changed if it's very dirty, or if the pH is above 4.5
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Products Section -->
    <section class="products" id="products">
        <div class="container">
            <div class="products-header">
                <span class="section-badge"><i class="fas fa-box"></i> Our Range</span>
                <h2>FARMCURE Product List</h2>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <h3><i class="fas fa-pump-soap"></i> FarmCure Degreaser</h3>
                    <p>A combination of all-natural microbes and enzymes that consumes fats, oils and grease (FOG) as well as food waste. Digests them into water and carbon dioxide, providing a deep clean, slip free finish to surfaces.</p>
                    <div class="product-sizes">Available in 750ml (Ready to use), 1L (Refill), 5L (Concentrate), 20L (Concentrate) & 5L (Super Concentrate)</div>
                    <button class="quote-btn" onclick="openQuote('FarmCure Degreaser')"><i class="fas fa-file-invoice"></i> Get Quote</button>
                </div>
                <div class="product-card">
                    <h3><i class="fas fa-shield-virus"></i> FarmCure Natural Disinfectant S-A-S</h3>
                    <ul>
                        <li><i class="fas fa-check"></i> Extremely effective disinfectant, cleaner and deodoriser</li>
                        <li><i class="fas fa-check"></i> Doesn't contain any chlorine, QUATS or alcohol</li>
                        <li><i class="fas fa-check"></i> Perfect disinfectant for food, animal & general cleaning areas</li>
                        <li><i class="fas fa-check"></i> Safe to use around people and animals</li>
                    </ul>
                    <div class="product-sizes">Available in 750ml (Ready to use), 1L (Refill), 5L (Ready to use), 20L (Ready to use) & 5L (Super Concentrate)</div>
                    <button class="quote-btn" onclick="openQuote('FarmCure Natural Disinfectant S-A-S')"><i class="fas fa-file-invoice"></i> Get Quote</button>
                </div>
                <div class="product-card">
                    <h3><i class="fas fa-bacteria"></i> FarmCure Natural Disinfectant S-A-M</h3>
                    <p>A complete biological formula designed to disinfect, clean and deodorise.</p>
                    <ul>
                        <li><i class="fas fa-check"></i> Doesn't contain any chlorine, QUATS or alcohol</li>
                        <li><i class="fas fa-check"></i> Eliminates a broad spectrum of bacteria, mycobacteria, viruses and fungi</li>
                        <li><i class="fas fa-check"></i> Use as a disinfectant on animals - helps with healing of cuts, bruises & infections</li>
                    </ul>
                    <div class="product-sizes">Available in 750ml (Ready to use), 1L (Refill), 5L (Ready to use), 20L (Ready to use) & 5L (Super Concentrate)</div>
                    <button class="quote-btn" onclick="openQuote('FarmCure Natural Disinfectant S-A-M')"><i class="fas fa-file-invoice"></i> Get Quote</button>
                </div>
                <div class="product-card">
                    <h3><i class="fas fa-water"></i> FarmCure Slurry Drain Care Liquid</h3>
                    <ul>
                        <li><i class="fas fa-check"></i> A blend of botanical extracts and vitamins which convert FOG into carbon dioxide and water</li>
                        <li><i class="fas fa-check"></i> Reduces trap clogging, rancid odours and eliminates FOG build-up</li>
                        <li><i class="fas fa-check"></i> Safe for people, plumbing and the environment</li>
                    </ul>
                    <div class="product-sizes">Available in 100ml, 5L</div>
                    <button class="quote-btn" onclick="openQuote('FarmCure Slurry Drain Care Liquid')"><i class="fas fa-file-invoice"></i> Get Quote</button>
                </div>
                <div class="product-card">
                    <h3><i class="fas fa-cubes"></i> FarmCure Slurry Drain Care Granules</h3>
                    <ul>
                        <li><i class="fas fa-check"></i> Proprietary blend of aerobic and anaerobic bacteria selected for their ability to degrade organic waste</li>
                        <li><i class="fas fa-check"></i> Converts waste particles into water and carbon dioxide</li>
                        <li><i class="fas fa-check"></i> Safe for people, plumbing and the environment</li>
                    </ul>
                    <div class="product-sizes">Available in 50gr Sachet, 1Kg</div>
                    <button class="quote-btn" onclick="openQuote('FarmCure Slurry Drain Care Granules')"><i class="fas fa-file-invoice"></i> Get Quote</button>
                </div>
                <div class="product-card">
                    <h3><i class="fas fa-hand-sparkles"></i> FarmCure S-A-W Disinfectant Powder</h3>
                    <ul>
                        <li><i class="fas fa-check"></i> Anti-microbial treatment with multiple uses</li>
                        <li><i class="fas fa-check"></i> Used as a disinfectant in foot baths in the farming sector</li>
                        <li><i class="fas fa-check"></i> Breaks down bio-film build-up in pipes and equipment</li>
                        <li><i class="fas fa-check"></i> Used for washing of fresh fruits, vegetables, fish and poultry - eliminates pathogens such as E-Coli & Salmonella</li>
                        <li><i class="fas fa-check"></i> The product does not leave any residue</li>
                    </ul>
                    <div class="product-sizes">Available in 15gr Sachet, 1Kg</div>
                    <button class="quote-btn" onclick="openQuote('FarmCure S-A-W Disinfectant Powder')"><i class="fas fa-file-invoice"></i> Get Quote</button>
                </div>
                <div class="product-card">
                    <h3><i class="fas fa-soap"></i> FarmCure Skin Wash</h3>
                    <ul>
                        <li><i class="fas fa-check"></i> Bio-Active cleaner that is gentle on hands & skin of humans & animals</li>
                        <li><i class="fas fa-check"></i> Removes general fat, oil and soil build-up, whilst still protecting the skin</li>
                        <li><i class="fas fa-check"></i> Non-allergenic, as it contains 100% natural ingredients</li>
                    </ul>
                    <div class="product-sizes">Available in 1L, 5L, 20L</div>
                    <button class="quote-btn" onclick="openQuote('FarmCure Skin Wash')"><i class="fas fa-file-invoice"></i> Get Quote</button>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact" id="contact">
        <div class="container">
            <h2>Get in Touch</h2>
            <div class="contact-grid">
                <div class="contact-item">
                    <i class="fas fa-globe"></i>
                    <span>www.farmcure.co.za</span>
                </div>
                <div class="contact-item">
                    <i class="fas fa-user"></i>
                    <span>Francois Viljoen</span>
                </div>
                <div class="contact-item">
                    <i class="fas fa-phone"></i>
                    <a href="#" class="protected-phone" data-p="27828050405" data-d="082 805 0405"></a>
                </div>
                <div class="contact-item">
                    <i class="fas fa-envelope"></i>
                    <a href="#" class="protected-email" data-u="cois" data-d="farmcure.co.za"></a>
                </div>
                <div class="contact-item" style="margin-top: 16px;">
                    <i class="fas fa-user"></i>
                    <span>Mariaan Viljoen</span>
                </div>
                <div class="contact-item">
                    <i class="fas fa-phone"></i>
                    <a href="#" class="protected-phone" data-p="27829077494" data-d="082 907 7494"></a>
                </div>
                <div class="contact-item">
                    <i class="fas fa-envelope"></i>
                    <a href="#" class="protected-email" data-u="mariaan" data-d="farmcure.co.za"></a>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> FarmCure. All rights reserved.</p>
                <a href="https://omnicure.co.za/" class="multicure-badge">
                    <span>Part of</span>
                    <div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
                </a>
            </div>
        </div>
    </footer>

    <!-- Floating Quote Button -->
    <button class="floating-quote" onclick="openQuote()">
        <i class="fas fa-file-invoice-dollar"></i>
        <span>Get a Quote</span>
    </button>

    <!-- Quote Modal -->
    <div class="quote-modal" id="quoteModal">
        <div class="quote-modal-content">
            <div class="quote-modal-header">
                <h3>Request a Quote</h3>
                <p>We'll get back to you within 24 hours</p>
                <button class="quote-modal-close" onclick="closeQuote()">&times;</button>
            </div>
            <form class="quote-form" action="mailto:cois@farmcure.co.za" method="post" enctype="text/plain" onsubmit="return handleQuoteSubmit(this)">
                <div class="form-group">
                    <label><i class="fas fa-user"></i> Your Name</label>
                    <input type="text" name="name" placeholder="Full name" required>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-building"></i> Company / Farm Name</label>
                    <input type="text" name="company" placeholder="Your company or farm name">
                </div>
                <div class="form-group">
                    <label><i class="fas fa-envelope"></i> Email Address</label>
                    <input type="email" name="email" placeholder="your@email.com" required>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-phone"></i> Phone Number</label>
                    <input type="tel" name="phone" placeholder="Your contact number" required>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-industry"></i> Industry Type</label>
                    <select name="industry" required>
                        <option value="">Select your industry...</option>
                        <option value="Poultry">Poultry</option>
                        <option value="Piggeries">Piggeries</option>
                        <option value="Dairies">Dairies</option>
                        <option value="Abattoirs">Abattoirs</option>
                        <option value="Butcheries">Butcheries</option>
                        <option value="Other">Other</option>
                    </select>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-box"></i> Products of Interest</label>
                    <div class="product-checkboxes">
                        <label class="product-checkbox">
                            <input type="checkbox" name="products" value="Degreaser" id="prod_degreaser"> Degreaser
                        </label>
                        <label class="product-checkbox">
                            <input type="checkbox" name="products" value="S-A-S" id="prod_sas"> Disinfectant S-A-S
                        </label>
                        <label class="product-checkbox">
                            <input type="checkbox" name="products" value="S-A-M" id="prod_sam"> Disinfectant S-A-M
                        </label>
                        <label class="product-checkbox">
                            <input type="checkbox" name="products" value="Slurry Liquid" id="prod_slurry_liquid"> Slurry Liquid
                        </label>
                        <label class="product-checkbox">
                            <input type="checkbox" name="products" value="Slurry Granules" id="prod_slurry_granules"> Slurry Granules
                        </label>
                        <label class="product-checkbox">
                            <input type="checkbox" name="products" value="S-A-W Powder" id="prod_saw"> S-A-W Powder
                        </label>
                        <label class="product-checkbox">
                            <input type="checkbox" name="products" value="Skin Wash" id="prod_skinwash"> Skin Wash
                        </label>
                        <label class="product-checkbox">
                            <input type="checkbox" name="products" value="Full Range" id="prod_full"> Full Range
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-comment"></i> Additional Requirements</label>
                    <textarea name="message" placeholder="Tell us about your specific needs, quantities required, or any questions..."></textarea>
                </div>
                <button type="submit" class="submit-quote">
                    <i class="fas fa-paper-plane"></i> Send Quote Request
                </button>
            </form>
        </div>
    </div>

    <script>
        function openQuote(product) {
            document.getElementById('quoteModal').classList.add('active');
            document.body.style.overflow = 'hidden';

            // If a specific product was clicked, pre-select it
            if (product) {
                const checkboxes = document.querySelectorAll('.product-checkbox input');
                checkboxes.forEach(cb => {
                    if (product.toLowerCase().includes(cb.value.toLowerCase()) ||
                        cb.value.toLowerCase().includes(product.toLowerCase().split(' ').pop())) {
                        cb.checked = true;
                    }
                });
            }
        }

        function closeQuote() {
            document.getElementById('quoteModal').classList.remove('active');
            document.body.style.overflow = '';
        }

        // Close modal on outside click
        document.getElementById('quoteModal').addEventListener('click', function(e) {
            if (e.target === this) closeQuote();
        });

        // Close on escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') closeQuote();
        });

        function handleQuoteSubmit(form) {
            // Get selected products
            const products = [];
            form.querySelectorAll('input[name="products"]:checked').forEach(cb => {
                products.push(cb.value);
            });

            // Build email body
            const name = form.querySelector('input[name="name"]').value;
            const company = form.querySelector('input[name="company"]').value;
            const email = form.querySelector('input[name="email"]').value;
            const phone = form.querySelector('input[name="phone"]').value;
            const industry = form.querySelector('select[name="industry"]').value;
            const message = form.querySelector('textarea[name="message"]').value;

            const subject = encodeURIComponent('FarmCure Quote Request - ' + (company || name));
            const body = encodeURIComponent(
                'Quote Request from FarmCure Website\n' +
                '================================\n\n' +
                'Name: ' + name + '\n' +
                'Company/Farm: ' + company + '\n' +
                'Email: ' + email + '\n' +
                'Phone: ' + phone + '\n' +
                'Industry: ' + industry + '\n\n' +
                'Products of Interest:\n' + (products.length ? '- ' + products.join('\n- ') : 'Not specified') + '\n\n' +
                'Additional Requirements:\n' + (message || 'None specified') + '\n'
            );

            window.location.href = 'mailto:cois@farmcure.co.za?subject=' + subject + '&body=' + body;

            // Show thank you message
            setTimeout(() => {
                alert('Thank you! Your email client should open with your quote request. If not, please email us directly at cois@farmcure.co.za');
                closeQuote();
            }, 500);

            return false;
        }
    </script>
    <script>
    // Protect contacts from bots
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.protected-email').forEach(function(el) {
            var u = el.getAttribute('data-u');
            var d = el.getAttribute('data-d');
            var email = u + '@' + d;
            el.href = 'mai' + 'lto:' + email;
            el.textContent = email;
        });
        document.querySelectorAll('.protected-phone').forEach(function(el) {
            var p = el.getAttribute('data-p');
            var d = el.getAttribute('data-d');
            el.href = 't' + 'el:+' + p;
            el.textContent = d;
        });
    });
    </script>
</body>
</html>
