<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products - FarmCure | 100% Natural Farming Solutions</title>
    <meta name="description" content="100% all-natural cleaning and disinfecting solutions for Poultry, Piggeries, Dairies, Abattoirs & Butcheries.">
    <link rel="icon" type="image/x-icon" href="/farmcure/favicon.ico">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #16a34a; --primary-dark: #14532d; --primary-light: #22c55e; --secondary: #84cc16; --accent: #65a30d; --white: #fff; --gray-50: #f0fdf4; --gray-100: #dcfce7; --gray-200: #bbf7d0; --gray-600: #4d7c0f; --dark: #14532d; --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: #333; line-height: 1.7; }
        .container { max-width: 1200px; margin: 0 auto; padding: 0 24px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 75px; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; }
        .nav-links a { text-decoration: none; color: #64748b; font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: #f1f5f9; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; font-size: 13px; text-decoration: none; transition: all 0.3s; border: none; cursor: pointer; }
        .btn-primary { background: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary) 100%); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-sm { padding: 8px 14px; font-size: 12px; }
        .page-header { background: linear-gradient(135deg, rgba(20,83,45,0.95) 0%, rgba(22,163,74,0.9) 100%); padding: 160px 0 80px; color: white; text-align: center; position: relative; overflow: hidden; }
        .page-header::before { content: ''; position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: url('https://images.unsplash.com/photo-1500382017468-9049fed747ef?w=1920&q=80') center/cover; opacity: 0.2; }
        .page-header .container { position: relative; z-index: 1; }
        .page-header h1 { font-size: 3rem; margin-bottom: 16px; }
        .page-header p { opacity: 0.9; max-width: 700px; margin: 0 auto 24px; }
        .certifications { display: flex; justify-content: center; gap: 24px; flex-wrap: wrap; }
        .cert-badge { background: rgba(255,255,255,0.15); padding: 8px 16px; border-radius: 50px; font-size: 13px; display: flex; align-items: center; gap: 8px; }
        .section { padding: 80px 0; }
        .section-alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(22,163,74,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.2rem; font-weight: 700; margin-bottom: 16px; color: var(--dark); }
        .section-header p { color: var(--gray-600); max-width: 700px; margin: 0 auto; }
        .products-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; }
        .product-card { background: white; border-radius: var(--radius); overflow: hidden; box-shadow: var(--shadow); transition: all 0.3s; }
        .product-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); }
        .product-image { height: 160px; overflow: hidden; }
        .product-image img { width: 100%; height: 100%; object-fit: cover; }
        .product-header { background: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary) 100%); color: white; padding: 20px; }
        .product-header h3 { font-size: 1.1rem; margin-bottom: 4px; }
        .product-header span { font-size: 12px; opacity: 0.9; }
        .product-content { padding: 20px; }
        .product-content p { color: #666; font-size: 13px; margin-bottom: 16px; line-height: 1.6; }
        .product-features { list-style: none; margin-bottom: 16px; }
        .product-features li { font-size: 12px; color: #666; padding: 4px 0; padding-left: 20px; position: relative; }
        .product-features li::before { content: '\f00c'; font-family: 'Font Awesome 6 Free'; font-weight: 900; position: absolute; left: 0; color: var(--primary); font-size: 10px; }
        .product-sizes { font-size: 11px; color: #666; background: var(--gray-50); padding: 8px 12px; border-radius: 8px; margin-bottom: 16px; }
        .product-actions { display: flex; gap: 8px; }
        .product-actions .btn { flex: 1; justify-content: center; }
        .industries { display: grid; grid-template-columns: repeat(5, 1fr); gap: 16px; margin-bottom: 40px; }
        .industry-card { background: white; border-radius: var(--radius); padding: 24px; text-align: center; box-shadow: var(--shadow); }
        .industry-card i { font-size: 2rem; color: var(--primary); margin-bottom: 12px; }
        .industry-card h4 { font-size: 0.9rem; color: var(--dark); }
        .cta { background: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary) 100%); padding: 80px 0; text-align: center; color: white; }
        .cta h2 { font-size: 2.2rem; margin-bottom: 16px; }
        .cta p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-content { display: flex; justify-content: space-between; align-items: center; }
        .footer p { color: rgba(255,255,255,0.6); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .products-grid { grid-template-columns: repeat(2, 1fr); } .industries { grid-template-columns: repeat(3, 1fr); } }
        @media (max-width: 768px) { .products-grid { grid-template-columns: 1fr; } .industries { grid-template-columns: repeat(2, 1fr); } .nav-links { display: none; } .footer-content { flex-direction: column; gap: 16px; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/farmcure/" class="logo"><img src="/farmcure/images/logo-long.png" alt="FarmCure"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/farmcure/">Home</a></li>
                <li><a href="/farmcure/products.php" class="active">Products</a></li>
                <li><a href="/farmcure/about.php">About Us</a></li>
                <li><a href="/farmcure/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <section class="page-header">
        <div class="container">
            <h1>100% Natural Farming Solutions</h1>
            <p>Powerful cleaning and disinfecting products for agricultural operations. Safe for animals, people, and the environment.</p>
            <div class="certifications">
                <span class="cert-badge"><i class="fas fa-leaf"></i> 100% Natural</span>
                <span class="cert-badge"><i class="fas fa-check-circle"></i> SABS Approved</span>
                <span class="cert-badge"><i class="fas fa-shield-alt"></i> Eco-Friendly</span>
            </div>
        </div>
    </section>

    <section class="section">
        <div class="container">
            <div class="industries">
                <div class="industry-card"><i class="fas fa-egg"></i><h4>Poultry</h4></div>
                <div class="industry-card"><i class="fas fa-piggy-bank"></i><h4>Piggeries</h4></div>
                <div class="industry-card"><i class="fas fa-cow"></i><h4>Dairies</h4></div>
                <div class="industry-card"><i class="fas fa-industry"></i><h4>Abattoirs</h4></div>
                <div class="industry-card"><i class="fas fa-store"></i><h4>Butcheries</h4></div>
            </div>
        </div>
    </section>

    <section class="section section-alt" id="cleaning">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Cleaning Solutions</span>
                <h2>Degreasers & Cleaners</h2>
                <p>Heavy-duty natural degreasers for farm equipment, surfaces, and processing areas.</p>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image"><img src="/farmcure/images/product-degreaser.jpg" alt="FarmCure Degreaser"></div>
                    <div class="product-header"><h3>FarmCure Degreaser</h3><span>Heavy-Duty Natural Cleaner</span></div>
                    <div class="product-content">
                        <p>Powerful all-natural degreaser for cleaning farm equipment, vehicles, processing areas, and more.</p>
                        <ul class="product-features"><li>100% natural formula</li><li>Safe around animals and food</li><li>Removes grease, oil, and grime</li><li>Biodegradable</li></ul>
                        <div class="product-sizes">Available: 750ml, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions"><a href="/farmcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Get Quote</a></div>
                    </div>
                </div>
                <div class="product-card">
                    <div class="product-image"><img src="/farmcure/images/product-skinwash.jpg" alt="FarmCure Skin Wash"></div>
                    <div class="product-header"><h3>FarmCure Skin Wash</h3><span>Natural Hand & Body Cleaner</span></div>
                    <div class="product-content">
                        <p>Gentle yet effective natural skin cleanser for farm workers. Removes dirt, grease, and contaminants.</p>
                        <ul class="product-features"><li>pH balanced formula</li><li>Moisturizing ingredients</li><li>Removes stubborn grime</li><li>Gentle on skin</li></ul>
                        <div class="product-sizes">Available: 500ml, 1L, 5L</div>
                        <div class="product-actions"><a href="/farmcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Get Quote</a></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section" id="disinfecting">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Disinfecting Solutions</span>
                <h2>Natural Disinfectants</h2>
                <p>Effective natural disinfectants for biosecurity and hygiene in agricultural settings.</p>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image"><img src="/farmcure/images/product-disinfectant.jpg" alt="FarmCure Disinfectant S-A-S"></div>
                    <div class="product-header"><h3>FarmCure Disinfectant S-A-S</h3><span>San-A-Safe Formula</span></div>
                    <div class="product-content">
                        <p>All-natural liquid disinfectant for surfaces, equipment, and facilities. Effective against a broad spectrum of pathogens.</p>
                        <ul class="product-features"><li>Broad-spectrum efficacy</li><li>Safe for food contact surfaces</li><li>No toxic residue</li><li>Suitable for fogging</li></ul>
                        <div class="product-sizes">Available: 750ml, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions"><a href="/farmcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Get Quote</a></div>
                    </div>
                </div>
                <div class="product-card">
                    <div class="product-image"><img src="/farmcure/images/product-disinfectant.jpg" alt="FarmCure Disinfectant S-A-M"></div>
                    <div class="product-header"><h3>FarmCure Disinfectant S-A-M</h3><span>San-A-Med Formula</span></div>
                    <div class="product-content">
                        <p>Medical-grade natural disinfectant for high-risk areas and equipment. Enhanced formulation for critical biosecurity.</p>
                        <ul class="product-features"><li>Medical-grade efficacy</li><li>Fast-acting formula</li><li>Non-corrosive</li><li>Safe for sensitive areas</li></ul>
                        <div class="product-sizes">Available: 750ml, 5L, 20L, 200L</div>
                        <div class="product-actions"><a href="/farmcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Get Quote</a></div>
                    </div>
                </div>
                <div class="product-card">
                    <div class="product-image"><img src="/farmcure/images/product-powder.jpg" alt="FarmCure S-A-W Powder"></div>
                    <div class="product-header"><h3>FarmCure S-A-W Powder</h3><span>Foot Bath Disinfectant</span></div>
                    <div class="product-content">
                        <p>Natural disinfectant powder for foot baths and biosecurity points. Essential for preventing disease transmission.</p>
                        <ul class="product-features"><li>Long-lasting effectiveness</li><li>Easy to mix and use</li><li>Cost-effective</li><li>Biodegradable</li></ul>
                        <div class="product-sizes">Available: 1kg, 5kg, 25kg</div>
                        <div class="product-actions"><a href="/farmcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Get Quote</a></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section section-alt" id="drainage">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Drainage Solutions</span>
                <h2>Slurry & Drain Care</h2>
                <p>Natural solutions for managing farm waste, slurry pits, and drainage systems.</p>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image"><img src="/farmcure/images/product-drain.jpg" alt="Slurry Drain Care Liquid"></div>
                    <div class="product-header"><h3>Slurry Drain Care Liquid</h3><span>Bio-Active Formula</span></div>
                    <div class="product-content">
                        <p>Bio-active liquid treatment for slurry pits and drains. Accelerates natural breakdown of organic waste.</p>
                        <ul class="product-features"><li>Reduces odors naturally</li><li>Accelerates waste breakdown</li><li>Prevents blockages</li><li>Environmentally safe</li></ul>
                        <div class="product-sizes">Available: 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions"><a href="/farmcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Get Quote</a></div>
                    </div>
                </div>
                <div class="product-card">
                    <div class="product-image"><img src="/farmcure/images/product-powder.jpg" alt="Slurry Drain Care Granules"></div>
                    <div class="product-header"><h3>Slurry Drain Care Granules</h3><span>Concentrated Formula</span></div>
                    <div class="product-content">
                        <p>Concentrated granular treatment for heavy-duty drain and slurry management. Long-lasting formula.</p>
                        <ul class="product-features"><li>Concentrated formula</li><li>Easy to apply</li><li>Long-lasting action</li><li>Cost-effective</li></ul>
                        <div class="product-sizes">Available: 1kg, 5kg, 25kg</div>
                        <div class="product-actions"><a href="/farmcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Get Quote</a></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="cta">
        <div class="container">
            <h2>Ready to Go Natural?</h2>
            <p>Contact us for product samples, pricing, or to discuss your farm's specific needs.</p>
            <a href="/farmcure/contact.php" class="btn" style="background: white; color: var(--primary);"><i class="fas fa-phone"></i> Contact Us</a>
        </div>
    </section>

    <footer class="footer"><div class="container"><div class="footer-content">
        <p>&copy; <?= date('Y') ?> FarmCure. All rights reserved.</p>
        <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
    </div></div></footer>
</body>
</html>
