<?php
require_once __DIR__ . '/../multicure/includes/config.php';
$isReseller = isReseller();
$resellerInfo = getResellerInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Story | GermCure South Africa</title>
    <meta name="description" content="The GermCure story - Professional disinfection solutions since 2012. Learn about our journey and mission.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1a7a5e;
            --primary-dark: #145c47;
            --secondary: #8dc63f;
            --accent: #0d6a6a;
            --dark: #0a1628;
            --gray-50: #f7f9fc;
            --gray-100: #eef2f7;
            --gray-200: #e2e8f0;
            --gray-600: #64748b;
            --white: #ffffff;
            --gradient-hero: linear-gradient(135deg, #0d4d4d 0%, #1a7a5e 50%, #2d6a4f 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.12);
            --radius: 16px;
            --radius-lg: 24px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        html { scroll-behavior: smooth; }

        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo { display: flex; align-items: center; text-decoration: none; }
        .logo img { height: 75px; transition: transform 0.3s; }
        .nav { display: flex; align-items: center; gap: 16px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; transition: all 0.2s; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-100); }
        .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 10px 18px; border-radius: 12px; font-weight: 600; font-size: 13px; text-decoration: none; transition: all 0.3s; cursor: pointer; border: none; }
        .btn-primary { background: var(--gradient-hero); color: white; box-shadow: 0 4px 20px rgba(26,122,94,0.3); }
        .btn-primary:hover { transform: translateY(-2px); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }

        .page-hero {
            background: var(--gradient-hero);
            padding: 160px 0 100px;
            text-align: center;
            color: white;
        }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }

        /* Story Section */
        .story-section {
            padding: 100px 0;
            background: linear-gradient(180deg, var(--gray-50) 0%, white 100%);
        }
        .story-grid {
            display: grid;
            grid-template-columns: 1.1fr 0.9fr;
            gap: 80px;
            align-items: center;
            margin-bottom: 80px;
        }
        .story-content {
            position: relative;
        }
        .story-badge {
            display: inline-block;
            background: rgba(26,122,94,0.1);
            color: var(--primary);
            padding: 8px 20px;
            border-radius: 50px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 20px;
        }
        .story-content h2 {
            font-size: 2.8rem;
            margin-bottom: 28px;
            color: var(--dark);
            line-height: 1.2;
        }
        .story-content h2 span {
            color: var(--primary);
        }
        .story-content p {
            color: var(--gray-600);
            font-size: 1.05rem;
            line-height: 1.9;
            margin-bottom: 20px;
        }
        .story-highlight {
            background: linear-gradient(135deg, var(--primary) 0%, var(--accent) 100%);
            color: white;
            padding: 24px 28px;
            border-radius: var(--radius);
            margin-top: 28px;
            display: flex;
            align-items: center;
            gap: 16px;
        }
        .story-highlight i {
            font-size: 2rem;
            opacity: 0.9;
        }
        .story-highlight p {
            color: rgba(255,255,255,0.95);
            margin: 0;
            font-size: 0.95rem;
            font-weight: 500;
        }
        .story-image-wrapper {
            position: relative;
        }
        .story-image {
            border-radius: var(--radius-lg);
            overflow: hidden;
            box-shadow: var(--shadow-lg);
            position: relative;
            z-index: 2;
        }
        .story-image img {
            width: 100%;
            height: auto;
            display: block;
        }
        .story-image-wrapper::before {
            content: '';
            position: absolute;
            top: -20px;
            right: -20px;
            width: 100%;
            height: 100%;
            background: var(--gradient-hero);
            border-radius: var(--radius-lg);
            z-index: 1;
            opacity: 0.15;
        }
        .story-image-wrapper::after {
            content: '';
            position: absolute;
            bottom: -30px;
            left: -30px;
            width: 120px;
            height: 120px;
            background: var(--secondary);
            border-radius: 50%;
            z-index: 0;
            opacity: 0.2;
        }
        .story-stats {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 24px;
            margin-top: 40px;
            padding-top: 40px;
            border-top: 1px solid var(--gray-200);
        }
        .stat-item {
            text-align: center;
        }
        .stat-number {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--primary);
            line-height: 1;
            margin-bottom: 8px;
        }
        .stat-label {
            font-size: 13px;
            color: var(--gray-600);
            font-weight: 500;
        }

        /* Mission & Vision Cards */
        .mission-vision {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 40px;
            margin-top: 60px;
        }
        .mv-card {
            background: linear-gradient(135deg, var(--gray-50) 0%, white 100%);
            border-radius: var(--radius-lg);
            padding: 48px;
            position: relative;
            overflow: hidden;
            box-shadow: var(--shadow);
            border: 1px solid var(--gray-200);
        }
        .mv-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 6px;
            height: 100%;
            background: var(--gradient-hero);
        }
        .mv-card.vision::before {
            background: linear-gradient(180deg, var(--secondary) 0%, var(--primary) 100%);
        }
        .mv-card-icon {
            width: 70px;
            height: 70px;
            background: var(--gradient-hero);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 24px;
        }
        .mv-card.vision .mv-card-icon {
            background: linear-gradient(135deg, var(--secondary) 0%, #6ba32d 100%);
        }
        .mv-card-icon i {
            font-size: 1.8rem;
            color: white;
        }
        .mv-card h3 {
            font-size: 1.5rem;
            margin-bottom: 16px;
            color: var(--dark);
        }
        .mv-card p {
            color: var(--gray-600);
            line-height: 1.8;
        }

        /* Horizontal Timeline */
        .timeline {
            padding: 100px 0;
            background: var(--gray-50);
            overflow: hidden;
        }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(26,122,94,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }

        .timeline-slider {
            position: relative;
            padding: 40px 0 60px;
        }
        .timeline-track {
            display: flex;
            gap: 0;
            overflow-x: auto;
            scroll-behavior: smooth;
            padding: 20px 40px 40px;
            -webkit-overflow-scrolling: touch;
            scrollbar-width: none;
        }
        .timeline-track::-webkit-scrollbar {
            display: none;
        }
        .timeline-line {
            position: absolute;
            bottom: 100px;
            left: 40px;
            right: 40px;
            height: 4px;
            background: linear-gradient(90deg, var(--primary) 0%, var(--secondary) 50%, var(--primary) 100%);
            border-radius: 2px;
        }
        .timeline-item {
            flex: 0 0 280px;
            position: relative;
            padding-bottom: 60px;
        }
        .timeline-dot {
            position: absolute;
            bottom: 38px;
            left: 50%;
            transform: translateX(-50%);
            width: 24px;
            height: 24px;
            background: white;
            border: 4px solid var(--primary);
            border-radius: 50%;
            z-index: 2;
            transition: all 0.3s;
        }
        .timeline-item:hover .timeline-dot {
            background: var(--primary);
            transform: translateX(-50%) scale(1.2);
        }
        .timeline-card {
            background: white;
            padding: 28px;
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            margin: 0 16px;
            transition: all 0.3s;
            height: 100%;
        }
        .timeline-item:hover .timeline-card {
            transform: translateY(-8px);
            box-shadow: var(--shadow-lg);
        }
        .timeline-year {
            font-size: 2rem;
            font-weight: 800;
            color: var(--primary);
            margin-bottom: 12px;
        }
        .timeline-card h3 {
            font-size: 1.1rem;
            margin-bottom: 10px;
            color: var(--dark);
        }
        .timeline-card p {
            color: var(--gray-600);
            font-size: 13px;
            line-height: 1.6;
        }
        /* Gradient Scrollbar Slider */
        .timeline-scrollbar {
            max-width: 600px;
            margin: 40px auto 0;
            padding: 0 20px;
        }
        .scrollbar-track {
            position: relative;
            height: 8px;
            background: var(--gray-200);
            border-radius: 4px;
            cursor: pointer;
        }
        .scrollbar-progress {
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            background: linear-gradient(90deg, var(--primary) 0%, var(--secondary) 50%, var(--primary-light) 100%);
            border-radius: 4px;
            width: 30%;
            transition: width 0.1s ease-out;
        }
        .scrollbar-thumb {
            position: absolute;
            top: 50%;
            transform: translate(-50%, -50%);
            width: 24px;
            height: 24px;
            background: white;
            border: 3px solid var(--primary);
            border-radius: 50%;
            cursor: grab;
            box-shadow: 0 2px 8px rgba(0,0,0,0.15);
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .scrollbar-thumb:hover {
            transform: translate(-50%, -50%) scale(1.1);
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }
        .scrollbar-thumb:active {
            cursor: grabbing;
            transform: translate(-50%, -50%) scale(1.05);
        }
        .scrollbar-labels {
            display: flex;
            justify-content: space-between;
            margin-top: 12px;
            font-size: 12px;
            color: var(--gray-600);
            font-weight: 500;
        }

        /* Values */
        .values { padding: 100px 0; }
        .values-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 32px; }
        .value-card {
            background: var(--gray-50);
            padding: 40px 32px;
            border-radius: var(--radius-lg);
            text-align: center;
            transition: all 0.3s;
        }
        .value-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow);
        }
        .value-card i { font-size: 3rem; color: var(--primary); margin-bottom: 20px; }
        .value-card h3 { font-size: 1.3rem; margin-bottom: 12px; }
        .value-card p { color: var(--gray-600); font-size: 13px; }

        /* Media Section with Tabs */
        .media-feature {
            padding: 100px 0;
            background: var(--gray-50);
        }
        .media-tabs {
            display: flex;
            justify-content: center;
            gap: 8px;
            margin-bottom: 40px;
        }
        .media-tab {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 16px 32px;
            background: white;
            border: 2px solid var(--gray-200);
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s;
            font-weight: 600;
            color: var(--gray-600);
        }
        .media-tab img {
            height: 40px;
            object-fit: contain;
        }
        .media-tab.active {
            border-color: var(--primary);
            background: rgba(26,122,94,0.05);
            color: var(--primary);
        }
        .media-tab:hover {
            border-color: var(--primary);
        }
        .tab-content {
            display: none;
        }
        .tab-content.active {
            display: block;
        }
        .video-container {
            max-width: 900px;
            margin: 0 auto;
        }
        .video-wrapper {
            position: relative;
            padding-bottom: 56.25%;
            border-radius: var(--radius-lg);
            overflow: hidden;
            box-shadow: var(--shadow-lg);
            background: var(--dark);
        }
        .video-wrapper iframe {
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
        }
        .video-caption {
            text-align: center;
            margin-top: 20px;
            color: var(--gray-600);
            font-size: 14px;
        }

        /* Radio Section */
        .radio-section {
            margin-top: 80px;
            padding-top: 60px;
            border-top: 1px solid var(--gray-200);
        }
        .radio-header {
            text-align: center;
            margin-bottom: 40px;
        }
        .radio-header img {
            height: 60px;
            margin-bottom: 16px;
        }
        .radio-header h3 {
            font-size: 1.5rem;
            margin-bottom: 8px;
        }
        .radio-header p {
            color: var(--gray-600);
        }
        .audio-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 32px;
            max-width: 900px;
            margin: 0 auto;
        }
        .audio-card {
            background: white;
            border-radius: var(--radius);
            padding: 32px;
            box-shadow: var(--shadow);
        }
        .audio-card h4 {
            font-size: 1rem;
            margin-bottom: 8px;
            color: var(--dark);
        }
        .audio-card p {
            font-size: 13px;
            color: var(--gray-600);
            margin-bottom: 16px;
        }
        .audio-card audio {
            width: 100%;
            border-radius: 8px;
        }

        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { font-size: 16px; margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-links a:hover { color: var(--secondary); }
        .footer-contact p { color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge img { height: 28px; display: block; }

        @media (max-width: 1024px) {
            .story-grid { grid-template-columns: 1fr; gap: 40px; }
            .story-image-wrapper { max-width: 500px; margin: 0 auto; }
            .story-stats { grid-template-columns: repeat(3, 1fr); gap: 16px; }
            .mission-vision { grid-template-columns: 1fr; }
            .values-grid { grid-template-columns: repeat(2, 1fr); }
            .footer-grid { grid-template-columns: 1fr 1fr; }
            .timeline-item { flex: 0 0 260px; }
        }
        @media (max-width: 768px) {
            .page-hero h1 { font-size: 2rem; }
            .story-content h2 { font-size: 2rem; }
            .story-highlight { flex-direction: column; text-align: center; }
            .story-stats { grid-template-columns: 1fr; gap: 20px; }
            .stat-number { font-size: 2rem; }
            .mv-card { padding: 32px; }
            .timeline-item { flex: 0 0 240px; }
            .timeline-scrollbar { max-width: 100%; }
            .values-grid, .audio-grid { grid-template-columns: 1fr; }
            .nav-links { display: none; }
            .footer-grid { grid-template-columns: 1fr; }
            .media-tabs { flex-direction: column; align-items: center; }
            .media-tab { width: 100%; max-width: 300px; justify-content: center; }
        }

        .mobile-menu-btn { display: none; background: none; border: none; font-size: 24px; color: var(--primary); cursor: pointer; }
        @media (max-width: 768px) { .mobile-menu-btn { display: block; } }
    </style>
</head>
<body>
    <?php if ($isReseller): ?>
    <?php endif; ?>

    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo">
                    <img src="/images/logo-long.png" alt="GermCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="/multicure/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/">Home</a></li>
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php" class="active">Our Story</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                        <a href="/multicure/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
                    <?php else: ?>
                        <a href="/multicure/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
                    <?php endif; ?>
                    <button class="mobile-menu-btn"><i class="fas fa-bars"></i></button>
                </nav>
            </div>
        </div>
    </header>

    <section class="page-hero">
        <div class="container">
            <h1>The GermCure Story</h1>
            <p>From humble beginnings to becoming South Africa's leading provider of professional disinfection solutions.</p>
        </div>
    </section>

    <!-- Story Section with Image -->
    <section class="story-section">
        <div class="container">
            <div class="story-grid">
                <div class="story-content">
                    <span class="story-badge"><i class="fas fa-leaf"></i> Since 2012</span>
                    <h2>The <span>GermCure</span> Story</h2>
                    <p>Since 2012, GermCure has been at the forefront of infection protection in South Africa. Our journey began with a simple vision: to make professional-grade disinfection solutions accessible to every business and community.</p>
                    <p>As the exclusive Sub-Sahara agents for Victory Electrostatic Sprayers, we bring world-class technology to the African market, combined with our expertise in professional-grade disinfectants and natural sanitization solutions.</p>
                    <div class="story-highlight">
                        <i class="fas fa-shield-virus"></i>
                        <p>We believe that everyone deserves access to clean, safe environments. That's why we work with healthcare facilities, schools, businesses, and government institutions.</p>
                    </div>
                    <div class="story-stats">
                        <div class="stat-item">
                            <div class="stat-number">12+</div>
                            <div class="stat-label">Years Experience</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number">500+</div>
                            <div class="stat-label">Clients Served</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number">100%</div>
                            <div class="stat-label">Natural Options</div>
                        </div>
                    </div>
                </div>
                <div class="story-image-wrapper">
                    <div class="story-image">
                        <img src="images/germcure-story.jpg" alt="GermCure Story">
                    </div>
                </div>
            </div>

            <!-- Mission & Vision Cards -->
            <div class="mission-vision">
                <div class="mv-card">
                    <div class="mv-card-icon">
                        <i class="fas fa-bullseye"></i>
                    </div>
                    <h3>Our Mission</h3>
                    <p>To provide innovative, effective, and accessible disinfection solutions to businesses and communities across Sub-Saharan Africa. We believe that everyone deserves access to clean, safe environments, and we work tirelessly to make professional-grade infection protection available to all.</p>
                </div>
                <div class="mv-card vision">
                    <div class="mv-card-icon">
                        <i class="fas fa-eye"></i>
                    </div>
                    <h3>Our Vision</h3>
                    <p>To be Africa's most trusted partner in infection control and hygiene solutions. We envision a future where every healthcare facility, school, business, and home has access to the best disinfection technology and products, creating healthier communities across the continent.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Horizontal Timeline -->
    <section class="timeline">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Our Journey</span>
                <h2>Milestones</h2>
                <p>Key moments in our journey to becoming South Africa's trusted disinfection partner.</p>
            </div>
            <div class="timeline-slider">
                <div class="timeline-line"></div>
                <div class="timeline-track" id="timelineTrack">
                    <div class="timeline-item">
                        <div class="timeline-card">
                            <div class="timeline-year">2012</div>
                            <h3>GermCure Founded</h3>
                            <p>Started with a vision to bring professional-grade disinfection solutions to South African businesses and institutions.</p>
                        </div>
                        <div class="timeline-dot"></div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-card">
                            <div class="timeline-year">2015</div>
                            <h3>Victory Partnership</h3>
                            <p>Became the exclusive Sub-Sahara agents for Victory Innovations electrostatic sprayers.</p>
                        </div>
                        <div class="timeline-dot"></div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-card">
                            <div class="timeline-year">2018</div>
                            <h3>Natural Product Line</h3>
                            <p>Launched our 100% natural disinfectant range, providing eco-friendly alternatives.</p>
                        </div>
                        <div class="timeline-dot"></div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-card">
                            <div class="timeline-year">2020</div>
                            <h3>COVID-19 Response</h3>
                            <p>Rapidly expanded operations to support South Africa's fight against COVID-19.</p>
                        </div>
                        <div class="timeline-dot"></div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-card">
                            <div class="timeline-year">2023</div>
                            <h3>Leading the Industry</h3>
                            <p>Trusted by hospitals, schools, businesses, and government across South Africa.</p>
                        </div>
                        <div class="timeline-dot"></div>
                    </div>
                </div>
                <!-- Gradient Scrollbar Slider -->
                <div class="timeline-scrollbar">
                    <div class="scrollbar-track" id="scrollbarTrack">
                        <div class="scrollbar-progress" id="scrollbarProgress"></div>
                        <div class="scrollbar-thumb" id="scrollbarThumb"></div>
                    </div>
                    <div class="scrollbar-labels">
                        <span>2012</span>
                        <span>2015</span>
                        <span>2018</span>
                        <span>2020</span>
                        <span>2023</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Values -->
    <section class="values">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">What We Believe</span>
                <h2>Our Values</h2>
                <p>The principles that guide everything we do at GermCure.</p>
            </div>
            <div class="values-grid">
                <div class="value-card">
                    <i class="fas fa-shield-virus"></i>
                    <h3>Protection First</h3>
                    <p>We prioritize the health and safety of people in every product we develop and service we provide.</p>
                </div>
                <div class="value-card">
                    <i class="fas fa-lightbulb"></i>
                    <h3>Innovation</h3>
                    <p>We continuously seek out the latest technologies and methods to improve infection control.</p>
                </div>
                <div class="value-card">
                    <i class="fas fa-leaf"></i>
                    <h3>Sustainability</h3>
                    <p>We develop eco-friendly solutions that protect both people and the environment.</p>
                </div>
                <div class="value-card">
                    <i class="fas fa-handshake"></i>
                    <h3>Partnership</h3>
                    <p>We work closely with our clients to understand their needs and deliver customized solutions.</p>
                </div>
                <div class="value-card">
                    <i class="fas fa-award"></i>
                    <h3>Excellence</h3>
                    <p>We maintain the highest standards in all our products and services.</p>
                </div>
                <div class="value-card">
                    <i class="fas fa-heart"></i>
                    <h3>Community</h3>
                    <p>We're committed to making a positive impact in the communities we serve.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Media Section with Tabs -->
    <section class="media-feature">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">As Seen On</span>
                <h2>Media Coverage</h2>
                <p>GermCure has been featured on leading South African media outlets.</p>
            </div>

            <!-- Video Tabs -->
            <div class="media-tabs">
                <button class="media-tab active" onclick="showTab(0)">
                    <img src="images/ontbytsake-logo.png" alt="Ontbytsake">
                    <span>Episode 1</span>
                </button>
                <button class="media-tab" onclick="showTab(1)">
                    <img src="images/ontbytsake-logo.png" alt="Ontbytsake">
                    <span>Episode 2</span>
                </button>
            </div>

            <!-- Tab Content -->
            <div class="tab-content active" id="tab0">
                <div class="video-container">
                    <div class="video-wrapper">
                        <iframe src="https://www.youtube.com/embed/jZUPPwyBf50" title="GermCure on Ontbytsake - Episode 1" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                    <p class="video-caption">GermCure featured on KykNET's Ontbytsake discussing electrostatic spraying technology</p>
                </div>
            </div>
            <div class="tab-content" id="tab1">
                <div class="video-container">
                    <div class="video-wrapper">
                        <iframe src="https://www.youtube.com/embed/mlGUT1Om7Qc" title="GermCure on Ontbytsake - Episode 2" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                    <p class="video-caption">Follow-up interview on KykNET's Ontbytsake about disinfection best practices</p>
                </div>
            </div>

            <!-- Radio Section -->
            <div class="radio-section">
                <div class="radio-header">
                    <img src="images/jacaranda-logo.jpg" alt="Jacaranda FM">
                    <h3>Radio Interview</h3>
                    <p>GermCure featured on Jacaranda FM discussing professional disinfection</p>
                </div>
                <div class="audio-card" style="background: white; padding: 40px; border-radius: var(--radius-lg); box-shadow: var(--shadow); max-width: 700px; margin: 0 auto;">
                    <div style="display: flex; align-items: center; gap: 20px; margin-bottom: 20px;">
                        <div style="width: 60px; height: 60px; background: linear-gradient(135deg, var(--primary) 0%, var(--accent) 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                            <i class="fas fa-microphone-alt" style="font-size: 1.5rem; color: white;"></i>
                        </div>
                        <div>
                            <h4 style="font-size: 1.1rem; margin-bottom: 4px; color: var(--dark);">From Personal Crisis to Proactive Prevention</h4>
                            <p style="font-size: 13px; color: var(--gray-600); margin: 0;">The GermCure Story - Jacaranda FM Interview</p>
                        </div>
                    </div>
                    <audio controls style="width: 100%; border-radius: 8px;">
                        <source src="audio/jacaranda-interview.mp3" type="audio/mpeg">
                        Your browser does not support the audio element.
                    </audio>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA -->
    <section style="padding: 100px 0; background: var(--gradient-hero); text-align: center; color: white;">
        <div class="container">
            <h2 style="font-size: 2.5rem; margin-bottom: 16px;">Join Our Mission</h2>
            <p style="font-size: 1.1rem; opacity: 0.9; margin-bottom: 32px; max-width: 600px; margin: 0 auto 32px;">Partner with GermCure to create cleaner, safer environments for your organization.</p>
            <div style="display: flex; gap: 16px; justify-content: center; flex-wrap: wrap;">
                <a href="/contact.php" class="btn btn-white" style="background: white; color: var(--primary);"><i class="fas fa-envelope"></i> Contact Us</a>
                <a href="/victory-sprayers.php" class="btn btn-outline" style="border-color: white; color: white;"><i class="fas fa-spray-can"></i> View Products</a>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-icon-container">
                        <img src="/images/logo-icon.png" alt="GermCure">
                    </div>
                    <p class="footer-tagline">Disinfection &amp; Hygiene</p>
                    <p>Professional infection<br>protection since 2012.</p>
                    <div class="c-virus-banner" style="margin-top: 16px;">
                        <img src="images/c-virus-logos.jpg" alt="COVID-19 Response Partners" style="height: 50px; opacity: 0.8;">
                    </div>
                    <a href="https://www.trustpilot.com/review/germcure.co.za" target="_blank" class="trustpilot-link" style="display: inline-flex; align-items: center; gap: 8px; margin-top: 20px; padding: 10px 16px; background: rgba(255,255,255,0.1); border-radius: 8px; color: white; text-decoration: none; font-size: 13px; transition: all 0.3s;">
                        <i class="fas fa-star" style="color: #00b67a;"></i>
                        <span>Review us on Trustpilot</span>
                    </a>
                </div>
                <div>
                    <h4>Quick Links</h4>
                    <ul class="footer-links">
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/media.php">Media</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="/victory-sprayers.php#backpack">VP300ESK Backpack</a></li>
                        <li><a href="/victory-sprayers.php#handheld">VP200ESK Handheld</a></li>
                        <li><a href="/products.php">Disinfectants</a></li>
                    </ul>
                </div>
                <div class="footer-contact">
                    <h4>Contact Us</h4>
                    <p><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p><i class="fas fa-envelope"></i> info@germcure.co.za</p>
                    <p><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> GermCure. All rights reserved.</p>
                <a href="/multicure/" class="multicure-badge">
                    <span>Part of</span>
                    <div class="badge-logo"><img src="/multicure/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
                </a>
            </div>
        </div>
    </footer>

    <script>
        // Timeline Scrollbar Slider
        const timelineTrack = document.getElementById('timelineTrack');
        const scrollbarTrack = document.getElementById('scrollbarTrack');
        const scrollbarProgress = document.getElementById('scrollbarProgress');
        const scrollbarThumb = document.getElementById('scrollbarThumb');

        let isDragging = false;

        // Update scrollbar position based on timeline scroll
        function updateScrollbar() {
            const maxScroll = timelineTrack.scrollWidth - timelineTrack.clientWidth;
            const scrollPercent = maxScroll > 0 ? (timelineTrack.scrollLeft / maxScroll) * 100 : 0;
            const thumbPosition = Math.min(Math.max(scrollPercent, 0), 100);

            scrollbarProgress.style.width = thumbPosition + '%';
            scrollbarThumb.style.left = thumbPosition + '%';
        }

        // Scroll timeline based on scrollbar position
        function scrollToPercent(percent) {
            const maxScroll = timelineTrack.scrollWidth - timelineTrack.clientWidth;
            timelineTrack.scrollLeft = (percent / 100) * maxScroll;
        }

        // Handle scrollbar click
        scrollbarTrack.addEventListener('click', (e) => {
            const rect = scrollbarTrack.getBoundingClientRect();
            const percent = ((e.clientX - rect.left) / rect.width) * 100;
            scrollToPercent(percent);
        });

        // Handle thumb drag
        scrollbarThumb.addEventListener('mousedown', (e) => {
            isDragging = true;
            e.preventDefault();
        });

        document.addEventListener('mousemove', (e) => {
            if (!isDragging) return;
            const rect = scrollbarTrack.getBoundingClientRect();
            const percent = Math.min(Math.max(((e.clientX - rect.left) / rect.width) * 100, 0), 100);
            scrollToPercent(percent);
        });

        document.addEventListener('mouseup', () => {
            isDragging = false;
        });

        // Touch support
        scrollbarThumb.addEventListener('touchstart', (e) => {
            isDragging = true;
        });

        document.addEventListener('touchmove', (e) => {
            if (!isDragging) return;
            const touch = e.touches[0];
            const rect = scrollbarTrack.getBoundingClientRect();
            const percent = Math.min(Math.max(((touch.clientX - rect.left) / rect.width) * 100, 0), 100);
            scrollToPercent(percent);
        });

        document.addEventListener('touchend', () => {
            isDragging = false;
        });

        // Listen for timeline scroll
        timelineTrack.addEventListener('scroll', updateScrollbar);

        // Initialize
        updateScrollbar();

        // Tab Switching
        function showTab(index) {
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.remove('active');
            });
            document.querySelectorAll('.media-tab').forEach(btn => {
                btn.classList.remove('active');
            });
            document.getElementById('tab' + index).classList.add('active');
            document.querySelectorAll('.media-tab')[index].classList.add('active');
        }
    </script>
</body>
</html>
