<?php
require_once __DIR__ . '/../multicure/includes/config.php';
$isReseller = isReseller();
$resellerInfo = getResellerInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GermCure - Innovative Infection Protection | Disinfection & Hygiene Since 2012</title>
    <meta name="description" content="Professional disinfection services since 2012. Sub-Sahara agents for Victory Electrostatic Sprayers. 100% Natural disinfectants.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1a7a5e;
            --primary-dark: #145c47;
            --primary-light: #2d9d7a;
            --secondary: #8dc63f;
            --accent: #0d6a6a;
            --dark: #0a1628;
            --gray-50: #f7f9fc;
            --gray-100: #eef2f7;
            --gray-200: #e2e8f0;
            --gray-600: #64748b;
            --white: #ffffff;
            --gradient-hero: linear-gradient(135deg, #0d4d4d 0%, #1a7a5e 50%, #2d6a4f 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.12);
            --radius: 16px;
            --radius-lg: 24px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        html { scroll-behavior: smooth; }

        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo { display: flex; align-items: center; text-decoration: none; gap: 12px; }
        .logo img { height: 75px; transition: transform 0.3s; }
        .logo:hover img { transform: scale(1.05); }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; transition: all 0.2s; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-100); }
        .multicure-link { background: var(--gray-100); color: var(--gray-600) !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }

        .btn { display: inline-flex; align-items: center; justify-content: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; font-size: 13px; text-decoration: none; transition: all 0.3s; cursor: pointer; border: none; }
        .btn-primary { background: var(--gradient-hero); color: white; box-shadow: 0 4px 20px rgba(26,122,94,0.3); }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 30px rgba(26,122,94,0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-white { background: white; color: var(--primary); }
        .btn-white:hover { background: var(--gray-100); transform: translateY(-2px); }
        .btn-lg { padding: 14px 28px; font-size: 15px; }

        /* Hero sized to fit background image aspect ratio */
        .hero { 
            height: calc(56.25vw + 84px); /* 16:9 aspect + header */
            max-height: 650px;
            min-height: 450px;
            display: flex; 
            align-items: center; 
            position: relative; 
            padding-top: 84px; 
            overflow: hidden; 
        }
        /* Background image of person spraying */
        .hero::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: url('/images/hero-spray.jpg') center/cover no-repeat;
        }
        /* Gradient overlay */
        .hero::after {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: linear-gradient(135deg, rgba(13, 77, 77, 0.75) 0%, rgba(26, 122, 94, 0.7) 50%, rgba(45, 106, 79, 0.75) 100%);
        }
        
        /* COVID-19 Coronavirus Particles */
        .hero-particles {
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            overflow: hidden;
            pointer-events: none;
            z-index: 1;
        }
        .coronavirus {
            position: absolute;
            animation: floatVirus 15s ease-in-out infinite;
        }
        .coronavirus svg {
            width: 100%;
            height: 100%;
            filter: drop-shadow(0 0 10px rgba(141, 198, 63, 0.4));
        }
        .coronavirus:nth-child(1) { width: 90px; height: 90px; top: 12%; left: 6%; animation-delay: 0s; animation-duration: 18s; }
        .coronavirus:nth-child(2) { width: 55px; height: 55px; top: 60%; left: 3%; animation-delay: 3s; animation-duration: 14s; }
        .coronavirus:nth-child(3) { width: 110px; height: 110px; top: 20%; right: 8%; animation-delay: 1s; animation-duration: 20s; }
        .coronavirus:nth-child(4) { width: 70px; height: 70px; top: 65%; right: 5%; animation-delay: 5s; animation-duration: 16s; }
        .coronavirus:nth-child(5) { width: 45px; height: 45px; top: 8%; right: 22%; animation-delay: 2s; animation-duration: 12s; }
        .coronavirus:nth-child(6) { width: 80px; height: 80px; top: 40%; left: 12%; animation-delay: 4s; animation-duration: 17s; }
        .coronavirus:nth-child(7) { width: 50px; height: 50px; top: 75%; right: 25%; animation-delay: 6s; animation-duration: 13s; }
        
        @keyframes floatVirus {
            0%, 100% { transform: translateY(0) rotate(0deg); opacity: 0.6; }
            25% { transform: translateY(-15px) rotate(45deg); opacity: 0.8; }
            50% { transform: translateY(-25px) rotate(90deg); opacity: 0.7; }
            75% { transform: translateY(-10px) rotate(135deg); opacity: 0.75; }
        }

        .hero-content { position: relative; z-index: 2; display: grid; grid-template-columns: 1fr 1fr; gap: 40px; align-items: center; }
        .hero-text { color: white; }
        .hero-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.15); padding: 8px 16px; border-radius: 50px; font-size: 14px; margin-bottom: 20px; backdrop-filter: blur(10px); }
        .hero h1 { font-size: 2.8rem; font-weight: 800; line-height: 1.15; margin-bottom: 16px; }
        .hero p { font-size: 1.05rem; opacity: 0.9; margin-bottom: 24px; max-width: 450px; }
        .hero-buttons { display: flex; gap: 12px; flex-wrap: wrap; }
        .hero-image { display: flex; justify-content: center; align-items: center; position: relative; }
        .hero-image img { max-width: 320px; filter: drop-shadow(0 20px 40px rgba(0,0,0,0.4)); animation: sprayFloat 4s ease-in-out infinite; }
        @keyframes sprayFloat { 0%, 100% { transform: translateY(0) rotate(-5deg); } 50% { transform: translateY(-15px) rotate(5deg); } }

        .stats-bar { background: white; padding: 40px 0; box-shadow: var(--shadow); }
        .stats-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 32px; text-align: center; }
        .stat-item h3 { font-size: 2.5rem; font-weight: 800; background: var(--gradient-hero); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        .stat-item p { color: var(--gray-600); font-size: 14px; font-weight: 500; }

        .services { padding: 100px 0; background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(26,122,94,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .services-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 32px; }
        .service-card { background: white; border-radius: var(--radius-lg); padding: 40px 32px; text-align: center; box-shadow: var(--shadow); transition: all 0.3s; text-decoration: none; color: inherit; display: block; }
        .service-card:hover { transform: translateY(-8px); box-shadow: var(--shadow-lg); }
        .service-icon { width: 100px; height: 100px; margin: 0 auto 24px; border-radius: 20px; display: flex; align-items: center; justify-content: center; overflow: hidden; }
        .service-icon img { width: 100%; height: 100%; object-fit: cover; }
        .service-card h3 { font-size: 1.4rem; font-weight: 700; margin-bottom: 12px; }
        .service-card p { color: var(--gray-600); font-size: 15px; margin-bottom: 20px; }
        .service-link { display: inline-flex; align-items: center; gap: 8px; color: var(--primary); font-weight: 600; font-size: 14px; }
        .service-link i { transition: transform 0.3s; }
        .service-card:hover .service-link i { transform: translateX(4px); }

        .video-section { padding: 100px 0; background: white; }
        .video-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .video-content h2 { font-size: 2.2rem; margin-bottom: 20px; }
        .video-content p { color: var(--gray-600); margin-bottom: 24px; }
        .video-wrapper { position: relative; padding-bottom: 56.25%; border-radius: var(--radius-lg); overflow: hidden; box-shadow: var(--shadow-lg); }
        .video-wrapper iframe { position: absolute; top: 0; left: 0; width: 100%; height: 100%; }

        .featured { padding: 100px 0; background: var(--gray-50); }
        .featured-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 40px; }
        .featured-card { background: white; border-radius: var(--radius-lg); overflow: hidden; box-shadow: var(--shadow); display: flex; flex-direction: column; }
        .featured-image { height: 250px; background: linear-gradient(135deg, var(--primary) 0%, var(--accent) 100%); display: flex; align-items: center; justify-content: center; position: relative; }
        .featured-image img { max-height: 200px; max-width: 90%; object-fit: contain; filter: drop-shadow(0 10px 30px rgba(0,0,0,0.2)); }
        .featured-content { padding: 32px; }
        .featured-content h3 { font-size: 1.5rem; margin-bottom: 12px; }
        .featured-content p { color: var(--gray-600); margin-bottom: 20px; }
        .featured-specs { display: flex; gap: 24px; margin-bottom: 24px; }
        .spec-item { text-align: center; }
        .spec-item strong { display: block; color: var(--primary); font-size: 1.2rem; }
        .spec-item span { font-size: 12px; color: var(--gray-600); }

        .cta { padding: 100px 0; background: var(--gradient-hero); position: relative; overflow: hidden; }
        .cta::before { content: ''; position: absolute; top: -50%; right: -10%; width: 600px; height: 600px; background: rgba(255,255,255,0.05); border-radius: 50%; }
        .cta-content { text-align: center; color: white; position: relative; z-index: 2; }
        .cta h2 { font-size: 2.5rem; margin-bottom: 16px; }
        .cta p { font-size: 1.1rem; opacity: 0.9; margin-bottom: 32px; max-width: 600px; margin-left: auto; margin-right: auto; }
        .cta-buttons { display: flex; gap: 16px; justify-content: center; }

        .distributors-section { padding: 80px 0; background: white; }
        .distributors-slider {
            overflow: hidden;
            position: relative;
            width: 100%;
        }
        .distributors-track {
            display: flex;
            animation: scrollDistributors 20s linear infinite;
            width: fit-content;
        }
        .distributors-track:hover { animation-play-state: paused; }
        .distributor-item {
            flex-shrink: 0;
            padding: 0 40px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .distributor-item img {
            height: 60px;
            max-width: 180px;
            object-fit: contain;
            opacity: 0.7;
            transition: all 0.3s;
            filter: grayscale(30%);
        }
        .distributor-item:hover img {
            opacity: 1;
            filter: grayscale(0%);
            transform: scale(1.05);
        }
        @keyframes scrollDistributors {
            0% { transform: translateX(0); }
            100% { transform: translateX(-50%); }
        }

        .c-virus-banner {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-top: 16px;
        }
        .c-virus-banner img {
            height: 50px;
            opacity: 0.8;
        }

        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer h4 { font-size: 16px; margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: var(--secondary); }
        .footer-contact p { color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }

        @media (max-width: 1024px) {
            .hero-content { grid-template-columns: 1fr; text-align: center; }
            .hero p { margin: 0 auto 24px; }
            .hero-image { display: none; }
            .hero-buttons { justify-content: center; }
            .services-grid { grid-template-columns: repeat(2, 1fr); }
            .video-grid { grid-template-columns: 1fr; }
            .footer-grid { grid-template-columns: 1fr 1fr; }
        }
        @media (max-width: 768px) {
            .hero { min-height: 400px; max-height: 500px; }
            .hero h1 { font-size: 2rem; }
            .logo img { height: 55px; }
            .stats-grid { grid-template-columns: repeat(2, 1fr); }
            .services-grid { grid-template-columns: 1fr; }
            .featured-grid { grid-template-columns: 1fr; }
            .nav-links { display: none; }
            .footer-grid { grid-template-columns: 1fr; }
            .footer-bottom { flex-direction: column; gap: 16px; }
        }

        .mobile-menu-btn { display: none; background: none; border: none; font-size: 24px; color: var(--primary); cursor: pointer; }
        @media (max-width: 768px) { .mobile-menu-btn { display: block; } }
    </style>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo">
                    <img src="/images/logo-long.png" alt="GermCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="/multicure/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/">Home</a></li>
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                    <button class="mobile-menu-btn"><i class="fas fa-bars"></i></button>
                    <?php if ($isReseller): ?>
                        <a href="/multicure/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
                    <?php else: ?>
                        <a href="/multicure/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </header>

    <section class="hero">
        <!-- COVID-19 Coronavirus Particles (SVG) -->
        <div class="hero-particles">
            <div class="coronavirus">
                <svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                    <defs>
                        <radialGradient id="virusGrad1" cx="30%" cy="30%">
                            <stop offset="0%" style="stop-color:#a8e063"/>
                            <stop offset="50%" style="stop-color:#6ab04c"/>
                            <stop offset="100%" style="stop-color:#27ae60"/>
                        </radialGradient>
                        <radialGradient id="spikeGrad1" cx="50%" cy="0%">
                            <stop offset="0%" style="stop-color:#c9e265"/>
                            <stop offset="100%" style="stop-color:#6ab04c"/>
                        </radialGradient>
                    </defs>
                    <circle cx="50" cy="50" r="28" fill="url(#virusGrad1)" opacity="0.9"/>
                    <circle cx="42" cy="42" r="8" fill="rgba(255,255,255,0.3)"/>
                    <!-- Spike proteins -->
                    <g fill="url(#spikeGrad1)">
                        <ellipse cx="50" cy="15" rx="4" ry="8"/><circle cx="50" cy="8" r="5"/>
                        <ellipse cx="50" cy="85" rx="4" ry="8"/><circle cx="50" cy="92" r="5"/>
                        <ellipse cx="15" cy="50" rx="8" ry="4"/><circle cx="8" cy="50" r="5"/>
                        <ellipse cx="85" cy="50" rx="8" ry="4"/><circle cx="92" cy="50" r="5"/>
                        <ellipse cx="25" cy="25" rx="5" ry="7" transform="rotate(-45 25 25)"/><circle cx="19" cy="19" r="4"/>
                        <ellipse cx="75" cy="25" rx="5" ry="7" transform="rotate(45 75 25)"/><circle cx="81" cy="19" r="4"/>
                        <ellipse cx="25" cy="75" rx="5" ry="7" transform="rotate(45 25 75)"/><circle cx="19" cy="81" r="4"/>
                        <ellipse cx="75" cy="75" rx="5" ry="7" transform="rotate(-45 75 75)"/><circle cx="81" cy="81" r="4"/>
                    </g>
                </svg>
            </div>
            <div class="coronavirus">
                <svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                    <defs>
                        <radialGradient id="virusGrad2" cx="30%" cy="30%">
                            <stop offset="0%" style="stop-color:#b8e994"/>
                            <stop offset="50%" style="stop-color:#78e08f"/>
                            <stop offset="100%" style="stop-color:#38ada9"/>
                        </radialGradient>
                    </defs>
                    <circle cx="50" cy="50" r="28" fill="url(#virusGrad2)" opacity="0.85"/>
                    <circle cx="40" cy="40" r="7" fill="rgba(255,255,255,0.25)"/>
                    <g fill="#78e08f">
                        <ellipse cx="50" cy="15" rx="4" ry="8"/><circle cx="50" cy="8" r="5"/>
                        <ellipse cx="50" cy="85" rx="4" ry="8"/><circle cx="50" cy="92" r="5"/>
                        <ellipse cx="15" cy="50" rx="8" ry="4"/><circle cx="8" cy="50" r="5"/>
                        <ellipse cx="85" cy="50" rx="8" ry="4"/><circle cx="92" cy="50" r="5"/>
                        <ellipse cx="25" cy="25" rx="5" ry="7" transform="rotate(-45 25 25)"/><circle cx="19" cy="19" r="4"/>
                        <ellipse cx="75" cy="25" rx="5" ry="7" transform="rotate(45 75 25)"/><circle cx="81" cy="19" r="4"/>
                        <ellipse cx="25" cy="75" rx="5" ry="7" transform="rotate(45 25 75)"/><circle cx="19" cy="81" r="4"/>
                        <ellipse cx="75" cy="75" rx="5" ry="7" transform="rotate(-45 75 75)"/><circle cx="81" cy="81" r="4"/>
                    </g>
                </svg>
            </div>
            <div class="coronavirus">
                <svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                    <defs>
                        <radialGradient id="virusGrad3" cx="30%" cy="30%">
                            <stop offset="0%" style="stop-color:#a8e063"/>
                            <stop offset="50%" style="stop-color:#56ab2f"/>
                            <stop offset="100%" style="stop-color:#1e8449"/>
                        </radialGradient>
                    </defs>
                    <circle cx="50" cy="50" r="28" fill="url(#virusGrad3)" opacity="0.9"/>
                    <circle cx="42" cy="42" r="8" fill="rgba(255,255,255,0.3)"/>
                    <g fill="#7cb342">
                        <ellipse cx="50" cy="15" rx="4" ry="8"/><circle cx="50" cy="8" r="5"/>
                        <ellipse cx="50" cy="85" rx="4" ry="8"/><circle cx="50" cy="92" r="5"/>
                        <ellipse cx="15" cy="50" rx="8" ry="4"/><circle cx="8" cy="50" r="5"/>
                        <ellipse cx="85" cy="50" rx="8" ry="4"/><circle cx="92" cy="50" r="5"/>
                        <ellipse cx="25" cy="25" rx="5" ry="7" transform="rotate(-45 25 25)"/><circle cx="19" cy="19" r="4"/>
                        <ellipse cx="75" cy="25" rx="5" ry="7" transform="rotate(45 75 25)"/><circle cx="81" cy="19" r="4"/>
                        <ellipse cx="25" cy="75" rx="5" ry="7" transform="rotate(45 25 75)"/><circle cx="19" cy="81" r="4"/>
                        <ellipse cx="75" cy="75" rx="5" ry="7" transform="rotate(-45 75 75)"/><circle cx="81" cy="81" r="4"/>
                    </g>
                </svg>
            </div>
            <div class="coronavirus">
                <svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="50" cy="50" r="28" fill="url(#virusGrad1)" opacity="0.85"/>
                    <circle cx="40" cy="40" r="7" fill="rgba(255,255,255,0.25)"/>
                    <g fill="#6ab04c">
                        <ellipse cx="50" cy="15" rx="4" ry="8"/><circle cx="50" cy="8" r="5"/>
                        <ellipse cx="50" cy="85" rx="4" ry="8"/><circle cx="50" cy="92" r="5"/>
                        <ellipse cx="15" cy="50" rx="8" ry="4"/><circle cx="8" cy="50" r="5"/>
                        <ellipse cx="85" cy="50" rx="8" ry="4"/><circle cx="92" cy="50" r="5"/>
                        <ellipse cx="25" cy="25" rx="5" ry="7" transform="rotate(-45 25 25)"/><circle cx="19" cy="19" r="4"/>
                        <ellipse cx="75" cy="25" rx="5" ry="7" transform="rotate(45 75 25)"/><circle cx="81" cy="19" r="4"/>
                        <ellipse cx="25" cy="75" rx="5" ry="7" transform="rotate(45 25 75)"/><circle cx="19" cy="81" r="4"/>
                        <ellipse cx="75" cy="75" rx="5" ry="7" transform="rotate(-45 75 75)"/><circle cx="81" cy="81" r="4"/>
                    </g>
                </svg>
            </div>
            <div class="coronavirus">
                <svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="50" cy="50" r="28" fill="url(#virusGrad2)" opacity="0.8"/>
                    <circle cx="42" cy="42" r="6" fill="rgba(255,255,255,0.2)"/>
                    <g fill="#78e08f">
                        <ellipse cx="50" cy="15" rx="4" ry="8"/><circle cx="50" cy="8" r="5"/>
                        <ellipse cx="50" cy="85" rx="4" ry="8"/><circle cx="50" cy="92" r="5"/>
                        <ellipse cx="15" cy="50" rx="8" ry="4"/><circle cx="8" cy="50" r="5"/>
                        <ellipse cx="85" cy="50" rx="8" ry="4"/><circle cx="92" cy="50" r="5"/>
                        <ellipse cx="25" cy="25" rx="5" ry="7" transform="rotate(-45 25 25)"/><circle cx="19" cy="19" r="4"/>
                        <ellipse cx="75" cy="25" rx="5" ry="7" transform="rotate(45 75 25)"/><circle cx="81" cy="19" r="4"/>
                        <ellipse cx="25" cy="75" rx="5" ry="7" transform="rotate(45 25 75)"/><circle cx="19" cy="81" r="4"/>
                        <ellipse cx="75" cy="75" rx="5" ry="7" transform="rotate(-45 75 75)"/><circle cx="81" cy="81" r="4"/>
                    </g>
                </svg>
            </div>
            <div class="coronavirus">
                <svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="50" cy="50" r="28" fill="url(#virusGrad3)" opacity="0.85"/>
                    <circle cx="40" cy="40" r="7" fill="rgba(255,255,255,0.25)"/>
                    <g fill="#56ab2f">
                        <ellipse cx="50" cy="15" rx="4" ry="8"/><circle cx="50" cy="8" r="5"/>
                        <ellipse cx="50" cy="85" rx="4" ry="8"/><circle cx="50" cy="92" r="5"/>
                        <ellipse cx="15" cy="50" rx="8" ry="4"/><circle cx="8" cy="50" r="5"/>
                        <ellipse cx="85" cy="50" rx="8" ry="4"/><circle cx="92" cy="50" r="5"/>
                        <ellipse cx="25" cy="25" rx="5" ry="7" transform="rotate(-45 25 25)"/><circle cx="19" cy="19" r="4"/>
                        <ellipse cx="75" cy="25" rx="5" ry="7" transform="rotate(45 75 25)"/><circle cx="81" cy="19" r="4"/>
                        <ellipse cx="25" cy="75" rx="5" ry="7" transform="rotate(45 25 75)"/><circle cx="19" cy="81" r="4"/>
                        <ellipse cx="75" cy="75" rx="5" ry="7" transform="rotate(-45 75 75)"/><circle cx="81" cy="81" r="4"/>
                    </g>
                </svg>
            </div>
            <div class="coronavirus">
                <svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="50" cy="50" r="28" fill="url(#virusGrad1)" opacity="0.8"/>
                    <circle cx="42" cy="42" r="6" fill="rgba(255,255,255,0.2)"/>
                    <g fill="#6ab04c">
                        <ellipse cx="50" cy="15" rx="4" ry="8"/><circle cx="50" cy="8" r="5"/>
                        <ellipse cx="50" cy="85" rx="4" ry="8"/><circle cx="50" cy="92" r="5"/>
                        <ellipse cx="15" cy="50" rx="8" ry="4"/><circle cx="8" cy="50" r="5"/>
                        <ellipse cx="85" cy="50" rx="8" ry="4"/><circle cx="92" cy="50" r="5"/>
                        <ellipse cx="25" cy="25" rx="5" ry="7" transform="rotate(-45 25 25)"/><circle cx="19" cy="19" r="4"/>
                        <ellipse cx="75" cy="25" rx="5" ry="7" transform="rotate(45 75 25)"/><circle cx="81" cy="19" r="4"/>
                        <ellipse cx="25" cy="75" rx="5" ry="7" transform="rotate(45 25 75)"/><circle cx="19" cy="81" r="4"/>
                        <ellipse cx="75" cy="75" rx="5" ry="7" transform="rotate(-45 75 75)"/><circle cx="81" cy="81" r="4"/>
                    </g>
                </svg>
            </div>
        </div>
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <div class="hero-badge"><i class="fas fa-shield-virus"></i> Trusted Since 2012</div>
                    <h1>Professional<br>Disinfection<br>Solutions</h1>
                    <p>South Africa's leading provider of infection control solutions. Electrostatic sprayers, hospital-grade disinfectants, and natural products.</p>
                    <div class="hero-buttons">
                        <a href="/victory-sprayers.php" class="btn btn-white btn-lg"><i class="fas fa-spray-can"></i> Victory Sprayers</a>
                        <a href="/products.php" class="btn btn-outline btn-lg" style="border-color: white; color: white;"><i class="fas fa-flask"></i> Our Products</a>
                    </div>
                </div>
                <div class="hero-image">
                    <img src="/images/victory-handheld-header.png" alt="Victory Electrostatic Sprayer">
                </div>
            </div>
        </div>
    </section>

    <section class="stats-bar">
        <div class="container">
            <div class="stats-grid">
                <div class="stat-item"><h3>2012</h3><p>Established</p></div>
                <div class="stat-item"><h3>65%</h3><p>Less Chemical Usage</p></div>
                <div class="stat-item"><h3>70%</h3><p>Time Savings</p></div>
                <div class="stat-item"><h3>2137m²</h3><p>Coverage Per Tank</p></div>
            </div>
        </div>
    </section>

    <section class="services">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Our Solutions</span>
                <h2>Complete Infection Protection</h2>
                <p>From electrostatic sprayers to natural disinfectants, we provide comprehensive hygiene solutions.</p>
            </div>
            <div class="services-grid">
                <a href="/victory-sprayers.php" class="service-card">
                    <div class="service-icon"><img src="images/victory-hexagon.png" alt="Victory Sprayers"></div>
                    <h3>Victory Sprayers</h3>
                    <p>Cordless electrostatic sprayers for professional disinfection. Up to 65% less chemicals, 70% faster application.</p>
                    <span class="service-link">View Products <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="/products.php" class="service-card">
                    <div class="service-icon"><img src="images/disinfection-hexagon.png" alt="Disinfection"></div>
                    <h3>Disinfectants</h3>
                    <p>Hospital-grade disinfectants and sanitizers for every application. Safe, effective, and eco-friendly.</p>
                    <span class="service-link">View Products <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="/products.php#natural" class="service-card">
                    <div class="service-icon"><img src="images/natural-hexagon.png" alt="Natural Products"></div>
                    <h3>Natural Solutions</h3>
                    <p>100% natural disinfectants that are safe for people, pets, and the environment while being highly effective.</p>
                    <span class="service-link">View Products <i class="fas fa-arrow-right"></i></span>
                </a>
            </div>
        </div>
    </section>

    <section class="video-section">
        <div class="container">
            <div class="video-grid">
                <div class="video-content">
                    <span class="section-badge">See It In Action</span>
                    <h2>Victory Electrostatic Technology</h2>
                    <p>Watch how our electrostatic sprayers provide superior coverage, wrapping surfaces with disinfectant for complete protection. Used by hospitals, schools, and businesses worldwide.</p>
                    <a href="/victory-sprayers.php" class="btn btn-primary btn-lg"><i class="fas fa-info-circle"></i> Learn More</a>
                </div>
                <div class="video-wrapper">
                    <iframe src="https://www.youtube.com/embed/DcJMqzbr3_E" title="Victory Sprayer Demo" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>

    <section class="featured">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Featured Products</span>
                <h2>Victory Electrostatic Sprayers</h2>
                <p>Professional cordless electrostatic sprayers for superior disinfection coverage.</p>
            </div>
            <div class="featured-grid">
                <div class="featured-card">
                    <div class="featured-image">
                        <img src="/images/victory-backpack-sprayer.png" alt="VP300ESK Backpack Sprayer">
                    </div>
                    <div class="featured-content">
                        <h3>VP300ESK Backpack Sprayer</h3>
                        <p>Professional cordless electrostatic backpack sprayer for large area disinfection.</p>
                        <div class="featured-specs">
                            <div class="spec-item"><strong>8.5L</strong><span>Tank Capacity</span></div>
                            <div class="spec-item"><strong>2137m²</strong><span>Coverage</span></div>
                            <div class="spec-item"><strong>4 hrs</strong><span>Battery Life</span></div>
                        </div>
                        <a href="/victory-sprayers.php#backpack" class="btn btn-primary">View Details</a>
                    </div>
                </div>
                <div class="featured-card">
                    <div class="featured-image">
                        <img src="/images/victory-handheld-header.png" alt="VP200ESK Handheld Sprayer">
                    </div>
                    <div class="featured-content">
                        <h3>VP200ESK Handheld Sprayer</h3>
                        <p>Compact cordless electrostatic handheld sprayer for precise application.</p>
                        <div class="featured-specs">
                            <div class="spec-item"><strong>1L</strong><span>Tank Capacity</span></div>
                            <div class="spec-item"><strong>260m²</strong><span>Coverage</span></div>
                            <div class="spec-item"><strong>2.5 hrs</strong><span>Battery Life</span></div>
                        </div>
                        <a href="/victory-sprayers.php#handheld" class="btn btn-primary">View Details</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="cta">
        <div class="container">
            <div class="cta-content">
                <h2>Ready for a Clean, Safe Environment?</h2>
                <p>Contact us today to discuss your disinfection needs. We offer solutions for businesses of all sizes.</p>
                <div class="cta-buttons">
                    <a href="/contact.php" class="btn btn-white btn-lg"><i class="fas fa-envelope"></i> Contact Us</a>
                    <a href="tel:+27123456789" class="btn btn-outline btn-lg" style="border-color: white; color: white;"><i class="fas fa-phone"></i> Call Now</a>
                </div>
            </div>
        </div>
    </section>

    <section class="distributors-section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Our Network</span>
                <h2>Distributors</h2>
            </div>
            <div class="distributors-slider">
                <div class="distributors-track">
                    <!-- First set -->
                    <div class="distributor-item"><img src="/images/logo-long.png" alt="GermCure"></div>
                    <div class="distributor-item"><img src="/multicure/uploads/logos/logos-no-background-oilcure-long.png" alt="OilCure"></div>
                    <div class="distributor-item"><img src="images/distributor-victory.jpg" alt="Victory Innovations"></div>
                    <div class="distributor-item"><img src="/multicure/uploads/logos/logos-no-background-watercure-long.png" alt="WaterCure"></div>
                    <!-- Duplicate set for seamless loop -->
                    <div class="distributor-item"><img src="/images/logo-long.png" alt="GermCure"></div>
                    <div class="distributor-item"><img src="/multicure/uploads/logos/logos-no-background-oilcure-long.png" alt="OilCure"></div>
                    <div class="distributor-item"><img src="images/distributor-victory.jpg" alt="Victory Innovations"></div>
                    <div class="distributor-item"><img src="/multicure/uploads/logos/logos-no-background-watercure-long.png" alt="WaterCure"></div>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-icon-container">
                        <img src="/images/logo-icon.png" alt="GermCure">
                    </div>
                    <p class="footer-tagline">Disinfection &amp; Hygiene</p>
                    <p>Professional infection<br>protection since 2012.</p>
                    <div class="c-virus-banner">
                        <img src="images/c-virus-logos.jpg" alt="COVID-19 Response Partners">
                    </div>
                    <a href="https://www.trustpilot.com/review/germcure.co.za" target="_blank" class="trustpilot-link" style="display: inline-flex; align-items: center; gap: 8px; margin-top: 20px; padding: 10px 16px; background: rgba(255,255,255,0.1); border-radius: 8px; color: white; text-decoration: none; font-size: 13px; transition: all 0.3s;">
                        <i class="fas fa-star" style="color: #00b67a;"></i>
                        <span>Review us on Trustpilot</span>
                    </a>
                </div>
                <div>
                    <h4>Quick Links</h4>
                    <ul class="footer-links">
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/media.php">Media</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="/victory-sprayers.php#backpack">VP300ESK Backpack</a></li>
                        <li><a href="/victory-sprayers.php#handheld">VP200ESK Handheld</a></li>
                        <li><a href="/products.php">Disinfectants</a></li>
                        <li><a href="/products.php#natural">Natural Solutions</a></li>
                    </ul>
                </div>
                <div class="footer-contact">
                    <h4>Contact Us</h4>
                    <p><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p><i class="fas fa-envelope"></i> info@germcure.co.za</p>
                    <p><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> GermCure. All rights reserved.</p>
                <a href="/multicure/" class="multicure-badge">
                    <span>Part of</span>
                    <div class="badge-logo"><img src="/multicure/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
                </a>
            </div>
        </div>
    </footer>
</body>
</html>
