<?php
require_once __DIR__ . '/../multicure/includes/config.php';
$isReseller = isReseller();
$resellerInfo = getResellerInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Disinfection | GermCure South Africa</title>
    <meta name="description" content="100% Natural disinfectants and sanitizers. Hospital-grade and eco-friendly solutions for complete infection protection.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1a7a5e;
            --primary-dark: #145c47;
            --primary-light: #2d9d7a;
            --secondary: #8dc63f;
            --accent: #0d6a6a;
            --dark: #0a1628;
            --gray-50: #f7f9fc;
            --gray-100: #eef2f7;
            --gray-200: #e2e8f0;
            --gray-600: #64748b;
            --white: #ffffff;
            --gradient-hero: linear-gradient(135deg, #0d4d4d 0%, #1a7a5e 50%, #2d6a4f 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.12);
            --radius: 16px;
            --radius-lg: 24px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        html { scroll-behavior: smooth; }

        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo { display: flex; align-items: center; text-decoration: none; gap: 12px; }
        .logo img { height: 75px; transition: transform 0.3s; }
        .nav { display: flex; align-items: center; gap: 16px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; transition: all 0.2s; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-100); }
        .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 10px 18px; border-radius: 12px; font-weight: 600; font-size: 13px; text-decoration: none; transition: all 0.3s; cursor: pointer; border: none; }
        .btn-primary { background: var(--gradient-hero); color: white; box-shadow: 0 4px 20px rgba(26,122,94,0.3); }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 30px rgba(26,122,94,0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-quote { background: var(--secondary); color: white; }
        .btn-quote:hover { background: #7ab32f; transform: translateY(-2px); }
        .btn-white { background: white; color: var(--primary); }
        .btn-sm { padding: 10px 20px; font-size: 14px; }
        .btn-lg { padding: 18px 36px; font-size: 16px; }

        /* Page Hero */
        .page-hero {
            background: var(--gradient-hero);
            padding: 160px 0 100px;
            position: relative;
            overflow: hidden;
        }
        .page-hero::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: url('images/products-bg.jpg') center/cover;
            opacity: 0.15;
        }
        .page-hero-content {
            position: relative;
            z-index: 2;
            text-align: center;
            color: white;
        }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 700px; margin: 0 auto 32px; }
        .hero-nav {
            display: flex;
            justify-content: center;
            gap: 16px;
            flex-wrap: wrap;
        }

        /* Section Styles */
        .section { padding: 100px 0; }
        .section-alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(26,122,94,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 700px; margin: 0 auto; }

        /* Products Grid */
        .products-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 32px;
        }
        .product-card {
            background: white;
            border-radius: var(--radius-lg);
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: all 0.3s;
        }
        .product-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-lg);
        }
        .product-image {
            height: 220px;
            background: var(--gray-50);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 24px;
        }
        .product-image img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }
        .product-content {
            padding: 24px;
        }
        .product-badge {
            display: inline-block;
            background: rgba(141,198,63,0.1);
            color: #5a8a1f;
            padding: 4px 12px;
            border-radius: 50px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            margin-bottom: 12px;
        }
        .product-content h3 { font-size: 1.1rem; margin-bottom: 8px; }
        .product-content p { color: var(--gray-600); font-size: 14px; margin-bottom: 16px; line-height: 1.6; }
        .product-features {
            list-style: none;
            margin-bottom: 20px;
        }
        .product-features li {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 13px;
            color: var(--gray-600);
            padding: 4px 0;
        }
        .product-features i {
            color: var(--secondary);
            font-size: 12px;
        }
        .product-actions {
            display: flex;
            gap: 12px;
        }
        .product-actions .btn {
            flex: 1;
            padding: 12px;
            font-size: 13px;
        }

        /* Categories Grid */
        .categories-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 32px;
        }
        .category-card {
            background: white;
            border-radius: var(--radius-lg);
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: all 0.3s;
            text-decoration: none;
            color: inherit;
        }
        .category-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--shadow-lg);
        }
        .category-image {
            height: 200px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 24px;
        }
        .category-content {
            padding: 24px;
            text-align: center;
        }
        .category-content h3 { font-size: 1.3rem; margin-bottom: 8px; }
        .category-content p { color: var(--gray-600); font-size: 14px; }

        /* Natural Products Highlight */
        .natural-highlight {
            background: linear-gradient(135deg, #e8f5e9 0%, #c8e6c9 100%);
            border-radius: var(--radius-lg);
            padding: 60px;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
        }
        .natural-highlight-content h3 {
            font-size: 2rem;
            color: var(--primary-dark);
            margin-bottom: 16px;
        }
        .natural-highlight-content p {
            color: var(--gray-600);
            margin-bottom: 24px;
        }
        .natural-badges {
            display: flex;
            gap: 16px;
            flex-wrap: wrap;
            margin-bottom: 24px;
        }
        .natural-badge {
            display: flex;
            align-items: center;
            gap: 8px;
            background: white;
            padding: 12px 20px;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 500;
            box-shadow: var(--shadow);
        }
        .natural-badge i { color: var(--secondary); }
        .natural-highlight-image {
            display: flex;
            justify-content: center;
        }
        .natural-highlight-image img {
            max-width: 300px;
            filter: drop-shadow(0 20px 40px rgba(0,0,0,0.1));
        }

        /* Quote Modal */
        .modal-overlay {
            display: none;
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(0,0,0,0.7);
            z-index: 9999;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .modal-overlay.active { display: flex; }
        .modal {
            background: white;
            border-radius: var(--radius-lg);
            padding: 40px;
            max-width: 500px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
        }
        .modal h3 { font-size: 1.5rem; margin-bottom: 8px; }
        .modal .subtitle { color: var(--gray-600); margin-bottom: 24px; }
        .modal-close {
            position: absolute;
            top: 20px;
            right: 20px;
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: var(--gray-600);
        }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select {
            width: 100%;
            padding: 14px;
            border: 2px solid var(--gray-200);
            border-radius: 10px;
            font-family: inherit;
            font-size: 13px;
            transition: border-color 0.2s;
        }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus {
            outline: none;
            border-color: var(--primary);
        }
        .form-group textarea { resize: vertical; min-height: 100px; }
        .success-message { display: none; text-align: center; padding: 40px 20px; }
        .success-message.active { display: block; }
        .success-message i { font-size: 4rem; color: var(--secondary); margin-bottom: 20px; }
        .success-message h3 { margin-bottom: 12px; }
        .success-message p { color: var(--gray-600); }

        /* Footer */
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { font-size: 16px; margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: var(--secondary); }
        .footer-contact p { color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge img { height: 28px; display: block; }

        /* Responsive */
        @media (max-width: 1024px) {
            .categories-grid { grid-template-columns: repeat(2, 1fr); }
            .products-grid { grid-template-columns: repeat(2, 1fr); }
            .natural-highlight { grid-template-columns: 1fr; }
            .footer-grid { grid-template-columns: 1fr 1fr; }
        }
        @media (max-width: 768px) {
            .page-hero h1 { font-size: 2rem; }
            .categories-grid { grid-template-columns: 1fr; }
            .products-grid { grid-template-columns: 1fr; }
            .natural-highlight { padding: 40px 24px; }
            .nav-links { display: none; }
            .footer-grid { grid-template-columns: 1fr; }
        }

        .mobile-menu-btn { display: none; background: none; border: none; font-size: 24px; color: var(--primary); cursor: pointer; }
        @media (max-width: 768px) { .mobile-menu-btn { display: block; } }
    </style>
</head>
<body>
    <?php if ($isReseller): ?>
    </div>
    <?php endif; ?>

    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo">
                    <img src="/images/logo-long.png" alt="GermCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="/multicure/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/">Home</a></li>
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php" class="active">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                        <a href="/multicure/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
                    <?php else: ?>
                        <a href="/multicure/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
                    <?php endif; ?>
                    <button class="mobile-menu-btn"><i class="fas fa-bars"></i></button>
                </nav>
            </div>
        </div>
    </header>

    <!-- Hero -->
    <section class="page-hero">
        <div class="container">
            <div class="page-hero-content">
                <h1>100% Natural Disinfectants</h1>
                <p>Professional-grade, eco-friendly disinfection solutions that are safe for people, pets, and the planet. Hospital-approved formulas with natural ingredients.</p>
                <div class="hero-nav">
                    <a href="#products" class="btn btn-white"><i class="fas fa-flask"></i> View Products</a>
                    <a href="#why-natural" class="btn btn-outline" style="border-color: white; color: white;"><i class="fas fa-leaf"></i> Why Natural?</a>
                    <a href="/contact.php" class="btn btn-outline" style="border-color: white; color: white;"><i class="fas fa-envelope"></i> Get Quote</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Products Section -->
    <section class="section" id="products">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">100% Natural</span>
                <h2>Our Disinfection Range</h2>
                <p>Professional-grade disinfectants made from natural ingredients. Safe, effective, and eco-friendly.</p>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-surface-disinfectant.png" alt="GermCure Surface Disinfectant">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Best Seller</span>
                        <h3>Surface Disinfectant</h3>
                        <p>Hospital-grade surface disinfectant effective against bacteria, viruses, and fungi. 100% natural formula.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Kills 99.99% of germs</li>
                            <li><i class="fas fa-check"></i> Non-corrosive formula</li>
                            <li><i class="fas fa-check"></i> Available in 1L, 5L, 25L</li>
                        </ul>
                        <div class="product-actions">
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure Surface Disinfectant')">
                                <i class="fas fa-file-invoice"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-hand-sanitizer.png" alt="GermCure Hand Sanitizer">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Hand Hygiene</span>
                        <h3>Hand Sanitizer</h3>
                        <p>Natural hand sanitizer with moisturizing properties. Effective protection without harsh chemicals.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Natural ingredients</li>
                            <li><i class="fas fa-check"></i> Added moisturizers</li>
                            <li><i class="fas fa-check"></i> Available 100ml-5L</li>
                        </ul>
                        <div class="product-actions">
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure Hand Sanitizer')">
                                <i class="fas fa-file-invoice"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-fogging-solution.png" alt="GermCure Fogging Solution">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">For Sprayers</span>
                        <h3>Fogging Solution</h3>
                        <p>Specially formulated for use with electrostatic and ULV fogging equipment. Safe for electronics.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Optimized for sprayers</li>
                            <li><i class="fas fa-check"></i> No residue formula</li>
                            <li><i class="fas fa-check"></i> Safe for electronics</li>
                        </ul>
                        <div class="product-actions">
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure Fogging Solution')">
                                <i class="fas fa-file-invoice"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-all-purpose.png" alt="GermCure All-Purpose Cleaner">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Multi-Use</span>
                        <h3>All-Purpose Cleaner</h3>
                        <p>Plant-based all-purpose disinfectant for homes, offices, and food preparation areas.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Plant-derived ingredients</li>
                            <li><i class="fas fa-check"></i> Food-safe formula</li>
                            <li><i class="fas fa-check"></i> Biodegradable</li>
                        </ul>
                        <div class="product-actions">
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure All-Purpose Cleaner')">
                                <i class="fas fa-file-invoice"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-air-purifier.png" alt="GermCure Air Purifier">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Air Care</span>
                        <h3>Air Purifier Spray</h3>
                        <p>Natural air disinfectant that eliminates airborne pathogens and freshens indoor spaces.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Essential oil based</li>
                            <li><i class="fas fa-check"></i> Kills airborne germs</li>
                            <li><i class="fas fa-check"></i> Pleasant natural scent</li>
                        </ul>
                        <div class="product-actions">
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure Air Purifier')">
                                <i class="fas fa-file-invoice"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-hospital-grade.png" alt="GermCure Hospital Grade">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Medical Grade</span>
                        <h3>Hospital Grade</h3>
                        <p>Professional medical-grade disinfectant for healthcare facilities and high-risk environments.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Lab tested formula</li>
                            <li><i class="fas fa-check"></i> Fast acting</li>
                            <li><i class="fas fa-check"></i> Hospital approved</li>
                        </ul>
                        <div class="product-actions">
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure Hospital Grade')">
                                <i class="fas fa-file-invoice"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-air160.png" alt="GermCure AIR160 Air Purifier">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Air Purification</span>
                        <h3>GermCure AIR160</h3>
                        <p>Hospital-grade air purifier using 3 technologies: Filtration, UV-C Light, and Ionization. Purifies air by 99.99%.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> 3-stage purification system</li>
                            <li><i class="fas fa-check"></i> Philips UV-C technology</li>
                            <li><i class="fas fa-check"></i> Areas up to 100m³</li>
                            <li><i class="fas fa-check"></i> 2 Year Warranty</li>
                        </ul>
                        <div class="product-actions">
                            <a href="/air160.php" class="btn btn-outline btn-sm">
                                <i class="fas fa-info-circle"></i> Learn More
                            </a>
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure AIR160 Air Purifier')">
                                <i class="fas fa-file-invoice"></i> Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-autodish.png" alt="GermCure Auto Dishwashing Liquid">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Household</span>
                        <h3>Auto Dishwashing Liquid</h3>
                        <p>100% all-natural enzyme-based detergent for automatic dishwashing machines. Non-foaming, rinses clean.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Halal Certified</li>
                            <li><i class="fas fa-check"></i> All temperature machines</li>
                            <li><i class="fas fa-check"></i> No chemicals or chlorine</li>
                            <li><i class="fas fa-check"></i> 1L Concentrate (20ml/load)</li>
                        </ul>
                        <div class="product-actions">
                            <a href="Documents/GC%20-%20Auto%20Dishwashing%20Liquid%20-%201L.pdf" target="_blank" class="btn btn-outline btn-sm">
                                <i class="fas fa-file-pdf"></i> Label
                            </a>
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure Auto Dishwashing Liquid 1L')">
                                <i class="fas fa-file-invoice"></i> Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-dish.png" alt="GermCure Dishwashing Liquid">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Household</span>
                        <h3>Dishwashing Liquid</h3>
                        <p>100% all-natural hand dishwashing liquid. Quickly dissolves baked-on food, oil and grease deposits.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Halal Certified</li>
                            <li><i class="fas fa-check"></i> Heavy-duty cleaning</li>
                            <li><i class="fas fa-check"></i> No film or water spots</li>
                            <li><i class="fas fa-check"></i> 1L Concentrate (20ml:5-10L)</li>
                        </ul>
                        <div class="product-actions">
                            <a href="Documents/GC%20-%20Dishwashing%20Liquid%20-%201L.pdf" target="_blank" class="btn btn-outline btn-sm">
                                <i class="fas fa-file-pdf"></i> Label
                            </a>
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure Dishwashing Liquid 1L')">
                                <i class="fas fa-file-invoice"></i> Quote
                            </button>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <img src="images/product-laundry.png" alt="GermCure Laundry Detergent">
                    </div>
                    <div class="product-content">
                        <span class="product-badge">Household</span>
                        <h3>Laundry Detergent</h3>
                        <p>100% all-natural laundry detergent for hand wash and automatic machines. Superior dirt removal and fabric care.</p>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> Halal Certified</li>
                            <li><i class="fas fa-check"></i> Top & front loaders</li>
                            <li><i class="fas fa-check"></i> Dissolves tough oily stains</li>
                            <li><i class="fas fa-check"></i> 1L Concentrate (20ml/30L)</li>
                        </ul>
                        <div class="product-actions">
                            <a href="Documents/GC%20-%20Laundry%20Detergent%20-%201L.pdf" target="_blank" class="btn btn-outline btn-sm">
                                <i class="fas fa-file-pdf"></i> Label
                            </a>
                            <button class="btn btn-quote btn-sm" onclick="openQuoteModal('GermCure Laundry Detergent 1L')">
                                <i class="fas fa-file-invoice"></i> Quote
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Natural Section -->
    <section class="section section-alt" id="why-natural">
        <div class="container">
            <div class="natural-highlight">
                <div class="natural-highlight-content">
                    <h3>Why Choose Natural Disinfectants?</h3>
                    <p>Our natural disinfectant range provides effective germ-killing power without the harsh chemicals found in traditional products. Safe for your family, pets, and the environment while delivering hospital-grade protection.</p>
                    <div class="natural-badges">
                        <div class="natural-badge"><i class="fas fa-leaf"></i> Plant-Based</div>
                        <div class="natural-badge"><i class="fas fa-paw"></i> Pet Safe</div>
                        <div class="natural-badge"><i class="fas fa-baby"></i> Child Safe</div>
                        <div class="natural-badge"><i class="fas fa-recycle"></i> Biodegradable</div>
                    </div>
                    <button class="btn btn-primary" onclick="openQuoteModal('Natural Products Range')">
                        <i class="fas fa-file-invoice"></i> Request Quote
                    </button>
                </div>
                <div class="natural-highlight-image">
                    <img src="images/disinfection-hexagon.png" alt="Natural Products">
                </div>
            </div>
        </div>
    </section>

    <!-- Disinfection Services Info -->
    <section class="section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Professional Services</span>
                <h2>Disinfection Solutions</h2>
                <p>Complete disinfection solutions for homes, offices, and commercial spaces.</p>
            </div>
            <div class="categories-grid">
                <div class="category-card">
                    <div class="category-image" style="background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);">
                        <i class="fas fa-hospital" style="font-size: 4rem; color: var(--primary);"></i>
                    </div>
                    <div class="category-content">
                        <h3>Healthcare Facilities</h3>
                        <p>Hospital-grade disinfection for clinics, hospitals, and medical offices.</p>
                    </div>
                </div>
                <div class="category-card">
                    <div class="category-image" style="background: linear-gradient(135deg, #e8f5e9 0%, #c8e6c9 100%);">
                        <i class="fas fa-building" style="font-size: 4rem; color: var(--primary);"></i>
                    </div>
                    <div class="category-content">
                        <h3>Commercial Spaces</h3>
                        <p>Office buildings, retail stores, and commercial properties disinfection.</p>
                    </div>
                </div>
                <div class="category-card">
                    <div class="category-image" style="background: linear-gradient(135deg, #fff3e0 0%, #ffe0b2 100%);">
                        <i class="fas fa-home" style="font-size: 4rem; color: var(--primary);"></i>
                    </div>
                    <div class="category-content">
                        <h3>Residential</h3>
                        <p>Safe, natural disinfection products for your home and family.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA -->
    <section style="padding: 100px 0; background: var(--gradient-hero);">
        <div class="container" style="text-align: center; color: white;">
            <h2 style="font-size: 2.5rem; margin-bottom: 16px;">Need Help Choosing?</h2>
            <p style="font-size: 1.1rem; opacity: 0.9; margin-bottom: 32px; max-width: 600px; margin-left: auto; margin-right: auto;">Our team can help you select the right products for your specific needs. Contact us for expert advice and bulk pricing.</p>
            <div style="display: flex; gap: 16px; justify-content: center; flex-wrap: wrap;">
                <a href="/contact.php" class="btn btn-white btn-lg">
                    <i class="fas fa-envelope"></i> Contact Us
                </a>
                <a href="/victory-sprayers.php" class="btn btn-outline btn-lg" style="border-color: white; color: white;">
                    <i class="fas fa-spray-can"></i> View Sprayers
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-icon-container">
                        <img src="/images/logo-icon.png" alt="GermCure">
                    </div>
                    <p class="footer-tagline">Disinfection &amp; Hygiene</p>
                    <p>Professional infection<br>protection since 2012.</p>
                    <div class="c-virus-banner" style="margin-top: 16px;">
                        <img src="images/c-virus-logos.jpg" alt="COVID-19 Response Partners" style="height: 50px; opacity: 0.8;">
                    </div>
                    <a href="https://www.trustpilot.com/review/germcure.co.za" target="_blank" class="trustpilot-link" style="display: inline-flex; align-items: center; gap: 8px; margin-top: 20px; padding: 10px 16px; background: rgba(255,255,255,0.1); border-radius: 8px; color: white; text-decoration: none; font-size: 13px; transition: all 0.3s;">
                        <i class="fas fa-star" style="color: #00b67a;"></i>
                        <span>Review us on Trustpilot</span>
                    </a>
                </div>
                <div>
                    <h4>Quick Links</h4>
                    <ul class="footer-links">
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/media.php">Media</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="#products">Surface Disinfectant</a></li>
                        <li><a href="#products">Hand Sanitizer</a></li>
                        <li><a href="#products">Fogging Solution</a></li>
                        <li><a href="#products">Hospital Grade</a></li>
                    </ul>
                </div>
                <div class="footer-contact">
                    <h4>Contact Us</h4>
                    <p><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p><i class="fas fa-envelope"></i> info@germcure.co.za</p>
                    <p><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> GermCure. All rights reserved.</p>
                <a href="/multicure/" class="multicure-badge">
                    <span>Part of</span>
                    <div class="badge-logo"><img src="/multicure/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
                </a>
            </div>
        </div>
    </footer>

    <!-- Quote Modal -->
    <div class="modal-overlay" id="quoteModal">
        <div class="modal">
            <button class="modal-close" onclick="closeQuoteModal()">&times;</button>
            <div id="quoteForm">
                <h3>Request a Quote</h3>
                <p class="subtitle" id="productName">Product Name</p>
                <form onsubmit="submitQuote(event)">
                    <div class="form-group">
                        <label>Your Name *</label>
                        <input type="text" name="name" required>
                    </div>
                    <div class="form-group">
                        <label>Company Name</label>
                        <input type="text" name="company">
                    </div>
                    <div class="form-group">
                        <label>Email Address *</label>
                        <input type="email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label>Phone Number *</label>
                        <input type="tel" name="phone" required>
                    </div>
                    <div class="form-group">
                        <label>Quantity / Volume Required</label>
                        <input type="text" name="quantity" placeholder="e.g., 10 x 5L bottles">
                    </div>
                    <div class="form-group">
                        <label>Additional Notes</label>
                        <textarea name="notes" placeholder="Tell us about your requirements..."></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary btn-lg" style="width: 100%;">
                        <i class="fas fa-paper-plane"></i> Submit Request
                    </button>
                </form>
            </div>
            <div class="success-message" id="successMessage">
                <i class="fas fa-check-circle"></i>
                <h3>Quote Request Received!</h3>
                <p>Thank you for your interest. A quote will be sent to you shortly. Our team will contact you within 24 hours.</p>
                <button class="btn btn-primary" onclick="closeQuoteModal()" style="margin-top: 20px;">Close</button>
            </div>
        </div>
    </div>

    <script>
        function openQuoteModal(product) {
            document.getElementById('productName').textContent = product;
            document.getElementById('quoteModal').classList.add('active');
            document.body.style.overflow = 'hidden';
        }
        function closeQuoteModal() {
            document.getElementById('quoteModal').classList.remove('active');
            document.body.style.overflow = '';
            document.getElementById('quoteForm').style.display = 'block';
            document.getElementById('successMessage').classList.remove('active');
        }
        function submitQuote(e) {
            e.preventDefault();
            document.getElementById('quoteForm').style.display = 'none';
            document.getElementById('successMessage').classList.add('active');
        }
        document.getElementById('quoteModal').addEventListener('click', function(e) {
            if (e.target === this) closeQuoteModal();
        });
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') closeQuoteModal();
        });
    </script>
</body>
</html>
