<?php
require_once __DIR__ . '/../multicure/includes/config.php';
$isReseller = isReseller();
$resellerInfo = getResellerInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Victory Cordless Electrostatic Sprayers | GermCure South Africa</title>
    <meta name="description" content="Sub-Sahara agents for Victory Electrostatic Sprayers. VP300ESK Backpack and VP200ESK Handheld sprayers for professional disinfection.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1a7a5e;
            --primary-dark: #145c47;
            --primary-light: #2d9d7a;
            --secondary: #8dc63f;
            --accent: #0d6a6a;
            --dark: #0a1628;
            --gray-50: #f7f9fc;
            --gray-100: #eef2f7;
            --gray-200: #e2e8f0;
            --gray-600: #64748b;
            --white: #ffffff;
            --gradient-hero: linear-gradient(135deg, #0d4d4d 0%, #1a7a5e 50%, #2d6a4f 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.12);
            --radius: 16px;
            --radius-lg: 24px;
            --victory-blue: #0077b6;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        html { scroll-behavior: smooth; }

        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo { display: flex; align-items: center; text-decoration: none; gap: 12px; }
        .logo img { height: 75px; transition: transform 0.3s; }
        .nav { display: flex; align-items: center; gap: 16px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 14px; padding: 10px 18px; border-radius: 10px; transition: all 0.2s; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-100); }
        .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 14px 28px; border-radius: 12px; font-weight: 600; font-size: 15px; text-decoration: none; transition: all 0.3s; cursor: pointer; border: none; }
        .btn-primary { background: var(--gradient-hero); color: white; box-shadow: 0 4px 20px rgba(26,122,94,0.3); }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 30px rgba(26,122,94,0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-quote { background: var(--secondary); color: white; }
        .btn-quote:hover { background: #7ab32f; transform: translateY(-2px); }
        .btn-white { background: white; color: var(--primary); }
        .btn-lg { padding: 18px 36px; font-size: 16px; }

        /* Hero Banner */
        .page-hero {
            background: linear-gradient(135deg, #003d5c 0%, #0077b6 50%, #00a8e8 100%);
            padding: 160px 0 100px;
            position: relative;
            overflow: hidden;
        }
        .page-hero::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: url('/images/victory-all-products.png') center/cover;
            opacity: 0.15;
        }
        .page-hero-content {
            position: relative;
            z-index: 2;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
        }
        .page-hero-text { color: white; }
        .page-hero-text h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero-text p { font-size: 1.2rem; opacity: 0.9; margin-bottom: 24px; }
        .victory-logo { max-width: 250px; margin-bottom: 24px; }
        .page-hero-image img { max-width: 100%; filter: drop-shadow(0 30px 60px rgba(0,0,0,0.3)); }

        /* Stats Section */
        .stats-highlight {
            background: white;
            padding: 60px 0;
            margin-top: -60px;
            position: relative;
            z-index: 10;
            border-radius: var(--radius-lg) var(--radius-lg) 0 0;
        }
        .stats-highlight-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 40px;
        }
        .stat-highlight-item {
            text-align: center;
            padding: 24px;
            background: var(--gray-50);
            border-radius: var(--radius);
        }
        .stat-highlight-item i {
            font-size: 2.5rem;
            color: var(--victory-blue);
            margin-bottom: 16px;
        }
        .stat-highlight-item h3 {
            font-size: 2rem;
            color: var(--primary);
            margin-bottom: 8px;
        }
        .stat-highlight-item p { color: var(--gray-600); font-size: 14px; }

        /* Technology Section */
        .technology { padding: 80px 0; background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(26,122,94,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 700px; margin: 0 auto; }

        .tech-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
        }
        .tech-video {
            position: relative;
            padding-bottom: 56.25%;
            border-radius: var(--radius-lg);
            overflow: hidden;
            box-shadow: var(--shadow-lg);
        }
        .tech-video iframe {
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
        }
        .tech-features { list-style: none; }
        .tech-features li {
            display: flex;
            align-items: flex-start;
            gap: 16px;
            padding: 20px 0;
            border-bottom: 1px solid var(--gray-200);
        }
        .tech-features li:last-child { border-bottom: none; }
        .tech-features i {
            width: 40px;
            height: 40px;
            background: var(--primary);
            color: white;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        .tech-features h4 { font-size: 1.1rem; margin-bottom: 4px; }
        .tech-features p { color: var(--gray-600); font-size: 14px; }

        /* Product Section */
        .products { padding: 100px 0; background: white; }
        .product-card {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
            padding: 60px;
            background: var(--gray-50);
            border-radius: var(--radius-lg);
            margin-bottom: 60px;
        }
        .product-card:nth-child(even) {
            direction: rtl;
        }
        .product-card:nth-child(even) > * {
            direction: ltr;
        }
        .product-images {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
        }
        .product-images img {
            width: 100%;
            border-radius: var(--radius);
            background: white;
            padding: 20px;
            box-shadow: var(--shadow);
        }
        .product-images .main-image {
            grid-column: span 2;
        }
        .product-info h3 {
            font-size: 2rem;
            margin-bottom: 16px;
            color: var(--dark);
        }
        .product-info .subtitle {
            color: var(--victory-blue);
            font-weight: 600;
            margin-bottom: 16px;
        }
        .product-info p {
            color: var(--gray-600);
            margin-bottom: 24px;
        }

        /* Specs Table */
        .specs-table {
            width: 100%;
            margin-bottom: 24px;
        }
        .specs-table tr {
            border-bottom: 1px solid var(--gray-200);
        }
        .specs-table td {
            padding: 12px 0;
            font-size: 14px;
        }
        .specs-table td:first-child {
            font-weight: 600;
            color: var(--dark);
            width: 50%;
        }
        .specs-table td:last-child {
            color: var(--gray-600);
        }

        .product-actions {
            display: flex;
            gap: 16px;
            flex-wrap: wrap;
        }

        /* Product Accessories - Inline under products */
        .product-accessories {
            background: var(--gray-50);
            border-radius: var(--radius-lg);
            padding: 32px 40px;
            margin-bottom: 60px;
        }
        .product-accessories h4 {
            font-size: 1rem;
            color: var(--primary);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .product-accessories h4 i {
            font-size: 1.1rem;
        }
        .accessories-inline {
            display: flex;
            flex-wrap: wrap;
            gap: 16px;
        }
        .accessory-item {
            display: flex;
            align-items: center;
            gap: 12px;
            background: white;
            padding: 12px 20px;
            border-radius: 12px;
            box-shadow: var(--shadow);
            transition: all 0.3s;
            flex: 1 1 200px;
            max-width: 280px;
        }
        .accessory-item:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }
        .accessory-item img {
            width: 50px;
            height: 50px;
            object-fit: contain;
            flex-shrink: 0;
        }
        .accessory-item strong {
            display: block;
            font-size: 13px;
            color: var(--dark);
            margin-bottom: 2px;
        }
        .accessory-item span {
            font-size: 11px;
            color: var(--gray-600);
        }

        @media (max-width: 768px) {
            .accessories-inline {
                flex-direction: column;
            }
            .accessory-item {
                max-width: 100%;
            }
        }

        /* Videos Grid */
        .videos { padding: 80px 0; background: white; }
        .videos-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 24px;
        }
        .video-card {
            position: relative;
            padding-bottom: 56.25%;
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
        }
        .video-card iframe {
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
        }

        /* Quote Modal */
        .modal-overlay {
            display: none;
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(0,0,0,0.7);
            z-index: 9999;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .modal-overlay.active { display: flex; }
        .modal {
            background: white;
            border-radius: var(--radius-lg);
            padding: 40px;
            max-width: 500px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
        }
        .modal h3 { font-size: 1.5rem; margin-bottom: 8px; }
        .modal .subtitle { color: var(--gray-600); margin-bottom: 24px; }
        .modal-close {
            position: absolute;
            top: 20px;
            right: 20px;
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: var(--gray-600);
        }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select {
            width: 100%;
            padding: 14px;
            border: 2px solid var(--gray-200);
            border-radius: 10px;
            font-family: inherit;
            font-size: 15px;
            transition: border-color 0.2s;
        }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus {
            outline: none;
            border-color: var(--primary);
        }
        .form-group textarea { resize: vertical; min-height: 100px; }

        .success-message {
            display: none;
            text-align: center;
            padding: 40px 20px;
        }
        .success-message.active { display: block; }
        .success-message i {
            font-size: 4rem;
            color: var(--secondary);
            margin-bottom: 20px;
        }
        .success-message h3 { margin-bottom: 12px; }
        .success-message p { color: var(--gray-600); }

        /* Footer */
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { font-size: 16px; margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: var(--secondary); }
        .footer-contact p { color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge img { height: 28px; display: block; }

        /* Responsive */
        @media (max-width: 1024px) {
            .page-hero-content { grid-template-columns: 1fr; text-align: center; }
            .page-hero-image { display: none; }
            .stats-highlight-grid { grid-template-columns: repeat(2, 1fr); }
            .tech-grid { grid-template-columns: 1fr; }
            .product-card { grid-template-columns: 1fr; }
            .product-card:nth-child(even) { direction: ltr; }
            .accessories-grid { grid-template-columns: repeat(2, 1fr); }
            .videos-grid { grid-template-columns: repeat(2, 1fr); }
            .footer-grid { grid-template-columns: 1fr 1fr; }
        }
        @media (max-width: 768px) {
            .page-hero h1 { font-size: 2rem; }
            .stats-highlight-grid { grid-template-columns: 1fr; }
            .product-images { grid-template-columns: 1fr; }
            .product-images .main-image { grid-column: span 1; }
            .accessories-grid { grid-template-columns: 1fr; }
            .videos-grid { grid-template-columns: 1fr; }
            .nav-links { display: none; }
            .footer-grid { grid-template-columns: 1fr; }
        }

        .mobile-menu-btn { display: none; background: none; border: none; font-size: 24px; color: var(--primary); cursor: pointer; }
        @media (max-width: 768px) { .mobile-menu-btn { display: block; } }
    </style>
</head>
<body>
    <?php if ($isReseller): ?>
    </div>
    <?php endif; ?>

    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo">
                    <img src="/images/logo-long.png" alt="GermCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="/multicure/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/">Home</a></li>
                        <li><a href="/victory-sprayers.php" class="active">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                    <?php else: ?>
                    <?php endif; ?>
                    <button class="mobile-menu-btn"><i class="fas fa-bars"></i></button>
                </nav>
            </div>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="page-hero">
        <div class="container">
            <div class="page-hero-content">
                <div class="page-hero-text">
                    <div style="background: white; padding: 16px 24px; border-radius: 12px; display: inline-block; margin-bottom: 24px;">
                        <img src="/images/victory-logo-registered.png" alt="Victory Innovations" style="max-width: 220px; display: block;">
                    </div>
                    <h1>Victory Cordless Electrostatic Sprayers</h1>
                    <p>Professional cordless electrostatic sprayers that deliver superior coverage with 65% less chemicals and 70% time savings. Sub-Sahara exclusive agents.</p>
                    <div style="display: flex; gap: 16px; flex-wrap: wrap;">
                        <a href="#handheld" class="btn btn-white"><i class="fas fa-spray-can"></i> VP200ESK Handheld</a>
                        <a href="#backpack" class="btn btn-outline" style="border-color: white; color: white;"><i class="fas fa-briefcase"></i> VP300ESK Backpack</a>
                    </div>
                </div>
                <div class="page-hero-image">
                    <img src="/images/victory-handheld-header.png" alt="Victory Sprayer">
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-highlight">
        <div class="container">
            <div class="stats-highlight-grid">
                <div class="stat-highlight-item">
                    <i class="fas fa-flask"></i>
                    <h3>65%</h3>
                    <p>Less Chemical Usage</p>
                </div>
                <div class="stat-highlight-item">
                    <i class="fas fa-clock"></i>
                    <h3>70%</h3>
                    <p>Time Savings</p>
                </div>
                <div class="stat-highlight-item">
                    <i class="fas fa-expand-arrows-alt"></i>
                    <h3>2137m²</h3>
                    <p>Backpack Coverage</p>
                </div>
                <div class="stat-highlight-item">
                    <i class="fas fa-battery-full"></i>
                    <h3>4+ hrs</h3>
                    <p>Battery Life</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Technology Section -->
    <section class="technology">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">The Technology</span>
                <h2>Electrostatic Spray Technology</h2>
                <p>Victory sprayers use patented electrostatic technology that positively charges liquid particles as they exit the nozzle, creating a wrap-around effect for complete surface coverage.</p>
            </div>
            <div class="tech-grid">
                <div class="tech-video">
                    <iframe src="https://www.youtube.com/embed/DcJMqzbr3_E" title="Victory Electrostatic Sprayer Demo" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
                <ul class="tech-features">
                    <li>
                        <i class="fas fa-bolt"></i>
                        <div>
                            <h4>Electrostatic Charge</h4>
                            <p>Particles are positively charged as they exit the nozzle, creating attraction to surfaces and wrap-around coverage.</p>
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-shield-virus"></i>
                        <div>
                            <h4>Complete Coverage</h4>
                            <p>Charged particles wrap around surfaces, reaching hidden areas that traditional spraying methods miss.</p>
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-leaf"></i>
                        <div>
                            <h4>Eco-Friendly</h4>
                            <p>Uses up to 65% less chemicals while providing superior coverage, reducing environmental impact.</p>
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-tachometer-alt"></i>
                        <div>
                            <h4>Fast Application</h4>
                            <p>Cover large areas up to 70% faster than traditional methods with consistent, even distribution.</p>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </section>

    <!-- Products Section -->
    <section class="products" id="products">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Our Products</span>
                <h2>Professional Sprayer Solutions</h2>
                <p>Choose the right Victory electrostatic sprayer for your needs.</p>
            </div>

            <!-- VP200ESK Handheld -->
            <div class="product-card" id="handheld">
                <div class="product-images">
                    <img src="/images/victory-handheld-header.png" alt="VP200ESK Handheld Sprayer" class="main-image">
                    <img src="/images/victory-handheld-tilt.png" alt="VP200ESK Components">
                    <img src="/images/victory-handheld-strap.png" alt="VP200ESK In Use">
                </div>
                <div class="product-info">
                    <p class="subtitle">Professional Cordless Electrostatic Handheld Sprayer</p>
                    <h3>VP200ESK</h3>
                    <p>The VP200ESK is a compact cordless electrostatic handheld sprayer perfect for targeted disinfection and smaller areas. Lightweight and ergonomic, it's ideal for offices, vehicles, restrooms, and touchpoint sanitization.</p>

                    <table class="specs-table">
                        <tr><td>Tank Capacity</td><td>1 Liter (33.8 oz)</td></tr>
                        <tr><td>Coverage Per Tank</td><td>260m² (2,800 sq ft)</td></tr>
                        <tr><td>Battery Life</td><td>2.5 hours continuous use</td></tr>
                        <tr><td>Charge Time</td><td>2 hours</td></tr>
                        <tr><td>Flow Rate</td><td>40-80 ml/min</td></tr>
                        <tr><td>Particle Size</td><td>40-80 microns</td></tr>
                        <tr><td>Weight (full)</td><td>1.4 kg (3.2 lbs)</td></tr>
                    </table>

                    <div class="product-actions">
                        <button class="btn btn-quote btn-lg" onclick="openQuoteModal('VP200ESK Handheld Sprayer')">
                            <i class="fas fa-file-invoice"></i> Request Quote
                        </button>
                        <a href="/contact.php" class="btn btn-outline">
                            <i class="fas fa-question-circle"></i> Ask a Question
                        </a>
                    </div>
                </div>
            </div>

            <!-- VP200ESK Accessories -->
            <div class="product-accessories">
                <h4><i class="fas fa-puzzle-piece"></i> VP200ESK Accessories</h4>
                <div class="accessories-inline">
                    <div class="accessory-item">
                        <img src="/images/accessory-tank.png" alt="Tank">
                        <div>
                            <strong>VP20 Tank Assembly</strong>
                            <span>Replacement 1L Tank</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-battery.png" alt="Battery">
                        <div>
                            <strong>VP20B Battery</strong>
                            <span>16.8V Lithium-Ion</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-charger.png" alt="Charger">
                        <div>
                            <strong>VP10 Charger</strong>
                            <span>Fast Battery Charger</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-nozzle.png" alt="Nozzle">
                        <div>
                            <strong>VP50 3-in-1 Nozzle</strong>
                            <span>40/80/110 Microns</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-strap.png" alt="Strap">
                        <div>
                            <strong>VP91 Carry Strap</strong>
                            <span>Shoulder Strap</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-extension.png" alt="Extension">
                        <div>
                            <strong>VP72 Extension Wand</strong>
                            <span>12" Extension</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- VP300ESK Backpack -->
            <div class="product-card" id="backpack">
                <div class="product-images">
                    <img src="/images/victory-backpack-sprayer.png" alt="VP300ESK Backpack Sprayer" class="main-image">
                    <img src="/images/victory-backpack-sprayer.png" alt="VP300ESK In Use">
                    <img src="/images/victory-all-products.png" alt="65% Less Chemicals">
                </div>
                <div class="product-info">
                    <p class="subtitle">Professional Cordless Electrostatic Backpack Sprayer</p>
                    <h3>VP300ESK</h3>
                    <p>The VP300ESK is a professional-grade cordless electrostatic backpack sprayer designed for large area disinfection. With an 8.5-liter tank capacity and 4+ hour battery life, it's perfect for schools, hospitals, offices, and large commercial spaces.</p>

                    <table class="specs-table">
                        <tr><td>Tank Capacity</td><td>8.5 Liters (2.25 gallons)</td></tr>
                        <tr><td>Coverage Per Tank</td><td>2137m² (23,000 sq ft)</td></tr>
                        <tr><td>Battery Life</td><td>4 hours continuous use</td></tr>
                        <tr><td>Charge Time</td><td>2.5 hours</td></tr>
                        <tr><td>Flow Rate</td><td>40-110 ml/min</td></tr>
                        <tr><td>Particle Size</td><td>40-80 microns</td></tr>
                        <tr><td>Weight (empty)</td><td>4.8 kg (10.5 lbs)</td></tr>
                    </table>

                    <div class="product-actions">
                        <button class="btn btn-quote btn-lg" onclick="openQuoteModal('VP300ESK Backpack Sprayer')">
                            <i class="fas fa-file-invoice"></i> Request Quote
                        </button>
                        <a href="/contact.php" class="btn btn-outline">
                            <i class="fas fa-question-circle"></i> Ask a Question
                        </a>
                    </div>
                </div>
            </div>

            <!-- VP300ESK Accessories -->
            <div class="product-accessories">
                <h4><i class="fas fa-puzzle-piece"></i> VP300ESK Accessories</h4>
                <div class="accessories-inline">
                    <div class="accessory-item">
                        <img src="/images/accessory-tank.png" alt="Tank">
                        <div>
                            <strong>VP31 Tank Assembly</strong>
                            <span>Replacement 8.5L Tank</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-battery.png" alt="Battery">
                        <div>
                            <strong>VP20B Battery</strong>
                            <span>16.8V Lithium-Ion</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-charger.png" alt="Charger">
                        <div>
                            <strong>VP10 Charger</strong>
                            <span>Fast Battery Charger</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-nozzle.png" alt="Nozzle">
                        <div>
                            <strong>VP50 3-in-1 Nozzle</strong>
                            <span>40/80/110 Microns</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-hose.png" alt="Hose Kit">
                        <div>
                            <strong>VRP32 Hose Kit</strong>
                            <span>4' Hose Connector</span>
                        </div>
                    </div>
                    <div class="accessory-item">
                        <img src="/images/accessory-handle.png" alt="Spray Handle">
                        <div>
                            <strong>VRP30 Spray Handle</strong>
                            <span>Replacement Handle</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- More Videos -->
    <section class="videos">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Video Gallery</span>
                <h2>See Victory In Action</h2>
                <p>Watch how Victory electrostatic sprayers are transforming disinfection worldwide.</p>
            </div>
            <div class="videos-grid">
                <div class="video-card">
                    <iframe src="https://www.youtube.com/embed/oNAXfSoxQsg" frameborder="0" allowfullscreen></iframe>
                </div>
                <div class="video-card">
                    <iframe src="https://www.youtube.com/embed/TOhXaBHT3Ho" frameborder="0" allowfullscreen></iframe>
                </div>
                <div class="video-card">
                    <iframe src="https://www.youtube.com/embed/yPjlO9RDihA" frameborder="0" allowfullscreen></iframe>
                </div>
                <div class="video-card">
                    <iframe src="https://www.youtube.com/embed/6b7xpYYTq2Y" frameborder="0" allowfullscreen></iframe>
                </div>
                <div class="video-card">
                    <iframe src="https://www.youtube.com/embed/xZlnyO8h1Ck" frameborder="0" allowfullscreen></iframe>
                </div>
                <div class="video-card">
                    <iframe src="https://www.youtube.com/embed/GPFLqt-JbpY" frameborder="0" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA -->
    <section class="cta" style="padding: 100px 0; background: var(--gradient-hero);">
        <div class="container" style="text-align: center; color: white;">
            <h2 style="font-size: 2.5rem; margin-bottom: 16px;">Ready to Upgrade Your Disinfection?</h2>
            <p style="font-size: 1.1rem; opacity: 0.9; margin-bottom: 32px; max-width: 600px; margin-left: auto; margin-right: auto;">Contact us today to learn more about Victory Electrostatic Sprayers and how they can benefit your organization.</p>
            <div style="display: flex; gap: 16px; justify-content: center;">
                <button class="btn btn-white btn-lg" onclick="openQuoteModal('Victory Sprayer')">
                    <i class="fas fa-file-invoice"></i> Request Quote
                </button>
                <a href="/contact.php" class="btn btn-outline btn-lg" style="border-color: white; color: white;">
                    <i class="fas fa-phone"></i> Contact Us
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-icon-container">
                        <img src="/images/logo-icon.png" alt="GermCure">
                    </div>
                    <p class="footer-tagline">Disinfection &amp; Hygiene</p>
                    <p>Professional infection<br>protection since 2012.</p>
                    <div class="c-virus-banner" style="margin-top: 16px;">
                        <img src="images/c-virus-logos.jpg" alt="COVID-19 Response Partners" style="height: 50px; opacity: 0.8;">
                    </div>
                    <a href="https://www.trustpilot.com/review/germcure.co.za" target="_blank" class="trustpilot-link" style="display: inline-flex; align-items: center; gap: 8px; margin-top: 20px; padding: 10px 16px; background: rgba(255,255,255,0.1); border-radius: 8px; color: white; text-decoration: none; font-size: 13px; transition: all 0.3s;">
                        <i class="fas fa-star" style="color: #00b67a;"></i>
                        <span>Review us on Trustpilot</span>
                    </a>
                </div>
                <div>
                    <h4>Quick Links</h4>
                    <ul class="footer-links">
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/media.php">Media</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="#handheld">VP200ESK Handheld</a></li>
                        <li><a href="#backpack">VP300ESK Backpack</a></li>
                        <li><a href="/products.php">Disinfectants</a></li>
                        <li><a href="/products.php#natural">Natural Solutions</a></li>
                    </ul>
                </div>
                <div class="footer-contact">
                    <h4>Contact Us</h4>
                    <p><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p><i class="fas fa-envelope"></i> info@germcure.co.za</p>
                    <p><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> GermCure. All rights reserved.</p>
                <a href="/multicure/" class="multicure-badge">
                    <span>Part of</span>
                    <div class="badge-logo"><img src="/multicure/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
                </a>
            </div>
        </div>
    </footer>

    <!-- Quote Modal -->
    <div class="modal-overlay" id="quoteModal">
        <div class="modal" style="position: relative;">
            <button class="modal-close" onclick="closeQuoteModal()">&times;</button>
            
            <div id="quoteForm">
                <h3>Request a Quote</h3>
                <p class="subtitle" id="productName">Victory Sprayer</p>
                
                <form onsubmit="submitQuote(event)">
                    <div class="form-group">
                        <label>Your Name *</label>
                        <input type="text" name="name" required>
                    </div>
                    <div class="form-group">
                        <label>Company Name</label>
                        <input type="text" name="company">
                    </div>
                    <div class="form-group">
                        <label>Email Address *</label>
                        <input type="email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label>Phone Number *</label>
                        <input type="tel" name="phone" required>
                    </div>
                    <div class="form-group">
                        <label>Product Interest</label>
                        <select name="product">
                            <option value="VP300ESK Backpack Sprayer">VP300ESK Backpack Sprayer</option>
                            <option value="VP200ESK Handheld Sprayer">VP200ESK Handheld Sprayer</option>
                            <option value="Both Sprayers">Both Sprayers</option>
                            <option value="Accessories">Accessories Only</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Quantity</label>
                        <input type="number" name="quantity" min="1" value="1">
                    </div>
                    <div class="form-group">
                        <label>Additional Notes</label>
                        <textarea name="notes" placeholder="Tell us about your requirements..."></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary btn-lg" style="width: 100%;">
                        <i class="fas fa-paper-plane"></i> Submit Request
                    </button>
                </form>
            </div>

            <div class="success-message" id="successMessage">
                <i class="fas fa-check-circle"></i>
                <h3>Quote Request Received!</h3>
                <p>Thank you for your interest. A quote will be sent to you shortly. Our team will contact you within 24 hours.</p>
                <button class="btn btn-primary" onclick="closeQuoteModal()" style="margin-top: 20px;">Close</button>
            </div>
        </div>
    </div>

    <script>
        function openQuoteModal(product) {
            document.getElementById('productName').textContent = product;
            document.getElementById('quoteModal').classList.add('active');
            document.body.style.overflow = 'hidden';
            
            // Set the product in the select dropdown
            const select = document.querySelector('select[name="product"]');
            for (let option of select.options) {
                if (option.value.includes(product.split(' ')[0])) {
                    option.selected = true;
                    break;
                }
            }
        }

        function closeQuoteModal() {
            document.getElementById('quoteModal').classList.remove('active');
            document.body.style.overflow = '';
            // Reset form
            document.getElementById('quoteForm').style.display = 'block';
            document.getElementById('successMessage').classList.remove('active');
        }

        function submitQuote(e) {
            e.preventDefault();
            // In production, this would send to a backend
            // For now, show success message
            document.getElementById('quoteForm').style.display = 'none';
            document.getElementById('successMessage').classList.add('active');
        }

        // Close modal on overlay click
        document.getElementById('quoteModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeQuoteModal();
            }
        });

        // Close on escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeQuoteModal();
            }
        });
    </script>
</body>
</html>
