<?php
require_once __DIR__ . '/includes/config.php';
$isReseller = isReseller();
$resellerInfo = getResellerInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GermCure AIR160 Air Purifier | Hospital-Grade Air Disinfection</title>
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #1a7a5e; --primary-dark: #145c47; --secondary: #8dc63f; --dark: #0a1628; --gray-50: #f7f9fc; --gray-100: #eef2f7; --gray-200: #e2e8f0; --gray-600: #64748b; --white: #ffffff; --gradient-hero: linear-gradient(135deg, #0d4d4d 0%, #1a7a5e 50%, #2d6a4f 100%); --gradient-air: linear-gradient(135deg, #00b4d8 0%, #0077b6 50%, #023e8a 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; --radius-lg: 24px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        html { scroll-behavior: smooth; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 75px; }
        .nav { display: flex; align-items: center; gap: 16px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-100); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 14px 28px; border-radius: 12px; font-weight: 600; font-size: 15px; text-decoration: none; cursor: pointer; border: none; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-white { background: white; color: var(--primary); }
        .btn-lg { padding: 18px 36px; font-size: 16px; }
        .page-hero { background: var(--gradient-air); padding: 160px 0 100px; }
        .page-hero-content { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .page-hero-text { color: white; }
        .page-hero-text h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero-text p { font-size: 1.1rem; opacity: 0.9; margin-bottom: 24px; }
        .hero-badge { display: inline-block; background: rgba(255,255,255,0.2); padding: 8px 20px; border-radius: 50px; font-size: 14px; font-weight: 600; margin-bottom: 16px; }
        .page-hero-image { text-align: center; }
        .page-hero-image img { max-height: 400px; filter: drop-shadow(0 30px 60px rgba(0,0,0,0.3)); }
        .purify-badge { background: white; color: var(--primary); padding: 16px 24px; border-radius: 12px; display: inline-flex; align-items: center; gap: 12px; font-weight: 700; font-size: 1.2rem; box-shadow: var(--shadow-lg); }
        .purify-badge span { color: #00b4d8; font-size: 2rem; }
        .section { padding: 80px 0; }
        .section-alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 48px; }
        .section-badge { display: inline-block; background: rgba(26,122,94,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.2rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 700px; margin: 0 auto; }
        .tech-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 32px; }
        .tech-card { background: white; border-radius: var(--radius-lg); padding: 40px 32px; text-align: center; box-shadow: var(--shadow); position: relative; }
        .tech-number { position: absolute; top: -20px; left: 50%; transform: translateX(-50%); width: 50px; height: 50px; background: var(--gradient-air); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; font-weight: 800; }
        .tech-icon { width: 80px; height: 80px; background: rgba(0,180,216,0.1); border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 2rem; color: #0077b6; margin: 20px auto 24px; }
        .tech-card h3 { font-size: 1.2rem; margin-bottom: 12px; }
        .tech-card p { color: var(--gray-600); font-size: 14px; }
        .effective-grid { display: grid; grid-template-columns: repeat(5, 1fr); gap: 20px; }
        .effective-item { background: white; padding: 24px 16px; border-radius: var(--radius); text-align: center; box-shadow: var(--shadow); }
        .effective-item i { font-size: 2rem; color: #00b4d8; margin-bottom: 12px; display: block; }
        .effective-item p { font-size: 13px; font-weight: 500; }
        .specs-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .specs-image img { max-width: 300px; }
        .specs-table { background: white; border-radius: var(--radius-lg); overflow: hidden; box-shadow: var(--shadow); }
        .specs-table table { width: 100%; border-collapse: collapse; }
        .specs-table th, .specs-table td { padding: 16px 24px; text-align: left; border-bottom: 1px solid var(--gray-100); }
        .specs-table th { background: var(--gradient-air); color: white; font-weight: 600; }
        .specs-table tr:last-child td { border-bottom: none; }
        .specs-table td:first-child { font-weight: 500; color: var(--gray-600); }
        .apps-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .app-card { background: white; padding: 32px 24px; border-radius: var(--radius); text-align: center; box-shadow: var(--shadow); }
        .app-card i { font-size: 2.5rem; color: var(--primary); margin-bottom: 16px; display: block; }
        .app-card h4 { font-size: 1rem; margin-bottom: 8px; }
        .app-card p { color: var(--gray-600); font-size: 13px; }
        .benefits-list { display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; }
        .benefit-item { display: flex; align-items: flex-start; gap: 16px; background: white; padding: 20px; border-radius: var(--radius); box-shadow: var(--shadow); }
        .benefit-item i { color: var(--secondary); font-size: 1.2rem; flex-shrink: 0; }
        .benefit-item span { font-size: 14px; }
        .cta-section { background: var(--gradient-air); padding: 80px 0; text-align: center; color: white; }
        .cta-section h2 { font-size: 2rem; margin-bottom: 16px; }
        .cta-section p { opacity: 0.9; margin-bottom: 32px; max-width: 600px; margin: 0 auto 32px; }
        .warranty-badge { display: inline-flex; align-items: center; gap: 12px; background: rgba(255,255,255,0.2); padding: 16px 32px; border-radius: 12px; margin-bottom: 32px; }
        .warranty-badge i { font-size: 2rem; }
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; }
        .footer-icon-container img { height: 100px; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; }
        .footer-brand p { color: rgba(255,255,255,0.7); font-size: 14px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-contact p { color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge img { height: 28px; }
        .modal-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.7); z-index: 9999; align-items: center; justify-content: center; padding: 20px; }
        .modal-overlay.active { display: flex; }
        .modal { background: white; border-radius: var(--radius-lg); padding: 40px; max-width: 500px; width: 100%; max-height: 90vh; overflow-y: auto; position: relative; }
        .modal h3 { font-size: 1.5rem; margin-bottom: 8px; color: var(--dark); }
        .modal .subtitle { color: var(--gray-600); margin-bottom: 24px; }
        .modal-close { position: absolute; top: 20px; right: 20px; background: none; border: none; font-size: 24px; cursor: pointer; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea { width: 100%; padding: 14px; border: 2px solid var(--gray-200); border-radius: 10px; font-family: inherit; font-size: 13px; }
        .form-group input:focus, .form-group textarea:focus { outline: none; border-color: var(--primary); }
        .form-group textarea { resize: vertical; min-height: 100px; }
        .success-message { display: none; text-align: center; padding: 40px 20px; }
        .success-message.active { display: block; }
        .success-message i { font-size: 4rem; color: var(--secondary); margin-bottom: 20px; display: block; }
        @media (max-width: 1024px) { .page-hero-content, .specs-grid { grid-template-columns: 1fr; text-align: center; } .tech-grid { grid-template-columns: 1fr; } .effective-grid { grid-template-columns: repeat(3, 1fr); } .apps-grid { grid-template-columns: repeat(2, 1fr); } .benefits-list { grid-template-columns: 1fr; } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .page-hero h1 { font-size: 2rem; } .effective-grid { grid-template-columns: repeat(2, 1fr); } .apps-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" alt="GermCure"></a>
        <nav class="nav"><ul class="nav-links"><li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li><li><a href="/">Home</a></li><li><a href="/victory-sprayers.php">Victory Sprayers</a></li><li><a href="/products.php">Disinfection</a></li><li><a href="/air160.php" class="active">AIR160</a></li><li><a href="/contact.php">Contact</a></li></ul>
    </div></div></header>

    <section class="page-hero"><div class="container"><div class="page-hero-content">
        <div class="page-hero-text">
            <span class="hero-badge"><i class="fas fa-award"></i> Hospital-Grade Technology</span>
            <h1>GermCure AIR160</h1>
            <p>The same three air disinfection technologies used in hospital operating theatres. Genuinely eliminates viruses, bacteria, moulds and other pollutants.</p>
            <div class="purify-badge"><span>99.99%</span><div>Air Purification</div></div>
            <div style="margin-top: 32px; display: flex; gap: 16px; flex-wrap: wrap;">
                <button class="btn btn-white btn-lg" onclick="openQuoteModal()"><i class="fas fa-file-invoice"></i> Request Quote</button>
                <a href="/Documents/GermCure Air160.pdf" target="_blank" class="btn btn-outline btn-lg" style="border-color: white; color: white;"><i class="fas fa-download"></i> Brochure</a>
            </div>
        </div>
        <div class="page-hero-image"><img src="images/product-air160.png" alt="GermCure AIR160"></div>
    </div></div></section>

    <section class="section"><div class="container">
        <div class="section-header"><span class="section-badge">3-Stage Technology</span><h2>Fresh, Clean Air in 3 Steps</h2><p>Three high-performance air-purification methods uniquely combined into a single high-tech unit.</p></div>
        <div class="tech-grid">
            <div class="tech-card"><div class="tech-number">1</div><div class="tech-icon"><i class="fas fa-filter"></i></div><h3>3M HAFE Filtration</h3><p>Hospital-grade 3M High Air Flow Electrostatic Filter with antimicrobial coating removes airborne particles with twice the efficiency of standard filters.</p></div>
            <div class="tech-card"><div class="tech-number">2</div><div class="tech-icon"><i class="fas fa-sun"></i></div><h3>UV-C Radiation</h3><p>Philips UV-C lamp at 253.7nm destroys the DNA of viruses, bacteria, moulds, fungi and other micro-organisms, preventing reproduction.</p></div>
        </div>
    </div></section>

    <section class="section section-alt"><div class="container">
        <div class="section-header"><span class="section-badge">Comprehensive Protection</span><h2>Effective Against</h2><p>The AIR160 eliminates a wide range of airborne contaminants.</p></div>
        <div class="effective-grid">
            <div class="effective-item"><i class="fas fa-virus"></i><p>Viruses</p></div>
            <div class="effective-item"><i class="fas fa-bacterium"></i><p>Bacteria</p></div>
            <div class="effective-item"><i class="fas fa-seedling"></i><p>Moulds</p></div>
            <div class="effective-item"><i class="fas fa-bug"></i><p>Dust Mites</p></div>
            <div class="effective-item"><i class="fas fa-tree"></i><p>Pollen</p></div>
            <div class="effective-item"><i class="fas fa-smoking"></i><p>Smoke</p></div>
            <div class="effective-item"><i class="fas fa-wind"></i><p>Gases</p></div>
            <div class="effective-item"><i class="fas fa-spray-can"></i><p>VOCs</p></div>
            <div class="effective-item"><i class="fas fa-nose"></i><p>Odours</p></div>
            <div class="effective-item"><i class="fas fa-smog"></i><p>Formaldehyde</p></div>
        </div>
    </div></section>

    <section class="section"><div class="container">
        <div class="section-header"><span class="section-badge">Technical Data</span><h2>Specifications</h2></div>
        <div class="specs-grid">
            <div class="specs-image"><img src="images/product-air160.png" alt="AIR160"></div>
            <div class="specs-table"><table>
                <tr><th colspan="2">Technical Specifications</th></tr>
                <tr><td>Unit Power</td><td>65 Watt</td></tr>
                <tr><td>UV-C Lamp</td><td>Philips PL-L 60W/4P HO</td></tr>
                <tr><td>Filter</td><td>3M HAFE Electrostatic</td></tr>
                <tr><td>Dimensions</td><td>600 x 170 x 150 mm</td></tr>
                <tr><td>Runtime</td><td>24 hours/day</td></tr>
                <tr><td>Maintenance</td><td>Annual lamp & filter</td></tr>
                <tr><td>Warranty</td><td>2 Years</td></tr>
            </table></div>
        </div>
    </div></section>

    <section class="section section-alt"><div class="container">
        <div class="section-header"><span class="section-badge">Health Benefits</span><h2>Advantages of the AIR160</h2></div>
        <div class="benefits-list">
            <div class="benefit-item"><i class="fas fa-check-circle"></i><span>Disinfects and purifies the air up to 99.99%</span></div>
            <div class="benefit-item"><i class="fas fa-check-circle"></i><span>Eliminates micro-organisms present in the air</span></div>
            <div class="benefit-item"><i class="fas fa-check-circle"></i><span>Improves air quality and comfort</span></div>
            <div class="benefit-item"><i class="fas fa-check-circle"></i><span>Strengthens body resistance against diseases</span></div>
            <div class="benefit-item"><i class="fas fa-check-circle"></i><span>Reduces or eliminates inhalation allergies</span></div>
            <div class="benefit-item"><i class="fas fa-check-circle"></i><span>Prevents spread of airborne diseases</span></div>
        </div>
    </div></section>

    <section class="section"><div class="container">
        <div class="section-header"><span class="section-badge">Applications</span><h2>Perfect For</h2></div>
        <div class="apps-grid">
            <div class="app-card"><i class="fas fa-baby"></i><h4>Childcare</h4><p>Pre-schools & daycare</p></div>
            <div class="app-card"><i class="fas fa-user-nurse"></i><h4>Aged Care</h4><p>Care facilities</p></div>
            <div class="app-card"><i class="fas fa-hospital"></i><h4>Medical</h4><p>Clinics & waiting rooms</p></div>
            <div class="app-card"><i class="fas fa-building"></i><h4>Offices</h4><p>Commercial spaces</p></div>
            <div class="app-card"><i class="fas fa-utensils"></i><h4>Restaurants</h4><p>Hospitality venues</p></div>
            <div class="app-card"><i class="fas fa-store"></i><h4>Retail</h4><p>Shops & showrooms</p></div>
            <div class="app-card"><i class="fas fa-home"></i><h4>Homes</h4><p>Living spaces</p></div>
            <div class="app-card"><i class="fas fa-chalkboard-teacher"></i><h4>Schools</h4><p>Classrooms</p></div>
        </div>
    </div></section>

    <section class="cta-section"><div class="container">
        <div class="warranty-badge"><i class="fas fa-shield-alt"></i><div><strong>2 Year Warranty</strong><span>Manufacturer's Guarantee</span></div></div>
        <h2>Breathe Cleaner Air Today</h2>
        <p>Contact us for pricing and availability. Professional installation available.</p>
        <div style="display: flex; gap: 16px; justify-content: center; flex-wrap: wrap;">
            <button class="btn btn-white btn-lg" onclick="openQuoteModal()"><i class="fas fa-file-invoice"></i> Request Quote</button>
            <a href="/contact.php" class="btn btn-outline btn-lg" style="border-color: white; color: white;"><i class="fas fa-phone"></i> Contact Us</a>
        </div>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand"><div class="footer-icon-container"><img src="/images/logo-icon.png" alt="GermCure"></div><p class="footer-tagline">Disinfection & Hygiene</p><p>Professional infection protection.</p></div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/victory-sprayers.php">Victory Sprayers</a></li><li><a href="/products.php">Disinfection</a></li><li><a href="/air160.php">AIR160</a></li><li><a href="/contact.php">Contact</a></li></ul></div>
            <div><h4>Products</h4><ul class="footer-links"><li><a href="/products.php">Surface Disinfectant</a></li><li><a href="/products.php">Hand Sanitizer</a></li><li><a href="/air160.php">AIR160 Purifier</a></li></ul></div>
            <div class="footer-contact"><h4>Contact Us</h4><p><i class="fas fa-phone"></i> 082 805 0405</p><p><i class="fas fa-envelope"></i> cois@germcure.co.za</p></div>
        </div>
        <div class="footer-bottom"><p>&copy; <?= date('Y') ?> GermCure. All rights reserved.</p><a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a></div>
    </div></footer>

    <div class="modal-overlay" id="quoteModal"><div class="modal">
        <button class="modal-close" onclick="closeQuoteModal()">&times;</button>
        <div id="quoteForm"><h3>Request AIR160 Quote</h3><p class="subtitle">Get pricing for the GermCure AIR160</p>
            <form onsubmit="submitQuote(event)">
                <div class="form-group"><label>Name *</label><input type="text" required></div>
                <div class="form-group"><label>Company</label><input type="text"></div>
                <div class="form-group"><label>Email *</label><input type="email" required></div>
                <div class="form-group"><label>Phone *</label><input type="tel" required></div>
                <div class="form-group"><label>Quantity</label><input type="number" min="1" value="1"></div>
                <div class="form-group"><label>Notes</label><textarea placeholder="Application details..."></textarea></div>
                <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fas fa-paper-plane"></i> Submit</button>
            </form>
        </div>
        <div class="success-message" id="successMessage"><i class="fas fa-check-circle"></i><h3>Request Received!</h3><p>We'll contact you within 24 hours.</p><button class="btn btn-primary" onclick="closeQuoteModal()" style="margin-top: 20px;">Close</button></div>
    </div></div>

    <script>
        function openQuoteModal() { document.getElementById('quoteModal').classList.add('active'); document.body.style.overflow = 'hidden'; }
        function closeQuoteModal() { document.getElementById('quoteModal').classList.remove('active'); document.body.style.overflow = ''; document.getElementById('quoteForm').style.display = 'block'; document.getElementById('successMessage').classList.remove('active'); }
        function submitQuote(e) { e.preventDefault(); document.getElementById('quoteForm').style.display = 'none'; document.getElementById('successMessage').classList.add('active'); }
        document.getElementById('quoteModal').addEventListener('click', function(e) { if (e.target === this) closeQuoteModal(); });
    </script>
</body>
</html>
