<?php
require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/email_config.php';
require_once __DIR__ . '/includes/security.php';
$brand = 'germcure';
$emails = getBrandEmails($brand);
$isReseller = isReseller();
$resellerInfo = getResellerInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us | GermCure South Africa</title>
    <meta name="description" content="Contact GermCure for professional disinfection solutions. Get in touch with our sales, support, or technical teams.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1a7a5e;
            --primary-dark: #145c47;
            --secondary: #8dc63f;
            --accent: #0d6a6a;
            --dark: #0a1628;
            --gray-50: #f7f9fc;
            --gray-100: #eef2f7;
            --gray-200: #e2e8f0;
            --gray-600: #64748b;
            --white: #ffffff;
            --gradient-hero: linear-gradient(135deg, #0d4d4d 0%, #1a7a5e 50%, #2d6a4f 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.12);
            --radius: 16px;
            --radius-lg: 24px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        html { scroll-behavior: smooth; }

        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo { display: flex; align-items: center; text-decoration: none; gap: 12px; }
        .logo img { height: 75px; transition: transform 0.3s; }
        .nav { display: flex; align-items: center; gap: 16px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; transition: all 0.2s; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-100); }
        .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 10px 18px; border-radius: 12px; font-weight: 600; font-size: 13px; text-decoration: none; transition: all 0.3s; cursor: pointer; border: none; }
        .btn-primary { background: var(--gradient-hero); color: white; box-shadow: 0 4px 20px rgba(26,122,94,0.3); }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 30px rgba(26,122,94,0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-lg { padding: 18px 36px; font-size: 16px; }

        /* Page Hero */
        .page-hero {
            background: var(--gradient-hero);
            padding: 160px 0 100px;
            text-align: center;
            color: white;
        }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }

        /* Contact Section */
        .contact-section { padding: 80px 0; }
        .contact-grid {
            display: grid;
            grid-template-columns: 1fr 1.5fr;
            gap: 60px;
        }

        /* Contact Info Cards */
        .contact-info { display: flex; flex-direction: column; gap: 24px; }
        .info-card {
            background: var(--gray-50);
            border-radius: var(--radius);
            padding: 32px;
        }
        .info-card-icon {
            width: 50px;
            height: 50px;
            background: var(--gradient-hero);
            color: white;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            margin-bottom: 16px;
        }
        .info-card h3 { font-size: 1.2rem; margin-bottom: 12px; }
        .info-card p { color: var(--gray-600); font-size: 14px; margin-bottom: 8px; }
        .info-card a { color: var(--primary); text-decoration: none; font-weight: 500; }
        .info-card a:hover { text-decoration: underline; }

        /* Contact Form */
        .contact-form {
            background: white;
            border-radius: var(--radius-lg);
            padding: 48px;
            box-shadow: var(--shadow-lg);
        }
        .contact-form h2 { font-size: 1.8rem; margin-bottom: 8px; }
        .contact-form .subtitle { color: var(--gray-600); margin-bottom: 32px; }
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .form-group { margin-bottom: 24px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select {
            width: 100%;
            padding: 14px 16px;
            border: 2px solid var(--gray-200);
            border-radius: 10px;
            font-family: inherit;
            font-size: 13px;
            transition: border-color 0.2s;
        }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus {
            outline: none;
            border-color: var(--primary);
        }
        .form-group textarea { resize: vertical; min-height: 120px; }

        .success-message {
            display: none;
            text-align: center;
            padding: 60px 20px;
        }
        .success-message.active { display: block; }
        .success-message i { font-size: 5rem; color: var(--secondary); margin-bottom: 24px; }
        .success-message h3 { font-size: 1.8rem; margin-bottom: 12px; }
        .success-message p { color: var(--gray-600); max-width: 400px; margin: 0 auto; }

        /* Departments Grid */
        .departments { padding: 80px 0; background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(26,122,94,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .departments-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 24px;
        }
        .department-card {
            background: white;
            border-radius: var(--radius);
            padding: 32px 24px;
            text-align: center;
            box-shadow: var(--shadow);
            transition: all 0.3s;
        }
        .department-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-lg);
        }
        .department-card i {
            font-size: 2.5rem;
            color: var(--primary);
            margin-bottom: 16px;
        }
        .department-card h3 { font-size: 1.1rem; margin-bottom: 8px; }
        .department-card p { color: var(--gray-600); font-size: 13px; margin-bottom: 16px; }
        .department-card a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
        }
        .department-card a:hover { text-decoration: underline; }

        /* Footer */
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { font-size: 16px; margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: var(--secondary); }
        .footer-contact p { color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge img { height: 28px; display: block; }

        @media (max-width: 1024px) {
            .contact-grid { grid-template-columns: 1fr; }
            .departments-grid { grid-template-columns: repeat(2, 1fr); }
            .footer-grid { grid-template-columns: 1fr 1fr; }
        }
        @media (max-width: 768px) {
            .page-hero h1 { font-size: 2rem; }
            .form-row { grid-template-columns: 1fr; }
            .departments-grid { grid-template-columns: 1fr; }
            .nav-links { display: none; }
            .footer-grid { grid-template-columns: 1fr; }
        }

        .mobile-menu-btn { display: none; background: none; border: none; font-size: 24px; color: var(--primary); cursor: pointer; }
        @media (max-width: 768px) { .mobile-menu-btn { display: block; } }
    </style>
</head>
<body>
    <?php if ($isReseller): ?>
    </div>
    <?php endif; ?>

    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo">
                    <img src="/images/logo-long.png" alt="GermCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/">Home</a></li>
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/contact.php" class="active">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                        <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
                    <?php else: ?>
                        <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
                    <?php endif; ?>
                    <button class="mobile-menu-btn"><i class="fas fa-bars"></i></button>
                </nav>
            </div>
        </div>
    </header>

    <section class="page-hero">
        <div class="container">
            <h1>Get In Touch</h1>
            <p>Have questions about our products or services? We're here to help. Reach out to our team and we'll respond within 24 hours.</p>
        </div>
    </section>

    <section class="contact-section">
        <div class="container">
            <div class="contact-grid">
                <div class="contact-info">
                    <div class="info-card">
                        <div class="info-card-icon"><i class="fas fa-user"></i></div>
                        <h3>Francois Viljoen</h3>
                        <p><i class="fas fa-envelope" style="width:16px;color:var(--primary);"></i> <a href="#" class="protected-email" data-u="cois" data-d="germcure.co.za"></a></p>
                        <p><i class="fas fa-phone" style="width:16px;color:var(--primary);"></i> <a href="#" class="protected-phone" data-p="27828050405" data-d="082 805 0405"></a></p>
                    </div>
                    <div class="info-card">
                        <div class="info-card-icon"><i class="fas fa-user"></i></div>
                        <h3>Mariaan Viljoen</h3>
                        <p><i class="fas fa-envelope" style="width:16px;color:var(--primary);"></i> <a href="#" class="protected-email" data-u="mariaan" data-d="germcure.co.za"></a></p>
                        <p><i class="fas fa-phone" style="width:16px;color:var(--primary);"></i> <a href="#" class="protected-phone" data-p="27829077494" data-d="082 907 7494"></a></p>
                    </div>
                    <div class="info-card">
                        <div class="info-card-icon"><i class="fas fa-map-marker-alt"></i></div>
                        <h3>Visit Us</h3>
                        <p>Pretoria, Gauteng<br>South Africa</p>
                    </div>
                    <div class="info-card">
                        <div class="info-card-icon"><i class="fab fa-whatsapp"></i></div>
                        <h3>WhatsApp</h3>
                        <p>Quick responses</p>
                        <a href="https://wa.me/27828050405">Chat on WhatsApp</a>
                    </div>
                </div>

                <div class="contact-form">
                    <div id="formContent">
                        <h2>Send Us a Message</h2>
                        <p class="subtitle">Fill out the form below and we'll get back to you as soon as possible.</p>
                        <form id="contactForm" onsubmit="submitContactForm(event)" method="post">
                            <?= outputHoneypot() ?>
                            <?= outputTimestamp() ?>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>First Name *</label>
                                    <input type="text" name="first_name" required>
                                </div>
                                <div class="form-group">
                                    <label>Last Name *</label>
                                    <input type="text" name="last_name" required>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>Email Address *</label>
                                    <input type="email" name="email" required>
                                </div>
                                <div class="form-group">
                                    <label>Phone Number</label>
                                    <input type="tel" name="phone">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Company Name</label>
                                <input type="text" name="company">
                            </div>
                            <div class="form-group">
                                <label>Subject *</label>
                                <select name="subject" required>
                                    <option value="">Select a subject...</option>
                                    <option value="Product Inquiry">Product Inquiry</option>
                                    <option value="Quote Request">Quote Request</option>
                                    <option value="Technical Support">Technical Support</option>
                                    <option value="Reseller Application">Reseller Application</option>
                                    <option value="General Inquiry">General Inquiry</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Message *</label>
                                <textarea name="message" required placeholder="How can we help you?"></textarea>
                            </div>
                            <?= outputMathCaptcha("math_answer") ?>
                            <button type="submit" class="btn btn-primary btn-lg" style="width: 100%;">
                                <i class="fas fa-paper-plane"></i> Send Message
                            </button>
                        </form>
                    </div>
                    <div class="success-message" id="successMessage">
                        <i class="fas fa-check-circle"></i>
                        <h3>Message Sent!</h3>
                        <p>Thank you for contacting us. We'll respond to your inquiry within 24 hours.</p>
                        <button class="btn btn-primary" onclick="resetForm()" style="margin-top: 24px;">Send Another Message</button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="departments">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Our Team</span>
                <h2>Contact Our Team</h2>
                <p>Get in touch with our team directly for faster assistance.</p>
            </div>
            <div class="departments-grid" style="grid-template-columns: repeat(2, 1fr); max-width: 600px; margin: 0 auto;">
                <div class="department-card">
                    <i class="fas fa-user-tie"></i>
                    <h3>Francois Viljoen</h3>
                    <p>Sales, quotes & general enquiries</p>
                    <a href="#" class="protected-email" data-u="cois" data-d="germcure.co.za"></a><br>
                    <a href="#" class="protected-phone" data-p="27828050405" data-d="082 805 0405"></a>
                </div>
                <div class="department-card">
                    <i class="fas fa-user-tie"></i>
                    <h3>Mariaan Viljoen</h3>
                    <p>Sales, quotes & general enquiries</p>
                    <a href="#" class="protected-email" data-u="mariaan" data-d="germcure.co.za"></a><br>
                    <a href="#" class="protected-phone" data-p="27829077494" data-d="082 907 7494"></a>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-icon-container">
                        <img src="/images/logo-icon.png" alt="GermCure">
                    </div>
                    <p class="footer-tagline">Disinfection &amp; Hygiene</p>
                    <p>Professional infection<br>protection since 2012.</p>
                    <div class="c-virus-banner" style="margin-top: 16px;">
                        <img src="images/c-virus-logos.jpg" alt="COVID-19 Response Partners" style="height: 50px; opacity: 0.8;">
                    </div>
                    <a href="https://www.trustpilot.com/review/germcure.co.za" target="_blank" class="trustpilot-link" style="display: inline-flex; align-items: center; gap: 8px; margin-top: 20px; padding: 10px 16px; background: rgba(255,255,255,0.1); border-radius: 8px; color: white; text-decoration: none; font-size: 13px; transition: all 0.3s;">
                        <i class="fas fa-star" style="color: #00b67a;"></i>
                        <span>Review us on Trustpilot</span>
                    </a>
                </div>
                <div>
                    <h4>Quick Links</h4>
                    <ul class="footer-links">
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/media.php">Media</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="/victory-sprayers.php#backpack">VP300ESK Backpack</a></li>
                        <li><a href="/victory-sprayers.php#handheld">VP200ESK Handheld</a></li>
                        <li><a href="/products.php">Disinfectants</a></li>
                    </ul>
                </div>
                <div class="footer-contact">
                    <h4>Contact Us</h4>
                    <p><i class="fas fa-user"></i> Francois: <a href="#" class="protected-phone" data-p="27828050405" data-d="082 805 0405" style="color:rgba(255,255,255,0.7);"></a></p>
                    <p><i class="fas fa-envelope"></i> <a href="#" class="protected-email" data-u="cois" data-d="germcure.co.za" style="color:rgba(255,255,255,0.7);"></a></p>
                    <p><i class="fas fa-user"></i> Mariaan: <a href="#" class="protected-phone" data-p="27829077494" data-d="082 907 7494" style="color:rgba(255,255,255,0.7);"></a></p>
                    <p><i class="fas fa-envelope"></i> <a href="#" class="protected-email" data-u="mariaan" data-d="germcure.co.za" style="color:rgba(255,255,255,0.7);"></a></p>
                    <p><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> GermCure. All rights reserved.</p>
                <a href="https://omnicure.co.za/" class="multicure-badge">
                    <span>Part of</span>
                    <div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
                </a>
            </div>
        </div>
    </footer>

    <script>
        function submitContactForm(e) {
            e.preventDefault();
            var form = document.getElementById('contactForm');
            var formData = new FormData(form);
            var submitBtn = form.querySelector('button[type=submit]');
            var originalText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
            submitBtn.disabled = true;
            
            fetch('send-contact.php', {
                method: 'POST',
                body: formData
            })
            .then(function(response) { return response.json(); })
            .then(function(data) {
                if (data.success) {
                    document.getElementById('formContent').style.display = 'none';
                    document.getElementById('successMessage').classList.add('active');
                } else {
                    alert(data.message || 'An error occurred. Please try again.');
                    submitBtn.innerHTML = originalText;
                    submitBtn.disabled = false;
                }
            })
            .catch(function(error) {
                console.error('Error:', error);
                alert('An error occurred. Please try again.');
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            });
        }
        function resetForm() {
            document.getElementById('formContent').style.display = 'block';
            document.getElementById('successMessage').classList.remove('active');
            document.querySelector('form').reset();
        }
        // Protect contacts from bots
        document.querySelectorAll('.protected-email').forEach(function(el) {
            var u = el.getAttribute('data-u');
            var d = el.getAttribute('data-d');
            var email = u + '@' + d;
            el.href = 'mai' + 'lto:' + email;
            el.textContent = email;
        });
        document.querySelectorAll('.protected-phone').forEach(function(el) {
            var p = el.getAttribute('data-p');
            var d = el.getAttribute('data-d');
            el.href = 't' + 'el:+' + p;
            el.textContent = d;
        });
    </script>
</body>
</html>
