<?php
require_once __DIR__ . '/includes/config.php';
$isReseller = isReseller();
$resellerInfo = getResellerInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Media Coverage - GermCure</title>
    <meta name="description" content="GermCure in the media - press coverage and news features.">
    <link rel="icon" type="image/png" href="/images/logo-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1a7a5e;
            --primary-dark: #145c47;
            --primary-light: #2d9d7a;
            --secondary: #8dc63f;
            --accent: #0d6a6a;
            --dark: #0a1628;
            --gray-50: #f7f9fc;
            --gray-100: #eef2f7;
            --gray-200: #e2e8f0;
            --gray-600: #64748b;
            --white: #ffffff;
            --gradient-hero: linear-gradient(135deg, #0d4d4d 0%, #1a7a5e 50%, #2d6a4f 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.12);
            --radius: 16px;
            --radius-lg: 24px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }

        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo { display: flex; align-items: center; text-decoration: none; gap: 12px; }
        .logo img { height: 75px; transition: transform 0.3s; }
        .logo:hover img { transform: scale(1.05); }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; transition: all 0.2s; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-100); }
        .multicure-link { background: var(--gray-100); color: var(--gray-600) !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }

        .btn { display: inline-flex; align-items: center; justify-content: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; font-size: 13px; text-decoration: none; transition: all 0.3s; cursor: pointer; border: none; }
        .btn-primary { background: var(--gradient-hero); color: white; box-shadow: 0 4px 20px rgba(26,122,94,0.3); }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 30px rgba(26,122,94,0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }

        .page-hero { background: var(--gradient-hero); padding: 140px 0 80px; color: white; text-align: center; }
        .page-hero h1 { font-size: 2.5rem; margin-bottom: 16px; }
        .page-hero p { font-size: 1.1rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }

        .media-section { padding: 80px 0; background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(26,122,94,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2rem; font-weight: 700; margin-bottom: 16px; }

        .media-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 32px; }
        .media-card { background: white; border-radius: var(--radius-lg); padding: 40px; text-align: center; box-shadow: var(--shadow); transition: all 0.3s; }
        .media-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); }
        .media-card img { height: 100px; object-fit: contain; margin-bottom: 24px; }
        .media-card h3 { font-size: 1.2rem; margin-bottom: 12px; }
        .media-card p { color: var(--gray-600); font-size: 14px; }

        .footer { background: var(--dark); color: white; padding: 40px 0; text-align: center; }
        .footer p { color: rgba(255,255,255,0.7); font-size: 14px; }
        .footer a { color: var(--secondary); text-decoration: none; }

        .mobile-menu-btn { display: none; background: none; border: none; font-size: 24px; color: var(--primary); cursor: pointer; }
        @media (max-width: 768px) {
            .mobile-menu-btn { display: block; }
            .nav-links { display: none; }
            .logo img { height: 55px; }
            .page-hero h1 { font-size: 2rem; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo">
                    <img src="/images/logo-long.png" alt="GermCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/">Home</a></li>
                        <li><a href="/victory-sprayers.php">Victory Sprayers</a></li>
                        <li><a href="/products.php">Disinfection</a></li>
                        <li><a href="/about.php">Our Story</a></li>
                        <li><a href="/media.php" class="active">Media</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                    <?php else: ?>
                    <?php endif; ?>
                    <button class="mobile-menu-btn"><i class="fas fa-bars"></i></button>
                </nav>
            </div>
        </div>
    </header>

    <section class="page-hero">
        <div class="container">
            <h1>Media Coverage</h1>
            <p>GermCure has been featured in various media outlets for our innovative disinfection solutions.</p>
        </div>
    </section>

    <section class="media-section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">As Seen On</span>
                <h2>Press Features</h2>
            </div>
            <div class="media-grid">
                <div class="media-card">
                    <img src="images/jacaranda-logo.jpg" alt="Jacaranda FM">
                    <h3>Jacaranda FM</h3>
                    <p>Featured on Jacaranda FM discussing the importance of professional disinfection in public spaces.</p>
                </div>
                <div class="media-card">
                    <img src="images/ontbytsake-logo.png" alt="Ontbytsake">
                    <h3>Ontbytsake</h3>
                    <p>GermCure's innovative electrostatic spraying technology highlighted on Ontbytsake morning show.</p>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer" style="background: #0a1628; color: white; padding: 80px 0 32px;">
        <div class="container">
            <div style="display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px;">
                <div class="footer-brand">
                    <div style="width: 120px; height: 120px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3);">
                        <img src="/images/logo-icon.png" alt="GermCure" style="height: 80px;">
                    </div>
                    <p style="color: #8dc63f; font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px;">Disinfection &amp; Hygiene</p>
                    <p style="color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px;">Professional infection<br>protection since 2012.</p>
                    <div style="margin-top: 16px;">
                        <img src="images/c-virus-logos.jpg" alt="COVID-19 Response Partners" style="height: 50px; opacity: 0.8;">
                    </div>
                    <a href="https://www.trustpilot.com/review/germcure.co.za" target="_blank" style="display: inline-flex; align-items: center; gap: 8px; margin-top: 20px; padding: 10px 16px; background: rgba(255,255,255,0.1); border-radius: 8px; color: white; text-decoration: none; font-size: 13px; transition: all 0.3s;">
                        <i class="fas fa-star" style="color: #00b67a;"></i>
                        <span>Review us on Trustpilot</span>
                    </a>
                </div>
                <div>
                    <h4 style="font-size: 16px; margin-bottom: 20px;">Quick Links</h4>
                    <ul style="list-style: none;">
                        <li><a href="/victory-sprayers.php" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">Victory Sprayers</a></li>
                        <li><a href="/products.php" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">Products</a></li>
                        <li><a href="/about.php" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">Our Story</a></li>
                        <li><a href="/media.php" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">Media</a></li>
                        <li><a href="/contact.php" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4 style="font-size: 16px; margin-bottom: 20px;">Products</h4>
                    <ul style="list-style: none;">
                        <li><a href="/victory-sprayers.php#backpack" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">VP300ESK Backpack</a></li>
                        <li><a href="/victory-sprayers.php#handheld" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">VP200ESK Handheld</a></li>
                        <li><a href="/products.php" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">Disinfectants</a></li>
                        <li><a href="/products.php#natural" style="color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0;">Natural Solutions</a></li>
                    </ul>
                </div>
                <div>
                    <h4 style="font-size: 16px; margin-bottom: 20px;">Contact Us</h4>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px;"><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px;"><i class="fas fa-envelope"></i> info@germcure.co.za</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; display: flex; align-items: center; gap: 10px; margin-bottom: 12px;"><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div style="border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center;">
                <p style="color: rgba(255,255,255,0.5); font-size: 13px;">&copy; <?= date('Y') ?> GermCure. All rights reserved.</p>
                <a href="https://omnicure.co.za/" style="display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none;">
                    <span>Part of</span>
                    <div style="background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px;"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network" style="height: 28px; display: block;"></div>
                </a>
            </div>
        </div>
    </footer>
</body>
</html>
