<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - HopeCure | Restoring Hope. Healing Lives.</title>
    <meta name="description" content="Learn about HopeCure's mission to restore hope, heal lives, and advance God's Kingdom through humanitarian aid across Africa.">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #0ea5e9; --primary-dark: #0284c7; --accent: #7c3aed; --gold: #f59e0b; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-600: #4b5563; --white: #fff; --gradient-hope: linear-gradient(135deg, #0ea5e9 0%, #7c3aed 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo-text { font-size: 1.5rem; font-weight: 700; color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 8px; }
        .logo-text i { color: var(--gold); }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav-links { display: flex; gap: 4px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; font-size: 13px; }
        .btn-gold { background: var(--gold); color: var(--dark); }
        .page-hero { background: var(--gradient-hope); padding: 160px 0 80px; color: white; text-align: center; }
        .page-hero h1 { font-size: 3rem; margin-bottom: 16px; }
        .page-hero p { opacity: 0.9; font-size: 1.2rem; }
        .content { padding: 80px 0; }
        .content-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; margin-bottom: 60px; }
        .content h2 { font-size: 2rem; margin-bottom: 20px; color: var(--dark); }
        .content p { color: var(--gray-600); margin-bottom: 16px; }
        .values { padding: 80px 0; background: var(--gray-50); }
        .values-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 32px; }
        .value-card { background: white; padding: 40px 32px; border-radius: var(--radius); text-align: center; box-shadow: var(--shadow); }
        .value-icon { width: 70px; height: 70px; background: var(--gradient-hope); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 28px; margin: 0 auto 20px; }
        .value-card h3 { margin-bottom: 12px; }
        .value-card p { color: var(--gray-600); font-size: 14px; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 768px) { .content-grid { grid-template-columns: 1fr; } .values-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-bottom { flex-direction: column; gap: 16px; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" alt="HopeCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/">Home</a></li>
                <li><a href="/about.php">About</a></li>
                <li><a href="/contact.php">Contact</a></li>
            </ul>
            <a href="/#donate" class="btn btn-gold"><i class="fas fa-heart"></i> Donate</a>
        </nav>
    </div></div></header>

    <section class="page-hero">
        <div class="container">
            <h1>About HopeCure</h1>
            <p>Our story, mission, and the faith that drives us forward.</p>
        </div>
    </section>

    <section class="content"><div class="container">
        <div class="content-grid">
            <div>
                <h2>Our Story</h2>
                <p>HopeCure was born from a deep conviction that faith without works is incomplete. Founded by believers who witnessed firsthand the struggles of vulnerable communities across Africa, we set out to be the hands and feet of Christ.</p>
                <p>What started as small acts of kindness—sharing meals, providing clothing, offering prayer—has grown into a movement of hope that spans communities and transforms lives.</p>
            </div>
            <div style="text-align: center;">
                <i class="fas fa-hands-holding-heart" style="font-size: 8rem; color: var(--primary); opacity: 0.2;"></i>
            </div>
        </div>
        <div class="content-grid">
            <div style="text-align: center;">
                <i class="fas fa-cross" style="font-size: 8rem; color: var(--gold); opacity: 0.2;"></i>
            </div>
            <div>
                <h2>Our Mission</h2>
                <p><strong>Restoring Hope:</strong> We believe that every person deserves hope. Through counseling, spiritual care, and community support, we help people find their way back to wholeness.</p>
                <p><strong>Healing Lives:</strong> Physical needs are just as important as spiritual ones. We provide healthcare, nutrition, and support services to those who need it most.</p>
                <p><strong>Advancing God's Kingdom:</strong> Everything we do is rooted in our faith. We share the Gospel through love in action, showing Christ's compassion to a hurting world.</p>
            </div>
        </div>
    </div></section>

    <section class="values"><div class="container">
        <div style="text-align: center; margin-bottom: 60px;">
            <h2 style="font-size: 2.5rem;">Our Core Values</h2>
        </div>
        <div class="values-grid">
            <div class="value-card">
                <div class="value-icon"><i class="fas fa-bible"></i></div>
                <h3>Faith-Centered</h3>
                <p>Everything we do is grounded in Scripture and guided by prayer.</p>
            </div>
            <div class="value-card">
                <div class="value-icon"><i class="fas fa-heart"></i></div>
                <h3>Compassionate</h3>
                <p>We see the dignity in every person and serve with unconditional love.</p>
            </div>
            <div class="value-card">
                <div class="value-icon"><i class="fas fa-handshake"></i></div>
                <h3>Integrity</h3>
                <p>We are transparent, accountable, and honest in all our dealings.</p>
            </div>
        </div>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> HopeCure. All Glory to God.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge">
                <span>Part of</span>
                <div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
            </a>
        </div>
    </div></footer>
</body>
</html>
