<?php 
require_once __DIR__ . '/includes/config.php'; 
require_once __DIR__ . '/includes/email_config.php';
require_once __DIR__ . '/includes/security.php';
$isReseller = isReseller(); 
$brand = 'hopecure';
$emails = getBrandEmails($brand);

$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'name' => htmlspecialchars($_POST['name'] ?? ''),
        'email' => filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL),
        'phone' => htmlspecialchars($_POST['phone'] ?? ''),
        'subject' => htmlspecialchars($_POST['subject'] ?? ''),
        'message' => htmlspecialchars($_POST['message'] ?? ''),
    ];
    
    if (empty($data['name']) || empty($data['email']) || empty($data['message'])) {
        $error = 'Please fill in all required fields.';
    } elseif (!filter_var($data['email'], FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } else {
        if (sendContactEmail($brand, $data)) {
            $success = true;
        } else {
            $error = 'Failed to send message. Please try again or contact us directly.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - HopeCure NPC | Get in Touch</title>
    <meta name="description" content="Contact HopeCure NPC for inquiries about donations, volunteering, or partnership opportunities.">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #0ea5e9; --accent: #7c3aed; --gold: #f59e0b; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-600: #4b5563; --white: #fff; --gradient-hope: linear-gradient(135deg, #0ea5e9 0%, #7c3aed 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --radius: 16px; --success: #10b981; --error: #ef4444; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo-text { font-size: 1.5rem; font-weight: 700; color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 8px; }
        .logo-text i { color: var(--gold); }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav-links { display: flex; gap: 4px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; font-size: 13px; border: none; cursor: pointer; transition: all 0.3s; }
        .btn-gold { background: var(--gold); color: var(--dark); }
        .btn-primary { background: var(--gradient-hope); color: white; }
        .page-hero { background: var(--gradient-hope); padding: 160px 0 80px; color: white; text-align: center; }
        .page-hero h1 { font-size: 3rem; margin-bottom: 16px; }
        .page-hero p { opacity: 0.9; font-size: 1.2rem; }
        .contact-section { padding: 80px 0; }
        .contact-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; }
        .contact-info h2 { font-size: 2rem; margin-bottom: 20px; }
        .contact-info > p { color: var(--gray-600); margin-bottom: 32px; }
        .contact-item { display: flex; align-items: flex-start; gap: 16px; margin-bottom: 24px; }
        .contact-icon { width: 50px; height: 50px; background: var(--gradient-hope); color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 20px; flex-shrink: 0; }
        .contact-item h4 { margin-bottom: 4px; }
        .contact-item p { color: var(--gray-600); font-size: 14px; margin: 0; }
        .contact-item a { color: var(--primary); text-decoration: none; font-size: 14px; }
        .contact-item a:hover { text-decoration: underline; }
        .email-list { margin-top: 32px; padding: 24px; background: var(--gray-50); border-radius: var(--radius); }
        .email-list h4 { margin-bottom: 16px; color: var(--dark); }
        .email-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 12px; }
        .email-item { display: flex; align-items: center; gap: 8px; font-size: 13px; }
        .email-item i { color: var(--primary); width: 16px; }
        .email-item a { color: var(--gray-600); text-decoration: none; }
        .email-item a:hover { color: var(--primary); }
        .contact-form { background: var(--gray-50); padding: 40px; border-radius: var(--radius); }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 600; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 14px; border: 2px solid var(--gray-100); border-radius: 10px; font-family: inherit; font-size: 14px; background: white; }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { outline: none; border-color: var(--primary); }
        .form-group textarea { min-height: 150px; resize: vertical; }
        .alert { padding: 16px; border-radius: 10px; margin-bottom: 20px; font-size: 14px; }
        .alert-success { background: #d1fae5; color: #065f46; }
        .alert-error { background: #fee2e2; color: #991b1b; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 768px) { .contact-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-bottom { flex-direction: column; gap: 16px; } .email-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/hopecure/" class="logo"><img src="/hopecure/images/logo-long.png" alt="HopeCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/hopecure/">Home</a></li>
                <li><a href="/hopecure/about.php">About</a></li>
                <li><a href="/hopecure/contact.php">Contact</a></li>
            </ul>
            <a href="/hopecure/#donate" class="btn btn-gold"><i class="fas fa-heart"></i> Donate</a>
        </nav>
    </div></div></header>

    <section class="page-hero">
        <div class="container">
            <h1>Contact Us</h1>
            <p>We'd love to hear from you. Reach out with questions, prayer requests, or partnership inquiries.</p>
        </div>
    </section>

    <section class="contact-section"><div class="container">
        <div class="contact-grid">
            <div class="contact-info">
                <h2>Get in Touch</h2>
                <p>Whether you're interested in volunteering, donating, or partnering with us, we're here to help you get involved in our mission.</p>
                
                <div class="contact-item">
                    <div class="contact-icon"><i class="fas fa-envelope"></i></div>
                    <div>
                        <h4>General Enquiries</h4>
                        <a href="mailto:<?= $emails['info'] ?>"><?= $emails['info'] ?></a>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon"><i class="fas fa-file-invoice"></i></div>
                    <div>
                        <h4>Quotes & Partnerships</h4>
                        <a href="mailto:<?= $emails['quotes'] ?>"><?= $emails['quotes'] ?></a>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon"><i class="fas fa-map-marker-alt"></i></div>
                    <div>
                        <h4>Location</h4>
                        <p>South Africa</p>
                    </div>
                </div>
                
                <div class="email-list">
                    <h4><i class="fas fa-at"></i> All Email Contacts</h4>
                    <div class="email-grid">
                        <?php foreach ($emails as $key => $email): ?>
                        <div class="email-item">
                            <i class="fas fa-envelope"></i>
                            <a href="mailto:<?= $email ?>"><?= $email ?></a>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
            <div class="contact-form">
                <?php if ($success): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> Thank you for your message! We'll get back to you soon.
                    </div>
                <?php elseif ($error): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i> <?= $error ?>
                    </div>
                <?php endif; ?>
                
                <form method="post" onsubmit="submitContactForm(event); return false;">
                            <?= outputHoneypot() ?>
                            <?= outputTimestamp() ?>
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input type="text" id="name" name="name" required>
                    </div>
                    <div class="form-group">
                        <label for="email">Email Address *</label>
                        <input type="email" id="email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input type="tel" id="phone" name="phone">
                    </div>
                    <div class="form-group">
                        <label for="subject">Subject</label>
                        <select id="subject" name="subject">
                            <option value="General Enquiry">General Enquiry</option>
                            <option value="Donation">Donation Enquiry</option>
                            <option value="Volunteer">Volunteering</option>
                            <option value="Partnership">Partnership</option>
                            <option value="Prayer Request">Prayer Request</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="message">Message *</label>
                        <textarea id="message" name="message" required></textarea>
                    </div>
                    <?= outputMathCaptcha("math_answer") ?>
                            <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fas fa-paper-plane"></i> Send Message</button>
                </form>
            </div>
        </div>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> HopeCure NPC. All Glory to God.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge">
                <span>Part of</span>
                <div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
            </a>
        </div>
    </div></footer>
</body>
</html>
