<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HopeCure NPC - Restoring Hope. Healing Lives. Advancing God's Kingdom.</title>
    <meta name="description" content="HopeCure NPC brings lasting hope to broken communities through the Gospel, church planting, education, and community upliftment in South Africa.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #0ea5e9; --primary-dark: #0284c7; --primary-light: #38bdf8; --accent: #7c3aed; --gold: #f59e0b; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-200: #e5e7eb; --gray-600: #4b5563; --white: #fff; --gradient-hope: linear-gradient(135deg, #0ea5e9 0%, #7c3aed 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo-text { font-size: 1.5rem; font-weight: 700; color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 8px; }
        .logo-text i { color: var(--gold); }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav-links { display: flex; gap: 4px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; transition: all 0.2s; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); color: var(--gray-600) !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 13px; transition: all 0.3s; }
        .btn-primary { background: var(--gradient-hope); color: white; }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(14, 165, 233, 0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-white { background: white; color: var(--primary); }
        .btn-gold { background: var(--gold); color: var(--dark); }
        .btn-lg { padding: 14px 28px; font-size: 15px; }

        .hero { background: var(--gradient-hope); padding: 180px 0 120px; color: white; position: relative; overflow: hidden; }
        .hero::before { content: ''; position: absolute; top: -50%; right: -20%; width: 900px; height: 900px; background: radial-gradient(circle, rgba(245,158,11,0.25) 0%, transparent 70%); border-radius: 50%; }
        .hero::after { content: ''; position: absolute; bottom: -30%; left: -10%; width: 700px; height: 700px; background: radial-gradient(circle, rgba(255,255,255,0.15) 0%, transparent 70%); border-radius: 50%; }
        .hero .container { position: relative; z-index: 1; display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .hero-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.2); padding: 10px 20px; border-radius: 50px; font-size: 14px; margin-bottom: 24px; backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.2); }
        .hero h1 { font-size: 3.2rem; font-weight: 800; margin-bottom: 24px; line-height: 1.15; text-shadow: 0 2px 20px rgba(0,0,0,0.2); }
        .hero h1 span { color: var(--gold); }
        .hero p { font-size: 1.15rem; opacity: 0.95; margin-bottom: 36px; line-height: 1.8; }
        .hero-buttons { display: flex; gap: 16px; flex-wrap: wrap; }
        .hero-image { text-align: center; }
        .hero-image img { max-width: 500px; width: 100%; filter: drop-shadow(0 25px 50px rgba(0,0,0,0.4)); animation: heroFloat 4s ease-in-out infinite; }
        @keyframes heroFloat { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-20px); } }

        .vision-mission { padding: 80px 0; background: var(--gray-50); }
        .vm-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 40px; }
        .vm-card { background: white; padding: 40px; border-radius: var(--radius); box-shadow: var(--shadow); }
        .vm-card h3 { font-size: 1.5rem; margin-bottom: 16px; color: var(--primary); display: flex; align-items: center; gap: 12px; }
        .vm-card p { color: var(--gray-600); font-size: 15px; }

        .pillars { padding: 100px 0; }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(14,165,233,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .pillars-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .pillar-card { background: var(--gray-50); border-radius: var(--radius); padding: 32px 24px; text-align: center; transition: all 0.3s; border-top: 4px solid var(--primary); }
        .pillar-card:hover { transform: translateY(-8px); box-shadow: var(--shadow-lg); background: white; }
        .pillar-icon { width: 70px; height: 70px; background: var(--gradient-hope); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 28px; margin: 0 auto 20px; }
        .pillar-card h3 { font-size: 1.1rem; margin-bottom: 8px; color: var(--dark); }
        .pillar-card h4 { font-size: 0.9rem; color: var(--primary); margin-bottom: 12px; }
        .pillar-card p { color: var(--gray-600); font-size: 13px; }
        .pillar-list { list-style: none; text-align: left; padding: 0; margin: 0; }
        .pillar-list li { color: var(--gray-600); font-size: 13px; padding: 4px 0; padding-left: 20px; position: relative; }
        .pillar-list li::before { content: "✓"; position: absolute; left: 0; color: var(--primary); font-weight: bold; }

        .verse { background: var(--dark); color: white; padding: 80px 0; text-align: center; position: relative; overflow: hidden; }
        .verse::before { content: '"'; position: absolute; top: 20px; left: 10%; font-size: 15rem; opacity: 0.05; font-family: Georgia, serif; }
        .verse blockquote { font-size: 1.4rem; font-style: italic; max-width: 800px; margin: 0 auto 20px; opacity: 0.95; position: relative; z-index: 1; }
        .verse cite { color: var(--gold); font-size: 1rem; font-style: normal; font-weight: 600; }

        .donate { padding: 100px 0; background: var(--gray-50); }
        .donate-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .donate-content h2 { font-size: 2.2rem; margin-bottom: 20px; }
        .donate-content p { color: var(--gray-600); margin-bottom: 24px; }
        .bank-details { background: white; padding: 32px; border-radius: var(--radius); box-shadow: var(--shadow); }
        .bank-details h3 { margin-bottom: 20px; color: var(--primary); display: flex; align-items: center; gap: 10px; }
        .bank-row { display: flex; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid var(--gray-100); }
        .bank-row:last-child { border-bottom: none; }
        .bank-row span:first-child { color: var(--gray-600); font-size: 14px; }
        .bank-row span:last-child { font-weight: 600; }

        .board { padding: 100px 0; }
        .board-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; }
        .board-card { background: var(--gray-50); padding: 32px; border-radius: var(--radius); text-align: center; }
        .board-avatar { width: 80px; height: 80px; background: var(--gradient-hope); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 28px; margin: 0 auto 16px; }
        .board-card h4 { margin-bottom: 4px; }
        .board-card p { color: var(--primary); font-size: 13px; font-weight: 600; }

        .cta { background: var(--gradient-hope); padding: 100px 0; text-align: center; color: white; position: relative; overflow: hidden; }
        .cta::before { content: ''; position: absolute; top: -50%; right: -10%; width: 600px; height: 600px; background: rgba(245,158,11,0.15); border-radius: 50%; }
        .cta h2 { font-size: 2.5rem; margin-bottom: 16px; position: relative; z-index: 1; }
        .cta p { opacity: 0.95; margin-bottom: 32px; max-width: 600px; margin-left: auto; margin-right: auto; position: relative; z-index: 1; font-size: 1.1rem; }
        .cta-buttons { display: flex; gap: 16px; justify-content: center; position: relative; z-index: 1; flex-wrap: wrap; }

        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container i { font-size: 48px; background: var(--gradient-hope); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--gold); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: var(--gold); }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }

        @media (max-width: 1024px) { .hero .container { grid-template-columns: 1fr; text-align: center; } .hero-image { display: none; } .hero-buttons { justify-content: center; } .pillars-grid { grid-template-columns: repeat(2, 1fr); } .donate-grid { grid-template-columns: 1fr; } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .hero h1 { font-size: 2rem; } .nav-links { display: none; } .nav .btn-gold { display: none; } .mobile-menu-btn { display: block; } .pillars-grid { grid-template-columns: 1fr; } .vm-grid { grid-template-columns: 1fr; } .board-grid { grid-template-columns: 1fr; } .footer-grid { grid-template-columns: 1fr; } .footer-bottom { flex-direction: column; gap: 16px; } .cta-buttons { flex-direction: column; align-items: center; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" alt="HopeCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/">Home</a></li>
                <li><a href="/about.php">About</a></li>
                <li><a href="/contact.php">Contact</a></li>
            </ul>
            <a href="#donate" class="btn btn-gold"><i class="fas fa-heart"></i> Donate</a>
        </nav>
    </div></div></header>

    <!-- Mobile Menu Overlay -->
    <div id="mobileMenu" class="mobile-menu">
        <button class="mobile-menu-close" onclick="document.getElementById('mobileMenu').classList.remove('active')"><i class="fas fa-times"></i></button>
        <a href="https://omnicure.co.za/"><i class="fas fa-th-large"></i> OmniCure</a>
        <a href="/">Home</a>
        <a href="#about">About</a>
        <a href="#donate">Donate</a>
        <a href="/contact.php">Contact</a>
    </div>

    <section class="hero">
        <div class="container">
            <div>
                <div class="hero-badge"><i class="fas fa-cross"></i> Non-Profit Company</div>
                <h1>Restoring <span>Hope</span>.<br>Healing Lives.<br>Advancing God's Kingdom.</h1>
                <p>HopeCure NPC brings lasting hope to broken communities through the spread of the Gospel, church planting, educational empowerment, and social upliftment in South Africa.</p>
                <div class="hero-buttons">
                    <a href="#donate" class="btn btn-gold btn-lg"><i class="fas fa-heart"></i> Support Our Mission</a>
                    <a href="#pillars" class="btn btn-white btn-lg"><i class="fas fa-hands-helping"></i> Our Pillars</a>
                </div>
            </div>
            <div class="hero-image"><img src="/images/hero-hope.png" alt="HopeCure Community Support"></div>
        </div>
    </section>

    <section class="vision-mission"><div class="container">
        <div class="vm-grid">
            <div class="vm-card">
                <h3><i class="fas fa-eye"></i> Our Vision</h3>
                <p>A South Africa restored through hope, healed through Christ, and empowered for lasting transformation.</p>
            </div>
            <div class="vm-card">
                <h3><i class="fas fa-bullseye"></i> Our Mission</h3>
                <p>HopeCure exists to bring lasting hope to broken communities through the spread of the Gospel, church planting, funding and equipping evangelists, educational empowerment, and social and economic upliftment.</p>
            </div>
        </div>
    </div></section>

    <section class="pillars" id="pillars"><div class="container">
        <div class="section-header">
            <span class="section-badge">Core Pillars</span>
            <h2>Four Pillars of Hope</h2>
            <p>Together, we don't just give help — we restore hope.</p>
        </div>
        <div class="pillars-grid">
            <div class="pillar-card">
                <div class="pillar-icon"><i class="fas fa-bible"></i></div>
                <h3>HopeCure Gospel</h3>
                <h4>Spreading the Good News</h4>
                <ul class="pillar-list">
                    <li>Evangelism</li>
                    <li>Crusades</li>
                    <li>Outreach programs</li>
                </ul>
            </div>
            <div class="pillar-card">
                <div class="pillar-icon"><i class="fas fa-church"></i></div>
                <h3>HopeCure Churches</h3>
                <h4>Building God's House</h4>
                <ul class="pillar-list">
                    <li>Church planting</li>
                    <li>Pastoral support</li>
                    <li>Leadership training</li>
                </ul>
            </div>
            <div class="pillar-card">
                <div class="pillar-icon"><i class="fas fa-graduation-cap"></i></div>
                <h3>HopeCure Education</h3>
                <h4>Empowering the Future</h4>
                <ul class="pillar-list">
                    <li>Youth development</li>
                    <li>Skills training</li>
                    <li>Schools support</li>
                    <li>Bursaries</li>
                </ul>
            </div>
            <div class="pillar-card">
                <div class="pillar-icon"><i class="fas fa-users"></i></div>
                <h3>HopeCure Community</h3>
                <h4>Restoring Lives</h4>
                <ul class="pillar-list">
                    <li>Poverty relief</li>
                    <li>Family restoration</li>
                    <li>Addiction recovery</li>
                    <li>Food security</li>
                </ul>
            </div>
        </div>
    </div></section>

    <section class="verse">
        <div class="container">
            <blockquote>"For I was hungry and you gave me something to eat, I was thirsty and you gave me something to drink, I was a stranger and you invited me in."</blockquote>
            <cite>— Matthew 25:35 (NIV)</cite>
        </div>
    </section>

    <section class="donate" id="donate"><div class="container">
        <div class="donate-grid">
            <div class="donate-content">
                <span class="section-badge">Partner With Us</span>
                <h2>Your Generosity Changes Lives</h2>
                <p>Every donation, no matter the size, makes a real difference in the lives of those we serve. Your gift helps spread the Gospel, plant churches, educate youth, and restore families.</p>
                <p><strong>Reference:</strong> Please use your name as the payment reference so we can acknowledge your gift and keep you updated on our impact.</p>
            </div>
            <div class="bank-details">
                <h3><i class="fas fa-university"></i> Banking Details</h3>
                <div class="bank-row">
                    <span>Bank Name</span>
                    <span>Capitec</span>
                </div>
                <div class="bank-row">
                    <span>Account Name</span>
                    <span>HopeCure NPC</span>
                </div>
                <div class="bank-row">
                    <span>Account Number</span>
                    <span>1536473462</span>
                </div>
                <div class="bank-row">
                    <span>Branch Code</span>
                    <span>470010</span>
                </div>
                <div class="bank-row">
                    <span>Reference</span>
                    <span>Your Name</span>
                </div>
            </div>
        </div>
    </div></section>

    <section class="board"><div class="container">
        <div class="section-header">
            <span class="section-badge">Leadership</span>
            <h2>Board of Directors</h2>
        </div>
        <div class="board-grid">
            <div class="board-card">
                <div class="board-avatar"><i class="fas fa-user"></i></div>
                <h4>Ansume Viljoen</h4>
                <p>Chairperson</p>
            </div>
            <div class="board-card">
                <div class="board-avatar"><i class="fas fa-user"></i></div>
                <h4>Francois Viljoen</h4>
                <p>Vice Chair</p>
            </div>
            <div class="board-card">
                <div class="board-avatar"><i class="fas fa-user"></i></div>
                <h4>Anre Viljoen</h4>
                <p>Treasurer</p>
            </div>
            <div class="board-card">
                <div class="board-avatar"><i class="fas fa-user"></i></div>
                <h4>Amorise Viljoen</h4>
                <p>Secretary</p>
            </div>
            <div class="board-card">
                <div class="board-avatar"><i class="fas fa-user"></i></div>
                <h4>Francois Viljoen Senior</h4>
                <p>Program Director</p>
            </div>
            <div class="board-card">
                <div class="board-avatar"><i class="fas fa-user"></i></div>
                <h4>Marlon Roelfse</h4>
                <p>Community Liaison</p>
            </div>
        </div>
    </div></section>

    <section class="cta">
        <div class="container">
            <h2>Together, We Restore Hope</h2>
            <p>Join us in bringing lasting transformation to South Africa. Whether through prayer, giving, or volunteering, you can be part of this Kingdom mission.</p>
            <div class="cta-buttons">
                <a href="#donate" class="btn btn-gold btn-lg"><i class="fas fa-heart"></i> Donate Now</a>
                <a href="/contact.php" class="btn btn-white btn-lg"><i class="fas fa-envelope"></i> Contact Us</a>
            </div>
        </div>
    </section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand">
                <div class="footer-icon-container"><img src="/images/logo-icon.png" alt="HopeCure" style="height: 80px;"></div>
                <p class="footer-tagline">Restoring Hope. Healing Lives.</p>
                <p>Advancing God's Kingdom<br>through love in action.</p>
            </div>
            <div>
                <h4>Core Pillars</h4>
                <ul class="footer-links">
                    <li><a href="#pillars">Gospel - Evangelism & Crusades</a></li>
                    <li><a href="#pillars">Churches - Planting & Training</a></li>
                    <li><a href="#pillars">Education - Youth & Bursaries</a></li>
                    <li><a href="#pillars">Community - Relief & Recovery</a></li>
                </ul>
            </div>
            <div>
                <h4>Quick Links</h4>
                <ul class="footer-links">
                    <li><a href="/about.php">About Us</a></li>
                    <li><a href="#donate">Donate</a></li>
                    <li><a href="/contact.php">Contact</a></li>
                </ul>
            </div>
            <div>
                <h4>Contact</h4>
                <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 8px;"><i class="fas fa-envelope"></i> info@hopecure.org</p>
                <p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-map-marker-alt"></i> South Africa</p>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> HopeCure NPC. All Glory to God.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge">
                <span>Part of</span>
                <div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure Network"></div>
            </a>
        </div>
    </div></footer>
</body>
</html>
