<?php
/**
 * Hopecure Reseller System - Configuration
 */

// Database Configuration - UPDATE THESE FOR YOUR SERVER
define('DB_HOST', 'localhost');
define('DB_NAME', 'hopecure_reseller_db');
define('DB_USER', 'hopecure_reseller_user');
define('DB_PASS', 'CHANGE_THIS_PASSWORD');

// Site Configuration
define('SITE_NAME', 'Hopecure');
define('SITE_URL', 'https://hopecure.co.za');
define('UPLOAD_DIR', __DIR__ . '/uploads/');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Database connection
function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            $pdo = new PDO(
                'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4',
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
                ]
            );
        } catch (PDOException $e) {
            die('Database connection failed. Please check configuration.');
        }
    }
    return $pdo;
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Check if user is admin
function isAdmin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

// Require login
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

// Require admin
function requireAdmin() {
    requireLogin();
    if (!isAdmin()) {
        header('Location: dashboard.php');
        exit;
    }
}

// Get current user
function getCurrentUser() {
    if (!isLoggedIn()) return null;
    $db = getDB();
    $stmt = $db->prepare('SELECT * FROM users WHERE id = ?');
    $stmt->execute([$_SESSION['user_id']]);
    return $stmt->fetch();
}

// Get current pricelist
function getCurrentPricelist() {
    $db = getDB();
    $stmt = $db->query('SELECT * FROM pricelists WHERE is_current = 1 ORDER BY uploaded_at DESC LIMIT 1');
    return $stmt->fetch();
}
?>
