<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OilCure - Innovative Environmental Remediation | South Africa</title>
    <meta name="description" content="OilCure provides innovative environmental remediation solutions for oil spills, contaminated soil, and industrial waste management across South Africa.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #f97316; --primary-dark: #ea580c; --primary-light: #fb923c; --accent: #1f2937; --accent-dark: #111827; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-200: #e5e7eb; --gray-600: #4b5563; --white: #fff; --gradient-hero: linear-gradient(135deg, #ea580c 0%, #f97316 50%, #fb923c 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 75px; }
        .logo-text { font-size: 1.5rem; font-weight: 700; color: var(--primary); text-decoration: none; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); color: var(--gray-600) !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 13px; transition: all 0.3s; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(249, 115, 22, 0.4); }
        .btn-accent { background: var(--accent); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-white { background: white; color: var(--primary); }
        .btn-lg { padding: 14px 28px; font-size: 15px; }
        .hero { background: var(--gradient-hero); padding: 160px 0 100px; color: white; position: relative; overflow: hidden; }
        .hero::before { content: ''; position: absolute; top: -50%; right: -20%; width: 800px; height: 800px; background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%); border-radius: 50%; }
        .hero .container { position: relative; z-index: 1; display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .hero-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.15); padding: 8px 16px; border-radius: 50px; font-size: 14px; margin-bottom: 20px; }
        .hero h1 { font-size: 3.2rem; font-weight: 800; margin-bottom: 20px; line-height: 1.1; }
        .hero p { font-size: 1.2rem; opacity: 0.9; margin-bottom: 32px; }
        .hero-buttons { display: flex; gap: 16px; flex-wrap: wrap; }
        .hero-image { text-align: center; }
        .hero-image img { max-width: 400px; width: 100%; filter: drop-shadow(0 20px 40px rgba(0,0,0,0.3)); animation: heroFloat 4s ease-in-out infinite; }
        @keyframes heroFloat { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-15px); } }
        .services { padding: 100px 0; background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(249,115,22,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .services-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .service-card { background: white; border-radius: var(--radius); padding: 32px; text-align: center; box-shadow: var(--shadow); transition: all 0.3s; text-decoration: none; color: inherit; }
        .service-card:hover { transform: translateY(-8px); box-shadow: var(--shadow-lg); }
        .service-icon { width: 80px; height: 80px; background: var(--gradient-hero); color: white; border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 32px; margin: 0 auto 20px; }
        .service-card h3 { font-size: 1.2rem; margin-bottom: 10px; }
        .service-card p { color: var(--gray-600); font-size: 14px; margin-bottom: 16px; }
        .service-link { color: var(--primary-dark); font-weight: 600; font-size: 14px; }
        .about { padding: 100px 0; }
        .about-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .about-content h2 { font-size: 2.5rem; margin-bottom: 20px; }
        .about-content p { color: var(--gray-600); margin-bottom: 16px; }
        .about-stats { display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; margin-top: 32px; }
        .stat-item { text-align: center; }
        .stat-item h3 { font-size: 2.5rem; font-weight: 800; color: var(--primary); }
        .stat-item p { color: var(--gray-600); font-size: 14px; }
        .features { padding: 100px 0; background: var(--gray-50); }
        .features-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .feature-card { text-align: center; padding: 32px 20px; background: white; border-radius: var(--radius); box-shadow: var(--shadow); }
        .feature-icon { width: 70px; height: 70px; background: var(--gradient-hero); color: white; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 28px; margin: 0 auto 20px; }
        .feature-card h3 { font-size: 1.1rem; margin-bottom: 10px; }
        .feature-card p { color: var(--gray-600); font-size: 14px; }
        .cta { background: var(--gradient-hero); padding: 100px 0; text-align: center; color: white; }
        .cta h2 { font-size: 2.5rem; margin-bottom: 16px; }
        .cta p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container i { font-size: 48px; color: var(--primary); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--primary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-links a:hover { color: var(--primary); }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .hero .container { grid-template-columns: 1fr; text-align: center; } .hero-image { display: none; } .services-grid { grid-template-columns: repeat(2, 1fr); } .about-grid { grid-template-columns: 1fr; } .features-grid { grid-template-columns: repeat(2, 1fr); } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .services-grid { grid-template-columns: 1fr; } .features-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .nav .btn-outline, .nav .btn-primary { display: none; } .mobile-menu-btn { display: block; } .footer-grid { grid-template-columns: 1fr; } .footer-bottom { flex-direction: column; gap: 16px; } .about-stats { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" alt="OilCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/">Home</a></li>
                <li><a href="/products.php">Solutions</a></li>
                <li><a href="/about.php">About Us</a></li>
                <li><a href="/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <!-- Mobile Menu Overlay -->
    <div id="mobileMenu" class="mobile-menu">
        <button class="mobile-menu-close" onclick="document.getElementById('mobileMenu').classList.remove('active')"><i class="fas fa-times"></i></button>
        <a href="https://omnicure.co.za/"><i class="fas fa-th-large"></i> OmniCure</a>
        <a href="/">Home</a>
        <a href="#products">Products</a>
        <a href="/contact.php">Contact</a>
        <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
    </div>

    <section class="hero">
        <div class="container">
            <div>
                <div class="hero-badge"><i class="fas fa-leaf"></i> Innovative Environmental Remediation</div>
                <h1>Environmental Oil Remediation Solutions</h1>
                <p>Professional oil spill cleanup, soil remediation, and industrial waste management for a cleaner South Africa.</p>
                <div class="hero-buttons">
                    <a href="/products.php" class="btn btn-accent btn-lg"><i class="fas fa-th-large"></i> Our Solutions</a>
                    <a href="/contact.php" class="btn btn-white btn-lg"><i class="fas fa-phone"></i> Get Consultation</a>
                </div>
            </div>
            <div class="hero-image"><img src="/images/hero-remediation.png" alt="OilCure Environmental Remediation"></div>
        </div>
    </section>

    <section class="services"><div class="container">
        <div class="section-header">
            <span class="section-badge">Our Services</span>
            <h2>Environmental Remediation Solutions</h2>
            <p>Comprehensive solutions for oil contamination and environmental cleanup.</p>
        </div>
        <div class="services-grid">
            <a href="/products.php#spill-response" class="service-card">
                <div class="service-icon"><i class="fas fa-exclamation-triangle"></i></div>
                <h3>Oil Spill Response</h3>
                <p>Rapid emergency response for oil spills and contamination incidents.</p>
                <span class="service-link">Learn More <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/products.php#soil-remediation" class="service-card">
                <div class="service-icon"><i class="fas fa-seedling"></i></div>
                <h3>Soil Remediation</h3>
                <p>Advanced techniques to restore contaminated soil to healthy conditions.</p>
                <span class="service-link">Learn More <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/products.php#bioremediation" class="service-card">
                <div class="service-icon"><i class="fas fa-bacteria"></i></div>
                <h3>Bioremediation</h3>
                <p>Eco-friendly biological solutions for breaking down oil contaminants.</p>
                <span class="service-link">Learn More <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/products.php#waste-management" class="service-card">
                <div class="service-icon"><i class="fas fa-recycle"></i></div>
                <h3>Waste Management</h3>
                <p>Safe disposal and recycling of oil-contaminated materials.</p>
                <span class="service-link">Learn More <i class="fas fa-arrow-right"></i></span>
            </a>
        </div>
    </div></section>

    <section class="about"><div class="container">
        <div class="about-grid">
            <div class="about-content">
                <span class="section-badge">About OilCure</span>
                <h2>Leaders in Environmental Remediation</h2>
                <p>OilCure is at the forefront of innovative environmental remediation in South Africa. We specialize in cleaning up oil spills, remediating contaminated soil, and providing sustainable solutions for industrial waste management.</p>
                <p>Our team of environmental experts uses cutting-edge technology and eco-friendly methods to restore environments to their natural state, protecting both communities and ecosystems.</p>
                <a href="/about.php" class="btn btn-primary"><i class="fas fa-info-circle"></i> Learn More About Us</a>
            </div>
            <div class="about-stats">
                <div class="stat-item">
                    <h3>500+</h3>
                    <p>Projects Completed</p>
                </div>
                <div class="stat-item">
                    <h3>98%</h3>
                    <p>Success Rate</p>
                </div>
                <div class="stat-item">
                    <h3>24/7</h3>
                    <p>Emergency Response</p>
                </div>
            </div>
        </div>
    </div></section>

    <section class="features"><div class="container">
        <div class="section-header">
            <span class="section-badge">Why OilCure</span>
            <h2>The OilCure Advantage</h2>
        </div>
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-clock"></i></div>
                <h3>Rapid Response</h3>
                <p>24/7 emergency response teams ready to deploy.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-leaf"></i></div>
                <h3>Eco-Friendly</h3>
                <p>Sustainable methods that protect the environment.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-certificate"></i></div>
                <h3>Certified</h3>
                <p>Fully certified and compliant with regulations.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-users"></i></div>
                <h3>Expert Team</h3>
                <p>Experienced environmental specialists.</p>
            </div>
        </div>
    </div></section>

    <section class="cta"><div class="container">
        <h2>Need Environmental Remediation?</h2>
        <p>Contact our team for a consultation on your environmental cleanup needs.</p>
        <a href="/contact.php" class="btn btn-accent btn-lg"><i class="fas fa-envelope"></i> Get in Touch</a>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand">
                <div class="footer-icon-container"><img src="/images/logo-icon.png" alt="OilCure"></div>
                <p class="footer-tagline">Environmental Remediation</p>
                <p>Innovative solutions for<br>a cleaner environment.</p>
            </div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/products.php">Solutions</a></li><li><a href="/about.php">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul></div>
            <div><h4>Services</h4><ul class="footer-links"><li><a href="/products.php#spill-response">Oil Spill Response</a></li><li><a href="/products.php#soil-remediation">Soil Remediation</a></li><li><a href="/products.php#bioremediation">Bioremediation</a></li><li><a href="/products.php#waste-management">Waste Management</a></li></ul></div>
            <div><h4>Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-phone"></i> +27 12 345 6789</p><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@oilcure.co.za</p></div>
        </div>
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> OilCure. All rights reserved.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
        </div>
    </div></footer>
</body>
</html>
