<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products & Solutions - OilCure | 100% Natural Cleaning & Remediation</title>
    <meta name="description" content="OilCure's 100% all-natural cleaning solutions for automotive, industrial, food & hospitality. Bioremediation technology that converts hydrocarbons to water and CO2.">
    <link rel="icon" type="image/x-icon" href="/oilcure/favicon.ico">
    <link rel="apple-touch-icon" href="/oilcure/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #f97316; --primary-dark: #ea580c; --primary-light: #fb923c; --accent: #1f2937; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-200: #e5e7eb; --gray-600: #4b5563; --white: #fff; --gradient-hero: linear-gradient(135deg, #ea580c 0%, #f97316 50%, #fb923c 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 60px; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; font-size: 13px; transition: all 0.3s; border: none; cursor: pointer; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(249, 115, 22, 0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-white { background: white; color: var(--primary); }
        .btn-sm { padding: 8px 14px; font-size: 12px; }
        .btn-lg { padding: 14px 28px; font-size: 15px; }

        .page-header { background: var(--gradient-hero); padding: 160px 0 80px; color: white; text-align: center; position: relative; overflow: hidden; }
        .page-header::before { content: ''; position: absolute; top: -50%; right: -20%; width: 600px; height: 600px; background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%); border-radius: 50%; }
        .page-header h1 { font-size: 3rem; margin-bottom: 16px; position: relative; }
        .page-header p { opacity: 0.9; max-width: 700px; margin: 0 auto 24px; position: relative; }
        .certifications { display: flex; justify-content: center; gap: 24px; flex-wrap: wrap; position: relative; }
        .cert-badge { background: rgba(255,255,255,0.15); padding: 8px 16px; border-radius: 50px; font-size: 13px; display: flex; align-items: center; gap: 8px; }

        .section { padding: 80px 0; }
        .section-alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(249,115,22,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.2rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 700px; margin: 0 auto; }

        /* Industry Cards */
        .industry-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; margin-bottom: 60px; }
        .industry-card { background: white; border-radius: var(--radius); padding: 32px 24px; text-align: center; box-shadow: var(--shadow); transition: all 0.3s; text-decoration: none; color: inherit; display: flex; flex-direction: column; }
        .industry-card:hover { transform: translateY(-8px); box-shadow: var(--shadow-lg); }
        .industry-icon { width: 80px; height: 80px; background: var(--gradient-hero); color: white; border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 32px; margin: 0 auto 20px; }
        .industry-card h3 { font-size: 1.1rem; margin-bottom: 8px; }
        .industry-card p { color: var(--gray-600); font-size: 13px; margin-bottom: 16px; }
        .industry-link { display: block; color: var(--primary); font-weight: 600; font-size: 13px; margin-top: auto; }

        /* Products Grid */
        .products-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; }
        .product-card { background: white; border-radius: var(--radius); overflow: hidden; box-shadow: var(--shadow); transition: all 0.3s; }
        .product-image { height: 140px; overflow: hidden; }
        .product-image img { width: 100%; height: 100%; object-fit: cover; }
        .product-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); }
        .product-header { background: var(--gradient-hero); color: white; padding: 20px; }
        .product-header h3 { font-size: 1.1rem; margin-bottom: 4px; }
        .product-header span { font-size: 12px; opacity: 0.9; }
        .product-content { padding: 20px; }
        .product-content p { color: var(--gray-600); font-size: 13px; margin-bottom: 16px; line-height: 1.6; }
        .product-features { list-style: none; margin-bottom: 16px; }
        .product-features li { font-size: 12px; color: var(--gray-600); padding: 4px 0; padding-left: 20px; position: relative; }
        .product-features li::before { content: '\f00c'; font-family: 'Font Awesome 6 Free'; font-weight: 900; position: absolute; left: 0; color: var(--primary); font-size: 10px; }
        .product-sizes { font-size: 11px; color: var(--gray-600); background: var(--gray-50); padding: 8px 12px; border-radius: 8px; margin-bottom: 16px; }
        .product-actions { display: flex; gap: 8px; }
        .product-actions .btn { flex: 1; justify-content: center; }

        /* Technology Section */
        .tech-highlight { background: linear-gradient(135deg, #fff7ed 0%, #ffedd5 100%); border-radius: var(--radius); padding: 60px; display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .tech-content h3 { font-size: 1.8rem; color: var(--primary-dark); margin-bottom: 16px; }
        .tech-content p { color: var(--gray-600); margin-bottom: 20px; }
        .tech-steps { list-style: none; }
        .tech-steps li { padding: 12px 0; padding-left: 40px; position: relative; border-bottom: 1px solid rgba(249,115,22,0.1); }
        .tech-steps li:last-child { border-bottom: none; }
        .tech-steps li::before { content: attr(data-step); position: absolute; left: 0; top: 12px; width: 24px; height: 24px; background: var(--primary); color: white; border-radius: 50%; font-size: 12px; font-weight: 600; display: flex; align-items: center; justify-content: center; }
        .tech-steps strong { color: var(--primary-dark); }
        .tech-image { text-align: center; }
        .tech-image i { font-size: 8rem; color: var(--primary); opacity: 0.3; }

        /* Documents Grid */
        .docs-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; }
        .doc-card { background: white; border-radius: var(--radius); padding: 20px; text-align: center; box-shadow: var(--shadow); transition: all 0.3s; text-decoration: none; color: inherit; }
        .doc-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); background: var(--primary); color: white; }
        .doc-card:hover .doc-icon { background: white; color: var(--primary); }
        .doc-card:hover p { color: rgba(255,255,255,0.8); }
        .doc-icon { width: 50px; height: 50px; background: var(--gradient-hero); color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin: 0 auto 12px; transition: all 0.3s; }
        .doc-card h4 { font-size: 0.85rem; margin-bottom: 4px; }
        .doc-card p { color: var(--gray-600); font-size: 11px; transition: all 0.3s; }

        .cta { background: var(--gradient-hero); padding: 80px 0; text-align: center; color: white; }
        .cta h2 { font-size: 2.2rem; margin-bottom: 16px; }
        .cta p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }

        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-content { display: flex; justify-content: space-between; align-items: center; }
        .footer p { color: rgba(255,255,255,0.6); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }

        @media (max-width: 1024px) { .industry-grid { grid-template-columns: repeat(2, 1fr); } .products-grid { grid-template-columns: repeat(2, 1fr); } .tech-highlight { grid-template-columns: 1fr; } .docs-grid { grid-template-columns: repeat(2, 1fr); } }
        @media (max-width: 768px) { .industry-grid { grid-template-columns: 1fr; } .products-grid { grid-template-columns: 1fr; } .docs-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-content { flex-direction: column; gap: 16px; } .tech-highlight { padding: 40px 24px; } .certifications { gap: 12px; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/oilcure/" class="logo"><img src="/oilcure/images/logo-long.png" alt="OilCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/oilcure/">Home</a></li>
                <li><a href="/oilcure/products.php" class="active">Products</a></li>
                <li><a href="/oilcure/about.php">About Us</a></li>
                <li><a href="/oilcure/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <section class="page-header">
        <div class="container">
            <h1>100% All-Natural Cleaning Solutions</h1>
            <p>State-of-the-art bioremediation technology that converts hydrocarbons into water and carbon dioxide. Safe, effective, and environmentally responsible.</p>
            <div class="certifications">
                <span class="cert-badge"><i class="fas fa-check-circle"></i> SABS Approved</span>
                <span class="cert-badge"><i class="fas fa-certificate"></i> Halal Certified</span>
                <span class="cert-badge"><i class="fas fa-globe-americas"></i> NSF Certified</span>
                <span class="cert-badge"><i class="fas fa-leaf"></i> EPA Recognized</span>
            </div>
        </div>
    </section>

    <!-- Industry Solutions -->
    <section class="section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Industry Solutions</span>
                <h2>Complete Cleaning Solutions by Industry</h2>
                <p>Tailored products for specific industry needs - from workshops to kitchens, petrol stations to mining operations.</p>
            </div>
            <div class="industry-grid">
                <a href="#automotive" class="industry-card">
                    <div class="industry-icon"><i class="fas fa-car"></i></div>
                    <h3>Automotive & Industrial</h3>
                    <p>Workshops, garages, manufacturing plants, and engineering facilities.</p>
                    <span class="industry-link">View Products <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="#food" class="industry-card">
                    <div class="industry-icon"><i class="fas fa-utensils"></i></div>
                    <h3>Food & Hospitality</h3>
                    <p>Restaurants, hotels, bakeries, supermarkets, and food prep facilities.</p>
                    <span class="industry-link">View Products <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="#petrol" class="industry-card">
                    <div class="industry-icon"><i class="fas fa-gas-pump"></i></div>
                    <h3>Petrol Stations</h3>
                    <p>Forecourt cleaning, fuel spill response, and store maintenance.</p>
                    <span class="industry-link">View Products <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="#remediation" class="industry-card">
                    <div class="industry-icon"><i class="fas fa-seedling"></i></div>
                    <h3>Environmental Remediation</h3>
                    <p>Soil, groundwater, and MTBE contamination treatment.</p>
                    <span class="industry-link">View Products <i class="fas fa-arrow-right"></i></span>
                </a>
            </div>
        </div>
    </section>

    <!-- Technology Section -->
    <section class="section section-alt">
        <div class="container">
            <div class="tech-highlight">
                <div class="tech-content">
                    <h3>BioRem-2000 Technology</h3>
                    <p>Our products use a powerful blend of 12 strains of microbes, enzymes, and natural botanical nutrients. This state-of-the-art technology converts hydrocarbons into harmless water and carbon dioxide.</p>
                    <ul class="tech-steps">
                        <li data-step="1"><strong>Biodispersion</strong> - Microbes produce bio-surfactants, converting hydrophobic hydrocarbons to hydrophilic</li>
                        <li data-step="2"><strong>Solubilization</strong> - Bio-surfactants increase surface area, breaking down macro to micro-sized molecules</li>
                        <li data-step="3"><strong>Assimilation</strong> - Enzymes cleave long hydrocarbon chains into two carbon units</li>
                        <li data-step="4"><strong>Mineralization</strong> - Microbes convert carbon units into CO2 and water as by-products</li>
                    </ul>
                </div>
                <div class="tech-image">
                    <i class="fas fa-atom"></i>
                </div>
            </div>
        </div>
    </section>

    <!-- Automotive & Industrial Products -->
    <section class="section" id="automotive">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Automotive & Industrial</span>
                <h2>Workshop & Industrial Cleaning</h2>
                <p>Heavy-duty cleaning solutions for garages, workshops, manufacturing plants, and industrial facilities.</p>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-degreaser.jpg" alt="Workshop Degreaser"></div>
                    <div class="product-header">
                        <h3>Workshop Degreaser</h3>
                        <span>Ultimate Cleaner & Foaming Degreaser</span>
                    </div>
                    <div class="product-content">
                        <p>Remediates oil, grease and hydrocarbons on hard surfaces into water and CO2. EPA recognized microbe technology.</p>
                        <ul class="product-features">
                            <li>Outperforms conventional degreasers</li>
                            <li>Neutral pH, non-corrosive, no VOCs</li>
                            <li>Listed on U.S. EPA's NCP Product Schedule</li>
                            <li>Significantly reduces disposal costs</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml - 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Workshop%20Degreaser.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-oil-vanisher.jpg" alt="Oil Vanisher"></div>
                    <div class="product-header">
                        <h3>Oil Vanisher</h3>
                        <span>Nano-Natural Technology</span>
                    </div>
                    <div class="product-content">
                        <p>Soaks deep into surfaces and lifts oil stains out. Removes oil from concrete, asphalt, pavers, garages, and parking areas.</p>
                        <ul class="product-features">
                            <li>Deep penetration cleaning</li>
                            <li>Works on concrete and asphalt</li>
                            <li>Fuel pumps and drive-throughs</li>
                            <li>No scrubbing required</li>
                        </ul>
                        <div class="product-sizes">Available: 750ml, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Automotive%20%26%20Industrial.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-rust-vanish.jpg" alt="Rust Vanish"></div>
                    <div class="product-header">
                        <h3>Rust Vanish</h3>
                        <span>Bio-Powered Rust Remover</span>
                    </div>
                    <div class="product-content">
                        <p>Dissolves tough rust to bare metal using selective chelation and bio-power technology. Will not harm surrounding parts.</p>
                        <ul class="product-features">
                            <li>3X ultra-concentrated formula</li>
                            <li>Reusable solution - lasts longer</li>
                            <li>Water-based, no acids or solvents</li>
                            <li>Safe for plastic, rubber, painted surfaces</li>
                        </ul>
                        <div class="product-sizes">Available: 16oz, 32oz (makes up to 128oz)</div>
                        <div class="product-actions">
                            <a href="Documents/Rust%20Vanish%20Rust%20Remover.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-multi-surface.jpg" alt="Multi-Surface Cleaner"></div>
                    <div class="product-header">
                        <h3>Multi-Surface Cleaner</h3>
                        <span>Fuel Eliminator</span>
                    </div>
                    <div class="product-content">
                        <p>Bioremediation for hazardous oil spills. Renders flammable liquids non-flammable. Everyday cleaning of all hydrocarbons.</p>
                        <ul class="product-features">
                            <li>Renders fuel spills non-flammable</li>
                            <li>Safe for floors, tools, equipment</li>
                            <li>Reduces disposal costs</li>
                            <li>Multiple dilution ratios</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml, 500ml, 750ml, 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Automotive%20%26%20Industrial.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-calcium.jpg" alt="Calcium Buster"></div>
                    <div class="product-header">
                        <h3>Calcium Buster</h3>
                        <span>Scale & Mineral Remover</span>
                    </div>
                    <div class="product-content">
                        <p>Fast-acting all-natural cleaning product which prevents build-up of calcium, lime, uric acid and scale.</p>
                        <ul class="product-features">
                            <li>Reduces maintenance costs</li>
                            <li>Extends equipment life</li>
                            <li>All-natural formula</li>
                            <li>Multiple applications</li>
                        </ul>
                        <div class="product-sizes">Available: 750ml, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Automotive%20%26%20Industrial.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-parts-powder.jpg" alt="Parts Cleaning Powder"></div>
                    <div class="product-header">
                        <h3>Parts Cleaning Powder</h3>
                        <span>Bioremediating Formula</span>
                    </div>
                    <div class="product-content">
                        <p>Eliminates toxic chemicals, reduces health risks and disposal costs. Contains corrosion inhibitors to prevent flash rusting.</p>
                        <ul class="product-features">
                            <li>For automatic spray cabinet washers</li>
                            <li>Prevents flash rusting</li>
                            <li>Eliminates toxic chemicals</li>
                            <li>Reduces disposal costs</li>
                        </ul>
                        <div class="product-sizes">Available: 1Kg, 5Kg, 20Kg, 200Kg</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Automotive%20%26%20Industrial.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Food & Hospitality Products -->
    <section class="section section-alt" id="food">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Food & Hospitality</span>
                <h2>Kitchen & Restaurant Cleaning</h2>
                <p>100% natural, food-safe cleaning solutions for bakeries, kitchens, restaurants, hotels, and food preparation facilities.</p>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-kitchen.jpg" alt="Kitchen Degreaser"></div>
                    <div class="product-header">
                        <h3>Kitchen Degreaser</h3>
                        <span>FOG Eliminator</span>
                    </div>
                    <div class="product-content">
                        <p>All-natural microbes and enzymes that consume fats, oils and grease (FOG). Provides deep clean, slip-free finish.</p>
                        <ul class="product-features">
                            <li>Digests FOG into water and CO2</li>
                            <li>Safe on all water-safe surfaces</li>
                            <li>Attacks protein, sugar, greasy solids</li>
                            <li>Food preparation area safe</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml, 500ml, 750ml, 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Food%20%26%20hospitality.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-grill.jpg" alt="Grill & Oven Cleaner"></div>
                    <div class="product-header">
                        <h3>Grill & Oven Cleaner</h3>
                        <span>Super-Cling Foam</span>
                    </div>
                    <div class="product-content">
                        <p>Cleans toughest kitchen ovens, grills and exhaust hoods. Penetrates and dissolves baked-on carbon, grease and food deposits.</p>
                        <ul class="product-features">
                            <li>Super-cling foam technology</li>
                            <li>Prolonged contact time</li>
                            <li>Initial penetration action</li>
                            <li>Exhaust hood cleaning</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml, 500ml, 750ml, 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Food%20%26%20hospitality.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-grease-trap.jpg" alt="Grease Trap Care"></div>
                    <div class="product-header">
                        <h3>Grease Trap Care</h3>
                        <span>Liquid FOG Treatment</span>
                    </div>
                    <div class="product-content">
                        <p>Botanical extracts and vitamins that convert FOG into CO2 and water. Reduces trap clogging and eliminates rancid odours.</p>
                        <ul class="product-features">
                            <li>Prevents trap clogging</li>
                            <li>Eliminates FOG build-up</li>
                            <li>Removes rancid odours</li>
                            <li>Regular maintenance solution</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Food%20%26%20hospitality.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-drain.jpg" alt="Drain Buster"></div>
                    <div class="product-header">
                        <h3>Granual Drain Buster</h3>
                        <span>Organic Waste Treatment</span>
                    </div>
                    <div class="product-content">
                        <p>Proprietary blend of aerobic and anaerobic bacteria for exhaust hood cleaning organic waste. Safe for plumbing and environment.</p>
                        <ul class="product-features">
                            <li>Converts waste to water and CO2</li>
                            <li>Safe for all plumbing</li>
                            <li>Environmentally friendly</li>
                            <li>Easy sachet application</li>
                        </ul>
                        <div class="product-sizes">Available: 50gr Sachet, 1Kg, 20Kg</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Food%20%26%20hospitality.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-sanitizer.jpg" alt="San-A-Safe"></div>
                    <div class="product-header">
                        <h3>San-A-Safe</h3>
                        <span>Natural Disinfectant</span>
                    </div>
                    <div class="product-content">
                        <p>Extremely effective disinfectant and deodoriser. 100% natural food grade ingredients - no chlorine, quats or alcohol.</p>
                        <ul class="product-features">
                            <li>100% natural ingredients</li>
                            <li>Food service area safe</li>
                            <li>Can be used as hand sanitizer</li>
                            <li>Foaming dispenser compatible</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml, 500ml, 750ml, 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Food%20%26%20hospitality.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-medical.jpg" alt="San-A-Med"></div>
                    <div class="product-header">
                        <h3>San-A-Med</h3>
                        <span>Bio-Disinfectant</span>
                    </div>
                    <div class="product-content">
                        <p>Complete biological formula to disinfect, clean and deodorise. Kills bacteria, viruses, fungi, mildew and black mold.</p>
                        <ul class="product-features">
                            <li>Broad spectrum effectiveness</li>
                            <li>100% natural formula</li>
                            <li>Removes mildew and black mold</li>
                            <li>Safe for toilets, urinals, showers</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml, 500ml, 750ml, 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Food%20%26%20hospitality.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Petrol Station & Environmental -->
    <section class="section" id="petrol">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Petrol Stations & Spill Response</span>
                <h2>Fuel Spill & Forecourt Solutions</h2>
                <p>Emergency spill response products that render fuel non-flammable within minutes and restore surfaces safely.</p>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-fuel.jpg" alt="Fuel Eliminator"></div>
                    <div class="product-header">
                        <h3>Fuel Eliminator</h3>
                        <span>Emergency Spill Response</span>
                    </div>
                    <div class="product-content">
                        <p>Knocks down vapors, reduces VOCs, elevates LEL on gasoline, diesel, jet fuel. Renders spills non-flammable.</p>
                        <ul class="product-features">
                            <li>Renders fuel non-flammable</li>
                            <li>Reduces spill clean-up time</li>
                            <li>Eliminates absorbents & fire foam</li>
                            <li>Stops asphalt deterioration</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml - 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/Oilcure%20Petrol%20statation%20%26%20store%20cleaner.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-asphalt.jpg" alt="Asphalt Remover"></div>
                    <div class="product-header">
                        <h3>Asphalt Remover</h3>
                        <span>Heavy Oil/Tar Cleaner</span>
                    </div>
                    <div class="product-content">
                        <p>Industrial cleaner specifically designed for cleaning asphalt and heavy oil/tar from trucks and equipment.</p>
                        <ul class="product-features">
                            <li>Dissolves and softens tar/asphalt</li>
                            <li>Safe on metals and plastics</li>
                            <li>Low porosity surface compatible</li>
                            <li>Equipment and vehicle safe</li>
                        </ul>
                        <div class="product-sizes">Available: 750ml, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Automotive%20%26%20Industrial.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-autoscrub.jpg" alt="Auto Scrub"></div>
                    <div class="product-header">
                        <h3>Auto Scrub</h3>
                        <span>Floor Scrubber Solution</span>
                    </div>
                    <div class="product-content">
                        <p>Low foaming water-based bio-remediating cleaner for all auto scrubbing machines. Degrades heavy synthetic oils and greases.</p>
                        <ul class="product-features">
                            <li>For all floor scrubbers</li>
                            <li>Degrades synthetic oils</li>
                            <li>Animal and vegetable oils</li>
                            <li>Concrete, tile, epoxy, waxed floors</li>
                        </ul>
                        <div class="product-sizes">Available: 100ml, 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/OilCure%20Automotive%20%26%20Industrial.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Environmental Remediation -->
    <section class="section section-alt" id="remediation">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Environmental Remediation</span>
                <h2>Oil Digester Range</h2>
                <p>Professional bioremediation solutions for contaminated soil, groundwater, and MTBE treatment.</p>
            </div>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-soil.jpg" alt="Oil Digester - Soil"></div>
                    <div class="product-header">
                        <h3>Oil Digester - Soil</h3>
                        <span>Hydrocarbon Soil Treatment</span>
                    </div>
                    <div class="product-content">
                        <p>12 strains of microbes designed to digest hydrocarbons in soil. Treats crude oil, gasoline, drilling mud, diesel and more.</p>
                        <ul class="product-features">
                            <li>In-situ and ex-situ applications</li>
                            <li>Changes soil from hydrophobic to hydrophilic</li>
                            <li>FDA-GRAS listed safe ingredients</li>
                            <li>Cost-effective alternative to excavation</li>
                        </ul>
                        <div class="product-sizes">Available: 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/Oil%20Cure%20oil%20digester.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-groundwater.jpg" alt="Oil Digester - Groundwater"></div>
                    <div class="product-header">
                        <h3>Oil Digester - Groundwater</h3>
                        <span>Aquifer Treatment</span>
                    </div>
                    <div class="product-content">
                        <p>Treats hydrocarbons in groundwater including crude oil, gasoline, fuels oils, diesel and multiple aromatics.</p>
                        <ul class="product-features">
                            <li>Injected directly into groundwater</li>
                            <li>Biologically converts to CO2 and water</li>
                            <li>Highly effective on free-product</li>
                            <li>Safe for aquatic life</li>
                        </ul>
                        <div class="product-sizes">Available: 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/Oil%20Cure%20oil%20digester.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image"><img src="/oilcure/images/product-mtbe.jpg" alt="Oil Digester - MTBE"></div>
                    <div class="product-header">
                        <h3>Oil Digester - MTBE</h3>
                        <span>BioRem-2000 Technology</span>
                    </div>
                    <div class="product-content">
                        <p>Specifically designed for MTBE contaminated groundwater. New research shows specific strains effective at MTBE biodegradation.</p>
                        <ul class="product-features">
                            <li>Converts MTBE to CO2 and water</li>
                            <li>Ex-situ bioreactor applications</li>
                            <li>In-situ injection treatments</li>
                            <li>Works with air sparging systems</li>
                        </ul>
                        <div class="product-sizes">Available: 1L, 5L, 20L, 200L, 1000L</div>
                        <div class="product-actions">
                            <a href="Documents/Oil%20Cure%20oil%20digester.pdf" target="_blank" class="btn btn-outline btn-sm"><i class="fas fa-file-pdf"></i> Brochure</a>
                            <a href="/oilcure/contact.php" class="btn btn-primary btn-sm"><i class="fas fa-envelope"></i> Quote</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Documentation Downloads -->
    <section class="section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Downloads</span>
                <h2>Product Brochures & Documentation</h2>
                <p>Download detailed product information, technical specifications, and industry-specific brochures.</p>
            </div>
            <div class="docs-grid">
                <a href="Documents/OilCure%20Automotive%20%26%20Industrial.pdf" target="_blank" class="doc-card">
                    <div class="doc-icon"><i class="fas fa-car"></i></div>
                    <h4>Automotive & Industrial</h4>
                    <p>Complete product range for workshops</p>
                </a>
                <a href="Documents/OilCure%20Food%20%26%20hospitality.pdf" target="_blank" class="doc-card">
                    <div class="doc-icon"><i class="fas fa-utensils"></i></div>
                    <h4>Food & Hospitality</h4>
                    <p>Kitchen and restaurant solutions</p>
                </a>
                <a href="Documents/OilCure%20Workshop%20Degreaser.pdf" target="_blank" class="doc-card">
                    <div class="doc-icon"><i class="fas fa-tools"></i></div>
                    <h4>Workshop Degreaser</h4>
                    <p>Technical specifications & dilution charts</p>
                </a>
                <a href="Documents/OilCure%20-%20Bioremediation%20Technology.pdf" target="_blank" class="doc-card">
                    <div class="doc-icon"><i class="fas fa-atom"></i></div>
                    <h4>Bioremediation Technology</h4>
                    <p>BioRem-2000 technical overview</p>
                </a>
                <a href="Documents/Oil%20Cure%20oil%20digester.pdf" target="_blank" class="doc-card">
                    <div class="doc-icon"><i class="fas fa-seedling"></i></div>
                    <h4>Oil Digester Range</h4>
                    <p>Soil, groundwater & MTBE solutions</p>
                </a>
                <a href="Documents/Rust%20Vanish%20Rust%20Remover.pdf" target="_blank" class="doc-card">
                    <div class="doc-icon"><i class="fas fa-wrench"></i></div>
                    <h4>Rust Vanish</h4>
                    <p>Bio-powered rust removal</p>
                </a>
                <a href="Documents/Oilcure%20Petrol%20statation%20%26%20store%20cleaner.pdf" target="_blank" class="doc-card">
                    <div class="doc-icon"><i class="fas fa-gas-pump"></i></div>
                    <h4>Petrol Station Solutions</h4>
                    <p>Forecourt and store cleaning</p>
                </a>
                <a href="Documents/Oilcure%20Tank%20Degassing%20%26%20Cleaning%20Protocol.pdf" target="_blank" class="doc-card">
                    <div class="doc-icon"><i class="fas fa-oil-can"></i></div>
                    <h4>Tank Degassing Protocol</h4>
                    <p>Safety procedures & cleaning</p>
                </a>
            </div>
        </div>
    </section>

    <section class="cta"><div class="container">
        <h2>Need a Custom Solution?</h2>
        <p>Contact our team for expert advice on the right products for your specific application.</p>
        <div style="display: flex; gap: 16px; justify-content: center; flex-wrap: wrap;">
            <a href="/oilcure/contact.php" class="btn btn-white btn-lg"><i class="fas fa-envelope"></i> Get in Touch</a>
            <a href="tel:+27614698370" class="btn btn-outline btn-lg" style="border-color: white; color: white;"><i class="fas fa-phone"></i> 061 469 8370</a>
        </div>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-content">
            <p>&copy; <?= date('Y') ?> OilCure. All rights reserved.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
        </div>
    </div></footer>
</body>
</html>
