<?php require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/security.php';
require_once __DIR__ . '/includes/email_config.php';

$brand = 'omnicure';
$emails = getBrandEmails($brand);  $sites = SITES; unset($sites['omnicure']); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us | OmniCure Network</title>
    <meta name="description" content="Contact OmniCure Network for enquiries about our brands, reseller opportunities, and bulk orders.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #2563eb; --primary-dark: #1d4ed8; --secondary: #fbbf24; --dark: #0f172a; --gray-50: #f8fafc; --gray-100: #f1f5f9; --gray-200: #e2e8f0; --gray-600: #475569; --white: #fff; --gradient-hero: linear-gradient(135deg, #1e3a5f 0%, #2563eb 50%, #1d4ed8 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 16px 0; }
        .logo img { height: 70px; }
        .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 14px; padding: 10px 18px; border-radius: 10px; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 14px 28px; border-radius: 12px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 15px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-secondary { background: var(--secondary); color: var(--dark); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-hero { background: var(--gradient-hero); padding: 160px 0 100px; text-align: center; color: white; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }
        .contact-section { padding: 80px 0; }
        .contact-grid { display: grid; grid-template-columns: 1fr 1.5fr; gap: 60px; }
        .info-card { background: var(--gray-50); border-radius: var(--radius); padding: 28px; margin-bottom: 20px; }
        .info-card-icon { width: 50px; height: 50px; background: var(--gradient-hero); color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-bottom: 16px; }
        .info-card h3 { font-size: 1.1rem; margin-bottom: 10px; }
        .info-card p { color: var(--gray-600); font-size: 14px; }
        .info-card a { color: var(--primary); text-decoration: none; font-weight: 500; }
        .contact-form { background: white; border-radius: var(--radius); padding: 40px; box-shadow: var(--shadow-lg); }
        .contact-form h2 { font-size: 1.6rem; margin-bottom: 8px; }
        .contact-form .subtitle { color: var(--gray-600); margin-bottom: 28px; }
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 14px; border: 2px solid var(--gray-200); border-radius: 10px; font-family: inherit; font-size: 15px; }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { outline: none; border-color: var(--primary); }
        .form-group textarea { resize: vertical; min-height: 100px; }
        .success-message { display: none; text-align: center; padding: 60px 20px; }
        .success-message.active { display: block; }
        .success-message i { font-size: 5rem; color: var(--secondary); margin-bottom: 24px; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 40px; }
        .footer-logo-container { background: rgba(255,255,255,0.95); padding: 16px 24px; border-radius: 12px; display: inline-block; }
        .footer-logo-container img { height: 50px; display: block; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; text-align: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        @media (max-width: 1024px) { .contact-grid { grid-template-columns: 1fr; } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .form-row { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></a>
        <nav><ul class="nav-links"><li><a href="/">Home</a></li><li><a href="/about.php">About Us</a></li><li><a href="/contact.php" class="active">Contact</a></li></ul>
        </nav>
    </div></div></header>

    <section class="page-hero"><div class="container"><h1>Contact Us</h1><p>Get in touch for enquiries, reseller opportunities, or support.</p></div></section>

    <section class="contact-section"><div class="container"><div class="contact-grid">
        <div>
            <div class="info-card"><div class="info-card-icon"><i class="fas fa-user"></i></div><h3>Contact Person</h3><p>Francois Viljoen</p></div>
            <div class="info-card"><div class="info-card-icon"><i class="fas fa-phone"></i></div><h3>Call Us</h3><p>Mon - Fri: 8:00 AM - 5:00 PM</p><a href="tel:+27828050405">082 805 0405</a></div>
            <div class="info-card"><div class="info-card-icon"><i class="fas fa-envelope"></i></div><h3>Email Us</h3><p>General enquiries</p><a href="mailto:info@omnicure.co.za">info@omnicure.co.za</a></div>
            <div class="info-card"><div class="info-card-icon"><i class="fas fa-map-marker-alt"></i></div><h3>Location</h3><p>South Africa<br>Nationwide Delivery</p></div>
            <div class="info-card"><div class="info-card-icon"><i class="fab fa-whatsapp"></i></div><h3>WhatsApp</h3><a href="https://wa.me/27828050405">Chat on WhatsApp</a></div>
        </div>
        <div class="contact-form">
            <div id="formContent"><h2>Send Us a Message</h2><p class="subtitle">We'll get back to you within 24 hours.</p>
                <form onsubmit="submitForm(event)">
                            <?= outputHoneypot() ?>
                            <?= outputTimestamp() ?>
                    <div class="form-row"><div class="form-group"><label>Name *</label><input type="text" required></div><div class="form-group"><label>Company</label><input type="text"></div></div>
                    <div class="form-row"><div class="form-group"><label>Email *</label><input type="email" required></div><div class="form-group"><label>Phone *</label><input type="tel" required></div></div>
                    <div class="form-group"><label>Brand Interest</label><select><option value="">Select a brand...</option><option>GermCure - Hygiene & Sanitation</option><option>FarmCure - Agricultural Solutions</option><option>TyreCure - Tyre Solutions</option><option>PestCure - Pest Control</option><option>BakiCure - Bakkie Accessories</option><option>Multiple Brands</option><option>Reseller Enquiry</option></select></div>
                    <div class="form-group"><label>Enquiry Type *</label><select required><option value="">Select...</option><option>Product Enquiry</option><option>Reseller Application</option><option>Bulk Order</option><option>Technical Support</option><option>General Enquiry</option></select></div>
                    <div class="form-group"><label>Message *</label><textarea required placeholder="Tell us how we can help you..."></textarea></div>
                    <?= outputMathCaptcha("math_answer") ?>
                            <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fas fa-paper-plane"></i> Send Message</button>
                </form>
            </div>
            <div class="success-message" id="successMessage"><i class="fas fa-check-circle"></i><h3>Message Sent!</h3><p>Thank you for contacting OmniCure Network. We'll respond within 24 hours.</p><button class="btn btn-primary" onclick="resetForm()" style="margin-top: 24px;">Send Another Message</button></div>
        </div>
    </div></div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand"><div class="footer-logo-container"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure" style="height: 50px;"></div><p>All Glory to God. Your complete cure solutions network.</p></div>
            <div><h4>Our Brands</h4><ul class="footer-links"><?php foreach ($sites as $key => $site): ?><li><a href="/<?php echo $key; ?>/"><?php echo $site['name']; ?></a></li><?php endforeach; ?></ul></div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/about.php">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul></div>
            <div><h4>Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-phone"></i> 082 805 0405</p><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@omnicure.co.za</p></div>
        </div>
        <div class="footer-bottom"><p>&copy; <?= date('Y') ?> OmniCure Network. All rights reserved.</p></div>
    </div></footer>
    <script>
        function submitForm(e) { e.preventDefault(); document.getElementById('formContent').style.display = 'none'; document.getElementById('successMessage').classList.add('active'); }
        function resetForm() { document.getElementById('formContent').style.display = 'block'; document.getElementById('successMessage').classList.remove('active'); document.querySelector('form').reset(); }
    
        function submitContactForm(e) {
            e.preventDefault();
            var form = e.target;
            var formData = new FormData(form);
            var submitBtn = form.querySelector('button[type=submit]');
            var originalText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
            submitBtn.disabled = true;
            
            fetch('send-contact.php', {
                method: 'POST',
                body: formData
            })
            .then(function(response) { return response.json(); })
            .then(function(data) {
                if (data.success) {
                    var formContent = document.getElementById('formContent');
                    var successMessage = document.getElementById('successMessage');
                    if (formContent && successMessage) {
                        formContent.style.display = 'none';
                        successMessage.classList.add('active');
                    } else {
                        alert('Message sent successfully!');
                        form.reset();
                    }
                } else {
                    alert(data.message || 'An error occurred. Please try again.');
                }
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            })
            .catch(function(error) {
                console.error('Error:', error);
                alert('An error occurred. Please try again.');
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            });
        }

    </script>
</body>
</html>
