<?php
/**
 * OmniCure Network - Shared Configuration
 * This config is shared across all cure sites
 *
 * BRANDS:
 * - OmniCure (parent) - All Glory to God
 * - GermCure - Disinfection & Hygiene
 * - FarmCure - Biosecurity & Animal Production
 * - TyreCure - Engineered for African Roads
 * - PestCure - Products & Services
 * - BakiCure - Driven By Excellence
 * - OilCure - Innovative Environmental Remediation
 * - WaterCure - Innovative Water Treatment
 * - HopeCure - Restoring Hope. Healing Lives. Advancing Gods Kingdom
 * - Gum Boots Africa - Powered By Dunlop Protective Footwear
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'multicure_db');
define('DB_USER', 'multicure_user');
define('DB_PASS', 'CHANGE_THIS_PASSWORD');

// Site Configuration
define('SITE_NAME', 'OmniCure Network');
define('BASE_URL', 'https://omnicure.co.za');
define('UPLOADS_PATH', __DIR__ . '/../uploads/');
define('UPLOADS_URL', BASE_URL . '/uploads/');

// Site URLs - All 10 brands
define('SITES', [
    'omnicure' => [
        'name' => 'OmniCure',
        'tagline' => 'All Glory To God',
        'url' => BASE_URL . '/',
        'description' => 'Your complete cure solutions network',
        'color' => '#2563eb'
    ],
    'germcure' => [
        'name' => 'GermCure',
        'tagline' => 'Disinfection & Hygiene',
        'url' => 'https://germcure.co.za/',
        'description' => 'Professional hygiene and sanitation solutions',
        'color' => '#2D8A6E'
    ],
    'farmcure' => [
        'name' => 'FarmCure',
        'tagline' => 'Biosecurity & Animal Production',
        'url' => 'https://farmcure.co.za/',
        'description' => 'Agricultural cleaning and disinfection solutions',
        'color' => '#16a34a'
    ],
    'tyrecure' => [
        'name' => 'TyreCure',
        'tagline' => 'Engineered For African Roads',
        'url' => BASE_URL . '/coming-soon.php?brand=tyrecure',
        'description' => 'Quality tyres for every vehicle',
        'color' => '#dc2626'
    ],
    'pestcure' => [
        'name' => 'PestCure',
        'tagline' => 'Products & Services',
        'url' => BASE_URL . '/coming-soon.php?brand=pestcure',
        'description' => 'Professional pest control products',
        'color' => '#ea580c'
    ],
    'bakicure' => [
        'name' => 'BakiCure',
        'tagline' => 'Driven By Excellence',
        'url' => BASE_URL . '/coming-soon.php?brand=bakicure',
        'description' => 'Premium bakkie accessories',
        'color' => '#374151'
    ],
    'oilcure' => [
        'name' => 'OilCure',
        'tagline' => 'Innovative Environmental Remediation',
        'url' => BASE_URL . '/coming-soon.php?brand=oilcure',
        'description' => 'Environmental oil remediation solutions',
        'color' => '#f97316'
    ],
    'watercure' => [
        'name' => 'WaterCure',
        'tagline' => 'Innovative Water Treatment',
        'url' => BASE_URL . '/coming-soon.php?brand=watercure',
        'description' => 'Water treatment and purification solutions',
        'color' => '#0ea5e9'
    ],
    'hopecure' => [
        'name' => 'HopeCure',
        'tagline' => 'Restoring Hope. Healing Lives. Advancing Gods Kingdom',
        'url' => BASE_URL . '/coming-soon.php?brand=hopecure',
        'description' => 'Advancing God\'s Kingdom through humanitarian aid',
        'color' => '#0ea5e9'
    ],
    'gumboots4africa' => [
        'name' => 'Gum Boots Africa',
        'tagline' => 'Powered By Dunlop Protective Footwear',
        'url' => 'https://dunlopboots.africa/',
        'external' => true,
        'description' => 'Protective footwear for Africa',
        'color' => '#16a34a'
    ]
]);

// Check if user is logged in as reseller
function isReseller() {
    return isset($_SESSION['reseller_logged_in']) && $_SESSION['reseller_logged_in'] === true;
}

// Get reseller info
function getResellerInfo() {
    if (isReseller()) {
        return [
            'id' => $_SESSION['reseller_id'] ?? null,
            'name' => $_SESSION['reseller_name'] ?? 'Reseller',
            'company' => $_SESSION['reseller_company'] ?? '',
            'discount' => $_SESSION['reseller_discount'] ?? 15
        ];
    }
    return null;
}

// Calculate reseller price
function getResellerPrice($regularPrice, $customDiscount = null) {
    if (!isReseller()) {
        return $regularPrice;
    }
    $discount = $customDiscount ?? ($_SESSION['reseller_discount'] ?? 15);
    return round($regularPrice * (1 - $discount / 100), 2);
}

// Format price for display
function formatPrice($price, $showReseller = true) {
    if (isReseller() && $showReseller) {
        return '<span class="reseller-price">R' . number_format($price, 2) . '</span>';
    }
    return 'R' . number_format($price, 2);
}

// Database connection function
function getDBConnection() {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        return $pdo;
    } catch (PDOException $e) {
        error_log("Database connection failed: " . $e->getMessage());
        return null;
    }
}

// CSRF Token functions
function generateCSRFToken() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function validateCSRFToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}
?>
