<?php
/**
 * Email Configuration for MultiCure Network
 * All domains use .co.za
 */

// Get email addresses for a specific brand
function getBrandEmails($brand) {
    $domain = $brand . '.co.za';
    
    $emails = [
        'info' => 'info@' . $domain,
        'cois' => 'cois@' . $domain, // Francois
        'admin' => 'admin@' . $domain,
        'quotes' => 'quotes@' . $domain,
        'sales' => 'sales@' . $domain,
    ];
    
    // Additional email for farmcure, germcure, pestcure
    if (in_array($brand, ['farmcure', 'germcure', 'pestcure'])) {
        $emails['mariaan'] = 'mariaan@' . $domain;
    }
    
    return $emails;
}

// Get quote recipients (quotes@ and sales@)
function getQuoteRecipients($brand) {
    $emails = getBrandEmails($brand);
    return [$emails['quotes'], $emails['sales']];
}

// Get general contact recipient
function getContactRecipient($brand) {
    $emails = getBrandEmails($brand);
    return $emails['info'];
}

// Send quote request email
function sendQuoteEmail($brand, $data) {
    $recipients = getQuoteRecipients($brand);
    $to = implode(', ', $recipients);
    $subject = "Quote Request from " . ucfirst($brand) . " Website";
    
    $message = "New Quote Request\n";
    $message .= "================\n\n";
    $message .= "Name: " . ($data['name'] ?? 'N/A') . "\n";
    $message .= "Email: " . ($data['email'] ?? 'N/A') . "\n";
    $message .= "Phone: " . ($data['phone'] ?? 'N/A') . "\n";
    $message .= "Company: " . ($data['company'] ?? 'N/A') . "\n\n";
    $message .= "Products/Services:\n" . ($data['products'] ?? 'N/A') . "\n\n";
    $message .= "Message:\n" . ($data['message'] ?? 'N/A') . "\n";
    
    $headers = "From: " . getContactRecipient($brand) . "\r\n";
    $headers .= "Reply-To: " . ($data['email'] ?? getContactRecipient($brand)) . "\r\n";
    
    return mail($to, $subject, $message, $headers);
}

// Send general contact email
function sendContactEmail($brand, $data) {
    $to = getContactRecipient($brand);
    $subject = "Contact Form - " . ucfirst($brand) . " Website";
    
    $message = "New Contact Form Submission\n";
    $message .= "===========================\n\n";
    $message .= "Name: " . ($data['name'] ?? 'N/A') . "\n";
    $message .= "Email: " . ($data['email'] ?? 'N/A') . "\n";
    $message .= "Phone: " . ($data['phone'] ?? 'N/A') . "\n";
    $message .= "Subject: " . ($data['subject'] ?? 'N/A') . "\n\n";
    $message .= "Message:\n" . ($data['message'] ?? 'N/A') . "\n";
    
    $headers = "From: " . $to . "\r\n";
    $headers .= "Reply-To: " . ($data['email'] ?? $to) . "\r\n";
    
    return mail($to, $subject, $message, $headers);
}
?>
