<?php
require_once __DIR__ . '/includes/config.php';

// Get brand from URL parameter
$brand = $_GET['brand'] ?? '';
$sites = SITES;

// Validate brand exists
if (!isset($sites[$brand]) || $brand === 'omnicure' || $brand === 'gumboots4africa') {
    header('Location: /');
    exit;
}

$site = $sites[$brand];
$brandColor = $site['color'];
$brandName = $site['name'];
$brandTagline = $site['tagline'];
$brandDescription = $site['description'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $brandName ?> - Coming Soon | OmniCure Network</title>
    <meta name="description" content="<?= $brandName ?> - <?= $brandDescription ?>. Coming soon to the OmniCure Network.">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --brand-color: <?= $brandColor ?>;
            --dark: #0f172a;
            --gray-600: #475569;
            --white: #fff;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            background: linear-gradient(135deg, var(--brand-color) 0%, color-mix(in srgb, var(--brand-color) 70%, #000) 100%);
            color: var(--white);
            overflow-x: hidden;
        }

        .bg-animation {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }
        .bg-animation span {
            position: absolute;
            display: block;
            width: 20px;
            height: 20px;
            background: rgba(255,255,255,0.1);
            animation: move 25s linear infinite;
            bottom: -150px;
            border-radius: 50%;
        }
        .bg-animation span:nth-child(1) { left: 25%; width: 80px; height: 80px; animation-delay: 0s; }
        .bg-animation span:nth-child(2) { left: 10%; width: 20px; height: 20px; animation-delay: 2s; animation-duration: 12s; }
        .bg-animation span:nth-child(3) { left: 70%; width: 20px; height: 20px; animation-delay: 4s; }
        .bg-animation span:nth-child(4) { left: 40%; width: 60px; height: 60px; animation-delay: 0s; animation-duration: 18s; }
        .bg-animation span:nth-child(5) { left: 65%; width: 20px; height: 20px; animation-delay: 0s; }
        .bg-animation span:nth-child(6) { left: 75%; width: 110px; height: 110px; animation-delay: 3s; }
        .bg-animation span:nth-child(7) { left: 35%; width: 150px; height: 150px; animation-delay: 7s; }
        .bg-animation span:nth-child(8) { left: 50%; width: 25px; height: 25px; animation-delay: 15s; animation-duration: 45s; }
        .bg-animation span:nth-child(9) { left: 20%; width: 15px; height: 15px; animation-delay: 2s; animation-duration: 35s; }
        .bg-animation span:nth-child(10) { left: 85%; width: 150px; height: 150px; animation-delay: 0s; animation-duration: 11s; }

        @keyframes move {
            0% { transform: translateY(0) rotate(0deg); opacity: 1; }
            100% { transform: translateY(-1000px) rotate(720deg); opacity: 0; }
        }

        .container { max-width: 800px; margin: 0 auto; padding: 0 32px; position: relative; z-index: 1; }

        .header {
            padding: 20px 0;
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            z-index: 10;
        }
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 32px;
        }
        .back-link {
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: color 0.3s;
        }
        .back-link:hover { color: white; }
        .omnicure-badge {
            background: rgba(255,255,255,0.15);
            padding: 8px 16px;
            border-radius: 50px;
            font-size: 12px;
            color: rgba(255,255,255,0.9);
            backdrop-filter: blur(10px);
        }

        .main {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            padding: 120px 0 80px;
        }

        .logo-container {
            background: white;
            width: 180px;
            height: 180px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            animation: pulse 2s ease-in-out infinite;
        }
        .logo-container img {
            height: 120px;
            width: auto;
            object-fit: contain;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
            50% { transform: scale(1.02); box-shadow: 0 25px 70px rgba(0,0,0,0.35); }
        }

        .tagline {
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 3px;
            opacity: 0.9;
            margin-bottom: 16px;
        }

        h1 {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 16px;
            text-shadow: 0 4px 20px rgba(0,0,0,0.2);
        }

        .coming-soon-badge {
            display: inline-block;
            background: rgba(255,255,255,0.2);
            backdrop-filter: blur(10px);
            padding: 12px 32px;
            border-radius: 50px;
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 24px;
            border: 2px solid rgba(255,255,255,0.3);
        }

        .description {
            font-size: 1.2rem;
            opacity: 0.9;
            max-width: 500px;
            margin: 0 auto 40px;
            line-height: 1.8;
        }

        .notify-section {
            background: rgba(255,255,255,0.1);
            backdrop-filter: blur(20px);
            padding: 32px;
            border-radius: 20px;
            max-width: 450px;
            margin: 0 auto;
            border: 1px solid rgba(255,255,255,0.2);
        }
        .notify-section h3 {
            font-size: 1.1rem;
            margin-bottom: 16px;
        }
        .notify-form {
            display: flex;
            gap: 12px;
        }
        .notify-form input {
            flex: 1;
            padding: 14px 20px;
            border: none;
            border-radius: 12px;
            font-family: inherit;
            font-size: 14px;
            outline: none;
        }
        .notify-form button {
            background: white;
            color: var(--brand-color);
            border: none;
            padding: 14px 24px;
            border-radius: 12px;
            font-family: inherit;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .notify-form button:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.3);
        }

        .footer {
            padding: 24px 0;
            text-align: center;
            position: relative;
            z-index: 1;
        }
        .footer p {
            font-size: 13px;
            opacity: 0.7;
        }
        .footer a {
            color: white;
            text-decoration: none;
        }
        .footer a:hover {
            text-decoration: underline;
        }

        @media (max-width: 768px) {
            h1 { font-size: 2.5rem; }
            .logo-container { width: 140px; height: 140px; }
            .logo-container img { height: 90px; }
            .notify-form { flex-direction: column; }
        }
    </style>
</head>
<body>
    <div class="bg-animation">
        <span></span><span></span><span></span><span></span><span></span>
        <span></span><span></span><span></span><span></span><span></span>
    </div>

    <header class="header">
        <div class="header-content">
            <a href="/" class="back-link">
                <i class="fas fa-arrow-left"></i> Back to OmniCure
            </a>
            <span class="omnicure-badge">Part of OmniCure Network</span>
        </div>
    </header>

    <main class="main">
        <div class="container">
            <div class="logo-container">
                <img src="/<?= $brand ?>/images/logo-icon.png" alt="<?= $brandName ?>" onerror="this.src='/uploads/logos/logos-no-background-<?= $brand ?>-long.png'">
            </div>
            <p class="tagline"><?= htmlspecialchars($brandTagline) ?></p>
            <h1><?= htmlspecialchars($brandName) ?></h1>
            <div class="coming-soon-badge">
                <i class="fas fa-rocket"></i> Coming Soon
            </div>
            <p class="description"><?= htmlspecialchars($brandDescription) ?>. We're working hard to bring you something amazing.</p>

            <div class="notify-section">
                <h3><i class="fas fa-bell"></i> Get Notified When We Launch</h3>
                <form class="notify-form" onsubmit="handleNotify(event)">
                    <input type="email" placeholder="Enter your email" required>
                    <button type="submit"><i class="fas fa-paper-plane"></i></button>
                </form>
            </div>
        </div>
    </main>

    <footer class="footer">
        <p>&copy; <?= date('Y') ?> <a href="/">OmniCure Network</a>. All Glory to God.</p>
    </footer>

    <script>
        function handleNotify(e) {
            e.preventDefault();
            const btn = e.target.querySelector('button');
            const input = e.target.querySelector('input');
            btn.innerHTML = '<i class="fas fa-check"></i>';
            input.value = '';
            input.placeholder = 'Thank you! We will notify you.';
            input.disabled = true;
            btn.disabled = true;
        }
    </script>
</body>
</html>
