<?php
require_once __DIR__ . '/includes/config.php';
$sites = SITES;
unset($sites['omnicure']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OmniCure Network - All Glory to God</title>
    <meta name="description" content="OmniCure Network - Your gateway to quality cure solutions across multiple industries. GermCure, FarmCure, TyreCure, PestCure, BakiCure.">
    <link rel="icon" type="image/png" href="/images/logo-icon.png">
    <link rel="apple-touch-icon" href="/images/logo-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #2563eb;
            --primary-dark: #1d4ed8;
            --secondary: #fbbf24;
            --dark: #0f172a;
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-600: #475569;
            --white: #fff;
            --gradient-hero: linear-gradient(135deg, #166534 0%, #0f766e 25%, #155e75 50%, #7c2d12 75%, #166534 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.15);
            --radius: 16px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }

        /* Header */
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 90px; }
        .nav { display: flex; align-items: center; gap: 16px; }
        .nav-links { display: flex; gap: 8px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 14px; padding: 10px 18px; border-radius: 10px; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 12px 24px; border-radius: 12px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 14px; white-space: nowrap; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-secondary { background: var(--secondary); color: var(--dark); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }

        /* Mobile Menu */
        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            font-size: 24px;
            color: var(--dark);
            cursor: pointer;
            padding: 8px;
        }
        .mobile-menu {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255,255,255,0.98);
            z-index: 2000;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 24px;
        }
        .mobile-menu.active { display: flex; }
        .mobile-menu-close {
            position: absolute;
            top: 20px;
            right: 20px;
            background: none;
            border: none;
            font-size: 32px;
            color: var(--dark);
            cursor: pointer;
        }
        .mobile-menu a {
            font-size: 20px;
            font-weight: 600;
            color: var(--dark);
            text-decoration: none;
            padding: 12px 24px;
        }
        .mobile-menu a:hover { color: var(--primary); }

        /* Hero Animations */
        @keyframes slideFromLeft {
            0% { transform: translateX(-100px) scale(0.8); opacity: 0; }
            100% { transform: translateX(0) scale(1); opacity: 1; }
        }
        @keyframes slideFromRight {
            0% { transform: translateX(100px) rotate(10deg); opacity: 0; }
            100% { transform: translateX(0) rotate(0); opacity: 1; }
        }
        @keyframes fadeInUp {
            0% { transform: translateY(30px); opacity: 0; }
            100% { transform: translateY(0); opacity: 1; }
        }
        @keyframes typing {
            from { max-width: 0; }
            to { max-width: 700px; }
        }
        @keyframes blink {
            50% { border-color: transparent; }
        }
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        @keyframes gradientShift {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* Hero */
        .hero {
            background: linear-gradient(-45deg, #166534, #0f766e, #155e75, #0891b2, #166534);
            background-size: 400% 400%;
            animation: gradientShift 15s ease infinite;
            padding: 180px 0 120px;
            text-align: center;
            color: white;
            position: relative;
            overflow: hidden;
        }
        .hero::before {
            content: '';
            position: absolute;
            top: -30%;
            right: -10%;
            width: 700px;
            height: 700px;
            background: radial-gradient(circle, rgba(251,191,36,0.15) 0%, transparent 60%);
            border-radius: 50%;
        }
        .hero::after {
            content: '';
            position: absolute;
            bottom: -20%;
            left: -10%;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(34,197,94,0.2) 0%, transparent 60%);
            border-radius: 50%;
        }
        .hero .container { position: relative; z-index: 1; }
        .hero-logo-container {
            display: inline-block;
            background: rgba(255,255,255,0.95);
            padding: 30px;
            border-radius: 24px;
            margin-bottom: 32px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            animation: slideFromLeft 1s ease-out forwards;
            overflow: hidden;
        }
        .hero-logo { 
            height: 140px; 
            display: block; 
            animation: slideFromRight 1s ease-out 0.3s forwards;
            opacity: 0;
        }
        .hero-logo-container:hover {
            animation: float 3s ease-in-out infinite;
        }
        .hero-tagline { 
            color: var(--secondary); 
            font-size: 20px; 
            font-weight: 700; 
            margin-bottom: 12px; 
            text-transform: uppercase; 
            letter-spacing: 2px;
            animation: fadeInUp 0.8s ease-out 0.8s forwards;
            opacity: 0;
        }
        .hero h1 { 
            font-size: 3.5rem; 
            font-weight: 800; 
            margin-bottom: 20px;
            opacity: 0;
            animation: fadeInUp 0.8s ease-out 1s forwards;
        }
        .hero-typing-wrapper {
            display: flex;
            justify-content: center;
            margin: 0 auto 36px;
        }
        .hero-typing {
            font-size: 1.3rem;
            opacity: 0.9;
            overflow: hidden;
            white-space: nowrap;
            border-right: 3px solid var(--secondary);
            max-width: 0;
            animation: typing 3s ease-out 1.5s forwards, blink 0.7s step-end infinite 1.5s;
        }
        .hero-btn {
            animation: fadeInUp 0.8s ease-out 4s forwards;
            opacity: 0;
        }

        /* Brands Section */
        .brands-section { padding: 100px 0; background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 800; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); font-size: 1.1rem; }
        .brands-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 32px; }
        .brand-card {
            background: white;
            border-radius: var(--radius);
            padding: 40px 24px;
            text-decoration: none;
            color: var(--dark);
            box-shadow: var(--shadow);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            border-top: 5px solid var(--brand-color);
            text-align: center;
        }
        .brand-card:hover { transform: translateY(-8px); box-shadow: var(--shadow-lg); }
        .brand-logo { height: 100px; margin-bottom: 24px; object-fit: contain; }
        .brand-card h3 { font-size: 1.3rem; margin-bottom: 12px; color: var(--dark); }
        .brand-card p { color: var(--gray-600); font-size: 14px; margin-bottom: 20px; }
        .brand-arrow { color: var(--brand-color); font-weight: 600; display: inline-flex; align-items: center; gap: 8px; }
        .brand-arrow i { transition: transform 0.2s; }
        .brand-card:hover .brand-arrow i { transform: translateX(4px); }

        /* Features */
        .features-section { padding: 100px 0; }
        .features-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 32px; }
        .feature-card { text-align: center; padding: 40px 24px; }
        .feature-icon { width: 80px; height: 80px; background: var(--gradient-hero); color: white; border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 32px; margin: 0 auto 24px; }
        .feature-card h3 { font-size: 1.2rem; margin-bottom: 12px; }
        .feature-card p { color: var(--gray-600); font-size: 14px; }

        /* CTA */
        .cta-section { background: linear-gradient(135deg, #166534 0%, #0f766e 50%, #155e75 100%); padding: 100px 0; text-align: center; color: white; }
        .cta-section h2 { font-size: 2.5rem; margin-bottom: 16px; }
        .cta-section p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }

        /* Footer */
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-brand { }
        .footer-icon-container {
            width: 140px;
            height: 140px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.3);
        }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); font-size: 14px; max-width: 200px; }
        .footer h4 { margin-bottom: 20px; font-size: 16px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: white; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; text-align: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }

        /* Responsive */
        @media (max-width: 1024px) {
            .brands-grid { grid-template-columns: repeat(2, 1fr); }
            .features-grid { grid-template-columns: repeat(2, 1fr); }
            .footer-grid { grid-template-columns: 1fr 1fr; }
        }
        @media (max-width: 768px) {
            .container { padding: 0 16px; }
            .hero { padding: 140px 0 80px; }
            .hero h1 { font-size: 2rem; }
            .hero-typing { font-size: 0.9rem; }
            .hero-logo-container { padding: 20px; }
            .hero-logo { height: 100px; }
            .brands-grid { grid-template-columns: 1fr; gap: 20px; }
            .features-grid { grid-template-columns: 1fr; }
            .brands-section, .features-section { padding: 60px 0; }
            .section-header h2 { font-size: 1.8rem; }
            .cta-section { padding: 60px 0; }
            .cta-section h2 { font-size: 1.8rem; }
            .nav-links { display: none; }
            .nav .btn-outline { display: none; }
            .mobile-menu-btn { display: block; }
            .footer-grid { grid-template-columns: 1fr; gap: 32px; text-align: center; }
            .footer-icon-container { margin: 0 auto 20px; width: 100px; height: 100px; }
            .footer-icon-container img { height: 70px; }
            .footer-brand p { max-width: 100%; }
            .logo img { height: 60px; }
            .header-content { padding: 8px 0; }
        }
        @media (max-width: 480px) {
            .hero h1 { font-size: 1.6rem; }
            .hero-tagline { font-size: 14px; letter-spacing: 1px; }
            .hero-logo-container { padding: 16px; }
            .hero-logo { height: 80px; }
            .btn { padding: 10px 20px; font-size: 13px; }
            .brand-card { padding: 24px 16px; }
            .brand-logo { height: 70px; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo">
                    <img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="/" class="active">Home</a></li>
                        <li><a href="/about.php">About Us</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                    <a href="/contact.php" class="btn btn-outline"><i class="fas fa-envelope"></i> Contact Us</a>
                    <button class="mobile-menu-btn" onclick="document.getElementById('mobileMenu').classList.add('active')">
                        <i class="fas fa-bars"></i>
                    </button>
                </nav>
            </div>
        </div>
    </header>

    <!-- Mobile Menu Overlay -->
    <div id="mobileMenu" class="mobile-menu">
        <button class="mobile-menu-close" onclick="document.getElementById('mobileMenu').classList.remove('active')">
            <i class="fas fa-times"></i>
        </button>
        <a href="/" onclick="document.getElementById('mobileMenu').classList.remove('active')">Home</a>
        <a href="/about.php" onclick="document.getElementById('mobileMenu').classList.remove('active')">About Us</a>
        <a href="/contact.php" onclick="document.getElementById('mobileMenu').classList.remove('active')">Contact</a>
    </div>

    <section class="hero">
        <div class="container">
            <div class="hero-logo-container">
                <img src="/uploads/logos/omnicure-logo-square.png" alt="OmniCure" class="hero-logo">
            </div>
            <p class="hero-tagline">All Glory to God</p>
            <h1>Welcome to OmniCure</h1>
            <div class="hero-typing-wrapper">
                <p class="hero-typing">Quality cure solutions for South Africa.</p>
            </div>
            <div class="hero-btn">
                <a href="#brands" class="btn btn-secondary"><i class="fas fa-th-large"></i> Explore Our Brands</a>
            </div>
        </div>
    </section>

    <section class="brands-section" id="brands">
        <div class="container">
            <div class="section-header">
                <h2>Our Family of Brands</h2>
                <p>Each brand specializes in delivering excellence within its industry.</p>
            </div>
            <div class="brands-grid">
                <?php foreach ($sites as $key => $site):
                    $isExternal = !empty($site['external']);
                    $linkUrl = $site['url'];
                    $targetAttr = $isExternal ? ' target="_blank" rel="noopener noreferrer"' : '';
                ?>
                <a href="<?php echo $linkUrl; ?>" class="brand-card"<?php echo $targetAttr; ?> style="--brand-color: <?php echo $site['color']; ?>;">
                    <?php
                    $pngFile = __DIR__ . "/uploads/logos/logos-no-background-{$key}-long.png";
                    $svgFile = __DIR__ . "/uploads/logos/{$key}-placeholder.svg";
                    if (file_exists($pngFile)) {
                        $logoPath = "/uploads/logos/logos-no-background-{$key}-long.png";
                    } elseif (file_exists($svgFile)) {
                        $logoPath = "/uploads/logos/{$key}-placeholder.svg";
                    } else {
                        $logoPath = "/uploads/logos/logos-no-background-{$key}-long.png";
                    }
                    ?>
                    <img src="<?php echo $logoPath; ?>" alt="<?php echo $site['name']; ?>" class="brand-logo">
                    <h3><?php echo $site['name']; ?></h3>
                    <p><?php echo $site['description']; ?></p>
                    <span class="brand-arrow"><?php echo $isExternal ? 'Visit Partner' : 'Visit Site'; ?> <i class="fas fa-arrow-right"></i></span>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
    </section>


    <section class="features-section">
        <div class="container">
            <div class="section-header">
                <h2>Why Choose OmniCure Network?</h2>
                <p>Benefits of partnering with our family of brands.</p>
            </div>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-medal"></i></div>
                    <h3>Quality Assured</h3>
                    <p>All products meet the highest industry standards and certifications.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-truck"></i></div>
                    <h3>Nationwide Delivery</h3>
                    <p>Fast and reliable delivery across South Africa.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-handshake"></i></div>
                    <h3>Partner Program</h3>
                    <p>Competitive bulk pricing and support for business partners.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-headset"></i></div>
                    <h3>Expert Support</h3>
                    <p>Dedicated customer service and technical assistance.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="cta-section">
        <div class="container">
            <h2>Ready to Partner With Us?</h2>
            <p>Contact us for bulk orders, special pricing, or product inquiries.</p>
            <a href="/contact.php" class="btn btn-secondary"><i class="fas fa-envelope"></i> Get in Touch</a>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-icon-container">
                        <img src="/images/logo-icon.png" alt="OmniCure">
                    </div>
                    <p class="footer-tagline">All Glory to God</p>
                    <p>Your complete cure<br>solutions network.</p>
                </div>
                <div>
                    <h4>Our Brands</h4>
                    <ul class="footer-links">
                        <?php foreach ($sites as $key => $site):
                            $isExt = !empty($site['external']);
                            $tgt = $isExt ? ' target="_blank"' : '';
                        ?>
                        <li><a href="<?php echo $site['url']; ?>"<?php echo $tgt; ?>><?php echo $site['name']; ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div>
                    <h4>Quick Links</h4>
                    <ul class="footer-links">
                        <li><a href="/about.php">About Us</a></li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Contact</h4>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 8px;"><i class="fas fa-phone"></i> 082 805 0405</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@omnicure.co.za</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> OmniCure Network. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html>
