<?php require_once __DIR__ . '/includes/config.php'; $sites = SITES; unset($sites['omnicure']); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us | OmniCure Network</title>
    <meta name="description" content="Learn about OmniCure Network - South Africa's trusted family of cure brands serving multiple industries.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #2563eb; --primary-dark: #1d4ed8; --secondary: #fbbf24; --dark: #0f172a; --gray-50: #f8fafc; --gray-100: #f1f5f9; --gray-200: #e2e8f0; --gray-600: #475569; --white: #fff; --gradient-hero: linear-gradient(135deg, #1e3a5f 0%, #2563eb 50%, #1d4ed8 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 16px 0; }
        .logo img { height: 70px; }
        .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 14px; padding: 10px 18px; border-radius: 10px; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 14px 28px; border-radius: 12px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 15px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-secondary { background: var(--secondary); color: var(--dark); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-hero { background: var(--gradient-hero); padding: 160px 0 100px; text-align: center; color: white; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }
        .about-section { padding: 80px 0; }
        .about-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .about-content h2 { font-size: 2rem; margin-bottom: 20px; }
        .about-content p { color: var(--gray-600); margin-bottom: 16px; }
        .about-image { background: linear-gradient(135deg, var(--gray-100) 0%, var(--gray-200) 100%); border-radius: var(--radius); height: 400px; display: flex; align-items: center; justify-content: center; }
        .about-image i { font-size: 8rem; color: var(--primary); opacity: 0.3; }
        .mission-section { padding: 80px 0; background: var(--gray-50); }
        .mission-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 32px; }
        .mission-card { background: white; padding: 40px 32px; border-radius: var(--radius); box-shadow: var(--shadow); text-align: center; }
        .mission-icon { width: 80px; height: 80px; background: var(--gradient-hero); color: white; border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 32px; margin: 0 auto 24px; }
        .mission-card h3 { font-size: 1.3rem; margin-bottom: 12px; }
        .mission-card p { color: var(--gray-600); }
        .brands-overview { padding: 80px 0; }
        .section-header { text-align: center; margin-bottom: 48px; }
        .section-header h2 { font-size: 2rem; margin-bottom: 12px; }
        .section-header p { color: var(--gray-600); }
        .brands-list { display: grid; grid-template-columns: repeat(5, 1fr); gap: 24px; }
        .brand-item { background: var(--gray-50); padding: 32px; border-radius: var(--radius); text-align: center; transition: all 0.3s; text-decoration: none; color: var(--dark); }
        .brand-item:hover { transform: translateY(-4px); box-shadow: var(--shadow); }
        .brand-item img { height: 50px; margin-bottom: 12px; }
        .brand-item h4 { font-size: 1rem; margin-bottom: 4px; }
        .brand-item span { color: var(--gray-600); font-size: 13px; }
        .cta-section { background: var(--gradient-hero); padding: 80px 0; text-align: center; color: white; }
        .cta-section h2 { font-size: 2rem; margin-bottom: 16px; }
        .cta-section p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 40px; }
        .footer-logo-container { background: rgba(255,255,255,0.95); padding: 16px 24px; border-radius: 12px; display: inline-block; }
        .footer-logo-container img { height: 50px; display: block; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; text-align: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        @media (max-width: 1024px) { .about-grid { grid-template-columns: 1fr; } .mission-grid { grid-template-columns: 1fr; } .brands-list { grid-template-columns: repeat(3, 1fr); } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .brands-list { grid-template-columns: repeat(2, 1fr); } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></a>
        <nav><ul class="nav-links"><li><a href="/">Home</a></li><li><a href="/about.php" class="active">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul>
        <a href="/contact.php" class="btn btn-outline"><i class="fas fa-envelope"></i> Contact Us</a></nav>
    </div></div></header>

    <section class="page-hero"><div class="container"><h1>About OmniCure</h1><p>A family of brands united by a commitment to quality and excellence.</p></div></section>

    <section class="about-section"><div class="container"><div class="about-grid">
        <div class="about-content">
            <h2>All Glory to God</h2>
            <p>OmniCure Network was founded with a clear vision: to provide South African businesses and consumers with access to quality products across multiple industries, all under one trusted umbrella.</p>
            <p>Our network of specialized brands allows us to focus on excellence in each sector while maintaining the high standards and reliable service that our customers depend on.</p>
            <p>From hygiene solutions to agricultural products, from tyres to pest control, and bakkie accessories - OmniCure Network has you covered with products you can trust.</p>
        </div>
        <div class="about-image"><i class="fas fa-network-wired"></i></div>
    </div></div></section>

    <section class="mission-section"><div class="container">
        <div class="section-header"><h2>Our Values</h2><p>The principles that guide everything we do.</p></div>
        <div class="mission-grid">
            <div class="mission-card"><div class="mission-icon"><i class="fas fa-star"></i></div><h3>Excellence</h3><p>We never compromise on quality. Every product in our network meets the highest standards.</p></div>
            <div class="mission-card"><div class="mission-icon"><i class="fas fa-hands-helping"></i></div><h3>Service</h3><p>Our customers are at the heart of everything we do. We're here to help you succeed.</p></div>
            <div class="mission-card"><div class="mission-icon"><i class="fas fa-pray"></i></div><h3>Faith</h3><p>All Glory to God. Our faith guides our business practices and relationships.</p></div>
        </div>
    </div></section>

    <section class="brands-overview"><div class="container">
        <div class="section-header"><h2>Our Brands</h2><p>Each brand specializes in its industry while sharing our commitment to quality.</p></div>
        <div class="brands-list">
            <?php foreach ($sites as $key => $site): ?>
            <a href="/<?php echo $key; ?>/" class="brand-item">
                <img src="/uploads/logos/logos-no-background-<?php echo $key; ?>-long.png" alt="<?php echo $site['name']; ?>">
                <h4><?php echo $site['name']; ?></h4>
                <span><?php echo $site['tagline']; ?></span>
            </a>
            <?php endforeach; ?>
        </div>
    </div></section>

    <section class="cta-section"><div class="container">
        <h2>Partner With Us</h2>
        <p>Have questions about our products or interested in partnering with us?</p>
        <a href="/contact.php" class="btn btn-secondary"><i class="fas fa-envelope"></i> Contact Us</a>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand"><div class="footer-logo-container"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure" style="height: 50px;"></div><p>All Glory to God. Your complete cure solutions network.</p></div>
            <div><h4>Our Brands</h4><ul class="footer-links"><?php foreach ($sites as $key => $site): ?><li><a href="/<?php echo $key; ?>/"><?php echo $site['name']; ?></a></li><?php endforeach; ?></ul></div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/about.php">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul></div>
            <div><h4>Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-phone"></i> 082 805 0405</p><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@omnicure.co.za</p></div>
        </div>
        <div class="footer-bottom"><p>&copy; <?= date('Y') ?> OmniCure Network. All rights reserved.</p></div>
    </div></footer>
</body>
</html>
