<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us | PestCure - Professional Pest Control Products South Africa</title>
    <meta name="description" content="Learn about PestCure - South Africa's trusted supplier of professional pest control products from Ensystex and Coopers Environmental Science.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #ea580c; --primary-dark: #c2410c; --secondary: #84cc16; --dark: #1c1917; --gray-50: #fafaf9; --gray-100: #f5f5f4; --gray-600: #57534e; --white: #fff; --gradient-hero: linear-gradient(135deg, #9a3412 0%, #ea580c 50%, #c2410c 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; --ensystex: #1e5631; --coopers: #1a4480; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 80px; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 10px 18px; border-radius: 12px; font-weight: 600; text-decoration: none; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-hero { background: linear-gradient(rgba(154, 52, 18, 0.85), rgba(194, 65, 12, 0.9)), url(/images/pestcure-about-banner.png); background-size: cover; background-position: center; padding: 160px 0 100px; text-align: center; color: white; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 700px; margin: 0 auto; }
        .section { padding: 80px 0; }
        .section-alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 48px; }
        .section-badge { display: inline-block; background: rgba(234,88,12,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.2rem; font-weight: 700; margin-bottom: 12px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .story-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .story-content h2 { font-size: 2rem; margin-bottom: 20px; }
        .story-content p { color: var(--gray-600); margin-bottom: 16px; }
        .story-image { background: var(--gradient-hero); border-radius: var(--radius); height: 350px; display: flex; align-items: center; justify-content: center; }
        .story-image i { font-size: 6rem; color: rgba(255,255,255,0.3); }
        .suppliers-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 40px; }
        .supplier-card { background: white; border-radius: var(--radius); padding: 40px; box-shadow: var(--shadow); transition: all 0.3s; }
        .supplier-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); }
        .supplier-header { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
        .supplier-icon { width: 60px; height: 60px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 24px; color: white; }
        .supplier-icon.ensystex { background: var(--ensystex); }
        .supplier-icon.coopers { background: var(--coopers); }
        .supplier-header h3 { font-size: 1.3rem; }
        .supplier-header span { display: block; color: var(--gray-600); font-size: 13px; }
        .supplier-card p { color: var(--gray-600); font-size: 14px; margin-bottom: 16px; }
        .supplier-features { list-style: none; margin-bottom: 24px; }
        .supplier-features li { padding: 8px 0; color: var(--gray-600); font-size: 14px; display: flex; align-items: center; gap: 10px; }
        .supplier-features li i { color: var(--secondary); }
        .supplier-link { color: var(--primary); font-weight: 600; font-size: 14px; text-decoration: none; display: inline-flex; align-items: center; gap: 6px; }
        .supplier-link:hover { text-decoration: underline; }
        .values-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .value-card { background: white; padding: 32px 24px; border-radius: var(--radius); text-align: center; box-shadow: var(--shadow); }
        .value-card i { font-size: 2rem; color: var(--primary); margin-bottom: 16px; }
        .value-card h3 { font-size: 1.1rem; margin-bottom: 10px; }
        .value-card p { color: var(--gray-600); font-size: 13px; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 40px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { max-height: 80px; max-width: 80px; object-fit: contain; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .story-grid { grid-template-columns: 1fr; } .suppliers-grid { grid-template-columns: 1fr; } .values-grid { grid-template-columns: repeat(2, 1fr); } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .values-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" alt="PestCure"></a>
        <nav class="nav"><ul class="nav-links"><li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li><li><a href="/">Home</a></li><li><a href="/products.php">Products</a></li><li><a href="/about.php" class="active">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
    </div></div></header>

    <section class="page-hero"><div class="container">
        <h1>About PestCure</h1>
        <p>South Africa's trusted supplier of professional pest control products from industry-leading manufacturers Ensystex and Coopers Environmental Science.</p>
    </div></section>

    <section class="section"><div class="container"><div class="story-grid">
        <div class="story-content">
            <h2>Your Professional Pest Control Partner</h2>
            <p>PestCure was established to provide South African pest control professionals, facility managers, and homeowners with access to the best pest management products available in the market.</p>
            <p>We partner exclusively with industry-leading suppliers Ensystex and Coopers Environmental Science to bring you environmentally responsible, effective, and long-lasting pest control solutions.</p>
            <p>From termite colony elimination systems to professional rodenticides, we offer comprehensive solutions for every pest control challenge.</p>
        </div>
        <div class="story-image" style="background: none;"><img src="/images/pestcure-about-inspection.png" alt="Professional Pest Inspection" style="width: 100%; height: 100%; object-fit: cover; border-radius: 16px;"></div>
    </div></div></section>

    <!-- SUPPLIER PARTNERSHIPS -->
    <section class="section section-alt"><div class="container">
        <div class="section-header">
            <span class="section-badge">Our Partners</span>
            <h2>Industry-Leading Suppliers</h2>
            <p>We partner with South Africa's most trusted pest control product manufacturers.</p>
        </div>
        <div class="suppliers-grid">
            <div class="supplier-card">
                <div class="supplier-header">
                    <div class="supplier-icon ensystex"><i class="fas fa-leaf"></i></div>
                    <div><h3>Ensystex South Africa</h3><span>Environmentally Responsible Solutions</span></div>
                </div>
                <p>Ensystex's vision is to be the first choice for environmentally responsible, effective, long-term pest management solutions. Their water-based formulations provide effective pest control while minimizing environmental impact.</p>
                <ul class="supplier-features">
                    <li><i class="fas fa-check"></i> EXTERRA Termite Colony Elimination System</li>
                    <li><i class="fas fa-check"></i> Water-based termiticides (MAXXTHOR, PROTHOR, ULTRATHOR)</li>
                    <li><i class="fas fa-check"></i> Professional insecticides (AEROTHOR, ATTRATHOR, BITHOR)</li>
                    <li><i class="fas fa-check"></i> Cockroach gel baits (BLATTATHOR ULTRA)</li>
                    <li><i class="fas fa-check"></i> Insect growth regulators (CULITHOR, EXOTHOR)</li>
                </ul>
                <a href="https://ensystex.co.za" target="_blank" class="supplier-link">Visit Ensystex <i class="fas fa-external-link-alt"></i></a>
            </div>
            <div class="supplier-card">
                <div class="supplier-header">
                    <div class="supplier-icon coopers"><i class="fas fa-flask"></i></div>
                    <div><h3>Coopers Environmental Science</h3><span>Premium Quality Products Since 1999</span></div>
                </div>
                <p>Established in 1999, Coopers Environmental Science strives to supply high quality products at competitive prices. With offices across South Africa, they provide comprehensive pest control solutions for domestic and professional applications.</p>
                <ul class="supplier-features">
                    <li><i class="fas fa-check"></i> Selontra professional rodenticide</li>
                    <li><i class="fas fa-check"></i> ProRoach Gel cockroach bait</li>
                    <li><i class="fas fa-check"></i> Ultrakill Termite Control SC</li>
                    <li><i class="fas fa-check"></i> Promethrin EC insecticide concentrate</li>
                    <li><i class="fas fa-check"></i> Professional application equipment</li>
                </ul>
                <a href="https://www.cooperses.com" target="_blank" class="supplier-link">Visit Coopers ES <i class="fas fa-external-link-alt"></i></a>
            </div>
        </div>
    </div></section>

    <section class="section"><div class="container">
        <div class="section-header">
            <span class="section-badge">Why Choose Us</span>
            <h2>Our Commitment to You</h2>
        </div>
        <div class="values-grid">
            <div class="value-card"><i class="fas fa-leaf"></i><h3>Environmentally Responsible</h3><p>Water-based and eco-friendly formulations from leading suppliers.</p></div>
            <div class="value-card"><i class="fas fa-certificate"></i><h3>Professional Grade</h3><p>Products trusted by pest control professionals across South Africa.</p></div>
            <div class="value-card"><i class="fas fa-tags"></i><h3>Competitive Pricing</h3><p>Best prices on professional pest control products.</p></div>
            <div class="value-card"><i class="fas fa-headset"></i><h3>Expert Support</h3><p>Technical advice on product selection and application methods.</p></div>
        </div>
    </div></section>

    <section class="section section-alt"><div class="container"><div class="story-grid">
        <div class="story-image" style="background: none;"><img src="/images/pestcure-about-eco.png" alt="Eco-Friendly Products" style="width: 100%; height: 100%; object-fit: cover; border-radius: 16px;"></div>
        <div class="story-content">
            <h2>Comprehensive Pest Solutions</h2>
            <p>We offer a complete range of pest control products covering termite management, crawling insect control, flying insect solutions, rodent management, and professional application equipment.</p>
            <p>Whether you need environmentally responsible termite colony elimination with the EXTERRA system, fast-acting rodent control with Selontra, or professional fogging equipment, PestCure has the right solution.</p>
            <p>Our team can help you select the right products for your specific pest problems and provide guidance on effective application methods.</p>
        </div>
    </div></div></section>

    <section style="padding: 80px 0; background: var(--gradient-hero); text-align: center; color: white;"><div class="container">
        <h2 style="font-size: 2.2rem; margin-bottom: 16px;">Ready to Get Started?</h2>
        <p style="opacity: 0.9; margin-bottom: 32px; max-width: 600px; margin-left: auto; margin-right: auto;">Contact us for expert advice and quotes on professional pest control products from South Africa's leading suppliers.</p>
        <a href="/contact.php" class="btn" style="background: white; color: var(--primary);"><i class="fas fa-envelope"></i> Contact Us</a>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand"><div class="footer-icon-container"><img src="/images/logo-icon.png" alt="PestCure"></div><p class="footer-tagline">Pest Control</p>
                    <p>Professional pest control<br>solutions from leading suppliers.</p></div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/products.php">Products</a></li><li><a href="/about.php">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul></div>
            <div><h4>Products</h4><ul class="footer-links"><li><a href="/products.php#termite">Termite Control</a></li><li><a href="/products.php#crawling">Crawling Insects</a></li><li><a href="/products.php#flying">Flying Insects</a></li><li><a href="/products.php#rodent">Rodent Control</a></li><li><a href="/products.php#equipment">Equipment</a></li></ul></div>
            <div><h4>Our Suppliers</h4><ul class="footer-links"><li><a href="https://ensystex.co.za" target="_blank">Ensystex SA</a></li><li><a href="https://www.cooperses.com" target="_blank">Coopers ES</a></li></ul><h4 style="margin-top: 24px;">Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@pestcure.co.za</p></div>
        </div>
        <div class="footer-bottom"><p>&copy; <?= date('Y') ?> PestCure. All rights reserved.</p><a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a></div>
    </div></footer>
</body>
</html>
