<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PestCure - Professional Pest Control Solutions | South Africa</title>
    <meta name="description" content="PestCure supplies professional pest control products from Ensystex and Coopers ES - termiticides, insecticides, rodenticides, and application equipment across South Africa.">
    <link rel="icon" type="image/x-icon" href="/pestcure/favicon.ico">
    <link rel="apple-touch-icon" href="/pestcure/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #ea580c; --primary-dark: #c2410c; --secondary: #84cc16; --dark: #1c1917; --gray-50: #fafaf9; --gray-100: #f5f5f4; --gray-200: #e7e5e4; --gray-600: #57534e; --white: #fff; --gradient-hero: linear-gradient(135deg, #9a3412 0%, #ea580c 50%, #c2410c 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; --ensystex: #1e5631; --coopers: #1a4480; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 80px; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-white { background: white; color: var(--primary); }
        .btn-lg { padding: 14px 28px; font-size: 15px; }
        .hero { background: var(--gradient-hero); padding: 160px 0 100px; color: white; position: relative; overflow: hidden; }
        .hero::before { content: ''; position: absolute; top: -50%; right: -20%; width: 800px; height: 800px; background: radial-gradient(circle, rgba(132,204,22,0.15) 0%, transparent 70%); border-radius: 50%; }
        .hero .container { position: relative; z-index: 1; display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; }
        .hero-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.15); padding: 8px 16px; border-radius: 50px; font-size: 14px; margin-bottom: 20px; }
        .hero h1 { font-size: 3.2rem; font-weight: 800; margin-bottom: 20px; line-height: 1.1; }
        .hero p { font-size: 1.2rem; opacity: 0.9; margin-bottom: 32px; }
        .hero-buttons { display: flex; gap: 16px; flex-wrap: wrap; }
        .hero-image { text-align: center; display: flex; align-items: center; justify-content: center; }
        .hero-image img { max-width: 500px; height: auto; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
        .suppliers { padding: 60px 0; background: var(--gray-50); }
        .suppliers-inner { display: flex; justify-content: center; align-items: center; gap: 60px; flex-wrap: wrap; }
        .supplier-item { display: flex; align-items: center; gap: 12px; color: var(--gray-600); font-size: 14px; font-weight: 500; }
        .supplier-item i { font-size: 24px; }
        .supplier-item.ensystex i { color: var(--ensystex); }
        .supplier-item.coopers i { color: var(--coopers); }
        .products { padding: 100px 0; }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-block; background: rgba(234,88,12,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .products-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .product-card { background: var(--gray-50); border-radius: var(--radius); padding: 32px; text-align: center; box-shadow: var(--shadow); transition: all 0.3s; text-decoration: none; color: inherit; }
        .product-card:hover { transform: translateY(-8px); box-shadow: var(--shadow-lg); background: white; }
        .product-icon { width: 100px; height: 100px; border-radius: 20px; display: flex; align-items: center; justify-content: center; margin: 0 auto 20px; overflow: hidden; } .product-icon img { width: 100%; height: 100%; object-fit: cover; border-radius: 20px; }
        .product-card h3 { font-size: 1.2rem; margin-bottom: 10px; }
        .product-card p { color: var(--gray-600); font-size: 14px; margin-bottom: 16px; }
        .product-link { color: var(--primary); font-weight: 600; font-size: 14px; }
        .pests { padding: 100px 0; background: var(--gray-50); }
        .pests-grid { display: grid; grid-template-columns: repeat(6, 1fr); gap: 20px; }
        .pest-item { background: white; padding: 24px; border-radius: 12px; text-align: center; box-shadow: var(--shadow); }
        .pest-item i { font-size: 32px; color: var(--primary); margin-bottom: 12px; }
        .pest-item .pest-emoji { font-size: 36px; display: block; margin-bottom: 12px; }
        .pest-item span { display: block; font-size: 13px; font-weight: 500; color: var(--gray-600); }
        .features { padding: 100px 0; }
        .features-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 32px; }
        .feature-card { text-align: center; padding: 40px 24px; background: var(--gray-50); border-radius: var(--radius); }
        .feature-icon { width: 70px; height: 70px; background: var(--gradient-hero); color: white; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 28px; margin: 0 auto 20px; }
        .feature-card h3 { font-size: 1.1rem; margin-bottom: 10px; }
        .feature-card p { color: var(--gray-600); font-size: 13px; }
        .cta { background: var(--gradient-hero); padding: 100px 0; text-align: center; color: white; }
        .cta h2 { font-size: 2.5rem; margin-bottom: 16px; }
        .cta p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 48px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { max-height: 80px; max-width: 80px; object-fit: contain; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-links a:hover { color: var(--secondary); }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .hero .container { grid-template-columns: 1fr; text-align: center; } .hero-image { display: none; } .products-grid { grid-template-columns: repeat(2, 1fr); } .pests-grid { grid-template-columns: repeat(3, 1fr); } .features-grid { grid-template-columns: repeat(2, 1fr); } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 1280px) { .products-grid { grid-template-columns: repeat(3, 1fr); } }
        @media (max-width: 768px) { .products-grid { grid-template-columns: 1fr; } .pests-grid { grid-template-columns: repeat(2, 1fr); } .features-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } .footer-bottom { flex-direction: column; gap: 16px; } .suppliers-inner { gap: 30px; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/pestcure/" class="logo"><img src="/pestcure/images/logo-long.png" alt="PestCure"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/pestcure/">Home</a></li>
                <li><a href="/pestcure/products.php">Products</a></li>
                <li><a href="/pestcure/about.php">About Us</a></li>
                <li><a href="/pestcure/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <section class="hero">
        <div class="container">
            <div>
                <div class="hero-badge"><i class="fas fa-bug"></i> Professional Pest Control</div>
                <h1>Professional Pest Control Solutions</h1>
                <p>South Africa's source for professional-grade pest control products from industry-leading suppliers Ensystex and Coopers Environmental Science.</p>
                <div class="hero-buttons">
                    <a href="/pestcure/products.php" class="btn btn-white btn-lg"><i class="fas fa-spray-can"></i> View Products</a>
                    <a href="/pestcure/contact.php" class="btn btn-outline btn-lg" style="border-color: white; color: white;"><i class="fas fa-envelope"></i> Get Quote</a>
                </div>
            </div>
            <div class="hero-image"><img src="/pestcure/images/pestcure-hero.png" alt="Professional Pest Control" style="max-width: 100%; height: auto; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);"></div>
        </div>
    </section>

    <section class="suppliers"><div class="container">
        <div class="suppliers-inner">
            <div class="supplier-item ensystex"><i class="fas fa-leaf"></i><span><strong>Ensystex</strong> - Environmentally Responsible Solutions</span></div>
            <div class="supplier-item coopers"><i class="fas fa-flask"></i><span><strong>Coopers ES</strong> - Premium Quality Products</span></div>
        </div>
    </div></section>

    <section class="products"><div class="container">
        <div class="section-header">
            <span class="section-badge">Our Products</span>
            <h2>Comprehensive Pest Control Range</h2>
            <p>Professional-grade products for every pest control application from termite management to rodent control.</p>
        </div>
        <div class="products-grid">
            <a href="/pestcure/products.php#termite" class="product-card">
                <div class="product-icon"><img src="/pestcure/images/pestcure-termite.png" alt="Termite Control"></div>
                <h3>Termite Control</h3>
                <p>Colony elimination systems, water-based termiticides, and soil treatment solutions from Ensystex.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/pestcure/products.php#crawling" class="product-card">
                <div class="product-icon"><img src="/pestcure/images/pestcure-crawling.png" alt="Crawling Insects"></div>
                <h3>Crawling Insects</h3>
                <p>Sprays, gel baits, and targeted insecticides for cockroaches, ants, spiders, and more.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/pestcure/products.php#flying" class="product-card">
                <div class="product-icon"><img src="/pestcure/images/pestcure-flying.png" alt="Flying Insects"></div>
                <h3>Flying Insects</h3>
                <p>Concentrates, larvicides, fly units, and fogging solutions for flies and mosquitoes.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/pestcure/products.php#rodent" class="product-card">
                <div class="product-icon"><img src="/pestcure/images/pestcure-rodent.png" alt="Rodent Control"></div>
                <h3>Rodent Control</h3>
                <p>Professional rodenticides, bait stations, and traps for rats and mice management.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/pestcure/products.php#growth-regulators" class="product-card">
                <div class="product-icon"><img src="/pestcure/images/pestcure-igr.png" alt="Growth Regulators"></div>
                <h3>Growth Regulators</h3>
                <p>IGR products that disrupt pest development cycles for long-term control solutions.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/pestcure/products.php#equipment" class="product-card">
                <div class="product-icon"><img src="/pestcure/images/pestcure-equipment.png" alt="Equipment"></div>
                <h3>Equipment</h3>
                <p>Professional sprayers, foggers, and application accessories for pest control operations.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/pestcure/products.php#fly-units" class="product-card">
                <div class="product-icon" style="background: var(--gray-100);"><i class="fas fa-lightbulb" style="font-size: 3rem; color: var(--primary); opacity: 0.6;"></i></div>
                <h3>Fly Units</h3>
                <p>Commercial UV fly traps and ILT units from Coopers for professional indoor fly control.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
            <a href="/pestcure/products.php#ppe" class="product-card">
                <div class="product-icon" style="background: var(--gray-100);"><i class="fas fa-user-shield" style="font-size: 3rem; color: var(--primary); opacity: 0.6;"></i></div>
                <h3>Safety & PPE</h3>
                <p>Respirators, protective suits, and filter cartridges for safe pest control applications.</p>
                <span class="product-link">View Range <i class="fas fa-arrow-right"></i></span>
            </a>
        </div>
    </div></section>

    <section class="pests"><div class="container">
        <div class="section-header">
            <span class="section-badge">Common Pests</span>
            <h2>Solutions for Every Pest Problem</h2>
            <p>We supply products to control a wide range of pest species.</p>
        </div>
        <div class="pests-grid">
            <div class="pest-item"><span class="pest-emoji">🪳</span><span>Cockroaches</span></div>
            <div class="pest-item"><span class="pest-emoji">🕷️</span><span>Spiders</span></div>
            <div class="pest-item"><span class="pest-emoji">🦟</span><span>Mosquitoes</span></div>
            <div class="pest-item"><span class="pest-emoji">🐜</span><span>Ants</span></div>
            <div class="pest-item"><span class="pest-emoji">🐀</span><span>Rats & Mice</span></div>
            <div class="pest-item"><span class="pest-emoji">🪲</span><span>Termites</span></div>
        </div>
    </div></section>

    <section class="features"><div class="container">
        <div class="section-header">
            <span class="section-badge">Why PestCure</span>
            <h2>Your Professional Pest Control Partner</h2>
        </div>
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-leaf"></i></div>
                <h3>Environmentally Responsible</h3>
                <p>Water-based formulations and eco-friendly solutions from Ensystex.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-flask"></i></div>
                <h3>Premium Quality</h3>
                <p>Industry-leading products from Coopers Environmental Science.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-certificate"></i></div>
                <h3>Professional Grade</h3>
                <p>Products trusted by pest control professionals across South Africa.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon"><i class="fas fa-headset"></i></div>
                <h3>Expert Support</h3>
                <p>Technical advice and support for all your pest control needs.</p>
            </div>
        </div>
    </div></section>

    <section class="cta"><div class="container">
        <h2>Need Pest Control Products?</h2>
        <p>Contact us for quotes on professional pest control solutions from South Africa's leading suppliers.</p>
        <a href="/pestcure/contact.php" class="btn btn-white btn-lg"><i class="fas fa-envelope"></i> Request a Quote</a>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand">
                <div class="footer-icon-container"><img src="/pestcure/images/logo-icon.png" alt="PestCure"></div>
                <p class="footer-tagline">Pest Control</p>
                <p>Professional pest control solutions from South Africa's leading suppliers.</p>
            </div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/pestcure/products.php">Products</a></li><li><a href="/pestcure/about.php">About Us</a></li><li><a href="/pestcure/contact.php">Contact</a></li></ul></div>
            <div><h4>Products</h4><ul class="footer-links"><li><a href="/pestcure/products.php#termite">Termite Control</a></li><li><a href="/pestcure/products.php#crawling">Crawling Insects</a></li><li><a href="/pestcure/products.php#flying">Flying Insects</a></li><li><a href="/pestcure/products.php#fly-units">Fly Units</a></li><li><a href="/pestcure/products.php#rodent">Rodent Control</a></li><li><a href="/pestcure/products.php#equipment">Equipment</a></li><li><a href="/pestcure/products.php#ppe">Safety & PPE</a></li></ul></div>
            <div><h4>Our Suppliers</h4><ul class="footer-links"><li><a href="https://ensystex.co.za" target="_blank">Ensystex SA</a></li><li><a href="https://www.cooperses.com" target="_blank">Coopers ES</a></li></ul><h4 style="margin-top: 24px;">Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@pestcure.co.za</p></div>
        </div>
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> PestCure. All rights reserved.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
        </div>
    </div></footer>
</body>
</html>
