<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products | PestCure - Professional Pest Control Products South Africa</title>
    <meta name="description" content="Professional pest control products from Ensystex and Coopers ES. Termiticides, insecticides, rodenticides, and application equipment for South African pest control professionals.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #ea580c; --primary-dark: #c2410c; --secondary: #84cc16; --dark: #1c1917; --gray-50: #fafaf9; --gray-100: #f5f5f4; --gray-200: #e7e5e4; --gray-600: #57534e; --white: #fff; --gradient-hero: linear-gradient(135deg, #9a3412 0%, #ea580c 50%, #c2410c 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; --ensystex: #1e5631; --coopers: #1a4480; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 80px; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 10px 18px; border-radius: 12px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-quote { background: var(--secondary); color: white; }
        .btn-sm { padding: 10px 20px; font-size: 14px; }
        .page-hero { background: linear-gradient(rgba(154, 52, 18, 0.85), rgba(194, 65, 12, 0.9)), url(/images/pestcure-products-banner.png); background-size: cover; background-position: center; padding: 160px 0 100px; text-align: center; color: white; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 700px; margin: 0 auto; }
        .supplier-badges { display: flex; justify-content: center; gap: 24px; margin-top: 32px; flex-wrap: wrap; }
        .supplier-badge { background: rgba(255,255,255,0.15); padding: 10px 20px; border-radius: 50px; font-size: 13px; font-weight: 500; }
        .section { padding: 80px 0; }
        .section-alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 48px; }
        .section-badge { display: inline-block; background: rgba(234,88,12,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; text-transform: uppercase; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.2rem; font-weight: 700; margin-bottom: 12px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; }
        .products-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .product-card { background: white; border-radius: var(--radius); overflow: hidden; box-shadow: var(--shadow); transition: all 0.3s; }
        .product-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); }
        .product-image { height: 140px; background: var(--gray-100); display: flex; align-items: center; justify-content: center; position: relative; }
        .product-image i { font-size: 3rem; color: var(--primary); opacity: 0.4; }
        .product-image img { width: 100%; height: 100%; object-fit: cover; }
        .supplier-tag { position: absolute; top: 10px; right: 10px; padding: 4px 10px; border-radius: 20px; font-size: 10px; font-weight: 600; color: white; }
        .supplier-tag.ensystex { background: var(--ensystex); }
        .supplier-tag.coopers { background: var(--coopers); }
        .product-content { padding: 20px; }
        .product-badge { display: inline-block; background: rgba(234,88,12,0.1); color: var(--primary); padding: 4px 12px; border-radius: 50px; font-size: 11px; font-weight: 600; margin-bottom: 10px; }
        .product-content h3 { font-size: 1rem; margin-bottom: 8px; line-height: 1.3; }
        .product-content p { color: var(--gray-600); font-size: 12px; margin-bottom: 16px; line-height: 1.5; }
        .product-actions .btn { width: 100%; justify-content: center; }
        .category-nav { background: white; padding: 20px 0; position: sticky; top: 84px; z-index: 100; box-shadow: 0 2px 10px rgba(0,0,0,0.05); }
        .category-nav-inner { display: flex; gap: 12px; overflow-x: auto; padding-bottom: 8px; }
        .category-nav a { padding: 10px 20px; background: var(--gray-100); border-radius: 50px; text-decoration: none; color: var(--gray-600); font-size: 13px; font-weight: 500; white-space: nowrap; transition: all 0.2s; }
        .category-nav a:hover, .category-nav a.active { background: var(--primary); color: white; }
        .modal-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.7); z-index: 9999; align-items: center; justify-content: center; padding: 20px; }
        .modal-overlay.active { display: flex; }
        .modal { background: white; border-radius: var(--radius); padding: 40px; max-width: 500px; width: 100%; position: relative; max-height: 90vh; overflow-y: auto; }
        .modal h3 { font-size: 1.5rem; margin-bottom: 8px; }
        .modal .subtitle { color: var(--gray-600); margin-bottom: 24px; }
        .modal-close { position: absolute; top: 20px; right: 20px; background: none; border: none; font-size: 24px; cursor: pointer; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 14px; border: 2px solid var(--gray-200); border-radius: 10px; font-family: inherit; font-size: 13px; }
        .form-group input:focus, .form-group textarea:focus { outline: none; border-color: var(--primary); }
        .success-message { display: none; text-align: center; padding: 40px; }
        .success-message.active { display: block; }
        .success-message i { font-size: 4rem; color: var(--secondary); margin-bottom: 20px; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 40px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { max-height: 80px; max-width: 80px; object-fit: contain; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .products-grid { grid-template-columns: repeat(3, 1fr); } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .products-grid { grid-template-columns: repeat(2, 1fr); } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } .category-nav-inner { justify-content: flex-start; } }
        @media (max-width: 480px) { .products-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" alt="PestCure"></a>
        <nav class="nav"><ul class="nav-links"><li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li><li><a href="/">Home</a></li><li><a href="/products.php" class="active">Products</a></li><li><a href="/about.php">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
    </div></div></header>

    <section class="page-hero">
        <div class="container">
            <h1>Professional Pest Control Products</h1>
            <p>Comprehensive range of environmentally responsible pest management solutions from South Africa's leading suppliers.</p>
            <div class="supplier-badges">
                <span class="supplier-badge"><i class="fas fa-leaf"></i> Ensystex - Environmentally Responsible Solutions</span>
                <span class="supplier-badge"><i class="fas fa-flask"></i> Coopers ES - Premium Quality Products</span>
            </div>
        </div>
    </section>

    <nav class="category-nav"><div class="container"><div class="category-nav-inner">
        <a href="#termite">Termite Control</a>
        <a href="#crawling">Crawling Insects</a>
        <a href="#flying">Flying Insects</a>
        <a href="#fly-units">Fly Units</a>
        <a href="#rodent">Rodent Control</a>
        <a href="#growth-regulators">Growth Regulators</a>
        <a href="#equipment">Equipment</a>
        <a href="#ppe">Safety & PPE</a>
    </div></div></nav>

    <!-- TERMITE CONTROL -->
    <section class="section" id="termite"><div class="container">
        <div class="section-header">
            <span class="section-badge">Termite Control</span>
            <h2>Termite Management Solutions</h2>
            <p>Water-based termiticides and colony elimination systems for effective long-term termite protection.</p>
        </div>
        <div class="products-grid">
            <div class="product-card">
                <div class="product-image"><img src="/images/product-termite.jpg" alt="Termite Control"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">Baiting System</span>
                    <h3>EXTERRA Termite Colony Elimination System</h3>
                    <p>Premium termite baiting system that eliminates entire colonies. Environmentally responsible approach to termite management.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('EXTERRA Termite Colony Elimination System')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="Insecticide"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">Termiticide</span>
                    <h3>MAXXTHOR 100</h3>
                    <p>Water-based termiticide and insecticide. Dual-purpose formulation for soil treatment and perimeter barriers.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('MAXXTHOR 100 Termiticide')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-termite.jpg" alt="Termite Control"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">Termiticide</span>
                    <h3>PROTHOR 200SC</h3>
                    <p>Water-based termiticide for professional soil treatment applications. Long-lasting barrier protection.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('PROTHOR 200SC Termiticide')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-termite.jpg" alt="Home Protection"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">Termiticide</span>
                    <h3>ULTRATHOR</h3>
                    <p>Water-based insecticide and termiticide. Versatile formulation for comprehensive pest protection.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('ULTRATHOR Termiticide')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-bait.jpg" alt="Concentrate"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Suspension Concentrate</span>
                    <h3>Ultrakill Termite Control SC</h3>
                    <p>Professional suspension concentrate for effective termite control. Ideal for pre and post-construction treatments.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Ultrakill Termite Control SC')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-termite.jpg" alt="Wood Treatment"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Wood Treatment</span>
                    <h3>Ultrakill Timberdefence</h3>
                    <p>Wood protection treatment against wood-boring insects. Available in 1L and 5L. Protects timber from termites and borers.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Ultrakill Timberdefence')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
        </div>
    </div></section>

    <!-- CRAWLING INSECTS -->
    <section class="section section-alt" id="crawling"><div class="container">
        <div class="section-header">
            <span class="section-badge">Crawling Insects</span>
            <h2>Crawling Insect Control</h2>
            <p>Professional solutions for cockroaches, ants, spiders, and other crawling pests.</p>
        </div>
        <div class="products-grid">
            <div class="product-card">
                <div class="product-image"><img src="/images/product-spray.jpg" alt="Spray Product"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">Spray</span>
                    <h3>AEROTHOR Extra Strength</h3>
                    <p>Extra strength crawling insect spray. Fast knockdown and residual control for professional applications.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('AEROTHOR Extra Strength Spray')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="Targeted Insecticide"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">Targeted</span>
                    <h3>ATTRATHOR Targeted Insecticide</h3>
                    <p>Targeted insecticide for precision pest control. Effective against specific pest species.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('ATTRATHOR Targeted Insecticide')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="Insecticide"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">Dual Action</span>
                    <h3>BITHOR Dual Action Insecticide</h3>
                    <p>Dual action insecticide combining knockdown and residual activity. Available in 3L containers.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('BITHOR Dual Action Insecticide')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-gel.jpg" alt="Gel Bait"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">Gel Bait</span>
                    <h3>BLATTATHOR ULTRA Cockroach Gel</h3>
                    <p>Professional gel cockroach bait with highly attractive formulation. Effective colony elimination through secondary kill.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('BLATTATHOR ULTRA Cockroach Gel')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-gel.jpg" alt="Gel Bait"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Gel Bait</span>
                    <h3>Coopers ProRoach Gel</h3>
                    <p>Professional cockroach gel bait for commercial and residential applications. Long-lasting effectiveness.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers ProRoach Gel')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-gel.jpg" alt="Gel Bait"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Gel Bait</span>
                    <h3>Ultrakill Roachforce Gel</h3>
                    <p>Gel-based roach control product in 10g applicator. Fast-acting formula for cockroach elimination.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Ultrakill Roachforce Gel 10g')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-termite.jpg" alt="Home Protection"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Multi-Purpose</span>
                    <h3>Coopers MultiCare Home</h3>
                    <p>Multi-purpose domestic pest control product for general crawling and flying insect control.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers MultiCare Home')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-spray.jpg" alt="Spray Product"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Spray</span>
                    <h3>Coopers MultiCare 1LT</h3>
                    <p>General-purpose insecticide spray in 1-litre format. Effective against a wide range of crawling insects.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers MultiCare 1LT')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="Ant Control"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Ant Control</span>
                    <h3>Coopers MultiCare Ant</h3>
                    <p>Specifically formulated for ant control. Targets ant colonies for effective elimination.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers MultiCare Ant')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="Ant Control"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Ant Control</span>
                    <h3>Ultrakill AntForce</h3>
                    <p>Ant-specific treatment available in 50g and 100g packages. Effective colony elimination.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Ultrakill AntForce')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fogger.jpg" alt="Fogger"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Fogger</span>
                    <h3>Coopers NuFog</h3>
                    <p>Dual-action fogging product for crawling insects. Ideal for treating enclosed spaces.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers NuFog')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="Insecticide"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Surface Spray</span>
                    <h3>D-Fend</h3>
                    <p>Multi-purpose crawling insect control solution. Long-lasting surface treatment.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('D-Fend')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="Insecticide"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Double Strength</span>
                    <h3>DBM Double Strength</h3>
                    <p>Enhanced-potency formulation for pest management. Extra strength for tough infestations.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('DBM Double Strength')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-spray.jpg" alt="Spray Product"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Aerosol</span>
                    <h3>NuPro Aerosol</h3>
                    <p>Aerosol spray available in 120ml and 330ml sizes. Quick knockdown for crawling pests.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('NuPro Aerosol')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Bait Station"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Storage</span>
                    <h3>Cupboard Guard</h3>
                    <p>Targeted product for protecting storage areas from crawling insects. Ideal for pantries and cupboards.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Cupboard Guard')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fly.jpg" alt="Moth Control" style="width:100%;height:100%;object-fit:cover;"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Moth Control</span>
                    <h3>Moth-ex Moth Strip</h3>
                    <p>Specialized moth control product in strip format. Protects clothing and fabrics from moth damage.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Moth-ex Moth Strip')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fly.jpg" alt="Moth Control" style="width:100%;height:100%;object-fit:cover;"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Moth Control</span>
                    <h3>Moth-ex Naphthalene Marbles</h3>
                    <p>Naphthalene-based moth prevention in marble form. 100g pack for wardrobes and storage.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Moth-ex Naphthalene Marbles 100g')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
        </div>
    </div></section>

    <!-- FLYING INSECTS -->
    <section class="section" id="flying"><div class="container">
        <div class="section-header">
            <span class="section-badge">Flying Insects</span>
            <h2>Flying Insect Control</h2>
            <p>Solutions for flies, mosquitoes, and other flying pests in domestic and commercial settings.</p>
        </div>
        <div class="products-grid">
            <div class="product-card">
                <div class="product-image"><img src="/images/product-bait.jpg" alt="Concentrate"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Concentrate</span>
                    <h3>Coopers Promethrin EC</h3>
                    <p>Professional insecticide concentrate for flying insect control. Effective space and residual treatment.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers Promethrin EC')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-bait.jpg" alt="Liquid Product"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Larvicide</span>
                    <h3>Coopers Larvakill SC 500ml</h3>
                    <p>Larval control concentrate for mosquito and fly breeding sites. Breaks the pest lifecycle effectively.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers Larvakill SC 500ml')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
        </div>
    </div></section>

    <!-- FLY UNITS -->
    <section class="section section-alt" id="fly-units"><div class="container">
        <div class="section-header">
            <span class="section-badge">Fly Units</span>
            <h2>Professional Fly Control Units</h2>
            <p>Commercial UV fly traps and ILT (Insect Light Trap) units for indoor fly control.</p>
        </div>
        <div class="products-grid">
            <div class="product-card">
                <div class="product-image"><img src="/images/product-trap.jpg" alt="Fly Trap"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Fly Trap</span>
                    <h3>Coopers Fly Catch</h3>
                    <p>Commercial fly catching unit for professional use. Effective trapping mechanism for fly control.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers Fly Catch')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="Insecticide"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">ILT Unit</span>
                    <h3>Cheetah 60</h3>
                    <p>Professional Insect Light Trap unit. High-performance UV attraction for commercial environments.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Cheetah 60 ILT Unit')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-trap.jpg" alt="EcoTek" style="width:100%;height:100%;object-fit:cover;"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">ILT Unit</span>
                    <h3>EcoTek II</h3>
                    <p>Eco-friendly Insect Light Trap for sustainable fly control. Modern design with effective performance.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('EcoTek II ILT Unit')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-trap.jpg" alt="Fly Trap"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">ILT Unit</span>
                    <h3>Jaguar 30</h3>
                    <p>Compact Insect Light Trap unit ideal for smaller commercial spaces. Efficient fly capture system.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Jaguar 30 ILT Unit')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-trap.jpg" alt="Laser Eye" style="width:100%;height:100%;object-fit:cover;"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">ILT Unit</span>
                    <h3>Laser Eye</h3>
                    <p>Advanced Insect Light Trap with superior UV technology. Designed for demanding commercial applications.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Laser Eye ILT Unit')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-trap.jpg" alt="Lynx" style="width:100%;height:100%;object-fit:cover;"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">ILT Unit</span>
                    <h3>Lynx</h3>
                    <p>Professional grade Insect Light Trap. Comprehensive coverage for large commercial areas.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Lynx ILT Unit')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
        </div>
    </div></section>

    <!-- RODENT CONTROL -->
    <section class="section" id="rodent"><div class="container">
        <div class="section-header">
            <span class="section-badge">Rodent Control</span>
            <h2>Rodent Management Products</h2>
            <p>Professional rodenticides, bait stations, and equipment for rats and mice control.</p>
        </div>
        <div class="products-grid">
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Rodent Control"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Soft Bait</span>
                    <h3>Selontra Rodenticide</h3>
                    <p>Professional soft bait rodenticide for Norway rats and roof rats. Fast-acting formula with excellent palatability.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Selontra Rodenticide')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Soft Bait"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Soft Bait</span>
                    <h3>Coopers Advanced Soft Bait</h3>
                    <p>Advanced soft bait rodenticide formulation. Highly palatable for effective rodent control.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers Advanced Soft Bait')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Wax Blocks"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Wax Block</span>
                    <h3>Ultrakill Rat & Mouse Wax Blocks</h3>
                    <p>Professional wax block baits suitable for wet and dry conditions. Consumer and professional sizes available.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Ultrakill Rat & Mouse Wax Blocks')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Grain Bait"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Grain Bait</span>
                    <h3>Ultrakill Rat & Mouse Grain Bait</h3>
                    <p>Grain-based rodenticide available in 80g and 2.5kg sizes. Traditional bait format for rodent control.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Ultrakill Rat & Mouse Grain Bait')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Pellets"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Pellets</span>
                    <h3>Ultrakill Rat & Mouse Pellets</h3>
                    <p>Pellet formulation rodenticide for rats and mice. Easy to use in bait stations or burrows.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Ultrakill Rat & Mouse Pellets')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Bait Station"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Bait Station</span>
                    <h3>Bravo Bait Station</h3>
                    <p>Professional bait station compatible with Ridak Pasta & Bait Blocks. Secure tamper-resistant design.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Bravo Bait Station')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Bait Station"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Bait Station</span>
                    <h3>Charlie Bait Station</h3>
                    <p>Compact bait station for Ridak Pasta & Bait Blocks. Ideal for smaller rodent control applications.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Charlie Bait Station')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Bait Station"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Bait Station</span>
                    <h3>Jerry Bait Stations</h3>
                    <p>Professional bait station system for Ridak Pasta & Bait Blocks. Versatile rodent control solution.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Jerry Bait Stations')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Bait Box"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Bait Box</span>
                    <h3>Rat Bait Boxes</h3>
                    <p>Enclosed bait stations for rats. Secure design protects bait from weather and non-target animals.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Rat Bait Boxes')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-bait.jpg" alt="Liquid Product"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Liquid Bait</span>
                    <h3>Rat Bars Liquid Bait Dispensers</h3>
                    <p>Liquid bait delivery system for rat control. Effective where rodents have limited water access.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Rat Bars Liquid Bait Dispensers')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Snap Trap"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Snap Trap</span>
                    <h3>Coopers Rodent Snap Trap</h3>
                    <p>Professional snap trap for quick rodent capture. Durable mechanical control solution.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers Rodent Snap Trap')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
        </div>
    </div></section>

    <!-- GROWTH REGULATORS -->
    <section class="section section-alt" id="growth-regulators"><div class="container">
        <div class="section-header">
            <span class="section-badge">Growth Regulators</span>
            <h2>Insect Growth Regulators</h2>
            <p>Specialized products that disrupt pest development cycles for long-term control.</p>
        </div>
        <div class="products-grid">
            <div class="product-card" style="opacity: 0.6; pointer-events: none;">
                <div class="product-image"><img src="/images/product-fly.jpg" alt="Mosquito Control" style="width:100%;height:100%;object-fit:cover;"><span class="supplier-tag ensystex">Ensystex</span><span class="supplier-tag" style="background: #dc2626; position: absolute; top: 10px; left: 10px; right: auto;">Discontinued</span></div>
                <div class="product-content">
                    <span class="product-badge">Granular IGR</span>
                    <h3>CULITHOR Mosquito Growth Regulator</h3>
                    <p>Granular mosquito growth regulator for breeding site treatment. Prevents adult mosquito emergence.</p>
                    <div class="product-actions"><span style="color: #dc2626; font-weight: 600; font-size: 13px;"><i class="fas fa-ban"></i> No Longer Available</span></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-insecticide.jpg" alt="IGR" style="width:100%;height:100%;object-fit:cover;"><span class="supplier-tag ensystex">Ensystex</span></div>
                <div class="product-content">
                    <span class="product-badge">IGR</span>
                    <h3>EXOTHOR Insect Growth Regulator</h3>
                    <p>Professional insect growth regulator that disrupts pest development. Long-lasting residual activity.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('EXOTHOR Insect Growth Regulator')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
        </div>
    </div></section>

    <!-- EQUIPMENT -->
    <section class="section" id="equipment"><div class="container">
        <div class="section-header">
            <span class="section-badge">Equipment</span>
            <h2>Application Equipment</h2>
            <p>Professional sprayers, foggers, and application tools for pest control operations.</p>
        </div>
        <div class="products-grid">
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fogger.jpg" alt="Thermal Fogger"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Thermal Fogger</span>
                    <h3>Pulsfog K10</h3>
                    <p>Professional thermal fogger for outdoor pest control. Compact and efficient for various applications.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Pulsfog K10 Thermal Fogger')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fogger.jpg" alt="Thermal Fogger"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Thermal Fogger</span>
                    <h3>Pulsfog K22</h3>
                    <p>Mid-range thermal fogging machine for professional applications. Ideal for medium-sized areas.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Pulsfog K22 Thermal Fogger')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fogger.jpg" alt="Bio Fogger"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Bio Fogger</span>
                    <h3>Pulsfog K30-20-Bio</h3>
                    <p>High-capacity thermal fogger for large area treatments. Bio-compatible for sensitive environments.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Pulsfog K30-20-Bio Fogger')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-bait.jpg" alt="Liquid Product"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Sprayer</span>
                    <h3>Power Sprayer 100L</h3>
                    <p>Heavy-duty 100L power sprayer for professional pest control operations. High volume application.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Power Sprayer 100L')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fogger.jpg" alt="Dust Applicator"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Dust Applicator</span>
                    <h3>Airofog Dust Applicator</h3>
                    <p>Professional dust application equipment for treating cracks, crevices, and voids.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Airofog Dust Applicator')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-gel.jpg" alt="Gel Bait"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Gel Applicator</span>
                    <h3>Airofog Gel Gun</h3>
                    <p>Precision gel application gun for cockroach and ant gel baits. Professional grade equipment.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Airofog Gel Gun')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-gel.jpg" alt="Gel Bait"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Gel Applicator</span>
                    <h3>Eco Gel Applicator</h3>
                    <p>Eco-friendly gel application tool for precise bait placement. Easy to use and refill.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Eco Gel Applicator')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fogger.jpg" alt="Fogger"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Aerosol Dispenser</span>
                    <h3>Ultramatic Eco Aerosol Dispenser</h3>
                    <p>Automatic aerosol dispenser for continuous fly control. Programmable timing for efficient coverage.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Ultramatic Eco Aerosol Dispenser')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-fogger.jpg" alt="Dust Applicator"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Duster</span>
                    <h3>Polminor Duster</h3>
                    <p>Manual dust applicator for powder insecticides. Ideal for treating hard-to-reach areas.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Polminor Duster')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
        </div>
    </div></section>

    <!-- PPE & SAFETY -->
    <section class="section section-alt" id="ppe"><div class="container">
        <div class="section-header">
            <span class="section-badge">Safety & PPE</span>
            <h2>Personal Protective Equipment</h2>
            <p>Essential safety equipment for pest control professionals.</p>
        </div>
        <div class="products-grid">
            <div class="product-card">
                <div class="product-image"><img src="/images/product-ppe.jpg" alt="Respirator"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Respirator</span>
                    <h3>Full Face Mask</h3>
                    <p>Full face respiratory protection mask. Compatible with various filter canisters for different applications.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Full Face Mask')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-ppe.jpg" alt="Respirator"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Respirator</span>
                    <h3>Half Face Double Mask</h3>
                    <p>Half face respirator with dual cartridge system. Balanced protection and comfort.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Half Face Double Mask')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-ppe.jpg" alt="Respirator"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Respirator</span>
                    <h3>Half Face Single Mask</h3>
                    <p>Compact half face respirator with single cartridge. Lightweight for extended use.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Half Face Single Mask')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-ppe.jpg" alt="Filter"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Filter</span>
                    <h3>Canister A2B2E2K1P3</h3>
                    <p>Multi-gas filter canister for comprehensive chemical protection. ABEK classification.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Canister A2B2E2K1P3')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-ppe.jpg" alt="Filter"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Filter</span>
                    <h3>Canister A2P3 (Organic)</h3>
                    <p>Organic vapor filter canister (Brown). Designed for organic chemical vapors and particles.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Canister A2P3 Organic')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-ppe.jpg" alt="Filter"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Filter</span>
                    <h3>Canister B2P3 (Inorganic)</h3>
                    <p>Inorganic vapor filter canister (Grey). Protection against inorganic gases and particles.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Canister B2P3 Inorganic')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Pellets"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Cartridge</span>
                    <h3>Cartridge A1P2</h3>
                    <p>Replacement cartridge A1P2 for half face respirators. Organic vapor and particulate protection.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Cartridge A1P2')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-rodent.jpg" alt="Pellets"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Cartridge</span>
                    <h3>Cartridge B1P2</h3>
                    <p>Replacement cartridge B1P2 for half face respirators. Inorganic vapor and particulate protection.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Cartridge B1P2')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
            <div class="product-card">
                <div class="product-image"><img src="/images/product-ppe.jpg" alt="PPE"><span class="supplier-tag coopers">Coopers</span></div>
                <div class="product-content">
                    <span class="product-badge">Coverall</span>
                    <h3>Coopers Microguard Tyvek Suit</h3>
                    <p>Disposable Tyvek protective suit for chemical applications. Full body protection.</p>
                    <div class="product-actions"><button class="btn btn-quote btn-sm" onclick="openQuoteModal('Coopers Microguard Tyvek Suit')"><i class="fas fa-file-invoice"></i> Get Quote</button></div>
                </div>
            </div>
        </div>
    </div></section>

    <section style="padding: 80px 0; background: var(--gradient-hero); text-align: center; color: white;"><div class="container">
        <h2 style="font-size: 2.2rem; margin-bottom: 16px;">Need Expert Advice?</h2>
        <p style="opacity: 0.9; margin-bottom: 32px; max-width: 600px; margin-left: auto; margin-right: auto;">Our team can help you choose the right products for your pest problem. We supply professional-grade solutions from leading manufacturers.</p>
        <a href="/contact.php" class="btn" style="background: white; color: var(--primary);"><i class="fas fa-phone"></i> Contact Us</a>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand"><div class="footer-icon-container"><img src="/images/logo-icon.png" alt="PestCure"></div><p class="footer-tagline">Pest Control</p>
                    <p>Professional pest control<br>solutions from leading suppliers.</p></div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/products.php">Products</a></li><li><a href="/about.php">About Us</a></li><li><a href="/contact.php">Contact</a></li></ul></div>
            <div><h4>Products</h4><ul class="footer-links"><li><a href="#termite">Termite Control</a></li><li><a href="#crawling">Crawling Insects</a></li><li><a href="#flying">Flying Insects</a></li><li><a href="#fly-units">Fly Units</a></li><li><a href="#rodent">Rodent Control</a></li><li><a href="#growth-regulators">Growth Regulators</a></li><li><a href="#equipment">Equipment</a></li><li><a href="#ppe">Safety & PPE</a></li></ul></div>
            <div><h4>Our Suppliers</h4><ul class="footer-links"><li><a href="https://ensystex.co.za" target="_blank">Ensystex SA</a></li><li><a href="https://www.cooperses.com" target="_blank">Coopers ES</a></li></ul><h4 style="margin-top: 24px;">Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@pestcure.co.za</p></div>
        </div>
        <div class="footer-bottom"><p>&copy; <?= date('Y') ?> PestCure. All rights reserved.</p><a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a></div>
    </div></footer>

    <div class="modal-overlay" id="quoteModal"><div class="modal"><button class="modal-close" onclick="closeQuoteModal()">&times;</button>
        <div id="quoteForm"><h3>Request a Quote</h3><p class="subtitle" id="productName">Product</p>
            <form onsubmit="submitQuote(event)">
                <div class="form-group"><label>Name *</label><input type="text" required></div>
                <div class="form-group"><label>Company</label><input type="text"></div>
                <div class="form-group"><label>Email *</label><input type="email" required></div>
                <div class="form-group"><label>Phone *</label><input type="tel" required></div>
                <div class="form-group"><label>Quantity</label><input type="number" value="1" min="1"></div>
                <div class="form-group"><label>Message</label><textarea rows="3" placeholder="Any specific requirements..."></textarea></div>
                <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fas fa-paper-plane"></i> Submit Request</button>
            </form>
        </div>
        <div class="success-message" id="successMessage"><i class="fas fa-check-circle"></i><h3>Quote Request Received!</h3><p>We'll get back to you within 24 hours with pricing and availability.</p><button class="btn btn-primary" onclick="closeQuoteModal()" style="margin-top: 20px;">Close</button></div>
    </div></div>

    <script>
        function openQuoteModal(product) { document.getElementById('productName').textContent = product; document.getElementById('quoteModal').classList.add('active'); }
        function closeQuoteModal() { document.getElementById('quoteModal').classList.remove('active'); document.getElementById('quoteForm').style.display = 'block'; document.getElementById('successMessage').classList.remove('active'); }
        function submitQuote(e) { e.preventDefault(); document.getElementById('quoteForm').style.display = 'none'; document.getElementById('successMessage').classList.add('active'); }
        document.getElementById('quoteModal').addEventListener('click', function(e) { if (e.target === this) closeQuoteModal(); });

        // Category nav active state
        document.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('section[id]');
            const navLinks = document.querySelectorAll('.category-nav a');
            let current = '';
            sections.forEach(section => {
                const sectionTop = section.offsetTop - 200;
                if (scrollY >= sectionTop) current = section.getAttribute('id');
            });
            navLinks.forEach(link => {
                link.classList.remove('active');
                if (link.getAttribute('href') === '#' + current) link.classList.add('active');
            });
        });
    </script>
</body>
</html>
