-- =============================================
-- PestCure Reseller Database Setup
-- cPanel Setup Guide
-- =============================================

-- =============================================
-- STEP 1: CREATE DATABASE IN cPanel
-- =============================================
-- 1. Login to cPanel
-- 2. Go to "Databases" section > Click "MySQL Databases"
-- 3. Under "Create New Database", enter: multicure_db
-- 4. Click "Create Database"
-- 5. NOTE: cPanel adds a prefix (e.g., youruser_multicure_db)

-- =============================================
-- STEP 2: CREATE DATABASE USER
-- =============================================
-- 1. Still on MySQL Databases page
-- 2. Scroll to "MySQL Users" > "Add New User"
-- 3. Username: multicure_user
-- 4. Password: Use generator for strong password
-- 5. SAVE THIS PASSWORD!
-- 6. Click "Create User"

-- =============================================
-- STEP 3: ADD USER TO DATABASE
-- =============================================
-- 1. Scroll to "Add User To Database"
-- 2. Select your user from dropdown
-- 3. Select your database from dropdown
-- 4. Click "Add"
-- 5. Check "ALL PRIVILEGES"
-- 6. Click "Make Changes"

-- =============================================
-- STEP 4: RUN SQL IN phpMyAdmin
-- =============================================
-- 1. Go to cPanel home > Click "phpMyAdmin"
-- 2. Click your database name in left sidebar
-- 3. Click "SQL" tab
-- 4. Copy everything below this line and paste:
-- =============================================

CREATE TABLE IF NOT EXISTS resellers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    email VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    name VARCHAR(100) NOT NULL,
    company VARCHAR(150) NOT NULL,
    phone VARCHAR(20),
    discount_percentage DECIMAL(5,2) DEFAULT 15.00,
    active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_login TIMESTAMP NULL,
    notes TEXT,
    INDEX idx_username (username),
    INDEX idx_email (email),
    INDEX idx_active (active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- STEP 5: UPDATE config.php
-- =============================================
-- 1. In cPanel, go to "File Manager"
-- 2. Navigate to: public_html/includes/config.php
-- 3. Right-click > Edit
-- 4. Update these lines:
--
--    define('DB_HOST', 'localhost');
--    define('DB_NAME', 'youruser_multicure_db');
--    define('DB_USER', 'youruser_multicure_user');
--    define('DB_PASS', 'your_password_here');
--
-- 5. Click "Save Changes"

-- =============================================
-- STEP 6: ADD A RESELLER (Optional)
-- =============================================
-- 1. Generate password hash at: https://phppasswordhash.com/
-- 2. Run this SQL in phpMyAdmin (replace values):

-- INSERT INTO resellers (username, email, password, name, company, discount_percentage, active)
-- VALUES (
--     'john_smith',
--     'john@company.com',
--     'PASTE_YOUR_HASH_HERE',
--     'John Smith',
--     'ABC Company',
--     15.00,
--     1
-- );

-- =============================================
-- USEFUL QUERIES
-- =============================================

-- View all resellers:
-- SELECT id, username, email, name, company, discount_percentage, active FROM resellers;

-- Deactivate a reseller:
-- UPDATE resellers SET active = 0 WHERE id = X;

-- Change discount percentage:
-- UPDATE resellers SET discount_percentage = 20 WHERE id = X;
