<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TyreCure - Premium Tyres & Tyre Services | South Africa</title>
    <meta name="description" content="TyreCure - South Africa's leader in tyres and tyre services. Consumer, Commercial, Industrial, Agricultural & Mining tyres. Retreading, Rim Engineering, Powder Coating & Fleet Management.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #dc2626;
            --primary-dark: #991b1b;
            --primary-light: #ef4444;
            --secondary: #1e3a5f;
            --secondary-light: #2d4a6f;
            --accent: #f59e0b;
            --dark: #0f172a;
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-600: #475569;
            --white: #fff;
            --gradient-primary: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary) 100%);
            --gradient-secondary: linear-gradient(135deg, var(--secondary) 0%, var(--secondary-light) 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.15);
            --radius: 16px;
            --radius-lg: 24px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1320px; margin: 0 auto; padding: 0 24px; }

        /* Header */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: rgba(255,255,255,0.98);
            backdrop-filter: blur(20px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.06);
        }
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0;
        }
        .logo img { height: 70px; }
        .nav { display: flex; align-items: center; gap: 8px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 2px; list-style: none; align-items: center; }
        .nav-links a {
            text-decoration: none;
            color: var(--gray-600);
            font-weight: 500;
            font-size: 13px;
            padding: 10px 14px;
            border-radius: 8px;
            transition: all 0.2s;
        }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .nav-links .dropdown { position: relative; }
        .nav-links .dropdown > a::after { content: '\f107'; font-family: 'Font Awesome 6 Free'; font-weight: 900; margin-left: 6px; font-size: 10px; }
        .dropdown-menu {
            position: absolute;
            top: 100%;
            left: 0;
            background: white;
            min-width: 220px;
            border-radius: 12px;
            box-shadow: var(--shadow-lg);
            padding: 8px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(10px);
            transition: all 0.2s;
        }
        .dropdown:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        .dropdown-menu a { display: block; padding: 10px 14px; border-radius: 8px; font-size: 13px; }
        .dropdown-menu a:hover { background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            padding: 12px 24px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 14px;
            text-decoration: none;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        .btn-primary { background: var(--gradient-primary); color: white; box-shadow: 0 4px 15px rgba(220,38,38,0.3); }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(220,38,38,0.4); }
        .btn-secondary { background: var(--gradient-secondary); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-white { background: white; color: var(--primary); }
        .btn-white:hover { background: var(--gray-50); }
        .btn-sm { padding: 8px 16px; font-size: 12px; }
        .btn-lg { padding: 16px 32px; font-size: 15px; }

        /* Hero */
        .hero {
            padding: 140px 0 80px;
            background: var(--gradient-secondary);
            position: relative;
            overflow: hidden;
        }
        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=1920&q=80') center/cover;
            opacity: 0.15;
        }
        .hero::after {
            content: '';
            position: absolute;
            bottom: -100px;
            right: -100px;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(220,38,38,0.3) 0%, transparent 70%);
            border-radius: 50%;
        }
        .hero .container { position: relative; z-index: 1; }
        .hero-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
        }
        .hero-content { color: white; }
        .hero-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(255,255,255,0.15);
            padding: 10px 20px;
            border-radius: 50px;
            font-size: 13px;
            font-weight: 500;
            margin-bottom: 24px;
        }
        .hero h1 {
            font-size: 3.2rem;
            font-weight: 800;
            line-height: 1.1;
            margin-bottom: 20px;
        }
        .hero h1 span { color: var(--primary-light); }
        .hero p {
            font-size: 1.15rem;
            opacity: 0.9;
            margin-bottom: 32px;
            max-width: 500px;
        }
        .hero-buttons { display: flex; gap: 16px; flex-wrap: wrap; }
        .hero-visual {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
        }
        .hero-stat {
            background: rgba(255,255,255,0.1);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 24px;
            text-align: center;
            border: 1px solid rgba(255,255,255,0.1);
        }
        .hero-stat h3 { font-size: 2.5rem; font-weight: 800; color: white; }
        .hero-stat p { font-size: 13px; color: rgba(255,255,255,0.8); margin-top: 4px; }
        .hero-stat.highlight { background: var(--gradient-primary); }

        /* Quick Nav Bar */
        .quick-nav {
            background: white;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            position: sticky;
            top: 90px;
            z-index: 100;
        }
        .quick-nav-content {
            display: flex;
            justify-content: center;
            gap: 8px;
            padding: 12px 0;
            overflow-x: auto;
        }
        .quick-nav a {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            background: var(--gray-50);
            color: var(--gray-600);
            text-decoration: none;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 500;
            white-space: nowrap;
            transition: all 0.2s;
        }
        .quick-nav a:hover { background: var(--primary); color: white; }
        .quick-nav a.services-link { background: var(--secondary); color: white; }
        .quick-nav a.services-link:hover { background: var(--secondary-light); }

        /* Section Styles */
        .section { padding: 100px 0; scroll-margin-top: 200px; }
        .section-header { text-align: center; margin-bottom: 60px; }
        #products, #services, #brands { scroll-margin-top: 200px; }
        .section-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(220,38,38,0.1);
            color: var(--primary);
            padding: 10px 20px;
            border-radius: 50px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 16px;
        }
        .section-badge.secondary { background: rgba(30,58,95,0.1); color: var(--secondary); }
        .section-header h2 { font-size: 2.5rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); max-width: 600px; margin: 0 auto; font-size: 16px; }

        /* Products Section */
        .products { background: var(--gray-50); }
        .products-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            gap: 20px;
        }
        .product-card {
            background: white;
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: all 0.3s;
            text-decoration: none;
            color: inherit;
        }
        .product-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--shadow-lg);
        }
        .product-card-image {
            height: 160px;
            background: var(--gradient-secondary);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }
        .product-card-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .product-card-image i {
            font-size: 4rem;
            color: rgba(255,255,255,0.3);
        }
        .product-card-body { padding: 20px; text-align: center; }
        .product-card h3 { font-size: 1rem; margin-bottom: 8px; color: var(--dark); }
        .product-card p { font-size: 12px; color: var(--gray-600); margin-bottom: 12px; }
        .product-card .view-link {
            color: var(--primary);
            font-size: 13px;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        /* Brands Section - Auto-scrolling slider */
        .brands { padding: 80px 0; background: var(--gray-50); overflow: hidden; }
        .brands-slider {
            overflow: hidden;
            position: relative;
            width: 100%;
            margin-top: 40px;
        }
        .brands-slider::before,
        .brands-slider::after {
            content: '';
            position: absolute;
            top: 0;
            bottom: 0;
            width: 100px;
            z-index: 2;
            pointer-events: none;
        }
        .brands-slider::before {
            left: 0;
            background: linear-gradient(to right, var(--gray-50), transparent);
        }
        .brands-slider::after {
            right: 0;
            background: linear-gradient(to left, var(--gray-50), transparent);
        }
        .brands-track {
            display: flex;
            animation: scrollBrands 60s linear infinite;
            width: fit-content;
        }
        .brands-track:hover { animation-play-state: paused; }
        .brand-item {
            flex-shrink: 0;
            padding: 16px 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: white;
            border-radius: 12px;
            margin: 0 12px;
            min-width: 160px;
            height: 80px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.06);
            transition: all 0.3s;
        }
        .brand-item:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.12);
        }
        .brand-item img {
            height: 45px;
            max-width: 130px;
            object-fit: contain;
            opacity: 0.7;
            transition: all 0.3s;
            filter: grayscale(40%);
        }
        .brand-item:hover img {
            opacity: 1;
            filter: grayscale(0%);
            transform: scale(1.08);
        }
        @keyframes scrollBrands {
            0% { transform: translateX(0); }
            100% { transform: translateX(-50%); }
        }

        /* Services Section */
        .services { background: var(--dark); color: white; position: relative; overflow: hidden; }
        .services::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 50%;
            height: 100%;
            background: url('https://images.unsplash.com/photo-1486262715619-67b85e0b08d3?w=1200&q=80') center/cover;
            opacity: 0.1;
        }
        .services .container { position: relative; z-index: 1; }
        .services .section-badge { background: rgba(220,38,38,0.2); color: var(--primary-light); }
        .services .section-header h2, .services .section-header p { color: white; }
        .services .section-header p { opacity: 0.8; }
        .services-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 24px;
        }
        .service-card {
            background: rgba(255,255,255,0.05);
            border: 1px solid rgba(255,255,255,0.1);
            border-radius: var(--radius);
            padding: 28px;
            text-align: center;
            transition: all 0.3s;
            cursor: pointer;
            text-decoration: none;
            color: inherit;
        }
        .service-card:hover {
            background: rgba(255,255,255,0.1);
            transform: translateY(-4px);
            border-color: var(--primary);
        }
        .service-icon {
            width: 70px;
            height: 70px;
            background: var(--gradient-primary);
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            margin: 0 auto 20px;
        }
        .service-card h3 { font-size: 1rem; margin-bottom: 10px; }
        .service-card p { font-size: 13px; opacity: 0.7; line-height: 1.6; }
        .service-card .badge {
            display: inline-block;
            background: var(--accent);
            color: var(--dark);
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 10px;
            font-weight: 700;
            text-transform: uppercase;
            margin-top: 12px;
        }

        /* CTA Section */
        .cta {
            padding: 80px 0;
            background: var(--gradient-primary);
            text-align: center;
            color: white;
        }
        .cta h2 { font-size: 2.2rem; margin-bottom: 16px; }
        .cta p { opacity: 0.9; margin-bottom: 32px; max-width: 500px; margin-left: auto; margin-right: auto; }
        .cta-buttons { display: flex; gap: 16px; justify-content: center; flex-wrap: wrap; }

        /* Footer */
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr 1fr;
            gap: 40px;
            margin-bottom: 48px;
        }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-logo {
            width: 100px;
            height: 100px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 16px;
        }
        .footer-logo img { height: 65px; }
        .footer h4 { font-size: 14px; margin-bottom: 20px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-links { list-style: none; }
        .footer-links a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            font-size: 14px;
            display: block;
            padding: 6px 0;
            transition: color 0.2s;
        }
        .footer-links a:hover { color: white; }
        .footer-bottom {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding-top: 32px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            font-size: 13px;
        }
        .multicure-badge .badge-logo {
            background: rgba(255,255,255,0.95);
            padding: 8px 16px;
            border-radius: 8px;
        }
        .multicure-badge img { height: 28px; display: block; }

        /* Quote Modal */
        .quote-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.8);
            z-index: 2000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .quote-modal.active { display: flex; }
        .quote-modal-content {
            background: white;
            border-radius: 20px;
            max-width: 550px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
            animation: modalSlide 0.3s ease;
        }
        @keyframes modalSlide {
            from { opacity: 0; transform: translateY(-30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .quote-modal-header {
            background: var(--gradient-primary);
            color: white;
            padding: 28px;
            border-radius: 20px 20px 0 0;
            position: relative;
        }
        .quote-modal-header h3 { font-size: 1.5rem; margin-bottom: 4px; }
        .quote-modal-header p { opacity: 0.9; font-size: 14px; }
        .quote-modal-close {
            position: absolute;
            top: 20px;
            right: 20px;
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            font-size: 20px;
            cursor: pointer;
            transition: all 0.2s;
        }
        .quote-modal-close:hover { background: rgba(255,255,255,0.3); }
        .quote-form { padding: 28px; }
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
        .form-group { margin-bottom: 20px; }
        .form-group label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 8px;
        }
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 14px 16px;
            border: 2px solid var(--gray-200);
            border-radius: 10px;
            font-size: 14px;
            font-family: inherit;
            transition: all 0.2s;
        }
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary);
        }
        .form-group textarea { min-height: 100px; resize: vertical; }
        .submit-quote {
            width: 100%;
            padding: 16px;
            background: var(--gradient-primary);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: all 0.3s;
        }
        .submit-quote:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(220,38,38,0.35); }

        /* Floating Quote Button */
        .floating-quote {
            position: fixed;
            bottom: 30px;
            right: 30px;
            z-index: 999;
            padding: 16px 28px;
            background: var(--gradient-primary);
            color: white;
            border: none;
            border-radius: 50px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 8px 30px rgba(220,38,38,0.4);
            display: flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s;
        }
        .floating-quote:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 12px 40px rgba(220,38,38,0.5);
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .products-grid { grid-template-columns: repeat(3, 1fr); }
            .services-grid { grid-template-columns: repeat(2, 1fr); }
            .footer-grid { grid-template-columns: repeat(3, 1fr); }
        }
        @media (max-width: 1024px) {
            .hero-grid { grid-template-columns: 1fr; text-align: center; }
            .hero p { margin-left: auto; margin-right: auto; }
            .hero-buttons { justify-content: center; }
            .hero-visual { max-width: 400px; margin: 40px auto 0; }
        }
        @media (max-width: 768px) {
            .nav-links { display: none; }
            .nav .btn-outline, .nav .btn-primary { display: none; }
            .mobile-menu-btn { display: block; }
            .products-grid { grid-template-columns: repeat(2, 1fr); }
            .services-grid { grid-template-columns: 1fr; }
            .hero h1 { font-size: 2.2rem; }
            .section { padding: 60px 0; }
            .footer-grid { grid-template-columns: 1fr 1fr; }
            .footer-bottom { flex-direction: column; gap: 16px; text-align: center; }
            .form-row { grid-template-columns: 1fr; }
            .quick-nav { top: 80px; }
        }
        @media (max-width: 480px) {
            .products-grid { grid-template-columns: 1fr; }
            .hero-visual { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo">
                    <img src="/images/logo-long.png" alt="TyreCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/">Home</a></li>
                        <li class="dropdown">
                            <a href="/products.php">Products</a>
                            <div class="dropdown-menu">
                                <a href="/products.php#consumer"><i class="fas fa-car"></i> Consumer Tyres</a>
                                <a href="/products.php#commercial"><i class="fas fa-truck"></i> Commercial Tyres</a>
                                <a href="/products.php#industrial"><i class="fas fa-industry"></i> Industrial Tyres</a>
                                <a href="/products.php#agricultural"><i class="fas fa-tractor"></i> Agricultural Tyres</a>
                                <a href="/products.php#mining"><i class="fas fa-hard-hat"></i> Mining Tyres</a>
                                <a href="/products.php#brands"><i class="fas fa-tags"></i> Tyre Brands</a>
                            </div>
                        </li>
                        <li class="dropdown">
                            <a href="/services.php">Services</a>
                            <div class="dropdown-menu">
                                <a href="/services/retread.php"><i class="fas fa-sync-alt"></i> Retread Factory</a>
                                <a href="/services/rim-engineering.php"><i class="fas fa-cog"></i> Rim Engineering</a>
                                <a href="/services/powder-coating.php"><i class="fas fa-spray-can"></i> Powder Coating</a>
                                <a href="/services/fleet-management.php"><i class="fas fa-truck-moving"></i> Fleet Management</a>
                                <a href="/services/fleet-maintenance.php"><i class="fas fa-tools"></i> Fleet Maintenance</a>
                                <a href="/services/breakdowns.php"><i class="fas fa-phone-alt"></i> 24HR Breakdowns</a>
                                <a href="/services/forklift-fitment.php"><i class="fas fa-dolly"></i> Forklift Fitment</a>
                                <a href="/services/drive-thru.php"><i class="fas fa-warehouse"></i> Truck Drive Thru</a>
                            </div>
                        </li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                        <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
                    <?php else: ?>
                        <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </header>

    <!-- Mobile Menu Overlay -->
    <div id="mobileMenu" class="mobile-menu">
        <button class="mobile-menu-close" onclick="document.getElementById('mobileMenu').classList.remove('active')"><i class="fas fa-times"></i></button>
        <a href="https://omnicure.co.za/"><i class="fas fa-th-large"></i> OmniCure</a>
        <a href="/">Home</a>
        <a href="#products">Products</a>
        <a href="#services">Services</a>
        <a href="/contact.php">Contact</a>
        <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
    </div>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-grid">
                <div class="hero-content">
                    <div class="hero-badge"><i class="fas fa-award"></i> South Africa's Tyre Leader</div>
                    <h1>Premium Tyres & <span>Expert Services</span></h1>
                    <p>From consumer to mining - we supply quality tyres across all categories. Plus world-class retreading, rim engineering, and fleet management services.</p>
                    <div class="hero-buttons">
                        <a href="#products" class="btn btn-white btn-lg"><i class="fas fa-tire"></i> Browse Tyres</a>
                        <a href="#services" class="btn btn-primary btn-lg"><i class="fas fa-cogs"></i> Our Services</a>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-stat">
                        <h3>5+</h3>
                        <p>Tyre Categories</p>
                    </div>
                    <div class="hero-stat highlight">
                        <h3>50+</h3>
                        <p>Premium Brands</p>
                    </div>
                    <div class="hero-stat highlight">
                        <h3>8+</h3>
                        <p>Service Solutions</p>
                    </div>
                    <div class="hero-stat">
                        <h3>24/7</h3>
                        <p>Breakdown Support</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Quick Navigation -->
    <nav class="quick-nav">
        <div class="container">
            <div class="quick-nav-content">
                <a href="#products"><i class="fas fa-car"></i> Consumer</a>
                <a href="#products"><i class="fas fa-truck"></i> Commercial</a>
                <a href="#products"><i class="fas fa-industry"></i> Industrial</a>
                <a href="#products"><i class="fas fa-tractor"></i> Agricultural</a>
                <a href="#products"><i class="fas fa-hard-hat"></i> Mining</a>
                <a href="#services" class="services-link"><i class="fas fa-cogs"></i> Services</a>
            </div>
        </div>
    </nav>

    <!-- Products Section -->
    <section class="section products" id="products">
        <div class="container">
            <div class="section-header">
                <span class="section-badge"><i class="fas fa-tire"></i> Our Products</span>
                <h2>Tyres for Every Application</h2>
                <p>Quality tyres across all categories - from everyday driving to extreme mining conditions.</p>
            </div>
            <div class="products-grid">
                <a href="/products.php#consumer" class="product-card">
                    <div class="product-card-image">
                        <img src="https://images.unsplash.com/photo-1549317661-bd32c8ce0db2?w=400&h=300&fit=crop" alt="Consumer Tyres">
                    </div>
                    <div class="product-card-body">
                        <h3>Consumer Tyres</h3>
                        <p>Passenger cars, sedans, hatchbacks & family vehicles</p>
                        <span class="view-link">View Range <i class="fas fa-arrow-right"></i></span>
                    </div>
                </a>
                <a href="/products.php#commercial" class="product-card">
                    <div class="product-card-image">
                        <img src="https://images.unsplash.com/photo-1601584115197-04ecc0da31d7?w=400&h=300&fit=crop" alt="Commercial Tyres">
                    </div>
                    <div class="product-card-body">
                        <h3>Commercial Tyres</h3>
                        <p>Trucks, trailers, buses & commercial fleets</p>
                        <span class="view-link">View Range <i class="fas fa-arrow-right"></i></span>
                    </div>
                </a>
                <a href="/products.php#industrial" class="product-card">
                    <div class="product-card-image">
                        <img src="https://images.unsplash.com/photo-1504307651254-35680f356dfd?w=400&h=300&fit=crop" alt="Industrial Tyres">
                    </div>
                    <div class="product-card-body">
                        <h3>Industrial Tyres</h3>
                        <p>Forklifts, warehouses & industrial equipment</p>
                        <span class="view-link">View Range <i class="fas fa-arrow-right"></i></span>
                    </div>
                </a>
                <a href="/products.php#agricultural" class="product-card">
                    <div class="product-card-image">
                        <img src="https://images.unsplash.com/photo-1530267981375-f0de937f5f13?w=400&h=300&fit=crop" alt="Agricultural Tyres">
                    </div>
                    <div class="product-card-body">
                        <h3>Agricultural Tyres</h3>
                        <p>Tractors, harvesters & farm implements</p>
                        <span class="view-link">View Range <i class="fas fa-arrow-right"></i></span>
                    </div>
                </a>
                <a href="/products.php#mining" class="product-card">
                    <div class="product-card-image" style="background: linear-gradient(135deg, #1e3a5f 0%, #0f172a 100%);">
                        <img src="https://images.unsplash.com/photo-1578328819058-b69f3a3b0f6b?w=400&h=300&fit=crop" alt="Mining Tyres">
                    </div>
                    <div class="product-card-body">
                        <h3>Mining Tyres</h3>
                        <p>Open-cast, underground & heavy earthmoving</p>
                        <span class="view-link">View Range <i class="fas fa-arrow-right"></i></span>
                    </div>
                </a>
            </div>
            <div style="text-align: center; margin-top: 40px;">
                <button class="btn btn-primary btn-lg" onclick="openQuote('tyres')"><i class="fas fa-file-invoice"></i> Request Tyre Quote</button>
            </div>
        </div>
    </section>

    <!-- Brands -->
    <section class="brands" id="brands">
        <div class="container">
            <div class="section-header">
                <span class="section-badge"><i class="fas fa-award"></i> Trusted Partners</span>
                <h2>Premium Tyre Brands</h2>
                <p>We stock quality tyres from the world's leading manufacturers</p>
            </div>
                        <div class="brands-slider">
                <div class="brands-track">
                    <!-- First set of brands -->
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/BLACKLION-1-new.jpg.webp" alt="Black Lion"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Asset-1Doublecoin-Logo-300x50.webp" alt="Double Coin"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/doublestar-300x36.png.webp" alt="DoubleStar"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Triangle-png.webp" alt="Triangle"></a>
                    <a href="/products.php#agricultural" class="brand-item"><img src="/images/Tianli-1-png.webp" alt="Tianli"></a>
                    <a href="/products.php#mining" class="brand-item"><img src="/images/Techking-png.webp" alt="Techking"></a>
                    <a href="/products.php#agricultural" class="brand-item"><img src="/images/Ceat-png.webp" alt="CEAT"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Anchee.jpg.webp" alt="Anchee"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/brutus_300x170-png.webp" alt="Brutus"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Annaite-jpg.webp" alt="Annaite"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Lanv.svg" alt="Lanvigator"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Comforser-Logo-1536x387.webp" alt="Comforser"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/ChaoyangLogo.jpg.webp" alt="Chaoyang"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Ogreen.svg" alt="Ogreen"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/Bison-png.webp" alt="Bison"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/new-roadshine_square.jpg.webp" alt="Roadshine"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/NumaPrime-png.webp" alt="NumaPrime"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Talon-Prime-png.webp" alt="Talon Prime"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/MARCHER-Logo.webp" alt="Marcher"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Solo-png.webp" alt="Solo"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/milemaster-png.webp" alt="Milemaster"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/ringtread.jpg.webp" alt="Ringtread"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/LEADERTREAD.jpg.webp" alt="Leadertread"></a>
                    <!-- Duplicate set for seamless loop -->
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/BLACKLION-1-new.jpg.webp" alt="Black Lion"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Asset-1Doublecoin-Logo-300x50.webp" alt="Double Coin"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/doublestar-300x36.png.webp" alt="DoubleStar"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Triangle-png.webp" alt="Triangle"></a>
                    <a href="/products.php#agricultural" class="brand-item"><img src="/images/Tianli-1-png.webp" alt="Tianli"></a>
                    <a href="/products.php#mining" class="brand-item"><img src="/images/Techking-png.webp" alt="Techking"></a>
                    <a href="/products.php#agricultural" class="brand-item"><img src="/images/Ceat-png.webp" alt="CEAT"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Anchee.jpg.webp" alt="Anchee"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/brutus_300x170-png.webp" alt="Brutus"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Annaite-jpg.webp" alt="Annaite"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Lanv.svg" alt="Lanvigator"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Comforser-Logo-1536x387.webp" alt="Comforser"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/ChaoyangLogo.jpg.webp" alt="Chaoyang"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Ogreen.svg" alt="Ogreen"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/Bison-png.webp" alt="Bison"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/new-roadshine_square.jpg.webp" alt="Roadshine"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/NumaPrime-png.webp" alt="NumaPrime"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Talon-Prime-png.webp" alt="Talon Prime"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/MARCHER-Logo.webp" alt="Marcher"></a>
                    <a href="/products.php#consumer" class="brand-item"><img src="/images/Solo-png.webp" alt="Solo"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/milemaster-png.webp" alt="Milemaster"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/ringtread.jpg.webp" alt="Ringtread"></a>
                    <a href="/products.php#commercial" class="brand-item"><img src="/images/LEADERTREAD.jpg.webp" alt="Leadertread"></a>
                </div>
            </div>

            <div style="text-align: center; margin-top: 40px;">
                <a href="/products.php" class="btn btn-primary"><i class="fas fa-tags"></i> View All Brands & Tyres</a>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="section services" id="services">
        <div class="container">
            <div class="section-header">
                <span class="section-badge"><i class="fas fa-cogs"></i> Our Services</span>
                <h2>World-Class Tyre Solutions</h2>
                <p>With the best equipment in the country, we deliver premium tyre services that set the industry standard.</p>
            </div>
            <div class="services-grid">
                <a href="/services/retread.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-sync-alt"></i></div>
                    <h3>Retread Factory</h3>
                    <p>State-of-the-art retreading facility with latest technologies for quality tyre reconditioning.</p>
                    <span class="badge">Factory</span>
                </a>
                <a href="/services/rim-engineering.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-cog"></i></div>
                    <h3>Rim Engineering Factory</h3>
                    <p>Cutting-edge rim manufacturing & repair for commercial and off-road vehicles.</p>
                    <span class="badge">Factory</span>
                </a>
                <a href="/services/powder-coating.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-spray-can"></i></div>
                    <h3>Powder Coating Factory</h3>
                    <p>Superior electrostatic powder coating finish for rims and components.</p>
                    <span class="badge">Factory</span>
                </a>
                <a href="/services/fleet-management.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-truck-moving"></i></div>
                    <h3>Fleet Tyre Management</h3>
                    <p>Complete fleet tyre solutions including tracking, reporting, and cost optimization.</p>
                </a>
                <a href="/services/fleet-maintenance.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-tools"></i></div>
                    <h3>Fleet Tyre Maintenance</h3>
                    <p>Scheduled maintenance programs to maximize tyre life and fleet efficiency.</p>
                </a>
                <a href="/services/breakdowns.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-phone-alt"></i></div>
                    <h3>24HR National Breakdowns</h3>
                    <p>Round-the-clock emergency breakdown assistance across South Africa.</p>
                    <span class="badge">24/7</span>
                </a>
                <a href="/services/forklift-fitment.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-dolly"></i></div>
                    <h3>Forklift Site Severity & Fitment</h3>
                    <p>On-site forklift tyre assessment, fitment, and maintenance services.</p>
                </a>
                <a href="/services/drive-thru.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-warehouse"></i></div>
                    <h3>Truck Drive Thru & Fitment</h3>
                    <p>Quick and efficient drive-through fitment centre for trucks and commercial vehicles.</p>
                </a>
            </div>
            <div style="text-align: center; margin-top: 40px;">
                <button class="btn btn-white btn-lg" onclick="openQuote('services')"><i class="fas fa-file-invoice"></i> Request Service Quote</button>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta">
        <div class="container">
            <h2>Need Tyres or Services?</h2>
            <p>Get competitive pricing on tyres or any of our world-class services. Our team is ready to help.</p>
            <div class="cta-buttons">
                <button class="btn btn-white btn-lg" onclick="openQuote()"><i class="fas fa-file-invoice"></i> Get a Quote</button>
                <a href="tel:+27123456789" class="btn btn-outline btn-lg" style="border-color: white; color: white;"><i class="fas fa-phone"></i> Call Now</a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-logo">
                        <img src="/images/logo-icon.png" alt="TyreCure">
                    </div>
                    <p style="color: var(--primary); font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 1px;">Premium Tyres & Services</p>
                    <p>South Africa's leader in tyres and tyre services.</p>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="/products.php#consumer">Consumer Tyres</a></li>
                        <li><a href="/products.php#commercial">Commercial Tyres</a></li>
                        <li><a href="/products.php#industrial">Industrial Tyres</a></li>
                        <li><a href="/products.php#agricultural">Agricultural Tyres</a></li>
                        <li><a href="/products.php#mining">Mining Tyres</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Services</h4>
                    <ul class="footer-links">
                        <li><a href="/services/retread.php">Retread Factory</a></li>
                        <li><a href="/services/rim-engineering.php">Rim Engineering</a></li>
                        <li><a href="/services/powder-coating.php">Powder Coating</a></li>
                        <li><a href="/services/fleet-management.php">Fleet Management</a></li>
                        <li><a href="/services/breakdowns.php">24HR Breakdowns</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Company</h4>
                    <ul class="footer-links">
                        <li><a href="/contact.php">Contact</a></li>
                        <li><a href="/services.php">Services</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Contact</h4>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 12px;"><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 12px;"><i class="fas fa-envelope"></i> info@tyrecure.co.za</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> TyreCure. All rights reserved.</p>
                <a href="https://omnicure.co.za/" class="multicure-badge">
                    <span>Part of</span>
                    <div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div>
                </a>
            </div>
        </div>
    </footer>

    <!-- Floating Quote Button -->
    <button class="floating-quote" onclick="openQuote()">
        <i class="fas fa-file-invoice-dollar"></i>
        <span>Get a Quote</span>
    </button>

    <!-- Quote Modal -->
    <div class="quote-modal" id="quoteModal">
        <div class="quote-modal-content">
            <div class="quote-modal-header">
                <h3>Request a Quote</h3>
                <p>We'll get back to you within 24 hours</p>
                <button class="quote-modal-close" onclick="closeQuote()">&times;</button>
            </div>
            <form class="quote-form" onsubmit="return handleQuoteSubmit(this)">
                <div class="form-row">
                    <div class="form-group">
                        <label><i class="fas fa-user"></i> Your Name *</label>
                        <input type="text" name="name" placeholder="Full name" required>
                    </div>
                    <div class="form-group">
                        <label><i class="fas fa-building"></i> Company</label>
                        <input type="text" name="company" placeholder="Company name">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label><i class="fas fa-envelope"></i> Email *</label>
                        <input type="email" name="email" placeholder="your@email.com" required>
                    </div>
                    <div class="form-group">
                        <label><i class="fas fa-phone"></i> Phone *</label>
                        <input type="tel" name="phone" placeholder="Your contact number" required>
                    </div>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-list"></i> Quote Type *</label>
                    <select name="quote_type" id="quoteType" required>
                        <option value="">Select what you need...</option>
                        <optgroup label="Tyres">
                            <option value="Consumer Tyres">Consumer Tyres</option>
                            <option value="Commercial Tyres">Commercial Tyres</option>
                            <option value="Industrial Tyres">Industrial Tyres</option>
                            <option value="Agricultural Tyres">Agricultural Tyres</option>
                            <option value="Mining Tyres">Mining Tyres</option>
                        </optgroup>
                        <optgroup label="Services">
                            <option value="Retread Factory">Retread Factory</option>
                            <option value="Rim Engineering">Rim Engineering</option>
                            <option value="Powder Coating">Powder Coating</option>
                            <option value="Fleet Management">Fleet Tyre Management</option>
                            <option value="Fleet Maintenance">Fleet Tyre Maintenance</option>
                            <option value="24HR Breakdowns">24HR National Breakdowns</option>
                            <option value="Forklift Services">Forklift Site Severity & Fitment</option>
                            <option value="Truck Fitment">Truck Drive Thru & Fitment</option>
                        </optgroup>
                        <option value="Multiple / Other">Multiple Items / Other</option>
                    </select>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-comment"></i> Details & Requirements *</label>
                    <textarea name="message" placeholder="Please provide details about what you need - tyre sizes, quantities, vehicle types, service requirements, etc." required></textarea>
                </div>
                <button type="submit" class="submit-quote">
                    <i class="fas fa-paper-plane"></i> Send Quote Request
                </button>
            </form>
        </div>
    </div>

    <script>
        function openQuote(type) {
            document.getElementById('quoteModal').classList.add('active');
            document.body.style.overflow = 'hidden';

            if (type === 'tyres') {
                document.getElementById('quoteType').value = '';
            } else if (type === 'services') {
                document.getElementById('quoteType').value = '';
            }
        }

        function closeQuote() {
            document.getElementById('quoteModal').classList.remove('active');
            document.body.style.overflow = '';
        }

        document.getElementById('quoteModal').addEventListener('click', function(e) {
            if (e.target === this) closeQuote();
        });

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') closeQuote();
        });

        function handleQuoteSubmit(form) {
            const name = form.querySelector('input[name="name"]').value;
            const company = form.querySelector('input[name="company"]').value;
            const email = form.querySelector('input[name="email"]').value;
            const phone = form.querySelector('input[name="phone"]').value;
            const quoteType = form.querySelector('select[name="quote_type"]').value;
            const message = form.querySelector('textarea[name="message"]').value;

            const subject = encodeURIComponent('TyreCure Quote Request - ' + quoteType);
            const body = encodeURIComponent(
                'Quote Request from TyreCure Website\n' +
                '====================================\n\n' +
                'Name: ' + name + '\n' +
                'Company: ' + (company || 'Not specified') + '\n' +
                'Email: ' + email + '\n' +
                'Phone: ' + phone + '\n\n' +
                'Quote Type: ' + quoteType + '\n\n' +
                'Details & Requirements:\n' + message + '\n'
            );

            window.location.href = 'mailto:info@tyrecure.co.za?subject=' + subject + '&body=' + body;

            setTimeout(() => {
                alert('Thank you! Your email client should open with your quote request. If not, please email us directly at info@tyrecure.co.za');
                closeQuote();
            }, 500);

            return false;
        }

        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    const headerOffset = 200;
                    const elementPosition = target.getBoundingClientRect().top;
                    const offsetPosition = elementPosition + window.pageYOffset - headerOffset;
                    window.scrollTo({ top: offsetPosition, behavior: 'smooth' });
                }
            });
        });
    </script>
</body>
</html>
