<?php
require_once __DIR__ . '/../includes/config.php';

if (!isReseller()) {
    header('Location: login.php?redirect=' . urlencode($_SERVER['REQUEST_URI']));
    exit;
}

$resellerInfo = getResellerInfo();

// Scan pricelists directory
$pricelistDir = __DIR__ . '/pricelists/';
$pricelists = [];
if (is_dir($pricelistDir)) {
    $files = scandir($pricelistDir);
    foreach ($files as $file) {
        if ($file !== '.' && $file !== '..' && !is_dir($pricelistDir . $file)) {
            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            if (in_array($ext, ['pdf', 'xlsx', 'xls', 'doc', 'docx', 'csv'])) {
                $pricelists[] = [
                    'name' => pathinfo($file, PATHINFO_FILENAME),
                    'file' => $file,
                    'path' => 'pricelists/' . $file,
                    'size' => filesize($pricelistDir . $file),
                    'ext' => $ext
                ];
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reseller Portal - Tyrecure</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root { --site-color: #dc2626; --site-color-dark: #b91c1c; }
        .reseller-portal { min-height: 100vh; background: var(--gray-50); }
        .portal-header { background: linear-gradient(135deg, var(--site-color), var(--site-color-dark)); color: white; padding: 40px 0; }
        .portal-content { padding: 48px 0; }
        .portal-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 24px; }
        .portal-card { background: white; border-radius: var(--radius-lg); padding: 32px; box-shadow: var(--shadow); }
        .portal-card h3 { margin-bottom: 16px; color: var(--site-color); }
        .portal-card ul { list-style: none; }
        .portal-card li { padding: 12px 0; border-bottom: 1px solid var(--gray-100); display: flex; justify-content: space-between; align-items: center; }
        .portal-card li:last-child { border-bottom: none; }
        .download-btn { display: inline-flex; align-items: center; gap: 8px; padding: 8px 16px; background: var(--site-color); color: white; border-radius: var(--radius); text-decoration: none; font-size: 14px; }
        .download-btn:hover { filter: brightness(0.9); }
        .quote-form { display: flex; flex-direction: column; gap: 16px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 12px; border: 2px solid var(--gray-200); border-radius: var(--radius); font-size: 14px; }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { outline: none; border-color: var(--site-color); }
    </style>
</head>
<body>
    <div class="reseller-portal">
        <header class="site-header">
            <div class="container">
                <div class="header-content">
                    <a href="../" class="logo"><span class="logo-text" style="color: var(--site-color);">TYRECURE</span></a>
                    <nav class="nav">
                        <span class="reseller-badge"><?php echo htmlspecialchars($resellerInfo['company']); ?></span>
                        <a href="index.php" class="btn btn-outline">Dashboard</a>
                        <a href="logout.php" class="btn btn-secondary">Logout</a>
                    </nav>
                </div>
            </div>
        </header>

        <div class="portal-header">
            <div class="container">
                <h1>Tyrecure Reseller Portal</h1>
                <p>Access exclusive pricing, price lists, and request quotes</p>
            </div>
        </div>

        <div class="portal-content">
            <div class="container">
                <div class="portal-grid">
                    <div class="portal-card">
                        <h3>Price Lists & Documents</h3>
                        <?php if (empty($pricelists)): ?>
                            <p style="color: var(--gray-600); text-align: center; padding: 20px;">No documents available yet.</p>
                        <?php else: ?>
                            <ul>
                                <?php foreach ($pricelists as $pricelist):
                                    $iconColors = ['pdf' => '#dc2626', 'xlsx' => '#16a34a', 'xls' => '#16a34a', 'doc' => '#2563eb', 'docx' => '#2563eb', 'csv' => '#6b7280'];
                                    $iconColor = $iconColors[$pricelist['ext']] ?? '#6b7280';
                                ?>
                                <li>
                                    <span style="display: flex; align-items: center; gap: 10px;">
                                        <span style="background: <?php echo $iconColor; ?>; color: white; padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600;"><?php echo strtoupper($pricelist['ext']); ?></span>
                                        <?php echo htmlspecialchars($pricelist['name']); ?>
                                        <span style="color: var(--gray-400); font-size: 12px;">(<?php echo round($pricelist['size'] / 1024); ?> KB)</span>
                                    </span>
                                    <a href="<?php echo htmlspecialchars($pricelist['path']); ?>" class="download-btn" download>Download</a>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </div>

                    <div class="portal-card">
                        <h3>Your Pricing</h3>
                        <p style="color: var(--gray-600); margin-bottom: 20px;">Your exclusive reseller discount</p>
                        <div style="text-align: center; padding: 24px; background: var(--gray-50); border-radius: var(--radius);">
                            <div style="font-size: 48px; font-weight: 800; color: var(--success);"><?php echo $resellerInfo['discount']; ?>%</div>
                            <div style="color: var(--gray-600);">Off all products</div>
                        </div>
                        <a href="../" class="btn btn-primary" style="width: 100%; margin-top: 20px;">Browse Products with Reseller Prices</a>
                    </div>

                    <div class="portal-card">
                        <h3>Request a Quote</h3>
                        <form class="quote-form" method="POST" action="quote-submit.php">
                            <div class="form-group">
                                <label>Product(s)</label>
                                <input type="text" name="products" placeholder="Enter product names or codes" required>
                            </div>
                            <div class="form-group">
                                <label>Quantity</label>
                                <input type="text" name="quantity" placeholder="e.g., 50 units" required>
                            </div>
                            <div class="form-group">
                                <label>Additional Notes</label>
                                <textarea name="notes" rows="3" placeholder="Any special requirements..."></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Submit Quote Request</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
