<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Services | TyreCure - Comprehensive Tyre & Rim Services</title>
    <meta name="description" content="TyreCure Services - Retreading, Rim Engineering, Powder Coating, Fleet Management, 24HR Breakdowns, and more. Complete tyre solutions for South Africa.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #dc2626; --primary-dark: #991b1b; --primary-light: #ef4444;
            --secondary: #1e3a5f; --secondary-light: #2d4a6f;
            --accent: #f59e0b; --dark: #0f172a;
            --gray-50: #f8fafc; --gray-100: #f1f5f9; --gray-200: #e2e8f0; --gray-600: #475569;
            --white: #fff;
            --gradient-primary: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary) 100%);
            --gradient-secondary: linear-gradient(135deg, var(--secondary) 0%, var(--secondary-light) 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.15);
            --radius: 16px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1320px; margin: 0 auto; padding: 0 24px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.98); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 10px 0; }
        .logo img { height: 70px; }
        .nav { display: flex; align-items: center; gap: 8px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 2px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 10px 14px; border-radius: 8px; transition: all 0.2s; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .nav-links .dropdown { position: relative; }
        .nav-links .dropdown > a::after { content: '\f107'; font-family: 'Font Awesome 6 Free'; font-weight: 900; margin-left: 6px; font-size: 10px; }
        .dropdown-menu { position: absolute; top: 100%; left: 0; background: white; min-width: 220px; border-radius: 12px; box-shadow: var(--shadow-lg); padding: 8px; opacity: 0; visibility: hidden; transform: translateY(10px); transition: all 0.2s; }
        .dropdown:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        .dropdown-menu a { display: flex; align-items: center; gap: 10px; padding: 10px 14px; border-radius: 8px; font-size: 13px; }
        .dropdown-menu a i { width: 16px; color: var(--primary); }
        .dropdown-menu a:hover { background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 12px 24px; border-radius: 10px; font-weight: 600; font-size: 14px; text-decoration: none; transition: all 0.3s; border: none; cursor: pointer; }
        .btn-primary { background: var(--gradient-primary); color: white; box-shadow: 0 4px 15px rgba(220,38,38,0.3); }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(220,38,38,0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-white { background: white; color: var(--primary); }
        .btn-lg { padding: 16px 32px; font-size: 15px; }
        .btn-sm { padding: 8px 16px; font-size: 12px; }
        .page-hero { padding: 160px 0 100px; background: var(--gradient-secondary); position: relative; overflow: hidden; }
        .page-hero::before { content: ''; position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: url('https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=1920&q=80') center/cover; opacity: 0.15; }
        .page-hero .container { position: relative; z-index: 1; }
        .hero-content { max-width: 700px; color: white; }
        .hero-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.15); padding: 10px 20px; border-radius: 50px; font-size: 13px; font-weight: 500; margin-bottom: 24px; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; line-height: 1.2; }
        .page-hero h1 span { color: var(--primary-light); }
        .page-hero p { font-size: 1.15rem; opacity: 0.9; margin-bottom: 32px; }
        .content-section { padding: 80px 0; }
        .content-section.alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(220,38,38,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.2rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); font-size: 1.1rem; max-width: 600px; margin: 0 auto; }
        .services-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .service-card { background: white; border-radius: var(--radius); padding: 32px; box-shadow: var(--shadow); transition: all 0.3s; border: 2px solid transparent; text-decoration: none; color: inherit; display: block; }
        .service-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); border-color: var(--primary); }
        .service-icon { width: 60px; height: 60px; background: var(--gradient-primary); border-radius: 14px; display: flex; align-items: center; justify-content: center; color: white; font-size: 24px; margin-bottom: 20px; }
        .service-card h3 { font-size: 1.1rem; font-weight: 600; margin-bottom: 12px; }
        .service-card p { color: var(--gray-600); font-size: 13px; line-height: 1.7; margin-bottom: 16px; }
        .service-link { color: var(--primary); font-weight: 600; font-size: 13px; display: inline-flex; align-items: center; gap: 6px; }
        .service-link i { transition: transform 0.2s; }
        .service-card:hover .service-link i { transform: translateX(4px); }
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr 1fr; gap: 40px; margin-bottom: 48px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-logo { width: 100px; height: 100px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; }
        .footer-logo img { height: 65px; }
        .footer h4 { font-size: 14px; margin-bottom: 20px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: white; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); text-decoration: none; font-size: 13px; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1200px) { .services-grid { grid-template-columns: repeat(3, 1fr); } .footer-grid { grid-template-columns: repeat(3, 1fr); } }
        @media (max-width: 1024px) { .services-grid { grid-template-columns: repeat(2, 1fr); } }
        @media (max-width: 768px) { .page-hero h1 { font-size: 2.2rem; } .services-grid { grid-template-columns: 1fr; } .footer-grid { grid-template-columns: 1fr 1fr; } .footer-bottom { flex-direction: column; gap: 16px; text-align: center; } .nav-links { display: none; } }
    </style>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/" class="logo"><img src="/images/logo-long.png" alt="TyreCure"></a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/">Home</a></li>
                        <li class="dropdown">
                            <a href="/products.php">Products</a>
                            <div class="dropdown-menu">
                                <a href="/products.php#consumer"><i class="fas fa-car"></i> Consumer Tyres</a>
                                <a href="/products.php#commercial"><i class="fas fa-truck"></i> Commercial Tyres</a>
                                <a href="/products.php#industrial"><i class="fas fa-industry"></i> Industrial Tyres</a>
                                <a href="/products.php#agricultural"><i class="fas fa-tractor"></i> Agricultural Tyres</a>
                                <a href="/products.php#mining"><i class="fas fa-hard-hat"></i> Mining Tyres</a>
                                <a href="/products.php#brands"><i class="fas fa-tags"></i> Tyre Brands</a>
                            </div>
                        </li>
                        <li class="dropdown">
                            <a href="/services.php">Services</a>
                            <div class="dropdown-menu">
                                <a href="/services/retread.php"><i class="fas fa-sync-alt"></i> Retread Factory</a>
                                <a href="/services/rim-engineering.php"><i class="fas fa-cog"></i> Rim Engineering</a>
                                <a href="/services/powder-coating.php"><i class="fas fa-spray-can"></i> Powder Coating</a>
                                <a href="/services/fleet-management.php"><i class="fas fa-truck-moving"></i> Fleet Management</a>
                                <a href="/services/fleet-maintenance.php"><i class="fas fa-tools"></i> Fleet Maintenance</a>
                                <a href="/services/breakdowns.php"><i class="fas fa-phone-alt"></i> 24HR Breakdowns</a>
                                <a href="/services/forklift-fitment.php"><i class="fas fa-dolly"></i> Forklift Fitment</a>
                                <a href="/services/drive-thru.php"><i class="fas fa-warehouse"></i> Truck Drive Thru</a>
                            </div>
                        </li>
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                    <?php else: ?>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </header>

    <section class="page-hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-badge"><i class="fas fa-cogs"></i> Our Services</div>
                <h1>Comprehensive <span>Tyre Services</span></h1>
                <p>From retreading to 24-hour breakdown assistance, TyreCure provides complete tyre and rim solutions for all your needs. Expert service, quality workmanship, nationwide coverage.</p>
            </div>
        </div>
    </section>

    <section class="content-section">
        <div class="container">
            <div class="section-header">
                <div class="section-badge"><i class="fas fa-industry"></i> Manufacturing & Reconditioning</div>
                <h2>Factory Services</h2>
                <p>State-of-the-art manufacturing and reconditioning facilities.</p>
            </div>
            <div class="services-grid">
                <a href="/services/retread.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-sync-alt"></i></div>
                    <h3>Retread Factory</h3>
                    <p>Marangoni retreading technology delivering quality reconditioning at a fraction of new tyre costs.</p>
                    <span class="service-link">Learn more <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="/services/rim-engineering.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-cog"></i></div>
                    <h3>Rim Engineering</h3>
                    <p>Expert rim manufacturing, repair, and refurbishment with safety testing for all vehicle types.</p>
                    <span class="service-link">Learn more <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="/services/powder-coating.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-spray-can"></i></div>
                    <h3>Powder Coating</h3>
                    <p>Durable, UV and corrosion resistant finishes in a wide range of colors. Eco-friendly process.</p>
                    <span class="service-link">Learn more <i class="fas fa-arrow-right"></i></span>
                </a>
            </div>
        </div>
    </section>

    <section class="content-section alt">
        <div class="container">
            <div class="section-header">
                <div class="section-badge"><i class="fas fa-truck"></i> Fleet Solutions</div>
                <h2>Fleet Services</h2>
                <p>Complete fleet tyre management and maintenance solutions.</p>
            </div>
            <div class="services-grid">
                <a href="/services/fleet-management.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-truck-moving"></i></div>
                    <h3>Fleet Management</h3>
                    <p>Comprehensive tyre tracking, performance reporting, cost analysis, and dedicated account management.</p>
                    <span class="service-link">Learn more <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="/services/fleet-maintenance.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-tools"></i></div>
                    <h3>Fleet Maintenance</h3>
                    <p>Regular inspections, pressure monitoring, rotations, and comprehensive maintenance services.</p>
                    <span class="service-link">Learn more <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="/services/breakdowns.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-phone-alt"></i></div>
                    <h3>24HR Breakdowns</h3>
                    <p>Emergency tyre assistance anywhere in South Africa. Fast response, available 24/7.</p>
                    <span class="service-link">Learn more <i class="fas fa-arrow-right"></i></span>
                </a>
            </div>
        </div>
    </section>

    <section class="content-section">
        <div class="container">
            <div class="section-header">
                <div class="section-badge"><i class="fas fa-wrench"></i> Field & Fitment</div>
                <h2>Fitment Services</h2>
                <p>Professional on-site and in-centre tyre fitment solutions.</p>
            </div>
            <div class="services-grid">
                <a href="/services/forklift-fitment.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-dolly"></i></div>
                    <h3>Forklift Fitment</h3>
                    <p>On-site forklift tyre assessment, severity analysis, and fitment. Zero downtime service.</p>
                    <span class="service-link">Learn more <i class="fas fa-arrow-right"></i></span>
                </a>
                <a href="/services/drive-thru.php" class="service-card">
                    <div class="service-icon"><i class="fas fa-warehouse"></i></div>
                    <h3>Truck Drive Thru</h3>
                    <p>Commercial vehicle tyre centre with quick turnaround on fitting, balancing, and alignment.</p>
                    <span class="service-link">Learn more <i class="fas fa-arrow-right"></i></span>
                </a>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-logo"><img src="/images/logo-icon.png" alt="TyreCure"></div>
                    <p style="color: var(--primary); font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 1px;">Premium Tyres & Services</p>
                    <p>South Africa's leader in tyres and tyre services.</p>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="/products.php#consumer">Consumer Tyres</a></li>
                        <li><a href="/products.php#commercial">Commercial Tyres</a></li>
                        <li><a href="/products.php#industrial">Industrial Tyres</a></li>
                        <li><a href="/products.php#agricultural">Agricultural Tyres</a></li>
                        <li><a href="/products.php#mining">Mining Tyres</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Services</h4>
                    <ul class="footer-links">
                        <li><a href="/services/retread.php">Retread Factory</a></li>
                        <li><a href="/services/rim-engineering.php">Rim Engineering</a></li>
                        <li><a href="/services/powder-coating.php">Powder Coating</a></li>
                        <li><a href="/services/fleet-management.php">Fleet Management</a></li>
                        <li><a href="/services/breakdowns.php">24HR Breakdowns</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Company</h4>
                    <ul class="footer-links">
                        <li><a href="/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Contact</h4>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 12px;"><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 12px;"><i class="fas fa-envelope"></i> info@tyrecure.co.za</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> TyreCure. All rights reserved.</p>
                <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
            </div>
        </div>
    </footer>
</body>
</html>
