<?php require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/email_config.php';
require_once __DIR__ . '/includes/security.php';
$brand = 'tyrecure';
$emails = getBrandEmails($brand); $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us | TyreCure - Get a Tyre Quote</title>
    <meta name="description" content="Contact TyreCure for tyre quotes and enquiries. We supply quality tyres for passenger, 4x4, commercial and agricultural vehicles across South Africa.">
    <link rel="icon" type="image/x-icon" href="/tyrecure/favicon.ico">
    <link rel="apple-touch-icon" href="/tyrecure/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #dc2626; --primary-dark: #b91c1c; --secondary: #f97316; --dark: #18181b; --gray-50: #fafafa; --gray-100: #f4f4f5; --gray-200: #e4e4e7; --gray-600: #52525b; --white: #fff; --gradient-hero: linear-gradient(135deg, #7f1d1d 0%, #dc2626 50%, #b91c1c 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.12); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo img { height: 60px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 8px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 10px; }
        .multicure-link { background: #f1f5f9; color: #64748b !important; font-size: 12px !important; }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .btn { display: inline-flex; align-items: center; gap: 8px; padding: 10px 18px; border-radius: 12px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-hero { background: var(--gradient-hero); padding: 160px 0 100px; text-align: center; color: white; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; }
        .page-hero p { font-size: 1.2rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }
        .contact-section { padding: 80px 0; }
        .contact-grid { display: grid; grid-template-columns: 1fr 1.5fr; gap: 60px; }
        .info-card { background: var(--gray-50); border-radius: var(--radius); padding: 28px; margin-bottom: 20px; }
        .info-card-icon { width: 50px; height: 50px; background: var(--gradient-hero); color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-bottom: 16px; }
        .info-card h3 { font-size: 1.1rem; margin-bottom: 10px; }
        .info-card p { color: var(--gray-600); font-size: 14px; }
        .info-card a { color: var(--primary); text-decoration: none; font-weight: 500; }
        .contact-form { background: white; border-radius: var(--radius); padding: 40px; box-shadow: var(--shadow-lg); }
        .contact-form h2 { font-size: 1.6rem; margin-bottom: 8px; }
        .contact-form .subtitle { color: var(--gray-600); margin-bottom: 28px; }
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 14px; border: 2px solid var(--gray-200); border-radius: 10px; font-family: inherit; font-size: 13px; }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { outline: none; border-color: var(--primary); }
        .form-group textarea { resize: vertical; min-height: 100px; }
        .success-message { display: none; text-align: center; padding: 60px 20px; }
        .success-message.active { display: block; }
        .success-message i { font-size: 5rem; color: var(--secondary); margin-bottom: 24px; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 48px; margin-bottom: 40px; }
        .footer-icon-container { width: 150px; height: 150px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; box-shadow: 0 8px 30px rgba(0,0,0,0.3); }
        .footer-icon-container img { height: 100px; display: block; }
        .footer-tagline { color: var(--secondary); font-weight: 600; font-size: 13px; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer h4 { margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 8px; color: rgba(255,255,255,0.7); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1024px) { .contact-grid { grid-template-columns: 1fr; } .footer-grid { grid-template-columns: 1fr 1fr; } }
        @media (max-width: 768px) { .form-row { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-grid { grid-template-columns: 1fr; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/tyrecure/" class="logo"><img src="/tyrecure/images/logo-long.png" alt="TyreCure" style="height: 70px;"></a>
        <nav><ul class="nav-links"><li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li><li><a href="/tyrecure/">Home</a></li><li><a href="/tyrecure/products.php">Products</a></li><li><a href="/tyrecure/services.php">Services</a></li><li><a href="/tyrecure/contact.php" class="active">Contact</a></li></ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
    </div></div></header>

    <section class="page-hero"><div class="container"><h1>Contact Us</h1><p>Get in touch for quotes, advice, or any tyre-related enquiries.</p></div></section>

    <section class="contact-section"><div class="container"><div class="contact-grid">
        <div>
            <div class="info-card"><div class="info-card-icon"><i class="fas fa-phone"></i></div><h3>Call Us</h3><p>Mon - Fri: 7:30 AM - 5:00 PM<br>Sat: 8:00 AM - 1:00 PM</p><a href="tel:+27123456789">+27 12 345 6789</a></div>
            <div class="info-card"><div class="info-card-icon"><i class="fas fa-envelope"></i></div><h3>Email Us</h3><p>For quotes and enquiries</p><a href="mailto:info@tyrecure.co.za">info@tyrecure.co.za</a></div>
            <div class="info-card"><div class="info-card-icon"><i class="fas fa-map-marker-alt"></i></div><h3>Location</h3><p>South Africa<br>Nationwide Delivery</p></div>
            <div class="info-card"><div class="info-card-icon"><i class="fab fa-whatsapp"></i></div><h3>WhatsApp</h3><p>Quick responses</p><a href="https://wa.me/27123456789">Chat on WhatsApp</a></div>
        </div>
        <div class="contact-form">
            <div id="formContent"><h2>Request a Quote</h2><p class="subtitle">Tell us what you need and we'll get back to you.</p>
                <form onsubmit="submitForm(event)">
                            <?= outputHoneypot() ?>
                            <?= outputTimestamp() ?>
                    <div class="form-row"><div class="form-group"><label>Name *</label><input type="text" required></div><div class="form-group"><label>Phone *</label><input type="tel" required></div></div>
                    <div class="form-group"><label>Email *</label><input type="email" required></div>
                    <div class="form-group"><label>Enquiry Type *</label><select required><option value="">Select...</option><option>Tyre Quote</option><option>Fleet Enquiry</option><option>Product Information</option><option>General Enquiry</option></select></div>
                    <div class="form-group"><label>Vehicle Make & Model</label><input type="text" placeholder="e.g., Toyota Hilux 2022"></div>
                    <div class="form-row"><div class="form-group"><label>Tyre Size</label><input type="text" placeholder="e.g., 265/65R17"></div><div class="form-group"><label>Quantity</label><input type="number" placeholder="4" min="1"></div></div>
                    <div class="form-group"><label>Message *</label><textarea required placeholder="Tell us more about your requirements..."></textarea></div>
                    <?= outputMathCaptcha("math_answer") ?>
                            <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fas fa-paper-plane"></i> Send Enquiry</button>
                </form>
            </div>
            <div class="success-message" id="successMessage"><i class="fas fa-check-circle"></i><h3>Enquiry Sent!</h3><p>We'll respond within 24 hours with your quote.</p><button class="btn btn-primary" onclick="resetForm()" style="margin-top: 24px;">Send Another</button></div>
        </div>
    </div></div></section>

    <footer class="footer"><div class="container">
        <div class="footer-grid">
            <div class="footer-brand"><div class="footer-icon-container"><img src="/tyrecure/images/logo-icon.png" alt="Tyrecure" style="height: 80px;"></div><p>The driving force behind the tyre industry in South Africa.</p></div>
            <div><h4>Quick Links</h4><ul class="footer-links"><li><a href="/tyrecure/products.php">Products</a></li><li><a href="/tyrecure/about.php">About Us</a></li><li><a href="/tyrecure/contact.php">Contact</a></li></ul></div>
            <div><h4>Tyre Categories</h4><ul class="footer-links"><li><a href="/tyrecure/products.php#passenger">Passenger</a></li><li><a href="/tyrecure/products.php#suv">4x4 & SUV</a></li><li><a href="/tyrecure/products.php#commercial">Commercial</a></li><li><a href="/tyrecure/products.php#agricultural">Agricultural</a></li></ul></div>
            <div><h4>Contact</h4><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-phone"></i> +27 12 345 6789</p><p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-envelope"></i> info@tyrecure.co.za</p></div>
        </div>
        <div class="footer-bottom"><p>&copy; <?= date('Y') ?> TyreCure. All rights reserved.</p><a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></div></div>
    </div></footer>
    <script>
        function submitForm(e) { e.preventDefault(); document.getElementById('formContent').style.display = 'none'; document.getElementById('successMessage').classList.add('active'); }
        function resetForm() { document.getElementById('formContent').style.display = 'block'; document.getElementById('successMessage').classList.remove('active'); document.querySelector('form').reset(); }
    
        function submitContactForm(e) {
            e.preventDefault();
            var form = e.target;
            var formData = new FormData(form);
            var submitBtn = form.querySelector('button[type=submit]');
            var originalText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
            submitBtn.disabled = true;
            
            fetch('send-contact.php', {
                method: 'POST',
                body: formData
            })
            .then(function(response) { return response.json(); })
            .then(function(data) {
                if (data.success) {
                    var formContent = document.getElementById('formContent');
                    var successMessage = document.getElementById('successMessage');
                    if (formContent && successMessage) {
                        formContent.style.display = 'none';
                        successMessage.classList.add('active');
                    } else {
                        alert('Message sent successfully!');
                        form.reset();
                    }
                } else {
                    alert(data.message || 'An error occurred. Please try again.');
                }
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            })
            .catch(function(error) {
                console.error('Error:', error);
                alert('An error occurred. Please try again.');
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            });
        }

    </script>
</body>
</html>
