<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tyre Products - TyreCure | Consumer, Commercial, Industrial, Agricultural & Mining Tyres</title>
    <meta name="description" content="Browse our comprehensive range of tyres - Consumer, Commercial, Industrial, Agricultural and Mining. Top brands including Black Lion, Triangle, Techking, Double Coin and more.">
    <link rel="icon" type="image/x-icon" href="/tyrecure/favicon.ico">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #dc2626;
            --primary-dark: #991b1b;
            --primary-light: #ef4444;
            --secondary: #1e3a5f;
            --secondary-light: #2d4a6f;
            --accent: #f59e0b;
            --dark: #0f172a;
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-600: #475569;
            --white: #fff;
            --gradient-primary: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary) 100%);
            --gradient-secondary: linear-gradient(135deg, var(--secondary) 0%, var(--secondary-light) 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --shadow-lg: 0 12px 40px rgba(0,0,0,0.15);
            --radius: 16px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1320px; margin: 0 auto; padding: 0 24px; }

        /* Header */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: rgba(255,255,255,0.98);
            backdrop-filter: blur(20px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.06);
        }
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0;
        }
        .logo img { height: 70px; }
        .nav { display: flex; align-items: center; gap: 8px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 2px; list-style: none; align-items: center; }
        .nav-links a {
            text-decoration: none;
            color: var(--gray-600);
            font-weight: 500;
            font-size: 13px;
            padding: 10px 14px;
            border-radius: 8px;
            transition: all 0.2s;
        }
        .nav-links a:hover, .nav-links a.active { color: var(--primary); background: var(--gray-50); }
        .nav-links .dropdown { position: relative; }
        .nav-links .dropdown > a::after { content: '\f107'; font-family: 'Font Awesome 6 Free'; font-weight: 900; margin-left: 6px; font-size: 10px; }
        .dropdown-menu { position: absolute; top: 100%; left: 0; background: white; min-width: 220px; border-radius: 12px; box-shadow: var(--shadow-lg); padding: 8px; opacity: 0; visibility: hidden; transform: translateY(10px); transition: all 0.2s; }
        .dropdown:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        .dropdown-menu a { display: flex; align-items: center; gap: 10px; padding: 10px 14px; border-radius: 8px; font-size: 13px; }
        .dropdown-menu a i { width: 16px; color: var(--primary); }
        .dropdown-menu a:hover { background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            padding: 12px 24px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 14px;
            text-decoration: none;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        .btn-primary { background: var(--gradient-primary); color: white; }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(220,38,38,0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-sm { padding: 8px 16px; font-size: 12px; }

        /* Page Hero */
        .page-hero {
            padding: 140px 0 60px;
            background: var(--gradient-secondary);
            color: white;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .page-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=1920&q=80') center/cover;
            opacity: 0.15;
        }
        .page-hero .container { position: relative; z-index: 1; }
        .page-hero h1 { font-size: 2.8rem; font-weight: 800; margin-bottom: 16px; }
        .page-hero p { font-size: 1.1rem; opacity: 0.9; max-width: 600px; margin: 0 auto; }

        /* Category Tabs */
        .category-tabs {
            background: white;
            box-shadow: var(--shadow);
            position: sticky;
            top: 90px;
            z-index: 100;
        }
        .tabs-content {
            display: flex;
            justify-content: center;
            gap: 8px;
            padding: 16px 0;
            overflow-x: auto;
        }
        .tab-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            background: var(--gray-50);
            color: var(--gray-600);
            border: none;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            white-space: nowrap;
            transition: all 0.2s;
            font-family: inherit;
        }
        .tab-btn:hover { background: var(--gray-100); color: var(--dark); }
        .tab-btn.active { background: var(--gradient-primary); color: white; }

        /* Section Styles */
        .section { padding: 60px 0; scroll-margin-top: 150px; }
        .section:nth-child(even) { background: var(--gray-50); }
        .category-section { scroll-margin-top: 150px; display: none; }
        .category-section.active { display: block; }
        .section-header { margin-bottom: 32px; text-align: center; }
        .section-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(220,38,38,0.1);
            color: var(--primary);
            padding: 8px 16px;
            border-radius: 50px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 12px;
        }
        .section-header h2 { font-size: 2rem; font-weight: 700; margin-bottom: 8px; }
        .section-header p { color: var(--gray-600); font-size: 15px; max-width: 600px; margin: 0 auto; }

        /* Sub-category Tabs */
        .subcategory-tabs {
            display: flex;
            justify-content: center;
            gap: 8px;
            margin-bottom: 24px;
            flex-wrap: wrap;
        }
        .subcategory-btn {
            padding: 10px 20px;
            background: white;
            color: var(--gray-600);
            border: 2px solid var(--gray-200);
            border-radius: 8px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            font-family: inherit;
        }
        .subcategory-btn:hover { border-color: var(--primary); color: var(--primary); }
        .subcategory-btn.active { background: var(--primary); color: white; border-color: var(--primary); }

        /* Tier Tabs */
        .tier-tabs {
            display: flex;
            justify-content: center;
            gap: 4px;
            margin-bottom: 24px;
            background: var(--gray-100);
            padding: 6px;
            border-radius: 12px;
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }
        .tier-btn {
            flex: 1;
            padding: 10px 16px;
            background: transparent;
            color: var(--gray-600);
            border: none;
            border-radius: 8px;
            font-size: 12px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.2s;
            font-family: inherit;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .tier-btn:hover { color: var(--dark); }
        .tier-btn.active.premium { background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8f 100%); color: white; }
        .tier-btn.active.mid { background: linear-gradient(135deg, #475569 0%, #64748b 100%); color: white; }
        .tier-btn.active.value { background: linear-gradient(135deg, #059669 0%, #10b981 100%); color: white; }
        .tier-btn.active.ultra { background: linear-gradient(135deg, #7c3aed 0%, #a855f7 100%); color: white; }

        /* Tier Content */
        .tier-content { display: none; }
        .tier-content.active { display: block; }
        .subcategory-content { display: none; }
        .subcategory-content.active { display: block; }

        /* Brands Grid */
        .brands-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 16px;
        }
        .brand-card {
            background: white;
            border-radius: var(--radius);
            padding: 20px;
            text-align: center;
            box-shadow: var(--shadow);
            cursor: pointer;
            transition: all 0.3s;
            border: 2px solid transparent;
        }
        .brand-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-lg);
            border-color: var(--primary);
        }
        .brand-logo {
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
        }
        .brand-logo img {
            max-height: 50px;
            max-width: 100%;
            object-fit: contain;
        }
        .brand-card h4 { font-size: 13px; color: var(--dark); margin-bottom: 2px; }
        .brand-card span { font-size: 10px; color: var(--gray-600); }


        /* Brand Section - Expandable */
        .brand-section {
            margin-bottom: 16px;
        }
        .brand-section-header {
            display: flex;
            align-items: center;
            gap: 16px;
            padding: 16px 20px;
            background: white;
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            cursor: pointer;
            transition: all 0.3s;
            border: 2px solid transparent;
        }
        .brand-section-header:hover {
            border-color: var(--primary);
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }
        .brand-section-header.active {
            border-color: var(--primary);
            border-radius: var(--radius) var(--radius) 0 0;
        }
        .brand-section-logo {
            height: 40px;
            width: auto;
        }
        .brand-section-logo img {
            height: 40px;
            max-width: 120px;
            object-fit: contain;
        }
        .brand-section-header h3 {
            font-size: 1rem;
            color: var(--dark);
            margin: 0;
            flex: 1;
        }
        .brand-section-header .expand-icon {
            font-size: 14px;
            color: var(--gray-600);
            transition: transform 0.3s;
        }
        .brand-section-header.active .expand-icon {
            transform: rotate(180deg);
        }
        .brand-tyres-container {
            display: none;
            background: var(--gray-50);
            padding: 20px;
            border-radius: 0 0 var(--radius) var(--radius);
            border: 2px solid var(--primary);
            border-top: none;
            margin-bottom: 16px;
        }
        .brand-tyres-container.active {
            display: block;
        }
        .availability-notice {
            text-align: center;
            padding: 24px;
            color: var(--gray-600);
        }
        .availability-notice i {
            font-size: 32px;
            color: var(--primary);
            margin-bottom: 12px;
        }
        .availability-notice h4 {
            color: var(--dark);
            margin-bottom: 8px;
        }
        
        /* Tyre Grid */
        .tyres-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            gap: 20px;
        }
        .tyre-card {
            background: white;
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            cursor: pointer;
            transition: all 0.3s;
            border: 2px solid transparent;
        }
        .tyre-card:hover {
            transform: translateY(-6px);
            box-shadow: var(--shadow-lg);
            border-color: var(--primary);
        }
        .tyre-card-image {
            height: 160px;
            background: var(--gray-50);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 16px;
        }
        .tyre-card-image img {
            max-height: 100%;
            max-width: 100%;
            object-fit: contain;
        }
        .tyre-card-body {
            padding: 16px;
            text-align: center;
        }
        .tyre-card h4 {
            font-size: 14px;
            color: var(--dark);
            margin-bottom: 4px;
        }
        .tyre-card span {
            font-size: 11px;
            color: var(--gray-600);
        }
        .tyre-card .view-btn {
            display: inline-block;
            margin-top: 10px;
            padding: 6px 14px;
            background: var(--primary);
            color: white;
            border-radius: 6px;
            font-size: 11px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.2s;
        }
        .tyre-card .view-btn:hover {
            background: var(--primary-dark);
        }

        /* Quote CTA */
        .quote-cta {
            background: var(--gradient-secondary);
            color: white;
            padding: 32px;
            border-radius: var(--radius);
            text-align: center;
            margin-top: 32px;
        }
        .quote-cta h3 { font-size: 1.3rem; margin-bottom: 8px; }
        .quote-cta p { opacity: 0.9; margin-bottom: 16px; font-size: 14px; }
        .quote-cta .btn { background: white; color: var(--secondary); }
        .quote-cta .btn:hover { background: var(--gray-100); }

        /* Footer */
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr 1fr; gap: 40px; margin-bottom: 48px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-logo { width: 100px; height: 100px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; }
        .footer-logo img { height: 65px; }
        .footer h4 { font-size: 14px; margin-bottom: 20px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: white; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); text-decoration: none; font-size: 13px; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        .multicure-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            font-size: 13px;
        }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge img { height: 28px; display: block; }

        /* Quote Modal */
        .quote-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.8);
            z-index: 2000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .quote-modal.active { display: flex; }
        .quote-modal-content {
            background: white;
            border-radius: 20px;
            max-width: 500px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
            animation: modalSlide 0.3s ease;
        }
        @keyframes modalSlide {
            from { opacity: 0; transform: translateY(-30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .quote-modal-header {
            background: var(--gradient-primary);
            color: white;
            padding: 24px;
            border-radius: 20px 20px 0 0;
            position: relative;
        }
        .quote-modal-header h3 { font-size: 1.3rem; margin-bottom: 4px; }
        .quote-modal-header p { opacity: 0.9; font-size: 13px; }
        .quote-modal-close {
            position: absolute;
            top: 16px;
            right: 16px;
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            font-size: 18px;
            cursor: pointer;
        }
        .quote-form { padding: 24px; }
        .form-group { margin-bottom: 16px; }
        .form-group label { display: block; font-size: 13px; font-weight: 600; margin-bottom: 6px; color: var(--dark); }
        .form-group input, .form-group select, .form-group textarea {
            width: 100%;
            padding: 12px 14px;
            border: 2px solid var(--gray-200);
            border-radius: 8px;
            font-size: 14px;
            font-family: inherit;
            transition: all 0.2s;
        }
        .form-group input:focus, .form-group select:focus, .form-group textarea:focus {
            outline: none;
            border-color: var(--primary);
        }
        .form-group textarea { min-height: 80px; resize: vertical; }
        .selected-product {
            background: var(--gray-50);
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 16px;
            font-size: 13px;
        }
        .selected-product strong { color: var(--primary); }
        .submit-quote {
            width: 100%;
            padding: 14px;
            background: var(--gradient-primary);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        .submit-quote:hover { transform: translateY(-2px); }

        /* Floating Quote */
        .floating-quote {
            position: fixed;
            bottom: 30px;
            right: 30px;
            z-index: 999;
            padding: 14px 24px;
            background: var(--gradient-primary);
            color: white;
            border: none;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 8px 30px rgba(220,38,38,0.4);
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .floating-quote:hover { transform: translateY(-4px) scale(1.05); }

        /* Responsive */
        @media (max-width: 1024px) {
            .footer-grid { grid-template-columns: 1fr 1fr; }
        }
        @media (max-width: 768px) {
            .nav-links { display: none; }
            .page-hero h1 { font-size: 2rem; }
            .brands-grid { grid-template-columns: repeat(2, 1fr); }
            .footer-grid { grid-template-columns: 1fr; }
            .footer-bottom { flex-direction: column; gap: 16px; }
            .section { padding: 40px 0; }
            .tier-tabs { flex-wrap: wrap; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/tyrecure/" class="logo">
                    <img src="/tyrecure/images/logo-long.png" alt="TyreCure">
                </a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/tyrecure/">Home</a></li>
                        <li class="dropdown">
                            <a href="/tyrecure/products.php" class="active">Products</a>
                            <div class="dropdown-menu">
                                <a href="/tyrecure/products.php#consumer"><i class="fas fa-car"></i> Consumer Tyres</a>
                                <a href="/tyrecure/products.php#commercial"><i class="fas fa-truck"></i> Commercial Tyres</a>
                                <a href="/tyrecure/products.php#industrial"><i class="fas fa-industry"></i> Industrial Tyres</a>
                                <a href="/tyrecure/products.php#agricultural"><i class="fas fa-tractor"></i> Agricultural Tyres</a>
                                <a href="/tyrecure/products.php#mining"><i class="fas fa-hard-hat"></i> Mining Tyres</a>
                                <a href="/tyrecure/products.php#brands"><i class="fas fa-tags"></i> Tyre Brands</a>
                            </div>
                        </li>
                        <li class="dropdown">
                            <a href="/tyrecure/services.php">Services</a>
                            <div class="dropdown-menu">
                                <a href="/tyrecure/services/retread.php"><i class="fas fa-sync-alt"></i> Retread Factory</a>
                                <a href="/tyrecure/services/rim-engineering.php"><i class="fas fa-cog"></i> Rim Engineering</a>
                                <a href="/tyrecure/services/powder-coating.php"><i class="fas fa-spray-can"></i> Powder Coating</a>
                                <a href="/tyrecure/services/fleet-management.php"><i class="fas fa-truck-moving"></i> Fleet Management</a>
                                <a href="/tyrecure/services/fleet-maintenance.php"><i class="fas fa-tools"></i> Fleet Maintenance</a>
                                <a href="/tyrecure/services/breakdowns.php"><i class="fas fa-phone-alt"></i> 24HR Breakdowns</a>
                                <a href="/tyrecure/services/forklift-fitment.php"><i class="fas fa-dolly"></i> Forklift Fitment</a>
                                <a href="/tyrecure/services/drive-thru.php"><i class="fas fa-warehouse"></i> Truck Drive Thru</a>
                            </div>
                        </li>
                        <li><a href="/tyrecure/contact.php">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                        <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
                    <?php else: ?>
                        <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </header>

    <section class="page-hero">
        <div class="container">
            <h1>Tyre Products</h1>
            <p>Comprehensive range of quality tyres for every application - from passenger vehicles to mining equipment.</p>
        </div>
    </section>

    <nav class="category-tabs">
        <div class="container">
            <div class="tabs-content">
                <button class="tab-btn active" onclick="showCategory('consumer')"><i class="fas fa-car"></i> Consumer</button>
                <button class="tab-btn" onclick="showCategory('commercial')"><i class="fas fa-truck"></i> Commercial</button>
                <button class="tab-btn" onclick="showCategory('industrial')"><i class="fas fa-industry"></i> Industrial</button>
                <button class="tab-btn" onclick="showCategory('agricultural')"><i class="fas fa-tractor"></i> Agricultural</button>
                <button class="tab-btn" onclick="showCategory('mining')"><i class="fas fa-hard-hat"></i> Mining</button>
            </div>
        </div>
    </nav>

    <!-- Consumer Tyres -->
    <section class="section category-section active" id="consumer">
        <div class="container">
            <div class="section-header">
                <span class="section-badge"><i class="fas fa-car"></i> Consumer Tyres</span>
                <h2>Passenger & Light Vehicle Tyres</h2>
                <p>Premium tyres for sedans, hatchbacks, SUVs, and family vehicles</p>
            </div>

            <!-- Sub-category tabs -->
            <div class="subcategory-tabs">
                <button class="subcategory-btn active" onclick="showSubcategory('consumer', 'passenger')"><i class="fas fa-car-side"></i> Passenger</button>
                <button class="subcategory-btn" onclick="showSubcategory('consumer', 'suv')"><i class="fas fa-truck-monster"></i> SUV / 4x4</button>
            </div>

            <!-- Passenger -->
            <div class="subcategory-content active" id="consumer-passenger">
                <div class="tier-tabs">
                    <button class="tier-btn premium active" onclick="showTier('consumer-passenger', 'premium')">Premium</button>
                    <button class="tier-btn mid" onclick="showTier('consumer-passenger', 'mid')">Mid Range</button>
                    <button class="tier-btn value" onclick="showTier('consumer-passenger', 'value')">Value</button>
                </div>

                <!-- Premium Tier - AUTOGRIP -->
                <div class="tier-content active" id="consumer-passenger-premium">
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/autogrip-logo.svg" alt="Autogrip"></div>
                            <h3>AUTOGRIP - Premium Performance</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Autogrip ECOSAVER', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-ecosaver.webp" alt="ECOSAVER" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>ECOSAVER</h4>
                                        <span>Eco-friendly touring</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Autogrip EFFITRAC', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-effitrac.webp" alt="EFFITRAC" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>EFFITRAC</h4>
                                        <span>Efficient performance</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Autogrip GRIP 1000', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-grip1000.webp" alt="GRIP 1000" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GRIP 1000</h4>
                                        <span>Superior grip</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Autogrip GRIP 2000', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-grip2000.webp" alt="GRIP 2000" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GRIP 2000</h4>
                                        <span>High performance</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Autogrip GRIP 500', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-grip500.webp" alt="GRIP 500" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GRIP 500</h4>
                                        <span>All-season grip</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Autogrip GRIP200', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-grip200.webp" alt="GRIP200" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GRIP200 / RUNFLAT</h4>
                                        <span>Run-flat option</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Autogrip P308', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-p308.webp" alt="P308" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>P308</h4>
                                        <span>Comfort touring</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Autogrip P308+', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-p308plus.webp" alt="P308+" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>P308+</h4>
                                        <span>Enhanced comfort</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Autogrip VANMAX', 'Consumer Passenger Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/autogrip-vanmax.webp" alt="VANMAX" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>VANMAX</h4>
                                        <span>Light commercial</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Mid Tier - HILO -->
                <div class="tier-content" id="consumer-passenger-mid">
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/hilo-logo.svg" alt="Hilo"></div>
                            <h3>HILO - Quality Mid-Range</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Hilo GENESYS XP1', 'Consumer Passenger Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/hilo-genesysxp1.webp" alt="GENESYS XP1" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GENESYS XP1</h4>
                                        <span>Premium comfort</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Hilo GREEN PLUS', 'Consumer Passenger Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/hilo-greenplus.webp" alt="GREEN PLUS" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GREEN PLUS</h4>
                                        <span>Eco performance</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Hilo SPORT', 'Consumer Passenger Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/hilo-sport.webp" alt="SPORT" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>SPORT</h4>
                                        <span>Sporty handling</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Hilo VANTAGE', 'Consumer Passenger Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/hilo-vantage.webp" alt="VANTAGE" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>VANTAGE</h4>
                                        <span>All-round excellence</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Value Tier - ANCHEE & ANNAITE -->
                <div class="tier-content" id="consumer-passenger-value">
                    <!-- ANCHEE -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Anchee.jpg.webp" alt="Anchee"></div>
                            <h3>ANCHEE - Budget Friendly</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Anchee AC808', 'Consumer Passenger Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/anchee-ac808.webp" alt="AC808" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>AC808</h4>
                                        <span>Economy touring</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Anchee AC818', 'Consumer Passenger Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/anchee-ac818.webp" alt="AC818" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>AC818</h4>
                                        <span>Value performance</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ANNAITE -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Annaite-jpg.webp" alt="Annaite"></div>
                            <h3>ANNAITE - Economy Range</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Annaite AN600', 'Consumer Passenger Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/passenger tires/annaite-an600.webp" alt="AN600" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>AN600</h4>
                                        <span>Reliable economy</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- LINGLONG -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/LingLong-logo.webp" alt="Linglong"></div>
                            <h3>LINGLONG - Value Range</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="availability-notice">
                                <i class="fas fa-phone-alt"></i>
                                <h4>Ask for Availability</h4>
                                <p>Contact us for current Linglong tyre stock and pricing.</p>
                                <button class="btn btn-primary" onclick="openQuote('Linglong Tyres', 'Consumer Passenger Value')" style="margin-top: 12px;">
                                    <i class="fas fa-envelope"></i> Request Quote
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- SUV / 4x4 -->
            <div class="subcategory-content" id="consumer-suv">
                <div class="tier-tabs">
                    <button class="tier-btn premium active" onclick="showTier('consumer-suv', 'premium')">Premium</button>
                    <button class="tier-btn mid" onclick="showTier('consumer-suv', 'mid')">Mid Range</button>
                    <button class="tier-btn value" onclick="showTier('consumer-suv', 'value')">Value</button>
                </div>

                <!-- Premium Tier - AUTOGRIP & XBRI -->
                <div class="tier-content active" id="consumer-suv-premium">
                    <!-- AUTOGRIP -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/autogrip-logo.svg" alt="Autogrip"></div>
                            <h3>AUTOGRIP - Premium 4x4</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Autogrip GRIP 6000', 'Consumer SUV Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/autogrip-grip6000.webp" alt="GRIP 6000" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GRIP 6000</h4>
                                        <span>All-terrain performance</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- XBRI / BRUTUS -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/brutus_300x170-png.webp" alt="XBRI Brutus"></div>
                            <h3>XBRI - Africa Tough</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('XBRI BRUTUS', 'Consumer SUV Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/xbri-brutus.webp" alt="BRUTUS" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>BRUTUS</h4>
                                        <span>Rugged off-road</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Mid Tier - HILO & LANVIGATOR -->
                <div class="tier-content" id="consumer-suv-mid">
                    <!-- HILO -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/hilo-logo.svg" alt="Hilo"></div>
                            <h3>HILO - Quality Mid-Range</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Hilo GENESYS XP1', 'Consumer SUV Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/hilo-genesysxp1.webp" alt="GENESYS XP1" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GENESYS XP1</h4>
                                        <span>Premium comfort</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Hilo GREEN PLUS', 'Consumer SUV Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/hilo-greenplus.webp" alt="GREEN PLUS" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>GREEN PLUS</h4>
                                        <span>Eco performance</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Hilo SPORT', 'Consumer SUV Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/hilo-sport.webp" alt="SPORT" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>SPORT</h4>
                                        <span>Sporty handling</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Hilo VANTAGE', 'Consumer SUV Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/hilo-vantage.webp" alt="VANTAGE" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>VANTAGE</h4>
                                        <span>All-round excellence</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- LANVIGATOR -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Lanv.svg" alt="Lanvigator"></div>
                            <h3>LANVIGATOR - Off-Road Specialists</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Lanvigator CATCH FORS A/T', 'Consumer SUV Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/lanvigator-catchfors-at.webp" alt="CATCH FORS A/T" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>CATCH FORS A/T</h4>
                                        <span>All-terrain</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Lanvigator CATCHFORS M/T', 'Consumer SUV Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/lanvigator-catchfors-mt.webp" alt="CATCHFORS M/T" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>CATCHFORS M/T</h4>
                                        <span>Mud-terrain</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Lanvigator CATCHFORS M/T II', 'Consumer SUV Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/lanvigator-catchfors-mtii.webp" alt="CATCHFORS M/T II" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>CATCHFORS M/T II</h4>
                                        <span>Extreme mud</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Lanvigator LAND WARRIOR R/T', 'Consumer SUV Mid')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/lanvigator-landwarrior-rt.webp" alt="LAND WARRIOR R/T" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>LAND WARRIOR R/T</h4>
                                        <span>Rugged terrain</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Value Tier - ANCHEE, COMFORSER, WIDEWAY -->
                <div class="tier-content" id="consumer-suv-value">
                    <!-- ANCHEE -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Anchee.jpg.webp" alt="Anchee"></div>
                            <h3>ANCHEE - Budget 4x4</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Anchee AC828', 'Consumer SUV Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/anchee-ac828.webp" alt="AC828" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>AC828</h4>
                                        <span>SUV all-terrain</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- COMFORSER -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Comforser-Logo-1536x387.webp" alt="Comforser"></div>
                            <h3>COMFORSER - Value Performance</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Comforser CF1000 A/T', 'Consumer SUV Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/comforser-cf1000.webp" alt="CF1000 A/T" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>CF1000 A/T</h4>
                                        <span>All-terrain</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Comforser CF1100 A/T', 'Consumer SUV Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/comforser-cf1100.webp" alt="CF1100 A/T" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>CF1100 A/T</h4>
                                        <span>Enhanced A/T</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Comforser CF710 UHP', 'Consumer SUV Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/SUV tires/comforser-cf710.webp" alt="CF710 UHP" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>CF710 UHP</h4>
                                        <span>Ultra high performance</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="quote-cta">
                <h3>Need Help Choosing?</h3>
                <p>Our tyre specialists can recommend the perfect tyres for your vehicle and driving needs.</p>
                <button class="btn" onclick="openQuote('Consumer Tyres', 'General Enquiry')"><i class="fas fa-phone"></i> Get Expert Advice</button>
            </div>
        </div>
    </section>

    <!-- Commercial Tyres -->
    <section class="section category-section" id="commercial">
        <div class="container">
            <div class="section-header">
                <span class="section-badge"><i class="fas fa-truck"></i> Commercial Tyres</span>
                <h2>Truck, Trailer & Fleet Tyres</h2>
                <p>Tyres designed for durability, stability, and efficiency for your commercial fleet</p>
            </div>

            <div class="tier-tabs">
                <button class="tier-btn premium active" onclick="showTier('commercial', 'premium')">Premium</button>
                <button class="tier-btn mid" onclick="showTier('commercial', 'mid')">Mid Range</button>
                <button class="tier-btn value" onclick="showTier('commercial', 'value')">Value</button>
            </div>

            <!-- Premium Tier -->
            <div class="tier-content active" id="commercial-premium">
                <!-- BLACKLION -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/BLACKLION-1-new.jpg.webp" alt="Blacklion"></div>
                        <h3>BLACKLION - Premium TBR</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Blacklion BD175', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/blacklion-bd175.webp" alt="BD175" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>BD175</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Blacklion BD280', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/blacklion-bd280.webp" alt="BD280" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>BD280</h4>
                                    <span>Regional drive</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Blacklion BT165', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/blacklion-bt165.webp" alt="BT165" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>BT165</h4>
                                    <span>Trailer axle</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- DOUBLE COIN -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Asset-1Doublecoin-Logo-300x50.webp" alt="Double Coin"></div>
                        <h3>DOUBLE COIN - TBR Specialist</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Double Coin RLB1', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublecoin-rlb1.webp" alt="RLB1" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RLB1</h4>
                                    <span>Long haul drive</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Double Coin RLB200', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublecoin-rlb200.webp" alt="RLB200" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RLB200</h4>
                                    <span>Drive position</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Double Coin RLB450', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublecoin-rlb450.webp" alt="RLB450" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RLB450</h4>
                                    <span>Regional drive</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Double Coin RLB490', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublecoin-rlb490.webp" alt="RLB490" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RLB490</h4>
                                    <span>Mixed service</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Double Coin RLB900', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublecoin-rlb900.webp" alt="RLB900" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RLB900</h4>
                                    <span>Premium drive</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Double Coin RR660', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublecoin-rr660.webp" alt="RR660" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RR660</h4>
                                    <span>Regional steer</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Double Coin RR680', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublecoin-rr680.webp" alt="RR680" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RR680</h4>
                                    <span>Highway steer</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Double Coin RR202', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublecoin-tbr-rr202.webp" alt="RR202" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RR202</h4>
                                    <span>All position</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- DOUBLESTAR -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/doublestar-300x36.png.webp" alt="Doublestar"></div>
                        <h3>DOUBLESTAR - Fleet Solutions</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Doublestar DSR08A', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublestar-dsr-08a.webp" alt="DSR08A" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>DSR08A</h4>
                                    <span>Steer axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Doublestar DSR168', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublestar-dsr168.webp" alt="DSR168" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>DSR168</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Doublestar DSR188', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublestar-dsr188.webp" alt="DSR188" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>DSR188</h4>
                                    <span>Regional</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Doublestar DSR266', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublestar-dsr266.webp" alt="DSR266" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>DSR266</h4>
                                    <span>Long haul</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Doublestar DSR588', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublestar-dsr588.webp" alt="DSR588" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>DSR588</h4>
                                    <span>Mixed service</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Doublestar DSR678', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/doublestar-dsr678-1-1.webp" alt="DSR678" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>DSR678</h4>
                                    <span>Highway</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- RINGTREAD -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/ringtread.jpg.webp" alt="Ringtread"></div>
                        <h3>RINGTREAD - Marangoni System</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Ringtread BUS', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ringtread-bus.webp" alt="BUS" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>BUS</h4>
                                    <span>Bus application</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Ringtread RD2 Plus', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ringtread-rd2-plus.webp" alt="RD2 Plus" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RD2 Plus</h4>
                                    <span>Drive retread</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Ringtread RZ12', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ringtread-rz12.webp" alt="RZ12" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RZ12</h4>
                                    <span>Regional</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Ringtread RZY HM', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ringtread-rzy-hm.webp" alt="RZY HM" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RZY HM</h4>
                                    <span>Highway</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- LEADER TREAD -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/LEADERTREAD.jpg.webp" alt="Leader Tread"></div>
                        <h3>LEADER TREAD - Leading the Way</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Leader Tread M14', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/leadertread-m14.webp" alt="M14" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>M14</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Leader Tread M15', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/leadertread-m15.webp" alt="M15" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>M15</h4>
                                    <span>Regional drive</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Leader Tread M36', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/leadertread-m36.webp" alt="M36" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>M36</h4>
                                    <span>Steer axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Leader Tread M43', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/leadertread-m43.webp" alt="M43" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>M43</h4>
                                    <span>Mixed service</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Leader Tread M78', 'Commercial Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/leadertread-m78.webp" alt="M78" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>M78</h4>
                                    <span>Long haul</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Mid Tier -->
            <div class="tier-content" id="commercial-mid">
                <!-- LANVIGATOR -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Lanv.svg" alt="Lanvigator"></div>
                        <h3>LANVIGATOR - High Performance TBR</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Lanvigator D268', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/lanvigator-d268.webp" alt="D268" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>D268</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Lanvigator S201', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/lanvigator-s201.webp" alt="S201" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>S201</h4>
                                    <span>Steer axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Lanvigator S205', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/lanvigator-s205.webp" alt="S205" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>S205</h4>
                                    <span>Regional steer</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Lanvigator S208', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/lanvigator-s208.webp" alt="S208" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>S208</h4>
                                    <span>Highway steer</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Lanvigator S600', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/lanvigator-s600.webp" alt="S600" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>S600</h4>
                                    <span>All position</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Lanvigator T705', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/lanvigator-t705.webp" alt="T705" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>T705</h4>
                                    <span>Trailer axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Lanvigator D900', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/lanvigator-tbr-d900.webp" alt="D900" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>D900</h4>
                                    <span>Premium drive</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- MILEMASTER -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/milemaster-png.webp" alt="Milemaster"></div>
                        <h3>MILEMASTER - Quality Mid-Range</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Milemaster MM38', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/milemaster-mm38.webp" alt="MM38" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MM38</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Milemaster MM43', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/milemaster-mm43.webp" alt="MM43" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MM43</h4>
                                    <span>Mixed service</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Milemaster MM65', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/milemaster-mm65.webp" alt="MM65" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MM65</h4>
                                    <span>Regional</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Milemaster MM68', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/milemaster-mm68.webp" alt="MM68" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MM68</h4>
                                    <span>Steer axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Milemaster MM75', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/milemaster-mm75.webp" alt="MM75" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MM75</h4>
                                    <span>Long haul</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Milemaster MM79', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/milemaster-mm79.webp" alt="MM79" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MM79</h4>
                                    <span>Highway</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Milemaster MM80', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/milemaster-mm80.webp" alt="MM80" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MM80</h4>
                                    <span>All position</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Milemaster MM84', 'Commercial Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/milemaster-mm84.webp" alt="MM84" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MM84</h4>
                                    <span>Trailer axle</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Value Tier -->
            <div class="tier-content" id="commercial-value">
                <!-- CHAOYANG -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/ChaoyangLogo.jpg.webp" alt="Chaoyang"></div>
                        <h3>CHAOYANG - Passion Forward</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Chaoyang CR832', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/chaoyang-cr832.webp" alt="CR832" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>CR832</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Chaoyang CR852', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/chaoyang-cr852.webp" alt="CR852" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>CR852</h4>
                                    <span>Regional drive</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Chaoyang CR942', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/chaoyang-cr942-tyre.webp" alt="CR942" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>CR942</h4>
                                    <span>All position</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Chaoyang CR952', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/chaoyang-cr952-tyre.webp" alt="CR952" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>CR952</h4>
                                    <span>Mixed service</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ANCHEE -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Anchee.jpg.webp" alt="Anchee"></div>
                        <h3>ANCHEE - Commercial Value</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Anchee AC838', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/anchee-ac838.webp" alt="AC838" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>AC838</h4>
                                    <span>All position TBR</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ANNAITE -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Annaite-jpg.webp" alt="Annaite"></div>
                        <h3>ANNAITE - Economy Fleet</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Annaite AN900', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/annaite-an900-05.webp" alt="AN900" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>AN900</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Annaite AN906', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/annaite-an906-04.webp" alt="AN906" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>AN906</h4>
                                    <span>Steer axle</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- O'GREEN -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Ogreen.svg" alt="O'Green"></div>
                        <h3>O'GREEN - Eco Value</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('O Green AG168', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ogreen-ag168.webp" alt="AG168" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>AG168</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('O Green AG198', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ogreen-ag198.webp" alt="AG198" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>AG198</h4>
                                    <span>Regional</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('O Green AG288', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ogreen-ag288.webp" alt="AG288" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>AG288</h4>
                                    <span>Long haul</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('O Green AG688', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ogreen-ag688.webp" alt="AG688" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>AG688</h4>
                                    <span>Mixed service</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('O Green AG868', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/ogreen-ag868.webp" alt="AG868" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>AG868</h4>
                                    <span>Premium value</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- BISON -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Bison-png.webp" alt="Bison"></div>
                        <h3>BISON - Strong Performance</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="availability-notice">
                            <i class="fas fa-phone-alt"></i>
                            <h4>Ask for Availability</h4>
                            <p>Contact us for current Bison TBR stock and pricing.</p>
                            <button class="btn btn-primary" onclick="openQuote('Bison TBR', 'Commercial Value')" style="margin-top: 12px;">
                                <i class="fas fa-envelope"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <!-- ROADSHINE -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/new-roadshine_square.jpg.webp" alt="Roadshine"></div>
                        <h3>ROADSHINE - Budget Fleet</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Roadshine RS602', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/roadshine-rs602.webp" alt="RS602" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RS602</h4>
                                    <span>Drive axle</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Roadshine RS604', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/roadshine-rs604.webp" alt="RS604" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RS604</h4>
                                    <span>Regional</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Roadshine RS612', 'Commercial Value')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Commercial/roadshine-rs612.webp" alt="RS612" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>RS612</h4>
                                    <span>All position</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="quote-cta">
                <h3>Fleet Solutions</h3>
                <p>Get volume pricing and dedicated support for your commercial fleet.</p>
                <button class="btn" onclick="openQuote('Commercial Fleet', 'Fleet Enquiry')"><i class="fas fa-truck"></i> Fleet Enquiry</button>
            </div>
        </div>
    </section>

    <!-- Industrial Tyres -->
    <section class="section category-section" id="industrial">
        <div class="container">
            <div class="section-header">
                <span class="section-badge"><i class="fas fa-industry"></i> Industrial Tyres</span>
                <h2>Forklift, Warehouse & Industrial Equipment</h2>
                <p>Complete solutions for material handling and industrial applications</p>
            </div>

            <!-- Sub-category tabs -->
            <div class="subcategory-tabs">
                <button class="subcategory-btn active" onclick="showSubcategory('industrial', 'forklift')"><i class="fas fa-dolly"></i> Forklift</button>
                <button class="subcategory-btn" onclick="showSubcategory('industrial', 'construction')"><i class="fas fa-hard-hat"></i> Construction</button>
                <button class="subcategory-btn" onclick="showSubcategory('industrial', 'port')"><i class="fas fa-anchor"></i> Port</button>
            </div>

            <!-- Forklift -->
            <div class="subcategory-content active" id="industrial-forklift">
                <div class="tier-tabs">
                    <button class="tier-btn ultra active" onclick="showTier('industrial-forklift', 'ultra')">Ultra</button>
                    <button class="tier-btn premium" onclick="showTier('industrial-forklift', 'premium')">Premium</button>
                    <button class="tier-btn value" onclick="showTier('industrial-forklift', 'value')">Value</button>
                </div>

                <!-- Ultra Tier -->
                <div class="tier-content active" id="industrial-forklift-ultra">
                    <!-- NUMAPRIME -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/NumaPrime-png.webp" alt="NumaPrime"></div>
                            <h3>NUMAPRIME - Ultra Performance</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('NumaPrime P9', 'Industrial Forklift Ultra')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/numa-prime-p9.webp" alt="P9" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>P9</h4>
                                        <span>Premium solid</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Premium Tier -->
                <div class="tier-content" id="industrial-forklift-premium">
                    <!-- TALON PRIME -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Talon-Prime-png.webp" alt="Talon Prime"></div>
                            <h3>TALON PRIME - Premium Forklift</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Talon Prime M1', 'Industrial Forklift Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/talon-prime-m1.webp" alt="M1" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>M1</h4>
                                        <span>Heavy duty</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Talon Prime P1', 'Industrial Forklift Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/talon-prime-p1.webp" alt="P1" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>P1</h4>
                                        <span>Standard duty</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Talon Prime P3', 'Industrial Forklift Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/talon-prime-p3.webp" alt="P3" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>P3</h4>
                                        <span>Versatile</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Value Tier -->
                <div class="tier-content" id="industrial-forklift-value">
                    <!-- MARCHER -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/MARCHER-Logo.webp" alt="Marcher"></div>
                            <h3>MARCHER - Industrial Value</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Marcher DFMP', 'Industrial Forklift Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/marcher-dfmp-.webp" alt="DFMP" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>DFMP</h4>
                                        <span>Dual purpose</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Marcher HAL5', 'Industrial Forklift Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/marcher-hal5-l-5.webp" alt="HAL5" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>HAL5</h4>
                                        <span>Heavy application</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Marcher HUL5', 'Industrial Forklift Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/marcher-hul5-l-5.webp" alt="HUL5" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>HUL5</h4>
                                        <span>Ultra heavy</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Marcher IMPF3', 'Industrial Forklift Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/marcher-impf3-f-3.webp" alt="IMPF3" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>IMPF3</h4>
                                        <span>Implement</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Marcher INTR1', 'Industrial Forklift Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/marcher-intr1-r-1.webp" alt="INTR1" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>INTR1</h4>
                                        <span>Industrial</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Marcher INTR4', 'Industrial Forklift Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/marcher-intr4-r-4.webp" alt="INTR4" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>INTR4</h4>
                                        <span>Heavy industrial</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('Marcher POSTR', 'Industrial Forklift Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/marcher-postr.webp" alt="POSTR" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>POSTR</h4>
                                        <span>Port service</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- SOLO -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Solo-png.webp" alt="Solo"></div>
                            <h3>SOLO - Economy Forklift</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('Solo Forklift', 'Industrial Forklift Value')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Fork lift/solo.webp" alt="Solo" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>SOLO</h4>
                                        <span>Economy solid</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Construction -->
            <div class="subcategory-content" id="industrial-construction">
                <div class="tier-tabs">
                    <button class="tier-btn premium active" onclick="showTier('industrial-construction', 'premium')">Premium</button>
                </div>
                <div class="tier-content active" id="industrial-construction-premium">
                    <!-- TRIANGLE -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Triangle-png.webp" alt="Triangle"></div>
                            <h3>TRIANGLE - Construction Range</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="availability-notice">
                                <i class="fas fa-phone-alt"></i>
                                <h4>Ask for Availability</h4>
                                <p>Contact us for current Triangle construction tyre stock and pricing.</p>
                                <button class="btn btn-primary" onclick="openQuote('Triangle Construction', 'Industrial Construction Premium')" style="margin-top: 12px;">
                                    <i class="fas fa-envelope"></i> Request Quote
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- CEAT -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Ceat-png.webp" alt="CEAT"></div>
                            <h3>CEAT SPECIALTY - Trusted Partner</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="tyres-grid">
                                <div class="tyre-card" onclick="openQuote('CEAT Aayushmaan HD', 'Industrial Construction Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Construction/ceat-aayushmaan-hd.webp" alt="Aayushmaan HD" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>AAYUSHMAAN HD</h4>
                                        <span>Heavy duty</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('CEAT Farmax', 'Industrial Construction Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Construction/ceat-farmax.webp" alt="Farmax" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>FARMAX</h4>
                                        <span>Multi-purpose</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('CEAT Farmax R70', 'Industrial Construction Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Construction/ceat-farmax-r70.webp" alt="Farmax R70" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>FARMAX R70</h4>
                                        <span>Radial construction</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('CEAT Farmax R85', 'Industrial Construction Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Construction/ceat-farmax-r85.webp" alt="Farmax R85" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>FARMAX R85</h4>
                                        <span>High traction</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('CEAT Floatation Plus', 'Industrial Construction Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Construction/ceat-floatation-plus.webp" alt="Floatation Plus" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>FLOATATION PLUS</h4>
                                        <span>Low ground pressure</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('CEAT Floatmax FT', 'Industrial Construction Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Construction/ceat-floatmax-ft.webp" alt="Floatmax FT" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>FLOATMAX FT</h4>
                                        <span>Flotation</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('CEAT Samraat Super XL', 'Industrial Construction Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Construction/ceat-samraat-super-xl.webp" alt="Samraat Super XL" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>SAMRAAT SUPER XL</h4>
                                        <span>Extra load</span>
                                    </div>
                                </div>
                                <div class="tyre-card" onclick="openQuote('CEAT T422 Value Pro', 'Industrial Construction Premium')">
                                    <div class="tyre-card-image"><img src="/tyrecure/images/Industrial/Construction/ceat-t422-value-pro.webp" alt="T422 Value Pro" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                    <div class="tyre-card-body">
                                        <h4>T422 VALUE PRO</h4>
                                        <span>Value range</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Port -->
            <div class="subcategory-content" id="industrial-port">
                <div class="tier-tabs">
                    <button class="tier-btn premium active" onclick="showTier('industrial-port', 'premium')">Premium</button>
                </div>
                <div class="tier-content active" id="industrial-port-premium">
                    <!-- TRIANGLE -->
                    <div class="brand-section">
                        <div class="brand-section-header" onclick="toggleBrand(this)">
                            <div class="brand-section-logo"><img src="/tyrecure/images/Triangle-png.webp" alt="Triangle"></div>
                            <h3>TRIANGLE - Port Range</h3>
                            <i class="fas fa-chevron-down expand-icon"></i>
                        </div>
                        <div class="brand-tyres-container">
                            <div class="availability-notice">
                                <i class="fas fa-phone-alt"></i>
                                <h4>Ask for Availability</h4>
                                <p>Contact us for current Triangle port tyre stock and pricing.</p>
                                <button class="btn btn-primary" onclick="openQuote('Triangle Port', 'Industrial Port Premium')" style="margin-top: 12px;">
                                    <i class="fas fa-envelope"></i> Request Quote
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="quote-cta">
                <h3>Industrial Solutions</h3>
                <p>Specialised fitment services and rim engineering available.</p>
                <button class="btn" onclick="openQuote('Industrial Tyres', 'Industrial Enquiry')"><i class="fas fa-cogs"></i> Request Consultation</button>
            </div>
        </div>
    </section>

    <!-- Agricultural Tyres -->
    <section class="section category-section" id="agricultural">
        <div class="container">
            <div class="section-header">
                <span class="section-badge"><i class="fas fa-tractor"></i> Agricultural Tyres</span>
                <h2>Tractor, Harvester & Farm Implement Tyres</h2>
                <p>High-performance agriculture tyres for maximum traction and longevity</p>
            </div>

            <div class="tier-tabs">
                <button class="tier-btn premium active" onclick="showTier('agricultural', 'premium')">Premium</button>
                <button class="tier-btn mid" onclick="showTier('agricultural', 'mid')">Mid Range</button>
            </div>

            <!-- Premium Tier -->
            <div class="tier-content active" id="agricultural-premium">
                <!-- CEAT -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Ceat-png.webp" alt="CEAT"></div>
                        <h3>CEAT SPECIALTY - Trusted Partner</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('CEAT C305', 'Agricultural Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/ceat-c305.webp" alt="C305" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>C305</h4>
                                    <span>Industrial tractor</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('CEAT Compactor XL', 'Agricultural Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/ceat-compactor-xl.webp" alt="Compactor XL" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>COMPACTOR XL</h4>
                                    <span>Compactor</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('CEAT Gripmaster ND', 'Agricultural Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/ceat-gripmaster-nd.webp" alt="Gripmaster ND" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>GRIPMASTER ND</h4>
                                    <span>Heavy traction</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('CEAT Grip X HD', 'Agricultural Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/ceat-grip-x-hd.webp" alt="Grip X HD" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>GRIP X HD</h4>
                                    <span>Heavy duty</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('CEAT Loader Pro', 'Agricultural Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/ceat-loader-pro.webp" alt="Loader Pro" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>LOADER PRO</h4>
                                    <span>Loader application</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('CEAT Loader Pro HD', 'Agricultural Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/ceat-loader-pro-hd.webp" alt="Loader Pro HD" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>LOADER PRO HD</h4>
                                    <span>Heavy loader</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('CEAT MPT602', 'Agricultural Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/ceat-mpt602.webp" alt="MPT602" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MPT602</h4>
                                    <span>Multi-purpose</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('CEAT MPT800', 'Agricultural Premium')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/ceat-mpt800.webp" alt="MPT800" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>MPT800</h4>
                                    <span>Premium MPT</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Mid Tier -->
            <div class="tier-content" id="agricultural-mid">
                <!-- MARCHER -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/MARCHER-Logo.webp" alt="Marcher"></div>
                        <h3>MARCHER - Agri Range</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="availability-notice">
                            <i class="fas fa-phone-alt"></i>
                            <h4>Ask for Availability</h4>
                            <p>Contact us for current Marcher agricultural tyre stock and pricing.</p>
                            <button class="btn btn-primary" onclick="openQuote('Marcher Agri', 'Agricultural Mid')" style="margin-top: 12px;">
                                <i class="fas fa-envelope"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <!-- TIANLI -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Tianli-1-png.webp" alt="Tianli"></div>
                        <h3>TIANLI - Forestry & Farm Range</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="tyres-grid">
                            <div class="tyre-card" onclick="openQuote('Tianli FF Flotation Forestry', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-ff-flotation-forestry.webp" alt="FF Flotation Forestry" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>FF FLOTATION FORESTRY</h4>
                                    <span>Forestry flotation</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Tianli FF X1', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-ff-x1.webp" alt="FF X1" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>FF X1</h4>
                                    <span>Flotation</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Tianli FG Forest Grip', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-fg-forest-grip.webp" alt="FG Forest Grip" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>FG FOREST GRIP</h4>
                                    <span>Forest traction</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Tianli LSMG-N Log Stomper', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-lsmg-n-log-stomper.webp" alt="LSMG-N Log Stomper" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>LSMG-N LOG STOMPER</h4>
                                    <span>Log skidder</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Tianli LSMG-T Log Stomper', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-lsmg-t-log-stomper.webp" alt="LSMG-T Log Stomper" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>LSMG-T LOG STOMPER</h4>
                                    <span>Traction skidder</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Tianli SEWP', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-sewp.webp" alt="SEWP" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>SEWP</h4>
                                    <span>Soft earth</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Tianli SL1 Super Logger', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-sl1-super-logger.webp" alt="SL1 Super Logger" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>SL1 SUPER LOGGER</h4>
                                    <span>Logging</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Tianli SLF Super Logger Flotation', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-slf-super-logger-flotation.webp" alt="SLF Super Logger Flotation" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>SLF SUPER LOGGER</h4>
                                    <span>Flotation logger</span>
                                </div>
                            </div>
                            <div class="tyre-card" onclick="openQuote('Tianli SU SXWP Ultra', 'Agricultural Mid')">
                                <div class="tyre-card-image"><img src="/tyrecure/images/Agricultural/tianli-su-sxwp-ultra.webp" alt="SU SXWP Ultra" onerror="this.src='/tyrecure/images/tyre-placeholder.webp'"></div>
                                <div class="tyre-card-body">
                                    <h4>SU SXWP ULTRA</h4>
                                    <span>Ultra performance</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="quote-cta">
                <h3>Farm Equipment Specialists</h3>
                <p>Expert advice for all your agricultural tyre requirements.</p>
                <button class="btn" onclick="openQuote('Agricultural Tyres', 'Farm Enquiry')"><i class="fas fa-tractor"></i> Farm Enquiry</button>
            </div>
        </div>
    </section>

    <!-- Mining Tyres -->
    <section class="section category-section" id="mining">
        <div class="container">
            <div class="section-header">
                <span class="section-badge"><i class="fas fa-hard-hat"></i> Mining Tyres</span>
                <h2>OTR & Mining Equipment Tyres</h2>
                <p>Tyres tailored for the challenges of open cast mining operations</p>
            </div>

            <div class="tier-tabs">
                <button class="tier-btn premium active" onclick="showTier('mining', 'premium')">Premium</button>
                <button class="tier-btn mid" onclick="showTier('mining', 'mid')">Mid Range</button>
            </div>

            <!-- Premium Tier -->
            <div class="tier-content active" id="mining-premium">
                <!-- TECHKING -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Techking-png.webp" alt="Techking"></div>
                        <h3>TECHKING - Tyre Solutions</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="availability-notice">
                            <i class="fas fa-phone-alt"></i>
                            <h4>Ask for Availability</h4>
                            <p>Contact us for current Techking OTR and mining tyre stock and pricing.</p>
                            <button class="btn btn-primary" onclick="openQuote('Techking OTR', 'Mining Premium')" style="margin-top: 12px;">
                                <i class="fas fa-envelope"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <!-- TRIANGLE -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Triangle-png.webp" alt="Triangle"></div>
                        <h3>TRIANGLE - Tyres for Life</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="availability-notice">
                            <i class="fas fa-phone-alt"></i>
                            <h4>Ask for Availability</h4>
                            <p>Contact us for current Triangle OTR and mining tyre stock and pricing.</p>
                            <button class="btn btn-primary" onclick="openQuote('Triangle OTR', 'Mining Premium')" style="margin-top: 12px;">
                                <i class="fas fa-envelope"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Mid Tier -->
            <div class="tier-content" id="mining-mid">
                <!-- TIANLI -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/Tianli-1-png.webp" alt="Tianli"></div>
                        <h3>TIANLI - Mining Range</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="availability-notice">
                            <i class="fas fa-phone-alt"></i>
                            <h4>Ask for Availability</h4>
                            <p>Contact us for current Tianli mining tyre stock and pricing.</p>
                            <button class="btn btn-primary" onclick="openQuote('Tianli Mining', 'Mining Mid')" style="margin-top: 12px;">
                                <i class="fas fa-envelope"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>

                <!-- MARCHER -->
                <div class="brand-section">
                    <div class="brand-section-header" onclick="toggleBrand(this)">
                        <div class="brand-section-logo"><img src="/tyrecure/images/MARCHER-Logo.webp" alt="Marcher"></div>
                        <h3>MARCHER - OTR Value</h3>
                        <i class="fas fa-chevron-down expand-icon"></i>
                    </div>
                    <div class="brand-tyres-container">
                        <div class="availability-notice">
                            <i class="fas fa-phone-alt"></i>
                            <h4>Ask for Availability</h4>
                            <p>Contact us for current Marcher OTR tyre stock and pricing.</p>
                            <button class="btn btn-primary" onclick="openQuote('Marcher OTR', 'Mining Mid')" style="margin-top: 12px;">
                                <i class="fas fa-envelope"></i> Request Quote
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="quote-cta">
                <h3>Mining Solutions</h3>
                <p>Dedicated mining division with on-site support available.</p>
                <button class="btn" onclick="openQuote('Mining Tyres', 'Mining Enquiry')"><i class="fas fa-mountain"></i> Mining Enquiry</button>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-logo">
                        <img src="/tyrecure/images/logo-icon.png" alt="TyreCure">
                    </div>
                    <p style="color: var(--primary); font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 1px;">Premium Tyres \& Services</p>
                    <p>South Africa's leader in tyres and tyre services.</p>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="/tyrecure/products.php#consumer">Consumer Tyres</a></li>
                        <li><a href="/tyrecure/products.php#commercial">Commercial Tyres</a></li>
                        <li><a href="/tyrecure/products.php#industrial">Industrial Tyres</a></li>
                        <li><a href="/tyrecure/products.php#agricultural">Agricultural Tyres</a></li>
                        <li><a href="/tyrecure/products.php#mining">Mining Tyres</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Services</h4>
                    <ul class="footer-links">
                        <li><a href="/tyrecure/services/retread.php">Retread Factory</a></li>
                        <li><a href="/tyrecure/services/rim-engineering.php">Rim Engineering</a></li>
                        <li><a href="/tyrecure/services/powder-coating.php">Powder Coating</a></li>
                        <li><a href="/tyrecure/services/fleet-management.php">Fleet Management</a></li>
                        <li><a href="/tyrecure/services/breakdowns.php">24HR Breakdowns</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Company</h4>
                    <ul class="footer-links">
                        <li><a href="/tyrecure/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Contact</h4>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 12px;"><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 12px;"><i class="fas fa-envelope"></i> info@tyrecure.co.za</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>\&copy; <?= date('Y') ?> TyreCure. All rights reserved.</p>
                <a href="https://omnicure.co.za/" class="multicure-badge">
                    <span>Part of</span>
                    <div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div>
                </a>
            </div>
    </footer>

    <!-- Floating Quote Button -->
    <button class="floating-quote" onclick="openQuote()">
        <i class="fas fa-file-invoice-dollar"></i>
        <span>Get Quote</span>
    </button>

    <!-- Quote Modal -->
    <div class="quote-modal" id="quoteModal">
        <div class="quote-modal-content">
            <div class="quote-modal-header">
                <h3>Request a Quote</h3>
                <p>We'll respond within 24 hours</p>
                <button class="quote-modal-close" onclick="closeQuote()">&times;</button>
            </div>
            <form class="quote-form" onsubmit="return handleQuoteSubmit(this)">
                <div class="selected-product" id="selectedProduct" style="display: none;">
                    <strong>Selected:</strong> <span id="productName"></span> (<span id="productCategory"></span>)
                </div>
                <div class="form-group">
                    <label><i class="fas fa-user"></i> Your Name *</label>
                    <input type="text" name="name" required placeholder="Full name">
                </div>
                <div class="form-group">
                    <label><i class="fas fa-building"></i> Company</label>
                    <input type="text" name="company" placeholder="Company name">
                </div>
                <div class="form-group">
                    <label><i class="fas fa-envelope"></i> Email *</label>
                    <input type="email" name="email" required placeholder="your@email.com">
                </div>
                <div class="form-group">
                    <label><i class="fas fa-phone"></i> Phone *</label>
                    <input type="tel" name="phone" required placeholder="Contact number">
                </div>
                <div class="form-group">
                    <label><i class="fas fa-comment"></i> Requirements *</label>
                    <textarea name="message" required placeholder="Tyre sizes, quantities, vehicle details..."></textarea>
                </div>
                <button type="submit" class="submit-quote">
                    <i class="fas fa-paper-plane"></i> Send Quote Request
                </button>
            </form>
        </div>
    </div>

    <script>
        // Toggle brand section expand/collapse
        function toggleBrand(header) {
            event.stopPropagation();
            const container = header.nextElementSibling;
            const isActive = header.classList.contains('active');

            // Toggle current brand
            header.classList.toggle('active');
            container.classList.toggle('active');
        }

        // Show main category
        function showCategory(category) {
            document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
            document.querySelectorAll('.category-section').forEach(sec => sec.classList.remove('active'));

            event.target.closest('.tab-btn').classList.add('active');
            document.getElementById(category).classList.add('active');

            // Scroll to section
            const element = document.getElementById(category);
            const headerOffset = 160;
            const elementPosition = element.getBoundingClientRect().top;
            const offsetPosition = elementPosition + window.pageYOffset - headerOffset;
            window.scrollTo({ top: offsetPosition, behavior: 'smooth' });
        }

        // Show subcategory
        function showSubcategory(category, subcategory) {
            const section = document.getElementById(category);
            section.querySelectorAll('.subcategory-btn').forEach(btn => btn.classList.remove('active'));
            section.querySelectorAll('.subcategory-content').forEach(content => content.classList.remove('active'));

            event.target.closest('.subcategory-btn').classList.add('active');
            document.getElementById(`${category}-${subcategory}`).classList.add('active');
        }

        // Show tier
        function showTier(context, tier) {
            const container = document.getElementById(context) || document.getElementById(context.split('-')[0]);
            const tierContainer = event.target.closest('.tier-tabs');

            // Update tier buttons
            tierContainer.querySelectorAll('.tier-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            event.target.classList.add('active');

            // Find the parent that contains the tier-content elements
            const parent = tierContainer.parentElement;
            parent.querySelectorAll(':scope > .tier-content').forEach(content => {
                content.classList.remove('active');
            });

            const targetId = `${context}-${tier}`;
            const targetElement = document.getElementById(targetId);
            if (targetElement) {
                targetElement.classList.add('active');
            }
        }

        // Quote modal
        let selectedTyre = '';
        let selectedCategory = '';

        function openQuote(tyre, category) {
            selectedTyre = tyre || '';
            selectedCategory = category || '';

            if (selectedTyre) {
                document.getElementById('selectedProduct').style.display = 'block';
                document.getElementById('productName').textContent = selectedTyre;
                document.getElementById('productCategory').textContent = selectedCategory;
            } else {
                document.getElementById('selectedProduct').style.display = 'none';
            }

            document.getElementById('quoteModal').classList.add('active');
            document.body.style.overflow = 'hidden';
        }

        function closeQuote() {
            document.getElementById('quoteModal').classList.remove('active');
            document.body.style.overflow = '';
        }

        document.getElementById('quoteModal').addEventListener('click', function(e) {
            if (e.target === this) closeQuote();
        });

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') closeQuote();
        });

        function handleQuoteSubmit(form) {
            const name = form.querySelector('input[name="name"]').value;
            const company = form.querySelector('input[name="company"]').value;
            const email = form.querySelector('input[name="email"]').value;
            const phone = form.querySelector('input[name="phone"]').value;
            const message = form.querySelector('textarea[name="message"]').value;

            const productInfo = selectedTyre ? `\nProduct: ${selectedTyre} (${selectedCategory})` : '';
            const subject = encodeURIComponent('TyreCure Quote Request' + (selectedTyre ? ' - ' + selectedTyre : ''));
            const body = encodeURIComponent(
                'Quote Request from TyreCure Website\n' +
                '====================================\n\n' +
                'Name: ' + name + '\n' +
                'Company: ' + (company || 'Not specified') + '\n' +
                'Email: ' + email + '\n' +
                'Phone: ' + phone + productInfo + '\n\n' +
                'Requirements:\n' + message
            );

            window.location.href = 'mailto:info@tyrecure.co.za?subject=' + subject + '&body=' + body;

            setTimeout(() => {
                alert('Thank you! Your email client should open with your quote request.');
                closeQuote();
            }, 500);

            return false;
        }

        // Handle hash navigation
        if (window.location.hash) {
            const category = window.location.hash.substring(1);
            const section = document.getElementById(category);
            if (section && section.classList.contains('category-section')) {
                document.querySelectorAll('.category-section').forEach(s => s.classList.remove('active'));
                document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
                section.classList.add('active');
                document.querySelector(`[onclick="showCategory('${category}')"]`)?.classList.add('active');
            }
        }
    </script>
</body>
</html>
