<?php require_once __DIR__ . '/../includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fleet Tyre Maintenance | TyreCure - Professional Fleet Services</title>
    <meta name="description" content="TyreCure Fleet Tyre Maintenance - Regular inspections, pressure monitoring, rotations, and comprehensive maintenance services to maximize tyre life.">
    <link rel="icon" type="image/x-icon" href="/tyrecure/favicon.ico">
    <link rel="apple-touch-icon" href="/tyrecure/apple-touch-icon.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #dc2626; --primary-dark: #991b1b; --primary-light: #ef4444;
            --secondary: #1e3a5f; --secondary-light: #2d4a6f;
            --accent: #f59e0b; --dark: #0f172a;
            --gray-50: #f8fafc; --gray-100: #f1f5f9; --gray-200: #e2e8f0; --gray-600: #475569;
            --white: #fff;
            --gradient-primary: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary) 100%);
            --gradient-secondary: linear-gradient(135deg, var(--secondary) 0%, var(--secondary-light) 100%);
            --shadow: 0 4px 20px rgba(0,0,0,0.08); --shadow-lg: 0 12px 40px rgba(0,0,0,0.15);
            --radius: 16px;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1320px; margin: 0 auto; padding: 0 24px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.98); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 10px 0; }
        .logo img { height: 70px; }
        .nav { display: flex; align-items: center; gap: 8px; }
        .nav-links { display: flex; gap: 2px; list-style: none; align-items: center; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 10px 14px; border-radius: 8px; transition: all 0.2s; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .nav-links .dropdown { position: relative; }
        .nav-links .dropdown > a::after { content: '\f107'; font-family: 'Font Awesome 6 Free'; font-weight: 900; margin-left: 6px; font-size: 10px; }
        .dropdown-menu { position: absolute; top: 100%; left: 0; background: white; min-width: 220px; border-radius: 12px; box-shadow: var(--shadow-lg); padding: 8px; opacity: 0; visibility: hidden; transform: translateY(10px); transition: all 0.2s; }
        .dropdown:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        .dropdown-menu a { display: flex; align-items: center; gap: 10px; padding: 10px 14px; border-radius: 8px; font-size: 13px; }
        .dropdown-menu a i { width: 16px; color: var(--primary); }
        .dropdown-menu a:hover { background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 12px 24px; border-radius: 10px; font-weight: 600; font-size: 14px; text-decoration: none; transition: all 0.3s; border: none; cursor: pointer; }
        .btn-primary { background: var(--gradient-primary); color: white; box-shadow: 0 4px 15px rgba(220,38,38,0.3); }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(220,38,38,0.4); }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .btn-outline:hover { background: var(--primary); color: white; }
        .btn-white { background: white; color: var(--primary); }
        .btn-lg { padding: 16px 32px; font-size: 15px; }
        .btn-sm { padding: 8px 16px; font-size: 12px; }
        .page-hero { padding: 160px 0 100px; background: var(--gradient-secondary); position: relative; overflow: hidden; }
        .page-hero::before { content: ''; position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: url('https://images.unsplash.com/photo-1580273916550-e323be2ae537?w=1920&q=80') center/cover; opacity: 0.15; }
        .page-hero .container { position: relative; z-index: 1; }
        .hero-content { max-width: 700px; color: white; }
        .hero-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.15); padding: 10px 20px; border-radius: 50px; font-size: 13px; font-weight: 500; margin-bottom: 24px; }
        .page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 20px; line-height: 1.2; }
        .page-hero h1 span { color: var(--primary-light); }
        .page-hero p { font-size: 1.15rem; opacity: 0.9; margin-bottom: 32px; }
        .hero-buttons { display: flex; gap: 16px; flex-wrap: wrap; }
        .content-section { padding: 80px 0; }
        .content-section.alt { background: var(--gray-50); }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(220,38,38,0.1); color: var(--primary); padding: 8px 20px; border-radius: 50px; font-size: 13px; font-weight: 600; margin-bottom: 16px; }
        .section-header h2 { font-size: 2.2rem; font-weight: 700; margin-bottom: 16px; }
        .section-header p { color: var(--gray-600); font-size: 1.1rem; max-width: 600px; margin: 0 auto; }
        .features-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 32px; }
        .feature-card { background: white; border-radius: var(--radius); padding: 32px; box-shadow: var(--shadow); transition: all 0.3s; border: 2px solid transparent; }
        .feature-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); border-color: var(--primary); }
        .feature-icon { width: 60px; height: 60px; background: var(--gradient-primary); border-radius: 14px; display: flex; align-items: center; justify-content: center; color: white; font-size: 24px; margin-bottom: 20px; }
        .feature-card h3 { font-size: 1.2rem; font-weight: 600; margin-bottom: 12px; }
        .feature-card p { color: var(--gray-600); font-size: 14px; line-height: 1.7; }
        .form-section { padding: 80px 0; }
        .form-grid { display: grid; grid-template-columns: 1fr 1.5fr; gap: 60px; }
        .form-info h2 { font-size: 2rem; font-weight: 700; margin-bottom: 16px; }
        .form-info > p { color: var(--gray-600); margin-bottom: 32px; }
        .contact-card { background: var(--gray-50); border-radius: var(--radius); padding: 24px; margin-bottom: 16px; }
        .contact-card-icon { width: 50px; height: 50px; background: var(--gradient-primary); color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-bottom: 16px; }
        .contact-card h4 { font-size: 1rem; margin-bottom: 8px; }
        .contact-card p { color: var(--gray-600); font-size: 14px; }
        .contact-card a { color: var(--primary); text-decoration: none; font-weight: 500; }
        .quote-form { background: white; border-radius: var(--radius); padding: 40px; box-shadow: var(--shadow-lg); }
        .quote-form h3 { font-size: 1.4rem; margin-bottom: 8px; }
        .quote-form .subtitle { color: var(--gray-600); margin-bottom: 28px; font-size: 14px; }
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 500; margin-bottom: 8px; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 14px; border: 2px solid var(--gray-200); border-radius: 10px; font-family: inherit; font-size: 14px; transition: border-color 0.2s; }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { outline: none; border-color: var(--primary); }
        .form-group textarea { resize: vertical; min-height: 120px; }
        .footer { background: var(--dark); color: white; padding: 80px 0 32px; }
        .footer-grid { display: grid; grid-template-columns: 2fr 1fr 1fr 1fr 1fr; gap: 40px; margin-bottom: 48px; }
        .footer-brand p { color: rgba(255,255,255,0.7); margin-top: 16px; font-size: 14px; }
        .footer-logo { width: 100px; height: 100px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 16px; }
        .footer-logo img { height: 65px; }
        .footer h4 { font-size: 14px; margin-bottom: 20px; text-transform: uppercase; letter-spacing: 1px; }
        .footer-links { list-style: none; }
        .footer-links a { color: rgba(255,255,255,0.7); text-decoration: none; font-size: 14px; display: block; padding: 6px 0; transition: color 0.2s; }
        .footer-links a:hover { color: white; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); padding-top: 32px; display: flex; justify-content: space-between; align-items: center; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); text-decoration: none; font-size: 13px; }
        .multicure-badge:hover { color: white; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 1200px) { .footer-grid { grid-template-columns: repeat(3, 1fr); } }
        @media (max-width: 1024px) { .features-grid { grid-template-columns: repeat(2, 1fr); } .form-grid { grid-template-columns: 1fr; } }
        @media (max-width: 768px) { .page-hero h1 { font-size: 2.2rem; } .features-grid { grid-template-columns: 1fr; } .form-row { grid-template-columns: 1fr; } .footer-grid { grid-template-columns: 1fr 1fr; } .footer-bottom { flex-direction: column; gap: 16px; text-align: center; } .nav-links { display: none; } }
    </style>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <a href="/tyrecure/" class="logo"><img src="https://omnicure.co.za/uploads/logos/logos-no-background-tyrecure-long.png" alt="TyreCure"></a>
                <nav class="nav">
                    <ul class="nav-links">
                        <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                        <li><a href="/tyrecure/">Home</a></li>
                        <li class="dropdown">
                            <a href="/tyrecure/products.php">Products</a>
                            <div class="dropdown-menu">
                                <a href="/tyrecure/products.php#consumer"><i class="fas fa-car"></i> Consumer Tyres</a>
                                <a href="/tyrecure/products.php#commercial"><i class="fas fa-truck"></i> Commercial Tyres</a>
                                <a href="/tyrecure/products.php#industrial"><i class="fas fa-industry"></i> Industrial Tyres</a>
                                <a href="/tyrecure/products.php#agricultural"><i class="fas fa-tractor"></i> Agricultural Tyres</a>
                                <a href="/tyrecure/products.php#mining"><i class="fas fa-hard-hat"></i> Mining Tyres</a>
                                <a href="/tyrecure/products.php#brands"><i class="fas fa-tags"></i> Tyre Brands</a>
                            </div>
                        </li>
                        <li class="dropdown">
                            <a href="/tyrecure/services.php">Services</a>
                            <div class="dropdown-menu">
                                <a href="/tyrecure/services/retread.php"><i class="fas fa-sync-alt"></i> Retread Factory</a>
                                <a href="/tyrecure/services/rim-engineering.php"><i class="fas fa-cog"></i> Rim Engineering</a>
                                <a href="/tyrecure/services/powder-coating.php"><i class="fas fa-spray-can"></i> Powder Coating</a>
                                <a href="/tyrecure/services/fleet-management.php"><i class="fas fa-truck-moving"></i> Fleet Management</a>
                                <a href="/tyrecure/services/fleet-maintenance.php"><i class="fas fa-tools"></i> Fleet Maintenance</a>
                                <a href="/tyrecure/services/breakdowns.php"><i class="fas fa-phone-alt"></i> 24HR Breakdowns</a>
                                <a href="/tyrecure/services/forklift-fitment.php"><i class="fas fa-dolly"></i> Forklift Fitment</a>
                                <a href="/tyrecure/services/drive-thru.php"><i class="fas fa-warehouse"></i> Truck Drive Thru</a>
                            </div>
                        </li>
                        <li><a href="/tyrecure/contact.php">Contact</a></li>
                    </ul>
                    <?php if ($isReseller): ?>
                    <?php else: ?>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </header>

    <section class="page-hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-badge"><i class="fas fa-tools"></i> Fleet Tyre Maintenance</div>
                <h1>Professional <span>Fleet Maintenance</span></h1>
                <p>Keep your fleet running safely with our comprehensive tyre maintenance services. Regular inspections, rotations, and pressure management to maximize tyre life.</p>
                <div class="hero-buttons">
                    <a href="#quote" class="btn btn-white btn-lg"><i class="fas fa-file-invoice"></i> Get a Quote</a>
                    <a href="tel:+27123456789" class="btn btn-primary btn-lg"><i class="fas fa-phone"></i> Call Now</a>
                </div>
            </div>
        </div>
    </section>

    <section class="content-section">
        <div class="container">
            <div class="section-header">
                <div class="section-badge"><i class="fas fa-wrench"></i> Our Services</div>
                <h2>Maintenance Services</h2>
                <p>Comprehensive tyre maintenance to keep your fleet safe and efficient.</p>
            </div>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-tachometer-alt"></i></div>
                    <h3>Pressure Monitoring</h3>
                    <p>Regular pressure checks and adjustments to ensure optimal fuel efficiency and even tyre wear across your fleet.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-sync-alt"></i></div>
                    <h3>Tyre Rotations</h3>
                    <p>Scheduled tyre rotations to promote even wear and extend the life of your tyres across all vehicles.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-search"></i></div>
                    <h3>Regular Inspections</h3>
                    <p>Thorough visual and mechanical inspections to identify issues before they become costly problems.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-ruler"></i></div>
                    <h3>Tread Depth Monitoring</h3>
                    <p>Accurate tread depth measurements and wear pattern analysis to optimize replacement timing.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-balance-scale"></i></div>
                    <h3>Wheel Alignment</h3>
                    <p>Professional alignment services to prevent uneven wear and improve handling and fuel economy.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon"><i class="fas fa-file-alt"></i></div>
                    <h3>Service Reports</h3>
                    <p>Detailed maintenance reports and recommendations to help you plan and budget for fleet expenses.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="form-section content-section alt" id="quote">
        <div class="container">
            <div class="form-grid">
                <div class="form-info">
                    <h2>Schedule Maintenance</h2>
                    <p>Let us create a customized maintenance schedule for your fleet to minimize downtime and maximize tyre life.</p>
                    <div class="contact-card">
                        <div class="contact-card-icon"><i class="fas fa-phone"></i></div>
                        <h4>Call Us</h4>
                        <p>Mon - Fri: 7:30 AM - 5:00 PM</p>
                        <a href="tel:+27123456789">+27 12 345 6789</a>
                    </div>
                    <div class="contact-card">
                        <div class="contact-card-icon"><i class="fas fa-envelope"></i></div>
                        <h4>Email Us</h4>
                        <p>For maintenance enquiries</p>
                        <a href="mailto:maintenance@tyrecure.co.za">maintenance@tyrecure.co.za</a>
                    </div>
                </div>
                <div class="quote-form">
                    <h3>Request Maintenance Quote</h3>
                    <p class="subtitle">Tell us about your fleet and maintenance needs.</p>
                    <form onsubmit="return handleSubmit(this)">
                        <div class="form-row">
                            <div class="form-group"><label>Name *</label><input type="text" name="name" required placeholder="Your full name"></div>
                            <div class="form-group"><label>Company *</label><input type="text" name="company" required placeholder="Company name"></div>
                        </div>
                        <div class="form-row">
                            <div class="form-group"><label>Email *</label><input type="email" name="email" required placeholder="your@email.com"></div>
                            <div class="form-group"><label>Phone *</label><input type="tel" name="phone" required placeholder="Contact number"></div>
                        </div>
                        <div class="form-row">
                            <div class="form-group"><label>Fleet Size</label><input type="text" name="fleet_size" placeholder="Number of vehicles"></div>
                            <div class="form-group"><label>Service Frequency</label>
                                <select name="frequency">
                                    <option value="">Select frequency...</option>
                                    <option>Weekly</option>
                                    <option>Bi-weekly</option>
                                    <option>Monthly</option>
                                    <option>As needed</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group"><label>Requirements *</label><textarea name="message" required placeholder="Please describe your fleet, current maintenance schedule, and any specific requirements..."></textarea></div>
                        <button type="submit" class="btn btn-primary" style="width: 100%;"><i class="fas fa-paper-plane"></i> Request Quote</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <div class="footer-logo"><img src="https://omnicure.co.za/uploads/logos/tyrecure-icon-only.png" alt="TyreCure"></div>
                    <p style="color: var(--primary); font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 1px;">Premium Tyres & Services</p>
                    <p>South Africa's leader in tyres and tyre services.</p>
                </div>
                <div>
                    <h4>Products</h4>
                    <ul class="footer-links">
                        <li><a href="/tyrecure/products.php#consumer">Consumer Tyres</a></li>
                        <li><a href="/tyrecure/products.php#commercial">Commercial Tyres</a></li>
                        <li><a href="/tyrecure/products.php#industrial">Industrial Tyres</a></li>
                        <li><a href="/tyrecure/products.php#agricultural">Agricultural Tyres</a></li>
                        <li><a href="/tyrecure/products.php#mining">Mining Tyres</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Services</h4>
                    <ul class="footer-links">
                        <li><a href="/tyrecure/services/retread.php">Retread Factory</a></li>
                        <li><a href="/tyrecure/services/rim-engineering.php">Rim Engineering</a></li>
                        <li><a href="/tyrecure/services/powder-coating.php">Powder Coating</a></li>
                        <li><a href="/tyrecure/services/fleet-management.php">Fleet Management</a></li>
                        <li><a href="/tyrecure/services/breakdowns.php">24HR Breakdowns</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Company</h4>
                    <ul class="footer-links">
                        <li><a href="/tyrecure/contact.php">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4>Contact</h4>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 12px;"><i class="fas fa-phone"></i> +27 12 345 6789</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px; margin-bottom: 12px;"><i class="fas fa-envelope"></i> info@tyrecure.co.za</p>
                    <p style="color: rgba(255,255,255,0.7); font-size: 14px;"><i class="fas fa-map-marker-alt"></i> Pretoria, South Africa</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> TyreCure. All rights reserved.</p>
                <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
            </div>
        </div>
    </footer>

    <script>
    function handleSubmit(form) {
        const formData = new FormData(form);
        const subject = encodeURIComponent('Fleet Maintenance Enquiry - TyreCure');
        let body = 'Fleet Maintenance Enquiry\n=========================\n\n';
        formData.forEach((value, key) => { if(value) body += key.charAt(0).toUpperCase() + key.slice(1).replace('_', ' ') + ': ' + value + '\n'; });
        window.location.href = 'mailto:maintenance@tyrecure.co.za?subject=' + subject + '&body=' + encodeURIComponent(body);
        setTimeout(() => alert('Thank you! Your email client should open with your enquiry.'), 500);
        return false;
    }
    </script>
</body>
</html>
