<?php require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/email_config.php';
require_once __DIR__ . '/includes/security.php';
$brand = 'watercure';
$emails = getBrandEmails($brand); $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - WaterCure | Pure Water Solutions</title>
    <meta name="description" content="Contact WaterCure for water treatment consultations and services.">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #0ea5e9; --primary-dark: #0284c7; --accent: #1f2937; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-600: #4b5563; --white: #fff; --gradient-hero: linear-gradient(135deg, #0284c7 0%, #0ea5e9 50%, #38bdf8 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo-text { font-size: 1.5rem; font-weight: 700; color: var(--primary); text-decoration: none; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-header { background: var(--gradient-hero); padding: 160px 0 80px; color: white; text-align: center; }
        .page-header h1 { font-size: 3rem; margin-bottom: 16px; }
        .page-header p { opacity: 0.9; max-width: 600px; margin: 0 auto; }
        .contact-section { padding: 80px 0; }
        .contact-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; }
        .contact-info h2 { font-size: 2rem; margin-bottom: 20px; color: var(--primary); }
        .contact-info p { color: var(--gray-600); margin-bottom: 32px; }
        .info-item { display: flex; align-items: flex-start; gap: 16px; margin-bottom: 24px; }
        .info-icon { width: 50px; height: 50px; background: var(--gradient-hero); color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 20px; flex-shrink: 0; }
        .info-item h3 { font-size: 1rem; margin-bottom: 4px; }
        .info-item p { color: var(--gray-600); font-size: 14px; margin: 0; }
        .contact-form { background: var(--gray-50); padding: 40px; border-radius: var(--radius); }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; font-size: 14px; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 12px 16px; border: 2px solid var(--gray-100); border-radius: 10px; font-family: inherit; font-size: 14px; }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { outline: none; border-color: var(--primary); }
        .form-group textarea { min-height: 120px; resize: vertical; }
        .btn-submit { width: 100%; padding: 14px; background: var(--gradient-hero); color: white; border: none; border-radius: 10px; font-weight: 600; cursor: pointer; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; margin-top: 60px; }
        .footer-content { display: flex; justify-content: space-between; align-items: center; }
        .footer p { color: rgba(255,255,255,0.6); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 768px) { .contact-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-content { flex-direction: column; gap: 16px; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/" class="logo"><img src="/images/logo-long.png" alt="WaterCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/">Home</a></li>
                <li><a href="/products.php">Solutions</a></li>
                <li><a href="/about.php">About Us</a></li>
                <li><a href="/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <section class="page-header">
        <div class="container">
            <h1>Contact Us</h1>
            <p>Get in touch for water treatment consultations and free water quality assessments.</p>
        </div>
    </section>

    <section class="contact-section"><div class="container">
        <div class="contact-grid">
            <div class="contact-info">
                <h2>Get in Touch</h2>
                <p>Whether you need a water quality assessment or want to discuss a treatment solution, our team is here to help.</p>
                <div class="info-item">
                    <div class="info-icon"><i class="fas fa-phone"></i></div>
                    <div><h3>Phone</h3><p>+27 12 345 6789</p></div>
                </div>
                <div class="info-item">
                    <div class="info-icon"><i class="fas fa-envelope"></i></div>
                    <div><h3>Email</h3><p>info@watercure.co.za</p></div>
                </div>
                <div class="info-item">
                    <div class="info-icon"><i class="fas fa-map-marker-alt"></i></div>
                    <div><h3>Address</h3><p>Pretoria, Gauteng<br>South Africa</p></div>
                </div>
                <div class="info-item">
                    <div class="info-icon"><i class="fas fa-clock"></i></div>
                    <div><h3>Business Hours</h3><p>Mon-Fri: 8am - 5pm<br>Sat: 8am - 12pm</p></div>
                </div>
            </div>
            <div class="contact-form">
                <form action="#" method="POST">
                            <?= outputHoneypot() ?>
                            <?= outputTimestamp() ?>
                    <div class="form-group"><label>Your Name</label><input type="text" name="name" required></div>
                    <div class="form-group"><label>Email Address</label><input type="email" name="email" required></div>
                    <div class="form-group"><label>Phone Number</label><input type="tel" name="phone"></div>
                    <div class="form-group">
                        <label>Service Required</label>
                        <select name="service">
                            <option value="">Select a service...</option>
                            <option value="purification">Water Purification</option>
                            <option value="treatment">Water Treatment</option>
                            <option value="testing">Water Testing</option>
                            <option value="systems">Treatment Systems</option>
                            <option value="consultation">General Consultation</option>
                        </select>
                    </div>
                    <div class="form-group"><label>Message</label><textarea name="message" placeholder="Tell us about your water needs..."></textarea></div>
                    <?= outputMathCaptcha("math_answer") ?>
                            <button type="submit" class="btn-submit"><i class="fas fa-paper-plane"></i> Send Message</button>
                </form>
            </div>
        </div>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-content">
            <p>&copy; <?= date('Y') ?> WaterCure. All rights reserved.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
        </div>
    </div></footer>
</body>
</html>
