<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - WaterCure | Pure Water Solutions</title>
    <meta name="description" content="Learn about WaterCure's mission to provide pure water solutions across South Africa.">
    <link rel="icon" type="image/x-icon" href="/watercure/favicon.ico">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #0ea5e9; --primary-dark: #0284c7; --accent: #1f2937; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-600: #4b5563; --white: #fff; --gradient-hero: linear-gradient(135deg, #0284c7 0%, #0ea5e9 50%, #38bdf8 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo-text { font-size: 1.5rem; font-weight: 700; color: var(--primary); text-decoration: none; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-header { background: var(--gradient-hero); padding: 160px 0 80px; color: white; text-align: center; }
        .page-header h1 { font-size: 3rem; margin-bottom: 16px; }
        .page-header p { opacity: 0.9; max-width: 600px; margin: 0 auto; }
        .content { padding: 80px 0; }
        .content-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; margin-bottom: 60px; }
        .content h2 { font-size: 2rem; margin-bottom: 20px; color: var(--primary); }
        .content p { color: var(--gray-600); margin-bottom: 16px; }
        .values-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; margin-top: 60px; }
        .value-card { background: var(--gray-50); padding: 32px; border-radius: var(--radius); text-align: center; }
        .value-icon { width: 70px; height: 70px; background: var(--gradient-hero); color: white; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 28px; margin: 0 auto 20px; }
        .value-card h3 { margin-bottom: 10px; }
        .value-card p { color: var(--gray-600); font-size: 14px; }
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; margin-top: 60px; }
        .footer-content { display: flex; justify-content: space-between; align-items: center; }
        .footer p { color: rgba(255,255,255,0.6); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 768px) { .content-grid { grid-template-columns: 1fr; } .values-grid { grid-template-columns: 1fr; } .nav-links { display: none; } .footer-content { flex-direction: column; gap: 16px; } }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/watercure/" class="logo"><img src="/watercure/images/logo-long.png" alt="WaterCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/watercure/">Home</a></li>
                <li><a href="/watercure/products.php">Solutions</a></li>
                <li><a href="/watercure/about.php">About Us</a></li>
                <li><a href="/watercure/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <section class="page-header">
        <div class="container">
            <h1>About WaterCure</h1>
            <p>Providing pure water solutions to South Africa for over 15 years.</p>
        </div>
    </section>

    <section class="content"><div class="container">
        <div class="content-grid">
            <div>
                <h2>Our Mission</h2>
                <p>WaterCure is committed to providing clean, safe water to homes, businesses, and industries across South Africa. We believe that access to pure water is fundamental to health and prosperity.</p>
                <p>Our team of water treatment specialists brings decades of combined experience to every project, ensuring optimal results and customer satisfaction.</p>
            </div>
            <div>
                <h2>Our Expertise</h2>
                <p>From simple residential filtration systems to complex industrial water treatment plants, we have the knowledge and technology to handle any water challenge.</p>
                <p>We stay at the forefront of water treatment technology, continuously improving our solutions to deliver the purest water possible.</p>
            </div>
        </div>
        <div class="values-grid">
            <div class="value-card">
                <div class="value-icon"><i class="fas fa-tint"></i></div>
                <h3>Purity First</h3>
                <p>We never compromise on water quality standards.</p>
            </div>
            <div class="value-card">
                <div class="value-icon"><i class="fas fa-users"></i></div>
                <h3>Customer Focus</h3>
                <p>Your water needs are our top priority.</p>
            </div>
            <div class="value-card">
                <div class="value-icon"><i class="fas fa-leaf"></i></div>
                <h3>Sustainability</h3>
                <p>Eco-friendly solutions for a better tomorrow.</p>
            </div>
        </div>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-content">
            <p>&copy; <?= date('Y') ?> WaterCure. All rights reserved.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
        </div>
    </div></footer>
</body>
</html>
