<?php require_once __DIR__ . '/includes/config.php'; $isReseller = isReseller(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solutions - WaterCure | Pure Water Solutions</title>
    <meta name="description" content="Professional water treatment and purification solutions for residential, commercial, and industrial applications.">
    <link rel="icon" type="image/x-icon" href="/watercure/favicon.ico">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #0ea5e9; --primary-dark: #0284c7; --accent: #1f2937; --dark: #111827; --gray-50: #f9fafb; --gray-100: #f3f4f6; --gray-600: #4b5563; --white: #fff; --gradient-hero: linear-gradient(135deg, #0284c7 0%, #0ea5e9 50%, #38bdf8 100%); --shadow: 0 4px 20px rgba(0,0,0,0.08); --radius: 16px; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--white); color: var(--dark); line-height: 1.7; }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 32px; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: rgba(255,255,255,0.97); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); }
        .header-content { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
        .logo-text { font-size: 1.5rem; font-weight: 700; color: var(--primary); text-decoration: none; }
        .nav { display: flex; align-items: center; gap: 12px; }
        .nav { display: flex; align-items: center; gap: 12px; } .nav-links { display: flex; gap: 4px; list-style: none; }
        .nav-links a { text-decoration: none; color: var(--gray-600); font-weight: 500; font-size: 13px; padding: 8px 14px; border-radius: 8px; }
        .nav-links a:hover { color: var(--primary); background: var(--gray-50); }
        .multicure-link { background: var(--gray-100); }
        .multicure-link:hover { background: #2563eb !important; color: white !important; }
        .btn { display: inline-flex; align-items: center; gap: 6px; padding: 10px 18px; border-radius: 10px; font-weight: 600; text-decoration: none; font-size: 13px; }
        .btn-primary { background: var(--gradient-hero); color: white; }
        .btn-outline { background: transparent; color: var(--primary); border: 2px solid var(--primary); }
        .page-header { background: var(--gradient-hero); padding: 160px 0 80px; color: white; text-align: center; }
        .page-header h1 { font-size: 3rem; margin-bottom: 16px; }
        .page-header p { opacity: 0.9; max-width: 600px; margin: 0 auto; }
        
        /* Services Section */
        .services-section { padding: 80px 0; }
        .service-block { margin-bottom: 80px; }
        .service-block:last-child { margin-bottom: 0; }
        .service-header { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; margin-bottom: 40px; }
        .service-header.reverse { direction: rtl; }
        .service-header.reverse > * { direction: ltr; }
        .service-content h2 { font-size: 2rem; margin-bottom: 16px; color: var(--primary); }
        .service-content p { color: var(--gray-600); margin-bottom: 16px; }
        .service-features { list-style: none; }
        .service-features li { display: flex; align-items: center; gap: 12px; padding: 8px 0; color: var(--gray-600); }
        .service-features li i { color: var(--primary); }
        .service-image { background: var(--gray-100); border-radius: var(--radius); height: 300px; display: flex; align-items: center; justify-content: center; }
        .service-image i { font-size: 80px; color: var(--primary); opacity: 0.3; }
        
        /* Image Gallery */
        .service-gallery { display: grid; grid-template-columns: repeat(4, 1fr); gap: 16px; }
        .gallery-item { aspect-ratio: 4/3; background: var(--gray-100); border-radius: 12px; overflow: hidden; }
        .gallery-item img { width: 100%; height: 100%; object-fit: cover; }
        .gallery-placeholder { width: 100%; height: 100%; display: flex; flex-direction: column; align-items: center; justify-content: center; color: var(--gray-600); }
        .gallery-placeholder i { font-size: 32px; margin-bottom: 8px; opacity: 0.5; }
        .gallery-placeholder span { font-size: 12px; opacity: 0.7; }
        
        /* Documentation Section */
        .docs-section { background: var(--gray-50); padding: 80px 0; }
        .docs-section h2 { text-align: center; font-size: 2rem; margin-bottom: 16px; color: var(--primary); }
        .docs-section > .container > p { text-align: center; color: var(--gray-600); margin-bottom: 40px; max-width: 600px; margin-left: auto; margin-right: auto; }
        .docs-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 24px; }
        .doc-card { background: white; padding: 32px; border-radius: var(--radius); text-align: center; text-decoration: none; color: inherit; box-shadow: var(--shadow); transition: transform 0.3s, box-shadow 0.3s; }
        .doc-card:hover { transform: translateY(-4px); box-shadow: 0 8px 30px rgba(0,0,0,0.12); }
        .doc-icon { width: 60px; height: 60px; background: var(--gradient-hero); color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 24px; margin: 0 auto 16px; }
        .doc-card h3 { font-size: 1rem; margin-bottom: 8px; }
        .doc-card p { color: var(--gray-600); font-size: 13px; margin-bottom: 12px; }
        .doc-card .download-text { color: var(--primary); font-weight: 600; font-size: 13px; }
        
        .footer { background: var(--dark); color: white; padding: 60px 0 32px; margin-top: 60px; }
        .footer-content { display: flex; justify-content: space-between; align-items: center; }
        .footer p { color: rgba(255,255,255,0.6); font-size: 13px; }
        .multicure-badge { display: flex; align-items: center; gap: 12px; color: rgba(255,255,255,0.7); font-size: 13px; text-decoration: none; }
        .multicure-badge .badge-logo { background: rgba(255,255,255,0.95); padding: 8px 16px; border-radius: 8px; }
        .multicure-badge .badge-logo img { height: 28px; display: block; }
        @media (max-width: 768px) { 
            .service-header { grid-template-columns: 1fr; } 
            .service-header.reverse { direction: ltr; }
            .service-gallery { grid-template-columns: repeat(2, 1fr); }
            .docs-grid { grid-template-columns: 1fr 1fr; }
            .nav-links { display: none; } 
            .footer-content { flex-direction: column; gap: 16px; } 
        }
    </style>
</head>
<body>
    <header class="header"><div class="container"><div class="header-content">
        <a href="/watercure/" class="logo"><img src="/watercure/images/logo-long.png" alt="WaterCure" style="height: 75px;"></a>
        <nav class="nav">
            <ul class="nav-links">
                <li><a href="https://omnicure.co.za/" class="multicure-link"><i class="fas fa-th-large"></i> OmniCure</a></li>
                <li><a href="/watercure/">Home</a></li>
                <li><a href="/watercure/products.php">Solutions</a></li>
                <li><a href="/watercure/about.php">About Us</a></li>
                <li><a href="/watercure/contact.php">Contact</a></li>
            </ul>
            <?php if ($isReseller): ?>
                <a href="/reseller/dashboard.php" class="btn btn-primary"><i class="fas fa-th-large"></i> Dashboard</a>
            <?php else: ?>
                <a href="/reseller/login.php" class="btn btn-outline"><i class="fas fa-sign-in-alt"></i> Reseller Login</a>
            <?php endif; ?>
        </nav>
    </div></div></header>

    <section class="page-header">
        <div class="container">
            <h1>Water Treatment Solutions</h1>
            <p>Professional water purification and treatment systems for every application.</p>
        </div>
    </section>

    <section class="services-section"><div class="container">
        <!-- Water Purification -->
        <div class="service-block">
            <div class="service-header">
                <div class="service-content">
                    <h2><i class="fas fa-tint"></i> Water Purification Systems</h2>
                    <p>Advanced purification technology to deliver crystal-clear, safe drinking water for homes and businesses.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Reverse osmosis filtration</li>
                        <li><i class="fas fa-check"></i> UV sterilization systems</li>
                        <li><i class="fas fa-check"></i> Multi-stage filtration units</li>
                        <li><i class="fas fa-check"></i> Point-of-use purifiers</li>
                    </ul>
                </div>
                <div class="service-image"><i class="fas fa-tint"></i></div>
            </div>
            <div class="service-gallery">
                <div class="gallery-item"><img src="/watercure/images/purification-1.png" alt="Water Purification System"></div>
                <div class="gallery-item"><img src="/watercure/images/purification-2.png" alt="Pure Water"></div>
                <div class="gallery-item"><img src="/watercure/images/purification-3.png" alt="UV Sterilization"></div>
                <div class="gallery-item"><img src="/watercure/images/purification-4.png" alt="Filter Cartridges"></div>
            </div>
        </div>

        <!-- Water Treatment -->
        <div class="service-block">
            <div class="service-header reverse">
                <div class="service-content">
                    <h2><i class="fas fa-filter"></i> Water Treatment Plants</h2>
                    <p>Industrial-grade treatment solutions for municipal, commercial, and agricultural water systems.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Municipal water treatment</li>
                        <li><i class="fas fa-check"></i> Industrial process water</li>
                        <li><i class="fas fa-check"></i> Wastewater treatment</li>
                        <li><i class="fas fa-check"></i> Agricultural irrigation systems</li>
                    </ul>
                </div>
                <div class="service-image"><i class="fas fa-filter"></i></div>
            </div>
            <div class="service-gallery">
                <div class="gallery-item"><img src="/watercure/images/treatment-1.png" alt="Water Treatment Facility"></div>
                <div class="gallery-item"><img src="/watercure/images/treatment-2.png" alt="Chemical Treatment"></div>
                <div class="gallery-item"><img src="/watercure/images/treatment-3.png" alt="Water Softener"></div>
                <div class="gallery-item"><img src="/watercure/images/treatment-4.png" alt="Chlorination System"></div>
            </div>
        </div>

        <!-- Water Testing -->
        <div class="service-block">
            <div class="service-header">
                <div class="service-content">
                    <h2><i class="fas fa-vial"></i> Water Testing & Analysis</h2>
                    <p>Comprehensive water quality testing to identify contaminants and ensure compliance with health standards.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Chemical analysis</li>
                        <li><i class="fas fa-check"></i> Microbiological testing</li>
                        <li><i class="fas fa-check"></i> Heavy metal detection</li>
                        <li><i class="fas fa-check"></i> pH and mineral balance</li>
                    </ul>
                </div>
                <div class="service-image"><i class="fas fa-vial"></i></div>
            </div>
            <div class="service-gallery">
                <div class="gallery-item"><img src="/watercure/images/testing-1.png" alt="Water Testing Lab"></div>
                <div class="gallery-item"><img src="/watercure/images/testing-2.png" alt="Quality Meter"></div>
                <div class="gallery-item"><img src="/watercure/images/testing-3.png" alt="Testing Kit"></div>
                <div class="gallery-item"><img src="/watercure/images/testing-4.png" alt="Microbiological Testing"></div>
            </div>
        </div>

        <!-- Treatment Systems -->
        <div class="service-block">
            <div class="service-header reverse">
                <div class="service-content">
                    <h2><i class="fas fa-cogs"></i> Custom Treatment Systems</h2>
                    <p>Tailored water treatment solutions designed for your specific requirements and water conditions.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Water softening systems</li>
                        <li><i class="fas fa-check"></i> Iron and manganese removal</li>
                        <li><i class="fas fa-check"></i> Desalination plants</li>
                        <li><i class="fas fa-check"></i> Borehole water treatment</li>
                    </ul>
                </div>
                <div class="service-image"><i class="fas fa-cogs"></i></div>
            </div>
            <div class="service-gallery">
                <div class="gallery-item"><img src="/watercure/images/system-1.png" alt="Industrial Treatment System"></div>
                <div class="gallery-item"><img src="/watercure/images/system-2.png" alt="Residential Filtration"></div>
                <div class="gallery-item"><img src="/watercure/images/system-3.png" alt="Pool Treatment"></div>
                <div class="gallery-item"><img src="/watercure/images/system-4.png" alt="Agricultural Water System"></div>
            </div>
        </div>
    </div></section>

    <!-- Documentation Section -->
    <section class="docs-section"><div class="container">
        <h2>Technical Documentation</h2>
        <p>Download product specifications, safety data sheets, and technical guides for our water treatment solutions.</p>
        <div class="docs-grid">
            <a href="#" class="doc-card">
                <div class="doc-icon"><i class="fas fa-file-pdf"></i></div>
                <h3>Safety Data Sheets</h3>
                <p>Chemical safety information and handling guidelines</p>
                <span class="download-text"><i class="fas fa-download"></i> Download</span>
            </a>
            <a href="#" class="doc-card">
                <div class="doc-icon"><i class="fas fa-book"></i></div>
                <h3>Technical Manuals</h3>
                <p>Installation and maintenance documentation</p>
                <span class="download-text"><i class="fas fa-download"></i> Download</span>
            </a>
            <a href="#" class="doc-card">
                <div class="doc-icon"><i class="fas fa-certificate"></i></div>
                <h3>Certifications</h3>
                <p>Quality certifications and compliance documents</p>
                <span class="download-text"><i class="fas fa-download"></i> Download</span>
            </a>
            <a href="#" class="doc-card">
                <div class="doc-icon"><i class="fas fa-chart-line"></i></div>
                <h3>Case Studies</h3>
                <p>Success stories and project documentation</p>
                <span class="download-text"><i class="fas fa-download"></i> Download</span>
            </a>
        </div>
    </div></section>

    <footer class="footer"><div class="container">
        <div class="footer-content">
            <p>&copy; <?= date('Y') ?> WaterCure. All rights reserved.</p>
            <a href="https://omnicure.co.za/" class="multicure-badge"><span>Part of</span><div class="badge-logo"><img src="https://omnicure.co.za/uploads/logos/omnicure-logo-long.png" alt="OmniCure"></div></a>
        </div>
    </div></footer>
</body>
</html>
